/*************************************************************************
  Crytek Source File.
  Copyright (C), Crytek Studios, 2001-2004.
 -------------------------------------------------------------------------
  $Id$
  $DateTime$
  
 -------------------------------------------------------------------------
  History:
  - 7:10:2004   14:48 : Created by Mrcio Martins
												taken over by Filippo De Luca

*************************************************************************/
#include "StdAfx.h"
#include "Game.h"
#include "Actor.h"
#include "ScriptBind_Actor.h"
#include "ISerialize.h"
#include "GameUtils.h"
#include <ICryAnimation.h>
#include <IGameTokens.h>
#include <IItemSystem.h>
#include "Item.h"
#include "Weapon.h"
#include "Player.h"
#include "GameRules.h"
#include <IMaterialEffects.h>
#include "HUD/HUD.h"
#include "..\..\CryEngine\CryAction\GameObjects\WorldQuery.h"

static ICVar * pDrawActorPos = 0;
IItemSystem *CActor::m_pItemSystem=0;
IGameFramework	*CActor::m_pGameFramework=0;


void SIKLimb::SetWPos(IEntity *pOwner,const Vec3 &pos,const Vec3 &normal,float blend,float recover,int requestID)
{
	if (requestID<blendID)
		return;

	goalWPos = pos;
	goalNormal = normal;

	if (requestID!=blendID)
	{
		blendTime = blendTimeMax = blend;
		blendID = requestID;
	}
	else if (blendTime<0.001f)
		blendTime = 0.0011f;

	recoverTime = recoverTimeMax = recover;
}

void SIKLimb::Update(IEntity *pOwner,float frameTime)
{	
	ICharacterInstance *pCharacter = pOwner->GetCharacter(characterSlot);

	lAnimPosLast = lAnimPos;
	lAnimPos = pCharacter->GetISkeleton()->GetAbsJPositionByID(endBoneID);

	bool setLimbPos(true);
	Vec3 finalPos;

	if (blendTime>0.001f)
	{
		Vec3 limbWPos = currentWPos;
		finalPos = goalWPos;

		//float middle(0.5f-fabs(0.5f - (blendTime / blendTimeMax)));
		//finalPos.z += middle * 2.0f * 5.0f;

		finalPos -= (finalPos - limbWPos) * min(blendTime / blendTimeMax,1.0f);
		currentWPos = finalPos;

		blendTime -= frameTime;
	}
	else if (recoverTime>0.001f)
	{
		Vec3 limbWPos = currentWPos;
		finalPos = pOwner->GetSlotWorldTM(characterSlot) * lAnimPos;

		finalPos -= (finalPos - limbWPos) * min(recoverTime / recoverTimeMax,1.0f);
		currentWPos = finalPos;
		goalNormal.zero();

		recoverTime -= frameTime;

		blendID = -1;
	}
	else
	{
		currentWPos = pOwner->GetSlotWorldTM(characterSlot) * lAnimPos;
		setLimbPos = false;
	}

	if (setLimbPos)
	{
		/*if (flags & IKLIMB_RIGHTHAND)
			pCharacter->GetISkeleton()->SetRArmIK(pOwner->GetSlotWorldTM(characterSlot).GetInverted() * finalPos);
		else if (flags & IKLIMB_LEFTHAND)
			pCharacter->GetISkeleton()->SetLArmIK(pOwner->GetSlotWorldTM(characterSlot).GetInverted() * finalPos);*/
		if (middleBoneID>-1)
		{
			pCharacter->GetISkeleton()->SetCustomArmIK(pOwner->GetSlotWorldTM(characterSlot).GetInverted() * finalPos,rootBoneID,middleBoneID,endBoneID);
		}
		else
		{
			ISkeleton* pISkeleton = pCharacter->GetISkeleton();
			pISkeleton->CCDInitIKBuffer();
			pISkeleton->CCDInitIKChain(rootBoneID,endBoneID);

			Vec3 limbEndNormal(0,0,0);
			//limbEndNormal = Matrix33(pISkeleton->GetAbsJMatrixByID(endBoneID)).GetColumn(0);
			//GetISystem()->GetIRenderer()->GetIRenderAuxGeom()->DrawLine(finalPos, ColorB(0,255,0,100), finalPos + limbEndNormal * 3.0f, ColorB(255,0,0,100));
			pISkeleton->CCDRotationSolver(finalPos,0.02f,0.25f,100,goalNormal/*limbEndNormal*/);
			pISkeleton->CCDTranslationSolver(finalPos);

			pISkeleton->CCDUpdateSkeleton();
		}

		//GetISystem()->GetIRenderer()->GetIRenderAuxGeom()->DrawSphere(finalPos,0.2f,ColorB(0,255,255,255) );
	}
}

//------------------------------------------------------------------------
CActor::CActor()
: m_pAnimatedCharacter(0)
, m_health(100.0f)
, m_maxHealth(0)
, m_pMovementController(0)
, m_stance(STANCE_NULL)
, m_frozenAmount(0.f)
, m_intensityMonitor(0)
, m_bHasHUD(false)
{
	//memset(&m_stances,0,sizeof(m_stances));
	//SetupStance(STANCE_NULL,&SStanceInfo());

	if (!pDrawActorPos)
		pDrawActorPos = GetISystem()->GetIConsole()->RegisterInt("g_drawActorPos", 0, VF_CHEAT);

	m_vIKArmGoal.Set(0,0,0);
	m_nIKArm=-1;
}

//------------------------------------------------------------------------
CActor::~CActor()
{
	GetGameObject()->SetMovementController(NULL);
	SAFE_RELEASE(m_pMovementController);
	if (GetGameObject())
	{
		if (m_pAnimatedCharacter)
			GetGameObject()->ReleaseExtension("AnimatedCharacter");
		GetGameObject()->ReleaseView( this );
		GetGameObject()->ReleasePhysics( this );
	}
	g_pGame->GetIGameFramework()->GetIActorSystem()->RemoveActor( GetEntityId() );
	delete m_intensityMonitor;
}

//------------------------------------------------------------------------
bool CActor::Init( IGameObject * pGameObject )
{
	SetGameObject(pGameObject);

	if (!GetGameObject()->CaptureView(this))
		return false;
	if (!GetGameObject()->CapturePhysics(this))
		return false;

	m_pMovementController = CreateMovementController();
	GetGameObject()->SetMovementController(m_pMovementController);

	g_pGame->GetIGameFramework()->GetIActorSystem()->AddActor( GetEntityId(), this );

	g_pGame->GetActorScriptBind()->AttachTo(this);
	m_pAnimatedCharacter = static_cast<IAnimatedCharacter*>(GetGameObject()->AcquireExtension("AnimatedCharacter"));
	if (m_pAnimatedCharacter)
	{
		BindInputs( m_pAnimatedCharacter->GetAnimationGraph() );
	}

	m_pGameFramework = g_pGame->GetIGameFramework();
	m_pItemSystem = m_pGameFramework->GetIItemSystem();

	GetEntity()->PrePhysicsActivate( true );
	m_intensityMonitor = new CIntensity(this);

	m_pZoomAmount = GetISystem()->GetIConsole()->GetCVar("int_ZoomAmount");
	m_pZoomInTime = GetISystem()->GetIConsole()->GetCVar("int_ZoomInTime");
	m_pZoomOutTime = GetISystem()->GetIConsole()->GetCVar("int_ZoomOutTime");
	m_pMoveZoomTime = GetISystem()->GetIConsole()->GetCVar("int_MoveZoomTime");

	m_pStrengthScale = GetISystem()->GetIConsole()->GetCVar("cl_strengthscale");

	if (!GetGameObject()->BindToNetwork())
		return false;

	return true;
}

void CActor::PostInit( IGameObject * pGameObject )
{
	pGameObject->EnableUpdateSlot( this, 0 );
}

//------------------------------------------------------------------------
void CActor::Revive( bool fromInit )
{
	//set the actor game parameters
	SmartScriptTable gameParams;
  if (GetEntity()->GetScriptTable()->GetValue("gameParams", gameParams))
		SetParams(gameParams,true);
	//

	GetGameObject()->SetPhysicalizationProfile(eAP_Alive);

	m_stance = STANCE_NULL;

	memset(m_boneIDs,-1,sizeof(m_boneIDs));

	if (m_pAnimatedCharacter)
		m_pAnimatedCharacter->ResetState();
	if (m_pMovementController)
		m_pMovementController->Reset();

	m_grabStats.Reset();
	m_intensityMonitor->Reset();
	m_lastFootStepPos = ZERO;
	m_rightFoot = true;

	//reset some AG inputs
	m_pAnimatedCharacter->GetAnimationGraphState()->SetInput("Action", "idle" );
	m_hackTime = 0;

	//
	m_pAnimatedCharacter->SetParams( m_pAnimatedCharacter->GetParams().ModifyFlags(eACF_EnableMovementProcessing,0));
}

//------------------------------------------------------------------------
void CActor::Physicalize()
{
	//FIXME:this code is duplicated from scriptBind_Entity.cpp, there should be a function that fill a SEntityPhysicalizeParams struct from a script table.
	SmartScriptTable physicsParams;
  if (GetEntity()->GetScriptTable()->GetValue("physicsParams", physicsParams))
	{
		//first, the actor model has to be loaded, this is still using lua for the moment.
		//ICharacterInstance *pChar = GetEntity()->GetCharacter(0);
		//pChar->GetModelFilePath()

		SetActorModel();

		pe_player_dimensions playerDim;
		pe_player_dynamics playerDyn;
		SEntityPhysicalizeParams pp;
		
		pp.pPlayerDimensions = &playerDim;
		pp.pPlayerDynamics = &playerDyn;

		pp.nSlot = 0;
		pp.type = PE_LIVING;

		physicsParams->GetValue("mass",pp.mass);
		physicsParams->GetValue("density",pp.density);
		physicsParams->GetValue("flags",pp.nFlagsOR);
		physicsParams->GetValue("partid",pp.nAttachToPart);
		physicsParams->GetValue("stiffness_scale",pp.fStiffnessScale);

		SmartScriptTable livingTab;
		if (physicsParams->GetValue( "Living",livingTab ))
		{
			// Player Dimensions
			livingTab->GetValue( "height",playerDim.heightCollider );
			livingTab->GetValue( "size",playerDim.sizeCollider );
			livingTab->GetValue( "height_eye",playerDim.heightEye );
			livingTab->GetValue( "height_pivot",playerDim.heightPivot );
			livingTab->GetValue( "head_radius",playerDim.headRadius );
			livingTab->GetValue( "height_head",playerDim.heightHead );
			livingTab->GetValue( "use_capsule",playerDim.bUseCapsule );

			// Player Dynamics.
			livingTab->GetValue( "inertia",playerDyn.kInertia );
			livingTab->GetValue( "inertiaAccel",playerDyn.kInertiaAccel );
			livingTab->GetValue( "air_resistance",playerDyn.kAirResistance );
			livingTab->GetValue( "gravity",playerDyn.gravity.z );
			livingTab->GetValue( "mass",playerDyn.mass );
			livingTab->GetValue( "min_slide_angle",playerDyn.minSlideAngle );
			livingTab->GetValue( "max_climb_angle",playerDyn.maxClimbAngle );
			livingTab->GetValue( "max_jump_angle",playerDyn.maxJumpAngle );
			livingTab->GetValue( "min_fall_angle",playerDyn.minFallAngle );
			livingTab->GetValue( "max_vel_ground",playerDyn.maxVelGround );
			livingTab->GetValue( "timeImpulseRecover",playerDyn.timeImpulseRecover );
		}

		GetEntity()->Physicalize(pp);
	}

	//the finish physicalization
	PostPhysicalize();
}

//
void CActor::SetActorModel()
{
	// this should be pure-virtual, but for the moment to support alien scripts
	Script::CallMethod(GetEntity()->GetScriptTable(), "SetActorModel");
}

//------------------------------------------------------------------------
void CActor::PostPhysicalize()
{
	//force the physical proxy to be rebuilt
	m_stance = STANCE_NULL;
	SetStance(STANCE_STAND);

	if (m_pAnimatedCharacter)
		m_pAnimatedCharacter->ResetState();

	IEntityRenderProxy *pRenderProxy = static_cast<IEntityRenderProxy *>(GetEntity()->GetProxy(ENTITY_PROXY_RENDER));

	if (pRenderProxy)
	{
		IRenderNode *pRenderNode = pRenderProxy?pRenderProxy->GetRenderNode():0;
		
		if (pRenderNode)
		{
			pRenderNode->SetViewDistRatio(255);
			pRenderNode->SetLodRatio(255);
		}
	}
}

//------------------------------------------------------------------------
void CActor::RagDollize()
{
	SActorStats *pStats = GetActorStats();
	
	if (pStats && !pStats->isRagDoll)
	{
		ICharacterInstance *pCharacter = GetEntity()->GetCharacter(0);
		if (pCharacter)
			pCharacter->SetRagdollDefaultPose();

		SEntityPhysicalizeParams pp;

		pp.type = PE_ARTICULATED;
		pp.nSlot = 0;
	
		pe_player_dimensions playerDim;
		pe_player_dynamics playerDyn;

		playerDyn.gravity.z = 15.0f;
		playerDyn.kInertia = 5.5f;

		pp.pPlayerDimensions = &playerDim;
		pp.pPlayerDynamics = &playerDyn;

		GetEntity()->Physicalize(pp);

		pStats->isRagDoll = true;
	}
}

//------------------------------------------------------------------------
void CActor::Freeze(bool frozen, float mass, const char *material)
{
	if (m_pAnimatedCharacter)
	{
		m_pAnimatedCharacter->GetAnimationGraphState()->Pause(frozen, eAGP_Freezing);
		UpdateAnimGraph(m_pAnimatedCharacter->GetAnimationGraphState());
	}

	ICharacterInstance *pCharacter = GetEntity()->GetCharacter(0);
	int surface_idx = GetISystem()->GetI3DEngine()->GetMaterialManager()->GetSurfaceTypeByName(material)->GetId();

	if (!pCharacter)
		return;

	if (frozen)
	{	
    m_frozenAmount = 1.f;
		if (GetEntity()->GetAI() && GetGameObject()->GetChannelId()==0)
			GetEntity()->GetAI()->Event(AIEVENT_DISABLE, 0);

		if (!IsClient())
		{
			pe_status_dynamics dynamics;
			GetEntity()->GetPhysics()->GetStatus(&dynamics);

			pCharacter->DestroyCharacterPhysics();


			SEntityPhysicalizeParams params;
			params.nSlot = 0;
			params.mass = mass;
			params.type = PE_RIGID;
			GetEntity()->Physicalize(params);

			IPhysicalEntity *pPhysicalEntity = GetEntity()->GetPhysics();

			pCharacter->BuildPhysicalEntity(pPhysicalEntity, params.mass, surface_idx, 1);

			pe_params_flags flags;
			flags.flagsOR = pef_log_collisions;
			pPhysicalEntity->SetParams(&flags);

			pe_action_awake awake;
			awake.bAwake=1;

			pPhysicalEntity->Action(&awake);
		}
		else
		{
			IPhysicalEntity *pPhysicalEntity = GetEntity()->GetPhysics();
			if (pPhysicalEntity)
			{
				pe_action_move actionMove;
				actionMove.dir = Vec3(0,0,0);
				pPhysicalEntity->Action(&actionMove);
			}
		}

		// stop all layers
		for (int i=0; i<16; i++)
		{
			pCharacter->GetISkeleton()->SetAnimationSpeedLayer(i,0);
			pCharacter->GetISkeleton()->StopAnimationInLayer(i); 
		}
		pCharacter->EnableStartAnimation(false);
	}
	else
	{	
    m_frozenAmount = 0.f;
		if (GetEntity()->GetAI() && GetGameObject()->GetChannelId()==0)
			GetEntity()->GetAI()->Event(AIEVENT_ENABLE, 0);

		if (!IsClient())
		{
			pCharacter->DestroyCharacterPhysics();
		}

		if (pCharacter)
		{
			// stop all layers
			for (int i=0; i<16; i++)
				pCharacter->GetISkeleton()->SetAnimationSpeedLayer(i,1);

			pCharacter->EnableStartAnimation(true);
		}
	}
}

//------------------------------------------------------------------------
void CActor::SetupStance(EStance stance,SStanceInfo *info)
{
	if (stance >= STANCE_NULL && stance < STANCE_LAST)
		memcpy((void *)GetStanceInfo(stance),info,sizeof(SStanceInfo));
}

void CActor::SetStance(EStance desiredStance)
{
	if (m_pAnimatedCharacter && !m_pAnimatedCharacter->InStanceTransition() && desiredStance != m_stance)
		m_pAnimatedCharacter->RequestStance( desiredStance, GetStanceInfo(desiredStance)->name );
}

void CActor::ProcessEvent(SEntityEvent& event)
{
	switch (event.event)
	{
	case ENTITY_EVENT_HIDE:
		{
			IItem *pItem=GetCurrentItem();
			if (pItem)
				pItem->GetEntity()->Hide(true);
		}	
		break;
	case ENTITY_EVENT_UNHIDE:
		{
			IItem *pItem=GetCurrentItem();
			if (pItem)
				pItem->GetEntity()->Hide(false);
		}	
		break;
	}
}

void CActor::Update(SEntityUpdateContext& ctx, int slot)
{
	//FIXME:ridiculously bad hack, we must figure out why the input is not set correctly at Revive time
	if (m_hackTime < 1.0f)
	{
		//reset some AG inputs
		m_pAnimatedCharacter->GetAnimationGraphState()->SetInput("Action", "idle");
		m_pAnimatedCharacter->GetAnimationGraphState()->SetInput("Item", "nw");
		m_pAnimatedCharacter->GetAnimationGraphState()->SetInput("Stance", GetStanceInfo(GetStance())->name);
		m_hackTime += ctx.fFrameTime;
	}

	//activate HUD (hack to avoid multiply HUDs in MP
	if(!m_bHasHUD && IsPlayer())
	{
		if(this == GetISystem()->GetIGame()->GetIGameFramework()->GetClientActor())
		{
			if(GetGameObject()->ActivateExtension("HUD"))
			{
				((CHUD*)GetGameObject()->QueryExtension("HUD"))->SetHud(2);
				m_bHasHUD = true;
			}
		}
	}

	if (GetEntity()->IsHidden())
		return;
	if (IsPlayer())
	{
		CPlayer *plr = (CPlayer *)this;
		if (!GetLinkedVehicle())
			UpdateFootSteps(ctx.fFrameTime);
	}
	else
		UpdateFootSteps(ctx.fFrameTime);
	
	if (!m_pAnimatedCharacter)
		GameWarning("%s has no AnimatedCharacter!", GetEntity()->GetName());

	UpdateStance();

	//should be this at the end of the update loop?
	//if yes, a PostUpdate function should be created.
	if (IsClient())
	{
		UpdateHUD();
		Vec3 myDir;
		if (IMovementController * pMC = GetMovementController())
		{
			SMovementState ms;
			pMC->GetMovementState( ms );
			myDir = ms.eyeDirection;
		}
		/* JOHN: REMOVE
		if (m_checkAimDir)
		{
			float dot = myDir.Dot(m_lastAimDir);
			float front = ((dot * -1.0f) + 1.0f)/2.0f;
			if (front >= m_pShootingCone->GetFVal())
			{
				m_intensityMonitor->ChangeFOV(1.0f, m_pShootingConeZoomTime->GetFVal(), true);
				m_checkAimDir = false;
			}
		}
		*/
		m_intensityMonitor->Update(ctx.fFrameTime);
	}

	UpdateGrab(ctx.fFrameTime);
	UpdateAnimGraph( m_pAnimatedCharacter?m_pAnimatedCharacter->GetAnimationGraphState():NULL );
}

void CActor::UpdateHUD()
{
	float health = (GetHealth()/(float)GetMaxHealth()) * 100.0f;//the hud handles it only from 0 to 100
	//TODO?:keep the pointer?
	g_pGame->GetIGameFramework()->GetIGameTokenSystem()->SetOrCreateToken("hud.health", TFlowInputData(health, true));
}

void CActor::UpdateStance()
{
	if (m_stance != GetStance())
	{
		EStance oldStance = m_stance;
		m_stance = GetStance();
		StanceChanged( oldStance );

		IPhysicalEntity *pPhysEnt = GetEntity()->GetPhysics();

		pe_player_dimensions playerDim;
		const SStanceInfo *sInfo = GetStanceInfo(m_stance);

		playerDim.heightEye = 0.0f;
		playerDim.heightCollider = sInfo->heightCollider;
		playerDim.sizeCollider = sInfo->size;
		playerDim.heightPivot = sInfo->heightPivot;
		playerDim.maxUnproj = max(0.0f,sInfo->heightPivot);

		int result(pPhysEnt->SetParams(&playerDim));

		pe_action_awake aa;
		aa.bAwake = 1;
		pPhysEnt->Action(&aa);
	}
}

void CActor::SetStats(SmartScriptTable &rTable)
{
	SActorStats *pStats = GetActorStats();
	if (pStats)
	{
		rTable->GetValue("inFiring",pStats->inFiring);
	}
}

//------------------------------------------------------------------------
void CActor::OnAction(const ActionId& actionId, int activationMode, float value)
{
	IItem *pItem = GetCurrentItem();
	if (pItem)
		pItem->OnAction(GetGameObject()->GetEntityId(), actionId.c_str(), activationMode, value);
}

//------------------------------------------------------------------------
void CActor::CreateScriptEvent(const char *event,float value,const char *str)
{
	IEntity *pEntity = GetEntity(); 

	if (pEntity)
	{
		HSCRIPTFUNCTION scriptEvent(NULL);	
		pEntity->GetScriptTable()->GetValue("ScriptEvent", scriptEvent);

		if (scriptEvent)
			Script::Call(GetISystem()->GetIScriptSystem(),scriptEvent,pEntity->GetScriptTable(),event,value,str);
	}
}

void CActor::CreateCodeEvent(SmartScriptTable &rTable)
{
	const char *event = NULL;
	rTable->GetValue("event",event);

	if (event && !strcmp(event,"grabObject"))
	{
		ScriptHandle id;
		id.n = 0;

		rTable->GetValue("entityId",id);
		rTable->GetValue("holdPos",m_grabStats.lHoldPos);
		rTable->GetValue("grabDelay",m_grabStats.grabDelay);
		rTable->GetValue("followSpeed",m_grabStats.followSpeed);

		m_grabStats.collisionFlags = 0;
		rTable->GetValue("collisionFlags",m_grabStats.collisionFlags);

		m_grabStats.useIKRotation = false;
		rTable->GetValue("useIKRotation",m_grabStats.useIKRotation);

		m_grabStats.throwDelay = 0.0f;
		m_grabStats.maxDelay = m_grabStats.grabDelay;

		m_grabStats.limbNum = 0;

		SmartScriptTable limbsTable;
		if (rTable->GetValue("limbs",limbsTable))
		{
			IScriptTable::Iterator iter = limbsTable->BeginIteration();
		
			while(limbsTable->MoveNext(iter))
			{
				const char *pLimb;
				iter.value.CopyTo(pLimb);

				int limbIdx = GetIKLimbIndex(pLimb);
				if (limbIdx > -1 && m_grabStats.limbNum<GRAB_MAXLIMBS)
					m_grabStats.limbId[m_grabStats.limbNum++] = limbIdx;
			}

			limbsTable->EndIteration(iter);
		}

		m_grabStats.usingAnimation = false;
		m_grabStats.grabAnimState[63] = 0;
		m_grabStats.throwAnimState[63] = 0;
		
		SmartScriptTable animationTable;
		if (rTable->GetValue("animation",animationTable))
		{
			const char *grabState = NULL;
			const char *throwState = NULL;

			if (animationTable->GetValue("grabState",grabState))
			{
				strncpy(m_grabStats.grabAnimState,grabState,64);
				m_grabStats.grabAnimState[63] = 0;
			}

			if (animationTable->GetValue("throwState",throwState))
			{
				strncpy(m_grabStats.throwAnimState,throwState,64);
				m_grabStats.throwAnimState[63] = 0;
			}

			if (grabState/* && throwState*/)
				m_grabStats.usingAnimation = true;

			if (animationTable->GetValue("forceThrow",m_grabStats.throwDelay))
			{
				//m_grabStats.grabDelay = 0.0f;
				m_grabStats.maxDelay = m_grabStats.throwDelay;
			}
					
			m_grabStats.animDummyOfs.zero();
			animationTable->GetValue("dummyOfs",m_grabStats.animDummyOfs);

			m_grabStats.releaseIKTime = 0.0f;
			animationTable->GetValue("releaseIKTime",m_grabStats.releaseIKTime);
		}

		m_grabStats.followBoneID = -1;

		const char *followBone;
		if (rTable->GetValue("followBone",followBone))
		{
			ICharacterInstance *pCharacter = GetEntity()->GetCharacter(0);
			if (pCharacter)
				m_grabStats.followBoneID = pCharacter->GetISkeleton()->GetIDByName(followBone);
		}

		GrabObject(id.n);
	}
	else if (event && !strcmp(event,"dropObject"))
	{
		rTable->GetValue("throwVec",m_grabStats.throwVector);

		int throwImmediately(0);
		rTable->GetValue("throwImmediately",throwImmediately);

		//FIXME:
		if (throwImmediately)
		{
			DropObject();
		}
		else if (m_grabStats.throwDelay<0.001f)
		{
			rTable->GetValue("throwDelay",m_grabStats.throwDelay);

			m_grabStats.grabDelay = 0.0f;
			m_grabStats.maxDelay = m_grabStats.throwDelay;

			StartDropObject();
		}
	}
}

void CActor::Serialize( TSerialize ser, unsigned aspects )
{	
	if (ser.GetSerializationTarget() != eST_Network)
	{
		int prevHealth = (int)m_health;

		ser.BeginGroup("CActor");
		ser.Value("health", m_health);
		ser.Value("maxHealth", m_maxHealth);
		ser.EndGroup();

		// perform post-writing fixups
		if (!ser.IsWriting())
		{
			if (prevHealth<=0 && m_health>0)
				CreateScriptEvent("resurrect",0);
			else if (prevHealth>0 && m_health<=0)
				CreateScriptEvent("kill",0);	
		}

	}
}

void CActor::SetChannelId(uint16 id)
{
}

void CActor::SetHealth( int health )
{ 
  if (health <= 0 && IsGod() > 0)
	{
		static char evtParam[] = "GodMode:died!";
		SGameObjectEvent evt("HUD_TextMessage",eGOEF_ToAll, IGameObjectSystem::InvalidExtensionID, evtParam);
		GetISystem()->GetIGame()->GetIGameFramework()->GetIGameObjectSystem()->BroadcastEvent(evt);
    return;
	}

	//if ((health - m_health) < 0)
		//m_intensityMonitor->Intensify(CIntensity::int_DamageTaken, m_health-health);

	int prevHealth = (int)m_health;
	m_health = float(min(health, m_maxHealth));

	UpdateHUD();
  
	//do things when the actor dies
	if (m_health<=0 && prevHealth>0)
		Kill();
}

void CActor::SetMaxHealth( int maxHealth )
{
	m_maxHealth = maxHealth;
	SetHealth(GetHealth());
}

void CActor::Kill()
{
	IItem *pItem = GetCurrentItem();
	IWeapon *pWeapon = pItem ? pItem->GetIWeapon() : NULL;

	if (pWeapon)
		pWeapon->StopFire(GetGameObject()->GetEntityId());

	m_pAnimatedCharacter->SetParams( m_pAnimatedCharacter->GetParams().ModifyFlags(0,eACF_EnableMovementProcessing));
}

void CActor::SetParams(SmartScriptTable &rTable,bool resetFirst)
{
	SmartScriptTable animTable;

	if (rTable->GetValue("stance",animTable))
	{
		IScriptTable::Iterator iter = animTable->BeginIteration();
		int stance;

		while(animTable->MoveNext(iter))
		{
			SmartScriptTable stanceTable;

			if (iter.value.CopyTo(stanceTable))
			{
				if (stanceTable->GetValue("stanceId",stance))
				{
					SStanceInfo sInfo;
					const char *name;

					stanceTable->GetValue("speed",sInfo.maxSpeed);
					stanceTable->GetValue("heightCollider",sInfo.heightCollider);
					stanceTable->GetValue("heightPivot",sInfo.heightPivot);
					stanceTable->GetValue("size",sInfo.size);
					stanceTable->GetValue("viewOffset",sInfo.viewOffset);
					stanceTable->GetValue("modelOffset",sInfo.modelOffset);
					if (stanceTable->GetValue("name",name))
					{
						strcpy(sInfo.name,name);
					}

					SetupStance((EStance)stance,&sInfo);
				}
			}
		}

		animTable->EndIteration(iter);
	}

	SActorParams *pParams(GetActorParams());
	if (pParams)
	{
		rTable->GetValue("maxGrabMass",pParams->maxGrabMass);
		rTable->GetValue("maxGrabVolume",pParams->maxGrabVolume);
		rTable->GetValue("nanoSuitActive",pParams->nanoSuitActive);
	}
}

bool CActor::IsClient() const
{
	//get the client
	IActor *pClient = g_pGame->GetIGameFramework()->GetClientActor();

	if (pClient && pClient->GetEntityId() == GetGameObject()->GetEntityId())
		return true;

	return false;
}

//------------------------------------------------------------------------
void CActor::PutDebugMessage( const char * msg )
{
	if (!m_debugInfo.empty())
		m_debugInfo.push_back('\n');
	m_debugInfo += msg;
}

void CActor::DisplayDebugInfo()
{
	if (DebugMode())
	{
		IRenderer * pRenderer = GetISystem()->GetIRenderer();
		IGame * pGame = GetISystem()->GetIGame();
		IGameFramework * pGameFramework = pGame->GetIGameFramework();
		float drawColor[4] = {1,1,1,1};
		if (IsClient())
		{
			pRenderer->Draw2dLabel( 50.0f, 50.0f, 2, drawColor, false, m_debugInfo.c_str() );
		}
		else
		{
			IEntity * pEntity = GetEntity();
			Vec3 drawPos = pEntity->GetWorldTM().GetTranslation();
			pRenderer->DrawLabelEx( drawPos, 1.0f, drawColor, true, true, m_debugInfo.c_str() );
		}
	}
	m_debugInfo.resize(0);
}

bool CActor::SetProfile( uint8 profile )
{
	//CryLog("%s::SetProfile(%d): %s", GetEntity()->GetName(), profile, profile==eAP_Alive?"alive":(profile==eAP_Ragdoll?"ragdoll":"unknown"));

	bool res(false);
	switch (profile)
	{
	case eAP_Alive:
		Physicalize();
		res = true;
		break;
	case eAP_Ragdoll:
		RagDollize();
		res = true;
		break;
	}

	if (res)
		ProfileChanged(profile);

	return res;
}

void CActor::ProfileChanged( uint8 newProfile )
{
	//inform scripts when the profile changes
	CreateScriptEvent("profileChanged",0,newProfile==eAP_Alive?"alive":"ragdoll");
}

bool CActor::SerializeProfile( TSerialize ser, uint8 profile )
{
	pe_type type = PE_NONE;
	switch (profile)
	{
	case eAP_Alive:
		type = PE_LIVING;
		break;
	case eAP_Ragdoll:
		type = PE_ARTICULATED;
		break;
	default:
		return false;
	}

	IEntityPhysicalProxy * pEPP = (IEntityPhysicalProxy *) GetEntity()->GetProxy(ENTITY_PROXY_PHYSICS);
	if (!pEPP)
		return false;

	pEPP->SerializeTyped( ser, type );
	return true;
}

void CActor::HandleEvent( const SGameObjectEvent& event )
{
	if (!strcmp(event.event, "OnShoot"))
	{
		SActorStats *pStats = GetActorStats();
		if (pStats)
			pStats->inFiring = 10.0f;
	}
	else if (0 == strcmp(event.event, "Ragdoll"))
	{
		GetGameObject()->SetPhysicalizationProfile( eAP_Ragdoll );
	}
	else if (0 == strcmp(event.event, "Physicalize"))
	{

	}
	else if (0 == strcmp(event.event, "RebindAnimGraphInputs"))
	{
		BindInputs( m_pAnimatedCharacter?m_pAnimatedCharacter->GetAnimationGraph():NULL );
	}
}

void CActor::BindInputs( IAnimationGraph * pGraph )
{
	if (pGraph)
	{
		m_inputHealth = pGraph->LookupInputId("Health");
		m_inputStance = pGraph->LookupInputId("Stance");
		m_inputFiring = pGraph->LookupInputId("Firing");
		m_inputAction = pGraph->LookupInputId("Action");
	}
}

void CActor::UpdateAnimGraph( IAnimationGraphState * pState )
{
	if (pState)
	{
		pState->SetInput( m_inputHealth, m_health );

		SActorStats *pStats = GetActorStats();
		if (pStats)
		{
			pState->SetInput(m_inputFiring, pStats->inFiring);
		}
	}
	//state.pHealth = &m_health;

	//const char * p = GetStanceInfo(m_stance)->name;
	//state.pStance = &p;
}

void CActor::QueueAnimationState( const char * state )
{
	if (m_pAnimatedCharacter)
		m_pAnimatedCharacter->PushForcedState( state );
}

void CActor::ChangeAnimGraph( const char *graph )
{
	if (m_pAnimatedCharacter)
	{
		m_pAnimatedCharacter->ChangeGraph(graph);
		BindInputs(m_pAnimatedCharacter->GetAnimationGraph());
	}
}

int CActor::GetBoneID(int ID,int slot) const
{
	if (m_boneIDs[ID]<0)
	{
		ICharacterInstance *pCharacter = GetEntity()->GetCharacter(slot);
		if (!pCharacter)
			return -1;

		//TODO:this could be done much better
		char boneStr[64];
		switch(ID)
		{
		case BONE_BIP01:	strcpy(boneStr,"Bip01");break;
		case BONE_SPINE:	strcpy(boneStr,"Bip01 Spine");break;
		case BONE_SPINE2:	strcpy(boneStr,"Bip01 Spine2");break;
		case BONE_SPINE3:	strcpy(boneStr,"Bip01 Spine3");break;
		case BONE_HEAD:		strcpy(boneStr,"Bip01 Head");break;
		case BONE_EYE_R:	strcpy(boneStr,"eye_right_bone");break;
		case BONE_EYE_L:	strcpy(boneStr,"eye_left_bone");break;
		case BONE_WEAPON: strcpy(boneStr,"weapon_bone");break;
		case BONE_FOOT_R:	strcpy(boneStr,"Bip01 R Foot");break;
		case BONE_FOOT_L: strcpy(boneStr,"Bip01 L Foot");break;
		case BONE_LEFT_HAND: strcpy(boneStr,"helperBone_right");break;
		case BONE_RIGHT_HAND: strcpy(boneStr,"helperBone_left");break;
		}

		m_boneIDs[ID] = pCharacter->GetISkeleton()->GetIDByName(boneStr);
	}

	return m_boneIDs[ID];
}

Vec3 CActor::GetLocalEyePos(int slot) const
{
	ICharacterInstance *pCharacter = GetEntity()->GetCharacter(slot);

	if (pCharacter)
	{
		int id_right = GetBoneID(BONE_EYE_R);
		int id_left = GetBoneID(BONE_EYE_L);

		if (id_right>-1 && id_left>-1)
			return ((pCharacter->GetISkeleton()->GetAbsJPositionByID(id_right)+
							pCharacter->GetISkeleton()->GetAbsJPositionByID(id_left)) * 0.5f);
	}

	return GetStanceInfo(m_stance)->viewOffset;
}

bool CActor::CheckZeroG(Vec3 &ZAxis)
{
	ZAxis.Set(0,0,1);
	Vec3 wpos(GetEntity()->GetWorldPos());

	IPhysicalEntity **ppList = NULL;
	int	numEntities = GetISystem()->GetIPhysicalWorld()->GetEntitiesInBox(wpos,wpos,ppList,ent_areas);

	bool inZeroG(false);

	for (int i=0;i<numEntities;++i)
	{
		pe_status_contains_point scp;
		scp.pt = wpos;
		
		if (ppList[i]->GetStatus(&scp))
		{
			pe_params_foreign_data fd;
			ppList[i]->GetParams(&fd);
      
			//FIXME:thats not 100% precise, but for now its fine
			if (fd.iForeignData == ZEROG_AREA_ID)
			{
				pe_status_pos sp;
				ppList[i]->GetStatus(&sp);

				ZAxis = sp.q.GetColumn2();
			
				inZeroG = true;
				break;
			}
		}
	}

	return inZeroG;
}

/*
void CActor::Locomanize(bool active)
{
	if (m_locomanized!=active)
	{
		m_locomanized = active;

		ICharacterInstance *pCharacter = GetEntity()->GetCharacter(0);
		if (pCharacter)
		{
			ISkeleton* pISkeleton = pCharacter->GetISkeleton();

			pISkeleton->SetTransRot2000(1*active);
			pISkeleton->SetFootAnchoring(1*active);
		}

		IPhysicalEntity *pPhysEnt = GetEntity()->GetPhysics();
		if (pPhysEnt)
		{
			pe_player_dynamics pd;
			float inertia;
			float inertiaAccel;

			if (active)
			{
				pPhysEnt->GetParams(&pd);

				m_LMStats.prevIntertia = pd.kInertia;
				m_LMStats.prevIntertiaAccel = pd.kInertiaAccel;
				
				inertia = inertiaAccel = 0.0f;
				pd = pe_player_dynamics();
			}
			else
			{
				inertia = m_LMStats.prevIntertia;
				inertiaAccel = m_LMStats.prevIntertiaAccel;
			}

			pd.kInertia = inertia;
			pd.kInertiaAccel = inertiaAccel;
			pPhysEnt->SetParams(&pd);
		}

		IEntityRenderProxy * pRenderProxy = (IEntityRenderProxy*) GetEntity()->GetProxy(ENTITY_PROXY_RENDER);
		if (pRenderProxy)
		{
			pRenderProxy->UpdateCharactersBeforePhysics( active );
		}
	}
}
*/

void CActor::ProcessBonesRotation(ICharacterInstance *pCharacter,float frameTime)
{
	ProcessIKLimbs(pCharacter,frameTime);
}

//grabbing and such
bool CActor::CanPickUpObject(IEntity *obj)
{
	if (!obj)
		return false;

	if(IsPlayer())
	{
		if(((CPlayer*)this)->IsZeroG())
			return true;
	}

	IPhysicalEntity *pEnt(obj->GetPhysics());
	if (!pEnt)
		return false;

	float mass(0);
	pe_simulation_params sp;	
	if (pEnt->GetParams(&sp))
		mass = sp.mass;	
	
	AABB lBounds;
	obj->GetLocalBounds(lBounds);
	Vec3 delta(lBounds.min - lBounds.max);
	float volume = fabs(delta.x * delta.y * delta.z);

	bool canPickUp = false;
	if(IsPlayer())
	{
		CPlayer* player = (CPlayer*)this;
		float wantedStrength = player->GetNanoSuit().GetSlotValue(NANOSLOT_STRENGTH, true);
		if(wantedStrength > 50)
		{
			SGameObjectEvent evt("NANOSUIT_UsingStrength",eGOEF_ToAll, IGameObjectSystem::InvalidExtensionID, NULL);
			m_pGameFramework->GetIGameObjectSystem()->BroadcastEvent(evt);
			canPickUp = true;
		}
	}
	if(!canPickUp)
	{
		float strength(GetActorStrength());
		SActorParams *pParams(GetActorParams());
		if (pParams && mass <= pParams->maxGrabMass*strength && volume <= pParams->maxGrabVolume*strength)
		{
			if(strength > 1.5f && !(mass <= pParams->maxGrabMass && volume <= pParams->maxGrabVolume))
			{
				SGameObjectEvent evt("NANOSUIT_UsingStrength",eGOEF_ToAll, IGameObjectSystem::InvalidExtensionID, NULL);
				m_pGameFramework->GetIGameObjectSystem()->BroadcastEvent(evt);
			}
			canPickUp = true;
		}
	}

	return canPickUp;
}

bool CActor::CanPickUpObject(float mass, float volume)
{
	float strength(GetActorStrength());
	SActorParams *pParams(GetActorParams());
	if (pParams && mass <= pParams->maxGrabMass*strength && volume <= pParams->maxGrabVolume*strength)
		return true;

	return false;
}


void CActor::IgnoreGrabCollision(EntityId eID,unsigned int flags,bool ignore)
{
	IEntity *pGrab = GetISystem()->GetIEntitySystem()->GetEntity(eID);
	IPhysicalEntity *ppGrab = pGrab ? pGrab->GetPhysics() : NULL;

	if (ppGrab)
	{
		if (ignore)
		{
			pe_action_add_constraint ac;
			ac.flags = constraint_inactive|constraint_ignore_buddy;
			ac.pBuddy = GetEntity()->GetPhysics();
			ac.pt[0].Set(0,0,0);

			ICharacterInstance *pCharacter = GetEntity()->GetCharacter(0);
			IPhysicalEntity *pPhysEnt = pCharacter?pCharacter->GetCharacterPhysics(-1):NULL;

			if (pPhysEnt)
			{
				pe_simulation_params sp;
				pPhysEnt->GetParams(&sp);
				if (sp.iSimClass <= 2)
					ac.pBuddy = pPhysEnt;
			}

			ppGrab->Action(&ac);
		}
		else
		{
			pe_action_update_constraint uc;
			uc.bRemove = 1;

			ppGrab->Action(&uc);
		}

		if (flags)
		{
			pe_params_part pp;
			pp.flagsAND = pp.flagsColliderAND = ~flags;
			pp.flagsOR = pp.flagsColliderOR = flags * (ignore?0:1);

			pe_status_nparts status_nparts;
			for(pp.ipart = ppGrab->GetStatus(&status_nparts)-1; pp.ipart>=0; pp.ipart--)
 				ppGrab->SetParams(&pp);
		}
	}
}

void CActor::GrabObject(EntityId objectId)
{
	if (m_grabStats.grabId<1)
	{
		IEntity *pGrab = GetISystem()->GetIEntitySystem()->GetEntity(objectId);

		if (pGrab)
		{
			m_grabStats.grabId = objectId;
			
			if ( m_grabStats.limbNum<1)
				m_grabStats.additionalRotation = (pGrab->GetRotation() / GetEntity()->GetRotation()).GetNormalized();
			else
				m_grabStats.additionalRotation.SetIdentity();

			if (m_grabStats.usingAnimation && m_grabStats.grabAnimState[0])
			{
				QueueAnimationState(m_grabStats.grabAnimState);

				m_grabStats.animationLimbOffset = pGrab->GetWorldPos() - GetEntity()->GetSlotWorldTM(0) * m_grabStats.animDummyOfs;
			}

			//if there is still a link to remove
			if (m_grabStats.dropId>0)
			{
				IgnoreGrabCollision(m_grabStats.dropId,m_grabStats.collisionFlags,false);
				m_grabStats.dropId = 0;
			}

			IgnoreGrabCollision(m_grabStats.grabId,m_grabStats.collisionFlags,true);
		}
	}
}

void CActor::StartDropObject()
{
	if (m_grabStats.usingAnimation && m_grabStats.throwAnimState[0])
		QueueAnimationState(m_grabStats.throwAnimState);
	else if (m_grabStats.throwDelay<0.001f)
		DropObject();
}

void CActor::DropObject()
{
	IEntity *pGrab = GetISystem()->GetIEntitySystem()->GetEntity(m_grabStats.grabId);
	IPhysicalEntity *pGrabPhys = pGrab ? pGrab->GetPhysics() : NULL;

	if (pGrabPhys && m_grabStats.throwVector.len2()>0.01f)
	{	
		pe_action_set_velocity asv;
		asv.v = m_grabStats.throwVector;

		asv.w.x = -1.0f + (rand()/(float)RAND_MAX*(float)(2.0f));
		asv.w.y = -1.0f + (rand()/(float)RAND_MAX*(float)(2.0f));
		asv.w.z = -1.0f + (rand()/(float)RAND_MAX*(float)(2.0f));
		asv.w.NormalizeSafe();
		asv.w *= 2.0f;

		pGrabPhys->Action(&asv);
	}

	if (m_grabStats.grabId>0)
	{
		m_grabStats.dropId = m_grabStats.grabId;
		m_grabStats.resetFlagsDelay = 1.0f;

		CreateScriptEvent("droppedObject",m_grabStats.grabId);
	}

	m_grabStats.Reset();
}

void CActor::UpdateGrab(float frameTime)
{
	//we have to restore the grabbed object collision flag at some point after the throw.
	if (m_grabStats.dropId>0)
	{
		m_grabStats.resetFlagsDelay -= frameTime;
		if (m_grabStats.resetFlagsDelay<0.001f)
		{
			IgnoreGrabCollision(m_grabStats.dropId,m_grabStats.collisionFlags,false);
			m_grabStats.dropId = 0;
		}
	}

	if (m_grabStats.grabId<1)
		return;

	bool grabbing(m_grabStats.grabDelay>0.001f);
	
	if (m_grabStats.throwDelay>0.001f)
	{
		m_grabStats.throwDelay -= frameTime;
		if (m_grabStats.throwDelay<=0.001f || GetHealth()<=0)
		{
			DropObject();
			return;
		}
	}

	IEntity *pGrab = GetISystem()->GetIEntitySystem()->GetEntity(m_grabStats.grabId);
	IPhysicalEntity *pGrabPhys = pGrab ? pGrab->GetPhysics() : NULL;
	
	if (pGrab && pGrabPhys)
	{
		//_controlfp(0, _EM_INVALID | _EM_ZERODIVIDE | _PC_64 );
		
		IEntity *pActor = GetEntity();
		IPhysicalEntity *pActorPhys = pActor ? pActor->GetPhysics() : NULL;

		if (!grabbing && pActor && pActorPhys)
		{
			//set object rotation here only if IK is not used
			if (!m_grabStats.useIKRotation || m_grabStats.limbNum<1)
			{
				if (!m_grabStats.wHoldQuat.IsIdentity())
				{
					pGrab->SetRotation(m_grabStats.wHoldQuat);
					m_grabStats.wHoldQuat.SetIdentity();
				}
				else
				{
					m_grabStats.additionalRotation = Quat::CreateSlerp( m_grabStats.additionalRotation, IDENTITY, frameTime * 3.3f );
					pGrab->SetRotation(pActor->GetRotation() * m_grabStats.additionalRotation,ENTITY_XFORM_USER);
				}
			}

			AABB bbox;
			pGrab->GetLocalBounds(bbox);

			Vec3 size = bbox.max - bbox.min;
			Vec3 grabCenter = ((bbox.max + bbox.min) * 0.5f);
			//grabCenter.y += bbox.max.y;
			grabCenter = pGrab->GetWorldTM() * grabCenter;

			//GetISystem()->GetIRenderer()->GetIRenderAuxGeom()->DrawSphere(grabCenter,0.25f,ColorB(0,255,255,255) );
		
			Vec3 grabWPos;

			if (m_grabStats.followBoneID>-1)
			{
				grabWPos = m_grabStats.followBoneWPos/* + m_grabStats.animationLimbOffset*/;
				
				Matrix34 tm(pGrab->GetWorldTM());
				tm.SetTranslation(grabWPos);
				pGrab->SetWorldTM(tm,ENTITY_XFORM_USER);
			}
			else
			{
				if (m_grabStats.wHoldPos.len2()>0.01f)
				{
					grabWPos = m_grabStats.wHoldPos;
					m_grabStats.wHoldPos.Set(0,0,0);
				}
				else
					grabWPos = pActor->GetSlotWorldTM(0) * m_grabStats.lHoldPos;

				Vec3 setGrabVel(0,0,0);
				if (!m_grabStats.usingAnimation && m_grabStats.throwDelay>0.001f)
				{
					float half(m_grabStats.maxDelay * 0.5f);
					float firstHalf(m_grabStats.throwDelay - half);
		
					if (firstHalf>0.0f)
					{
						setGrabVel = (m_grabStats.throwVector*-0.5f) * (1.0f-min((firstHalf*2) / m_grabStats.maxDelay,1.0f));
					}
					else
					{
						float secondHalf(firstHalf + half);
						setGrabVel = (m_grabStats.throwVector) * (1.0f-min((secondHalf*2) / m_grabStats.maxDelay,1.0f));
					}

					//GetISystem()->GetIRenderer()->GetIRenderAuxGeom()->DrawSphere(grabWPos+setGrabVel,2.5f,ColorB(0,255,0,255) );
				}
				
				//GetISystem()->GetIRenderer()->GetIRenderAuxGeom()->DrawSphere(grabWPos,0.25f,ColorB(0,255,0,255) );
			
				pe_status_dynamics	dyn;
				pActorPhys->GetStatus(&dyn);

				pe_action_set_velocity asv;
				if (setGrabVel.len2()>0.01f)
					asv.v = dyn.v + setGrabVel;
				else
					asv.v = dyn.v + (grabWPos - grabCenter)*m_grabStats.followSpeed;
				asv.w.Set(0,0,0);
					
				pGrab->GetPhysics()->Action(&asv);
			}
		}

		if (pActor)
		{
			//update IK
			for (int i=0;i<m_grabStats.limbNum;++i)
			{
				SIKLimb *pLimb = &m_IKLimbs[m_grabStats.limbId[i]];

				Vec3 grabCenter(GetGrabIKPos(pGrab,i));

				if (m_grabStats.followBoneID<0)
				{
					pLimb->SetWPos(GetEntity(),grabCenter,ZERO,0.5f,2.0f,1000);
				}
				else if (m_grabStats.usingAnimation && m_grabStats.releaseIKTime>0.001f)
				{
					Vec3 bPos = pActor->GetSlotWorldTM(0) * pLimb->lAnimPos;
					pLimb->SetWPos(GetEntity(),bPos + m_grabStats.animationLimbOffset,ZERO,0.5f,2.0f,1000);
					//GetISystem()->GetIRenderer()->GetIRenderAuxGeom()->DrawLine(bPos, ColorB(0,255,0,100), bPos + m_grabStats.animationLimbOffset, ColorB(255,0,0,100));
				}
				
				//if there are multiple limbs, only the first one sets the rotation of the object.
				if (m_grabStats.useIKRotation && i == 0 && m_grabStats.grabDelay<0.001f)
				{
					ICharacterInstance *pCharacter = pActor->GetCharacter(pLimb->characterSlot);
					Quat boneRot(pCharacter->GetISkeleton()->GetAbsJMatrixByID(pLimb->endBoneID));

					if (m_grabStats.additionalRotation.IsIdentity())
						m_grabStats.additionalRotation = pGrab->GetRotation() / boneRot;

					Quat grabQuat(boneRot * m_grabStats.additionalRotation);
					grabQuat.Normalize();

					//FIXME:VS2 hack
					CActor *pActor = (CActor *)g_pGame->GetIGameFramework()->GetIActorSystem()->GetActor(m_grabStats.grabId);
					if (pActor && pActor->GetActorStats())
					{
						Vec3 upVec(Quat(boneRot * m_grabStats.additionalRotation).GetColumn2());
						upVec.z = fabs_tpl(upVec.z) * 2.0f;
						upVec.NormalizeSafe(Vec3(0,0,1));

						pActor->GetActorStats()->forceUpVector = upVec;

						/*Vec3 forward = grabQuat.GetColumn1();
						Vec3 right = forward % upVec;
						forward = upVec % right;
						upVec = right % forward;
				
						//grabQuat = Quat(Matrix33::CreateFromVectors(right,forward,upVec));

						GetISystem()->GetIRenderer()->GetIRenderAuxGeom()->DrawLine(pActor->GetEntity()->GetWorldPos(), ColorB(255,0,0,255), pActor->GetEntity()->GetWorldPos() + forward * 3, ColorB(255,0,0,255));
						GetISystem()->GetIRenderer()->GetIRenderAuxGeom()->DrawLine(pActor->GetEntity()->GetWorldPos(), ColorB(0,255,0,255), pActor->GetEntity()->GetWorldPos() + upVec * 3, ColorB(0,255,0,255));
						GetISystem()->GetIRenderer()->GetIRenderAuxGeom()->DrawLine(pActor->GetEntity()->GetWorldPos(), ColorB(0,0,255,255), pActor->GetEntity()->GetWorldPos() + right * 3, ColorB(0,0,255,255));*/
					}
					else
					{
						pGrab->SetRotation(grabQuat,ENTITY_XFORM_USER);
					}
				}
			}
		}

		//_controlfp(0, _PC_64 );
	}
	else
	{
		//in case the grabber lost the grabbed object, reset the ignore collision flags
		IPhysicalEntity *pActorPhys = GetEntity() ? GetEntity()->GetPhysics() : NULL;
		if (pActorPhys)
		{
			pe_action_update_constraint uc;
			uc.bRemove = 1;

			pActorPhys->Action(&uc);
		}
	}

	if (m_grabStats.grabDelay>0.001f)
		m_grabStats.grabDelay -= frameTime;

	if (m_grabStats.releaseIKTime>0.001f)
		m_grabStats.releaseIKTime -= frameTime;
}

Vec3 CActor::GetGrabIKPos(IEntity *pGrab,int limbIdx)
{
	AABB bbox;
	pGrab->GetLocalBounds(bbox);

	Vec3 grabCenter((bbox.max + bbox.min) * 0.5f);

	if (m_grabStats.limbNum<2)
	{
	}
	else
	{
		SIKLimb *pLimb = &m_IKLimbs[m_grabStats.limbId[limbIdx]];
		ICharacterInstance *pCharacter = GetEntity()->GetCharacter(pLimb->characterSlot);

		if (pCharacter)
		{
			Vec3 posPool[2]={grabCenter,grabCenter};
			posPool[0].x = bbox.min.x;
			posPool[1].x = bbox.max.x;

			Vec3 limbPosInLocal(pGrab->GetWorldTM().GetInverted()*(GetEntity()->GetSlotWorldTM(pLimb->characterSlot) * pCharacter->GetISkeleton()->GetAbsJPositionByID(pLimb->rootBoneID)));

			float minDist(9999.9f);
			for (int i=0;i<2;++i)
			{
				//GetISystem()->GetIRenderer()->GetIRenderAuxGeom()->DrawLine(pGrab->GetWorldTM() * posPool[i], ColorB(0,255,0,100), pGrab->GetWorldTM() * limbPosInLocal, ColorB(0,255,0,100));
				float len2((posPool[i] - limbPosInLocal).len2());
				if (len2<minDist)
				{
					minDist = len2;
					grabCenter = posPool[i];
				}
			}
		}
	}

	return (pGrab->GetWorldTM() * grabCenter);
}

//IK stuff
void CActor::SetIKPos(const char *pLimbName, const Vec3& goalPos, int priority)
{
	int limbID = GetIKLimbIndex(pLimbName);
	if (limbID > -1)
	{
		Vec3 pos(goalPos);
		m_IKLimbs[limbID].SetWPos(GetEntity(),pos,ZERO,0.5f,0.5f,priority);
	}
}

void CActor::CreateIKLimb(int characterSlot, const char *limbName, const char *rootBone, const char *midBone, const char *endBone, int flags)
{
	for (int i=0;i<m_IKLimbs.size();++i)
	{
		if (!strcmp(limbName,m_IKLimbs[i].name))
			return;
	}

	ICharacterInstance *pCharacter = GetEntity()->GetCharacter(characterSlot);
	if (pCharacter)
	{
		SIKLimb newLimb;
		newLimb.SetLimb(characterSlot,limbName,pCharacter->GetISkeleton()->GetIDByName(rootBone),pCharacter->GetISkeleton()->GetIDByName(midBone),pCharacter->GetISkeleton()->GetIDByName(endBone),flags);

		if (newLimb.endBoneID>-1 && newLimb.rootBoneID>-1)
			m_IKLimbs.push_back(newLimb);
	}
}

int CActor::GetIKLimbIndex(const char *limbName)
{
	for (int i=0;i<m_IKLimbs.size();++i)
		if (!strcmp(limbName,m_IKLimbs[i].name))
			return i;

	return -1;
}

//////////////////////////////////////////////////////////////////////////
void CActor::SetIKArm(const Vec3 &vGoal, int nArm)
{
	m_vIKArmGoal=vGoal;
	m_nIKArm=nArm;
}

//////////////////////////////////////////////////////////////////////////
void CActor::ProcessIKLimbs(ICharacterInstance *pCharacter,float frameTime)
{
	ISkeleton * pSkeleton = pCharacter->GetISkeleton();

	//GetISystem()->GetIRenderer()->GetIRenderAuxGeom()->DrawSphere(m_vIKArmGoal,0.2f,ColorB(0,255,255,255) );
 
	if (m_nIKArm==1)
		pSkeleton->SetLArmIK(m_vIKArmGoal);
	else
	if (m_nIKArm==0)
		pSkeleton->SetRArmIK(m_vIKArmGoal);
	
	// [marco] returned out as it is not clear what's going on next.
	// didnt commented out the code so it should be easier to integrate
	// but this code should eventually go away
	return; 

	//first thing: restore the original animation pose if there was some IK
	//FIXME: it could get some optimization.
	for (int i=0;i<m_IKLimbs.size();++i)
		m_IKLimbs[i].Update(GetEntity(),frameTime);

	if (m_grabStats.grabId>0 && pCharacter && m_grabStats.followBoneID>-1)
	{
		Matrix34 entMtx(GetEntity()->GetSlotWorldTM(0));
		//entMtx.NoScale();
		Vec3 bonePos(pCharacter->GetISkeleton()->GetAbsJPositionByID(m_grabStats.followBoneID));

		//static float color[] = {1,1,1,1};
		//GetISystem()->GetIRenderer()->Draw2dLabel(100,50,1.5,color,false,"bonePos:%f,%f,%f", bonePos.x,bonePos.y,bonePos.z);

		m_grabStats.followBoneWPos = entMtx * bonePos;
	}
	else
		m_grabStats.followBoneWPos.zero();	
}

IAnimationGraphState * CActor::GetAnimationGraphState()
{
	if (m_pAnimatedCharacter)
		return m_pAnimatedCharacter->GetAnimationGraphState();
	else
		return NULL;
}

Vec3 CActor::GetAIAttentionPos()
{
	IAIObject* pObject = GetEntity()->GetAI();
	IPipeUser* pPipeUser = 0;

	if (pObject && pObject->CanBeConvertedTo(AIOBJECT_PIPEUSER,(void**) &pPipeUser))
	{
		IAIObject* pTarget = pPipeUser->GetAttentionTarget();
		if (pTarget)
			return pTarget->GetPos();
	}

	return ZERO;
}

//------------------------------------------------------------------------
void CActor::SelectNextItem(int direction, bool keepHistory)
{
	IInventory *pInventory = static_cast<IInventory *>(GetGameObject()->QueryExtension("Inventory"));
	if (!pInventory)
		return;

	if (pInventory->GetCount() < 1)
		return;

	int startSlot = -1;
	int delta = direction;
	EntityId currentItemId = pInventory->GetCurrentItem();

	if (currentItemId)
		startSlot = pInventory->FindItem(currentItemId);

	int skip = pInventory->GetCount(); // maximum number of interactions
	while(skip)
	{
		int slot = startSlot+delta;

		if (slot<0)
			slot = pInventory->GetCount()-1;
		else if (slot >= pInventory->GetCount())
			slot = 0;

		if (startSlot==slot)
			return;

		EntityId itemId = pInventory->GetItem(slot);
		IItem *pItem = m_pItemSystem->GetItem(itemId);

		if (pItem && pItem->CanSelect())
		{
			m_pItemSystem->SetActorItem(this, pItem->GetEntityId());
			return;
		}

		startSlot = slot;
		--skip;
	}
}

//------------------------------------------------------------------------
CItem *CActor::GetItem(EntityId itemId)
{
	return static_cast<CItem *>(m_pItemSystem->GetItem(itemId));
}

//------------------------------------------------------------------------
CWeapon *CActor::GetWeapon(EntityId itemId)
{
	CItem *pItem = static_cast<CItem *>(m_pItemSystem->GetItem(itemId));
	if (pItem)
		return static_cast<CWeapon *>(pItem->GetIWeapon());

	return 0;
}

//------------------------------------------------------------------------
void CActor::SelectLastItem(bool keepHistory)
{
	IInventory *pInventory = static_cast<IInventory *>(GetGameObject()->QueryExtension("Inventory"));
	if (!pInventory)
		return;

	EntityId itemId = pInventory->GetLastItem();
	IItem *pItem = m_pItemSystem->GetItem(itemId);

	if (pItem)
		m_pItemSystem->SetActorItem(this, pItem->GetEntityId());
}

//------------------------------------------------------------------------
void CActor::SelectItemByName(const char *name, bool keepHistory)
{
	IInventory *pInventory = static_cast<IInventory *>(GetGameObject()->QueryExtension("Inventory"));
	if (!pInventory)
		return;

	if (pInventory->GetCount() < 1)
		return;

	EntityId itemId = pInventory->GetItemByClass(name);
	IItem *pItem = m_pItemSystem->GetItem(itemId);

	if (pItem)
		m_pItemSystem->SetActorItem(this, pItem->GetEntityId());
}

//------------------------------------------------------------------------
void CActor::SelectItem(EntityId itemId, bool keepHistory)
{
	IInventory *pInventory = static_cast<IInventory *>(GetGameObject()->QueryExtension("Inventory"));
	if (!pInventory)
		return;

	if (pInventory->GetCount() < 1)
		return;

	if (pInventory->FindItem(itemId) < 0)
	{
		GameWarning("Trying to select an item which is not in %s's inventory!", GetEntity()->GetName());
		return;
	}

	IItem *pItem = m_pItemSystem->GetItem(itemId);

	if (pItem)
		m_pItemSystem->SetActorItem(this, pItem->GetEntityId());
}

//------------------------------------------------------------------------
void CActor::HolsterItem(bool holster)
{
	IInventory *pInventory = static_cast<IInventory *>(GetGameObject()->QueryExtension("Inventory"));
	if (!pInventory)
		return;

	pInventory->HolsterItem(holster);
}

//------------------------------------------------------------------------
void CActor::PickUpItem(EntityId itemId, bool sound)
{
	IItem *pItem = m_pItemSystem->GetItem(itemId);
	if (!pItem)
		return;

	if (!CanPickUpObject(pItem->GetEntity()))  //try to pick up ...
	{
		pItem->PickUp(GetEntityId(), true);
		const char *str="You need more strength to pick it up!";
		SGameObjectEvent evt("HUD_TextMessage",eGOEF_ToAll, IGameObjectSystem::InvalidExtensionID, (void*)str);
		m_pGameFramework->GetIGameObjectSystem()->BroadcastEvent(evt);
		DropItem(pItem->GetEntityId());
		return;
	}

	if (m_pGameFramework->IsServer())
		pItem->PickUp(GetEntityId(), true);
	else
		GetGameObject()->InvokeRMI(SvRequestPickUpItem(), ItemIdParam(itemId), eRMI_ToServer);
}

//------------------------------------------------------------------------
void CActor::DropItem(EntityId itemId)
{
	IItem *pItem = m_pItemSystem->GetItem(itemId);
	if (!pItem)
		return;

	if (m_pGameFramework->IsServer())
		pItem->Drop();
	else
		GetGameObject()->InvokeRMI(SvRequestDropItem(), ItemIdParam(itemId), eRMI_ToServer);
}

//------------------------------------------------------------------------
IItem *CActor::GetCurrentItem() const
{
	IInventory *pInventory = static_cast<IInventory *>(GetGameObject()->QueryExtension("Inventory"));
	if (!pInventory)
		return 0;

	return m_pItemSystem->GetItem(pInventory->GetCurrentItem());
}

//------------------------------------------------------------------------
IInventory *CActor::GetInventory() const
{
	IInventory *pInventory = static_cast<IInventory *>(GetGameObject()->QueryExtension("Inventory"));
	return pInventory;
}

//------------------------------------------------------------------------
EntityId CActor::NetGetCurrentItem() const
{
	IInventory *pInventory = GetInventory();
	if (!pInventory)
		return 0;

	return pInventory->GetCurrentItem();
}

//------------------------------------------------------------------------
void CActor::NetSetCurrentItem(EntityId id)
{
	if ((!GetCurrentItem() && id) || (GetCurrentItem() && GetCurrentItem()->GetEntityId() != id))
		CryLogAlways("%s::NetSetCurrentItem(%08x: %s)", GetEntity()->GetName(), id, GetItem(id)?GetItem(id)->GetEntity()->GetName():"null");

	if (GetInventory() && GetInventory()->FindItem(id)>-1)
		m_pItemSystem->SetActorItem(this, id, false);
}

//------------------------------------------------------------------------
void CActor::UpdateFootSteps(float frameTime)
{
	Vec3 curPos = GetEntity()->GetWorldPos();
	float delta = (m_lastFootStepPos - curPos).len();
	if (delta > 1.5f)
	{		
		ICharacterInstance *chr = GetEntity()->GetCharacter(0);
		if (!chr)
			return;

		SMFXRunTimeEffectParams params;
		params.angle = GetEntity()->GetWorldAngles().z + g_PI/2.0f;
				
		int boneID = GetBoneID(m_rightFoot?BONE_FOOT_R:BONE_FOOT_L);

		Vec3 pos;
		if (boneID>-1)
			pos = GetEntity()->GetSlotWorldTM(0) * chr->GetISkeleton()->GetAbsJPositionByID(boneID);
		else
			pos = curPos;		

		// Get the material we're walking on
		ray_hit ray;

		static const unsigned int objTypes = ent_all;    
		static const int flags = rwi_stop_at_pierceable|rwi_colltype_any|rwi_any_hit;
		Matrix33 mat = Matrix33::CreateRotationXYZ(GetAngles());
		Vec3 up = mat.GetColumn(2).normalize();
		Vec3 down = up * -1.0f;
		int col = GetISystem()->GetIPhysicalWorld()->RayWorldIntersection(pos, down * 100.0f, objTypes, flags, &ray, 1, GetEntity()->GetPhysics());
		const char *effect = 0;
		if (col && GetActorStats()->onGround)
		{
			params.pos = ray.pt;
			params.normal = ray.n;
			int mat = ray.surface_idx;
			//CryLogAlways("hit material: %s id: %d mat: %d", GetISystem()->GetI3DEngine()->GetMaterialManager()->GetSurfaceType(mat)->GetName(), ray.idmatOrg, mat);
			effect = GetISystem()->GetIGame()->GetIGameFramework()->GetIMaterialEffects()->GetEffectString("footstep", mat);
		}
		/*
		local soundRange = 1;
		local soundStart = 0;
		local maxSpeed = 1;
		if (stats.stance == STANCE_PRONE) then
			soundRange = 0.25;
		soundStart = 0;
		maxSpeed = self.gameParams.stance[3].speed;
		elseif (stats.stance == STANCE_CROUCH) then
			soundRange = 0.25;
		soundStart = 0.25;
		maxSpeed = self.gameParams.stance[2].speed;
		else
			soundRange = 0.5;
		soundStart = 0.5;
		maxSpeed = self.gameParams.stance[1].speed;
		end

			local normalizedSpeed = __min(stats.flatSpeed / maxSpeed,1.0);
		--Sound.SetSoundPaused(sound,true);
		Sound.SetParameterValue(sound,"speed",(soundStart + normalizedSpeed*soundRange));
		*/

		//GetISystem()->GetIGame()->GetIGameFramework();
		SmartScriptTable stats;
		stats.Create(GetISystem()->GetIScriptSystem());
		GetStats(stats);
		float flatspeed;
		float footstepRadius = 6;
		float proneMult = .1f;
		float crouchMult = .3f;
		float movingMult = 2.0f;
		if (stats->GetValue("flatSpeed", flatspeed))
		{
			EStance stance = GetStance();
			if (effect)
			{
				float soundRange = 1.0f;
				float soundStart = 0;
				float maxSpeed = 1.0f;
				if (stance == STANCE_PRONE)
				{
					soundRange = .25f;
					soundStart = 0.0f;
					maxSpeed = GetStanceInfo(stance)->maxSpeed;
				}
				else if (stance == STANCE_CROUCH)
				{
					soundRange = .25f;
					soundStart = .25f;
					maxSpeed = GetStanceInfo(stance)->maxSpeed;
				}
				else
				{
					soundRange = .5f;
					soundStart = .5f;
					maxSpeed = GetStanceInfo(stance)->maxSpeed;
				}
				float normalizedSpeed = min(flatspeed/maxSpeed, 1.0f);
				SMFXSoundEffectParam *speed = new SMFXSoundEffectParam();
				speed->paramName = "speed";
				speed->paramValue = soundStart + normalizedSpeed*soundRange;
				speed->pNext = params.soundParams;
				params.soundParams = speed;
				GetISystem()->GetIGame()->GetIGameFramework()->GetIMaterialEffects()->ExecuteEffect(effect, params);
			}
			
			if (stance == STANCE_CROUCH)
				footstepRadius *= crouchMult;
			else if (stance == STANCE_PRONE)
				footstepRadius *= proneMult;
			else if (flatspeed > .1)
			{
				float maxSpeed = GetStanceInfo(stance)->maxSpeed;
				float mult = 1.0 - (max(0.0f, maxSpeed - flatspeed)/maxSpeed);
				footstepRadius *= (1 + mult);
			}

			SmartScriptTable plrTable = GetEntity()->GetScriptTable();
			float dampen;
			if (plrTable->GetValue("AISoundDampen", dampen))
			{
				footstepRadius *= dampen;
			}
			IAISystem *aiSys = GetISystem()->GetAISystem();
			if (aiSys)
			{
				if (GetEntity()->GetAI())
					aiSys->SoundEvent(GetEntity()->GetWorldPos(), footstepRadius, 0, 1, GetEntity()->GetAI());
				else
					aiSys->SoundEvent(GetEntity()->GetWorldPos(), footstepRadius, 0, 1, NULL);
			}
			
		}
		
		m_lastFootStepPos = curPos;
		m_rightFoot = !m_rightFoot;
	}
}

IMPLEMENT_RMI(CActor, ClDBGRMIValidateInventory)
{
	IInventory *pInventory = static_cast<IInventory *>(GetGameObject()->QueryExtension("Inventory"));
	if (!pInventory)
	{
		GameWarning("[gamenet] Inventory check failed! Client has no inventory!");
		return false;
	}

	if (pInventory->GetCount() != params.count)
	{
		GameWarning("[gamenet] Inventory check failed! Server has %d items, client has %d!", params.count,
			pInventory->GetCount());
		return false;
	}

	return true;
}

//------------------------------------------------------------------------
IMPLEMENT_RMI(CActor, SvRequestDropItem)
{
	CItem *pItem = GetItem(params.itemId);
	if (!pItem)
	{
		GameWarning("[gamenet] Failed to drop item. Item not found!");
		return false;
	}

	CryLogAlways("%s::SvRequestDropItem(%s)", GetEntity()->GetName(), pItem->GetEntity()->GetName());

	pItem->Drop();

	return true;
}

//------------------------------------------------------------------------
IMPLEMENT_RMI(CActor, SvRequestPickUpItem)
{
	CItem *pItem = GetItem(params.itemId);
	if (!pItem)
	{
		GameWarning("[gamenet] Failed to pickup item. Item not found!");
		return false;
	}

	CryLogAlways("%s::SvRequestPickUpItem(%s)", GetEntity()->GetName(), pItem->GetEntity()->GetName());

	pItem->PickUp(GetEntityId(), true);

	return true;
}

//------------------------------------------------------------------------
IMPLEMENT_RMI(CActor, ClDropItem)
{
	CItem *pItem = GetItem(params.itemId);
	if (!pItem)
	{
		GameWarning("[gamenet] Failed to drop item. Item not found!");
		return false;
	}

	pItem->Drop();

	return true;
}

//------------------------------------------------------------------------
IMPLEMENT_RMI(CActor, ClPickUpItem)
{
	CItem *pItem = GetItem(params.itemId);
	if (!pItem)
	{
		GameWarning("[gamenet] Failed to pickup item. Item not found!");
		return false;
	}

	pItem->PickUp(GetEntityId(), true);

	return true;
}

//------------------------------------------------------------------------
IMPLEMENT_RMI(CActor, ClRevive)
{
	Revive();

	GetEntity()->SetWorldTM(Matrix34::Create(Vec3(1,1,1), params.rot, params.pos));
	SetAngles(Ang3(params.rot));

	return true;
}

//------------------------------------------------------------------------
IMPLEMENT_RMI(CActor, ClKill)
{
	if (GetHealth()>0)
		SetHealth(0);

	Kill();

	if (params.ragdoll)
		RagDollize();

	if (params.cleaninv)
		GetInventory()->Clear();

	g_pGame->GetGameRules()->OnKillMessage(GetEntityId(), params.shooterId, params.weaponId, params.damage, params.material);

	return true;
}

//------------------------------------------------------------------------
IMPLEMENT_RMI(CActor, ClMoveTo)
{
	GetEntity()->SetWorldTM(Matrix34::Create(Vec3(1,1,1), params.rot, params.pos));

	return true;
}
