/*************************************************************************
  Crytek Source File.
  Copyright (C), Crytek Studios, 2001-2004.
 -------------------------------------------------------------------------
  $Id$
  $DateTime$
  Description: Implements the naked alien.
  
 -------------------------------------------------------------------------
  History:
  - 6:12:2004: Created by Filippo De Luca

*************************************************************************/
#ifndef __ALIEN_H__
#define __ALIEN_H__

#if _MSC_VER > 1000
# pragma once
#endif

#include "Actor.h"
#include <IActionMapManager.h>

struct SViewParams;
struct IItemSystem;
struct IGroundEffect;

//this might change
struct SAlienInput
{
	Vec3 deltaMovement;//desired movement change: X = side movement, Y = forward, Z = up
	Vec3 deltaRotation;//desired rotation change, X = pitch, Z = yaw, Y will probably be the lean

	int actions;

	//misc
	Vec3 movementVector;//direct movement vector, it will be capped between 0-1 length, used only by AI for now
	Vec3 viewVector;//if len != 0 use as view direction (no roll atm)

	Vec3 posTarget;
	Vec3 dirTarget;
	Vec3 upTarget;
	float	speedTarget;

	static const int STICKY_ACTIONS = 
		ACTION_JUMP | 
		ACTION_CROUCH |
		ACTION_LEANLEFT | 
		ACTION_LEANRIGHT |
		ACTION_SPRINT;

	void ResetDeltas()
	{
		deltaMovement.Set(0,0,0);
		deltaRotation.Set(0,0,0);
		movementVector.Set(0,0,0);
		viewVector.Set(0,0,0);

		//REMINDER:be careful setting the actions to 0, some actions may not need to be resetted each frame.
		actions &= ~STICKY_ACTIONS;
	};

	SAlienInput()
	{
		memset(this,0,sizeof(SAlienInput));
		speedTarget = 1.0f;
	}

	void Serialize( TSerialize ser, unsigned aspects );
};

//this might change
struct SAlienStats : public SActorStats
{
	float speedModule;

	float mass;
	float	bobCycle;

	float sprintLeft;
	float sprintTreshold;
	float sprintMaxSpeed;

	bool isThirdPerson;
	
	bool isFiring;
	bool inZeroG;
	bool isFloating;
  
	Vec3 velocity;
	Vec3 gravity;

	Vec3 eyePos;
	Ang3 eyeAngles;

	//LM
	float desiredSpeed;
	//

	//AI
	Vec3 lookTargetSmooth;
	Vec3 fireDir;
	Vec3 fireDirGoal;

	//misc
	float physicsAnimationRatio;
	Vec3 animationSpeedVec;
	Vec3 lastRootPos;

	SAlienStats()
	{
		memset(this,0,sizeof(SAlienStats));

		fireDir.Set(0,1,0);
		fireDirGoal.Set(0,1,0);
	}

	void Serialize( TSerialize ser, unsigned aspects );
};

struct SAlienParams : public SActorParams
{
	float speedInertia;
	float rollAmount;
	float rollSpeed;
		
	float sprintMultiplier;
	float sprintDuration;

	float rotSpeed_min;
	float rotSpeed_max;
		
	float speed_min;

	float forceView;
	
	float movingBend;

	float idealSpeed;
	float blendingRatio;
	float	approachLookat;

	char fullAnimTentacles[256];
	float fullAnimationTentaclesBlendMult;
	int8 tentaclesCollide;

	Vec3 jumpTo;

	char tentaclesMaterial[64];
	float tentaclesRadius;
	float tentaclesJointLimit;

	float cameraShakeRange;
	float cameraShakeMultiplier;

	char groundEffect[128];
	float groundEffectHeight;

	SAlienParams()
	{
		memset(this,0,sizeof(SAlienParams));

		speedInertia = 3.0f;
		rollAmount = 1.0f;
		rollSpeed = 1.0f;
		
		sprintMultiplier = 1.5f;
		sprintDuration = 0.5f;
		
		idealSpeed = -1.0f;
		blendingRatio = 10.0f; 
		approachLookat = 0;

		rotSpeed_min = 0.0f;
		rotSpeed_max = 0.6f;
		
		speed_min = 0.0f;

		forceView = 1.0f;

		fullAnimationTentaclesBlendMult = 10.0f;

		tentaclesCollide = 0;

		strcpy(tentaclesMaterial,"mat_alien_flesh");
		tentaclesRadius = 0.1f;
		tentaclesJointLimit = 10.0f;

		cameraShakeRange = 90.0f;
		cameraShakeMultiplier = 1.0f;
	}

	void Serialize( TSerialize ser, unsigned aspects );
};

class CAlien :
	public CActor,
	public IActionListener
{
public:

	CAlien();
	virtual ~CAlien();

	// CActor
	virtual void ProcessEvent(SEntityEvent& event);

	virtual bool Init( IGameObject * pGameObject );
	virtual void Update(SEntityUpdateContext&, int updateSlot);
	virtual void UpdateView(SViewParams &viewParams);

	virtual void Kill();
	virtual void Revive(bool fromInit = false);
	virtual void RagDollize();
	virtual void BindInputs( IAnimationGraph * pGraph );

	virtual void OnAction(const ActionId& actionId, int activationMode, float value);
	virtual void Serialize( TSerialize ser, unsigned aspects );
	virtual void SerializeXML( XmlNodeRef& node, bool bLoading );
	virtual void SetAuthority( bool auth );
	//AI specific
	virtual void SetActorMovement(SOBJECTSTATE &control);
	virtual void GetActorInfo( SAIBodyInfo& bodyInfo );
	//retrieve actor status
	virtual SActorStats *GetActorStats() { return &m_stats; };
	virtual SActorParams *GetActorParams() { return &m_params; };
	virtual void SetStats(SmartScriptTable &rTable);
	virtual bool GetStats(SmartScriptTable &rTable);
	//set actor params
	virtual void SetParams(SmartScriptTable &rTable,bool resetFirst);
	virtual void PostPhysicalize();
	virtual void SetMovementTarget(const Vec3 &position,const Vec3 &looktarget,const Vec3 &up,float speed) {m_input.posTarget = position; m_input.dirTarget = looktarget; m_input.upTarget=up;m_input.speedTarget=speed;}
	virtual void SetAngles(const Ang3 &angles);
	virtual Ang3 GetAngles();
	virtual void StanceChanged(EStance last);
//	virtual void SetRotation(const Quat &rot,int flags=0);
	// ~CActor

	virtual void ProcessRotation(float frameTime);
	virtual void ProcessMovement(float frameTime);
	virtual void ProcessMovement2(float frameTime);
	
	virtual void ProcessAnimation(ICharacterInstance *pCharacter,float frameTime);
	virtual void ProcessBonesRotation(ICharacterInstance *pCharacter,float frameTime);

	//
	virtual void SetDesiredSpeed(const Vec3 &desiredSpeed);
	virtual void SetDesiredDirection(const Vec3 &desiredDir);

	virtual void ResetAnimations();

	//stances
	virtual void	SetActorStance(SOBJECTSTATE &control, int& actions);
	//

	//misc
	virtual void UpdateStats(float frameTime);
	virtual void UpdateFiringDir(float frameTime){m_stats.fireDir = m_stats.fireDirGoal;}


	virtual bool CanPickUpObject(IEntity *obj) { return true; };
	virtual bool CanPickUpObject(float mass, float volume) { return true; };

	virtual void Draw(bool draw);
	
	virtual bool IsZeroG();
	virtual bool IsFlying(){return true;}

	void SetTentacles(ICharacterInstance *pCharacter,float animStiffness,float mass = 0,float damping = 0,bool bRagdolize = false);
	void PushCharacterTentacles(ICharacterInstance *pCharacter);

	void DetachTentacle(ICharacterInstance *pCharacter,const char *tentacle);

	virtual void SetFiring(bool fire);

	virtual IActorMovementController * CreateMovementController();
	
protected:
  void SetActorMovementCommon(SOBJECTSTATE& control);
	void UpdateAnimGraph( IAnimationGraphState * pState );
  
	IItemSystem	*m_pItemSystem;
	
	Quat		m_modelQuat;//the model rotation
	Vec3		m_modelOffset;
	Vec3		m_modelOffsetAdd;

	Matrix33	m_eyeMtx;//view matrix

	Matrix33	m_viewMtx;//view matrix
	Matrix33	m_baseMtx;//base rotation matrix, rotating on the Z axis

	Matrix34	m_charLocalMtx;

	Vec3		m_velocity;
	Vec3		m_desiredVelocity;
	Quat		m_desiredVeloctyQuat;

	float		m_curSpeed;
	float		m_turnSpeed;
	float		m_turnSpeedGoal;

	int			m_requestedStance;

	//zeroG specific	
	Ang3		m_angularVel;
	//

	SAlienInput m_input;
	SAlienStats	m_stats;
	SAlienParams m_params;

	//animation Specific
	float	m_tentacleBlendRatio;

	bool	m_forceOrient;

	bool m_isFiring;//very bad, to be removed after M4

	float	m_endOfThePathTime;

	std::vector<IPhysicalEntity *> m_tentaclesProxy;
	std::vector<IPhysicalEntity *> m_tentaclesProxyFullAnimation;

	IAnimationGraph::InputID m_inputSpeed;
	IAnimationGraph::InputID m_inputDesiredSpeed;
	IAnimationGraph::InputID m_inputAiming;

	//misc
	float m_followEyesTime;
	float	m_roll;

	//effects and such
	IGroundEffect *m_pGroundEffect;
};


#endif //__ALIEN_H__
