/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2004.
-------------------------------------------------------------------------
$Id$
$DateTime$

-------------------------------------------------------------------------
History:
- 18:12:2005   14:01 : Created by Mrcio Martins

*************************************************************************/
#include "StdAfx.h"
#include "AmmoPickup.h"
#include "Weapon.h"
#include "Actor.h"
#include "IItemSystem.h"



//------------------------------------------------------------------------
void CAmmoPickup::PostInit( IGameObject * pGameObject )
{
	const char *model;
	if (GetEntityProperty("objModel", model) && model)
		SetGeometry(eIGS_ThirdPerson, model);

	CItem::PostInit(pGameObject);
}

//------------------------------------------------------------------------
void CAmmoPickup::Use(EntityId userId)
{
	CActor *pActor=GetActor(userId);

	if (!pActor)
		return;
	const char *weapon=0;
	const char *ammo=0;

	if (GetEntityProperty("WeaponName", weapon) && weapon && weapon[0] &&
		GetEntityProperty("AmmoName", ammo) && ammo && ammo[0])
	{
		int count=1;
		GetEntityProperty("Count", count);

		IInventory *pInventory = GetActorInventory(pActor);
		if (!pInventory)
			return;

		IItem *pItem = m_pItemSystem->GetItem(pInventory->GetItemByClass(weapon));
		if (!pItem)
			return;

		IWeapon *pWeapon=pItem->GetIWeapon();
		if (!pWeapon)
			return;

		pWeapon->SetClipCount(ammo, pWeapon->GetClipCount(ammo)+count);
		Hide(true);

		float timer=0;
		GetEntity()->KillTimer(eIT_Last);
		if (GetEntityProperty("Timer", timer) && timer>0.0f)
			GetEntity()->SetTimer(eIT_Last, (int)(timer*1000.0f));
	}
}

//------------------------------------------------------------------------
bool CAmmoPickup::CanUse(EntityId userId)
{
	return true;
}

//------------------------------------------------------------------------
bool CAmmoPickup::CanPickUp(EntityId pickerId)
{
	return false;
}

//------------------------------------------------------------------------
void CAmmoPickup::ProcessEvent(SEntityEvent &entityEvent)
{
	switch (entityEvent.event)
	{
	case ENTITY_EVENT_RESET:
		GetEntity()->KillTimer(eIT_Last);
		Hide(false);
		break;
	case ENTITY_EVENT_TIMER:
		if (entityEvent.nParam[0]==eIT_Last)
		{
			Hide(false);
			break;
		}
	default:
		CItem::ProcessEvent(entityEvent);
	}
}