
/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2004.
-------------------------------------------------------------------------
$Id$
$DateTime$
Description: Implements the auto combat class.

-------------------------------------------------------------------------
History:
- 27:6:2005: Created by Marco Corbetta

*************************************************************************/

#include "StdAfx.h"
#include <IPhysics.h>
#include <IEntitySystem.h>
#include <IGame.h>
#include <IGameFramework.h>
#include ".\autocombat.h"
#include "Player.h"
#include "G4Player.h"
#include "MTPseudoRandom.h"
#include "IRenderer.h"
#include "IRenderAuxGeom.h"

#include "FilmDirector.h"
#include "Game04.h"


//////////////////////////////////////////////////////////////////////////
CAutoCombat::CAutoCombat(CPlayerG4 *pPlayer)
{
	m_pPlayer=pPlayer;
	m_eGamePlayMode=eNavigationMode;
	m_pLastAiming=NULL;
	m_vLastTargetPos.Set(0,0,0);
	m_fCurrTime=0;

	m_pEntitySystem=GetISystem()->GetIEntitySystem();
	m_pActorSystem=GetISystem()->GetIGame()->GetIGameFramework()->GetIActorSystem();
	
	m_pAutoAimingRange=GetISystem()->GetIConsole()->RegisterFloat("auto_aiming_range", 15.0f, VF_DUMPTODISK, "Sets the auto-aiming range in meters");
	m_pAutoAimingDelay=GetISystem()->GetIConsole()->RegisterFloat("auto_aiming_delay", 2.0f, VF_DUMPTODISK, "Sets the auto-aiming delay in seconds");

	// TODO: needs a function to get the build number	
	uint nSeed=781;
	m_pIRandGen=new CMTRand_int32(nSeed);

	m_pLastAITarget=NULL;

	//SetGamePlayMode(eNavigationMode);
}

//////////////////////////////////////////////////////////////////////////
CAutoCombat::~CAutoCombat(void)
{
	SAFE_DELETE(m_pIRandGen);
} 

//////////////////////////////////////////////////////////////////////////
void CAutoCombat::SetTargetDir(const Vec3 &vDefaultDir)
{
	//m_pPlayer->SetWeaponTargetDir(vDefaultDir,0);
	//m_pPlayer->SetWeaponTargetDir(vDefaultDir,1);
	//m_pPlayer->SetWeaponTargetDist(0,0);
	//m_pPlayer->SetWeaponTargetDist(0,1);
}

//////////////////////////////////////////////////////////////////////////
void CAutoCombat::SetSensibleLookDir()
{
	// set a sensible look dir
	//m_pPlayer->SetDesiredDirection(vDefaultDir);
	//#### HERE ####
	Vec3 vDefaultLookDir=Vec3(0,1,0);//m_pPlayer->GetDesiredDirection();
	//if(abs(vDefaultLookDir.z)>0.5f)
	{
		vDefaultLookDir.z=0;
		vDefaultLookDir.NormalizeSafe(Vec3(0,0,1));
		vDefaultLookDir.z=-0.1f;
		vDefaultLookDir.Normalize();
//m_pPlayer->SetDesiredDirection(vDefaultLookDir);
	}
}

//////////////////////////////////////////////////////////////////////////
void CAutoCombat::SetGamePlayMode(eGamePlayMode eMode)
{

	//IActorProxy *pProxy=m_pPlayer->GetProxy();
	//if (!pProxy)
	//	return;

  if( (eMode!=m_eGamePlayMode) )
	{
		if (eMode==eCombatMode)
		{
			// set a sensible look dir
			SetSensibleLookDir();
			GetISystem()->GetILog()->Log("*** Combat mode");
		}
		else
		{
			GetISystem()->GetILog()->Log("*** Nav mode");
		}
	}


	IEntity *pEntity =m_pPlayer->GetEntity(); 		

	if (!pEntity)
		return;
	
	HSCRIPTFUNCTION scriptEvent(NULL);	
	pEntity->GetScriptTable()->GetValue("ActorEvent", scriptEvent);

	m_eGamePlayMode=eMode;

	// [marco] must be called with boolean otherwise 0/1 dont work
	if (scriptEvent)
	{
		if (m_eGamePlayMode==eNavigationMode)
			Script::Call(GetISystem()->GetIScriptSystem(),scriptEvent,pEntity->GetScriptTable(),"holster",true,NULL);
		else
		if (m_eGamePlayMode==eCombatMode)
			Script::Call(GetISystem()->GetIScriptSystem(),scriptEvent,pEntity->GetScriptTable(),"holster",false,NULL);
	}
}

// copied from IEntitySystem.h
#define PHYS_ENTITY_ALL (1<<1)|(1<<2)|(1<<3)|(1<<4)

//////////////////////////////////////////////////////////////////////////
void CAutoCombat::Update(float frameTime)
{	
	// [marco] holsterweapon cannot be called at the beginning because there is a 
	// bug in multiplayer calling load weapons after 300 ms, after connection etc.

	m_fCurrTime+=frameTime;

  if(!m_pPlayer->m_bCameraCut && !g_pGame04->GetDirector()->InCinematic())  // don't change targets mid cam cut or seq
  {
    //IEntity *pPlayerEnt=m_pPlayer->GetProxy()->GetEntity();
    IEntity *pPlayerEnt=m_pPlayer->GetEntity();
    //SAIBodyInfo bodyInfo;
    
    //m_pPlayer->GetActorInfo(bodyInfo);
		Vec3 vEyePos,vEyeDir;
		m_pPlayer->GetEyePosDir(vEyePos,vEyeDir);

    Vec3 vDefaultDir=vEyeDir;
    Vec3 vDefaultLookDir=vDefaultDir;

//	  if (m_eGamePlayMode==eNavigationMode)
    {
			vDefaultDir=Quat::CreateRotationZ(m_pPlayer->GetAiming().aimYaw)*vDefaultDir;
			SetTargetDir(vDefaultDir);

		  return;
    }

		float radius=m_pAutoAimingRange->GetFVal();	  
		Vec3 vOrigin=pPlayerEnt->GetWorldPos();

	  Vec3 bmin = vOrigin - Vec3(radius, radius, radius);
	  Vec3 bmax = vOrigin + Vec3(radius, radius, radius);

	  int physFlags = PHYS_ENTITY_ALL;

		// detect new enemies as they could come on during combat, therefore
		// when changing to left / right target the system needs to be aware of them

	  // note: this list is shared by physics for ray intersection etc.
	  // so entities must be saved into another list before ray checks for visibiilty
	  IPhysicalEntity **pList=NULL;
	  int n=GetISystem()->GetIPhysicalWorld()->GetEntitiesInBox(bmin, bmax, pList,physFlags);
  				
	  int i;
	  m_lstEntities.clear();
	  for (i=0; i<n; i++)
	  {
		  IEntity *pEnt=m_pEntitySystem->GetEntityFromPhysics(pList[i]);  // NB: sometimes returns null pointers.
		  if ((!pEnt) || (pEnt==pPlayerEnt))
			  continue;
		  int nId=pEnt->GetId();
		  IActor *pActor=m_pActorSystem->GetActor(nId);

		  if ((!pActor) || (pActor->GetHealth()<=0))
			  continue;

		  m_lstEntities.push_back(pEnt);
	  } //i
		
		// change target only if there is none or previous one died,
		// keep previous one tracked unless we go out of autoaiming range

		if (m_pLastAiming)
		{
			int nId=m_pLastAiming->GetId();
			IActor *pActor=m_pActorSystem->GetActor(nId);
			if ((pActor) && (pActor->GetHealth()>0))
			{
				// previous target still present and alive;	see if in range
				Vec3 Center=m_pLastAiming->GetWorldPos();
				Vec3 diff(Center-vOrigin);
				float fDist=diff.GetLengthSquared();			

				if (fDist<(radius*radius))
				{
					SetTargetParams(vOrigin,Center,m_pLastAiming);
					return;
				}
			}
		}	  	  

	  Vec3  Center;
	  Vec3  bestPoint3D;
	  float fBestDist=99999;
	  IEntity *pBest=NULL;

	  for (i=0;i<m_lstEntities.size();i++)
	  {
		  IEntity *pEnt=m_lstEntities[i];

		  Center=pEnt->GetWorldPos();

		  Vec3 diff(Center-vOrigin);

		  float fDist=diff.GetLengthSquared();			

		  // pick the closest		
		  if (fDist<fBestDist)
		  {		
			  ray_hit RayHit;
			  Vec3 vPos1=vOrigin;
			  //vPos1.z+=0.5f;
			  Vec3 vPos2=Center;
			  //vPos1.z+=0.5f;

			  Vec3 diff(vPos2-vPos1);
			//Vec3 offset = diff.normalized()*0.25f;    // trace not from the weapon position - to skip windows               
			IPhysicalEntity	*skipPhys[2] = {0,0};
			skipPhys[0]=pEnt->GetPhysics();
			skipPhys[1]=pPlayerEnt->GetPhysics();
			int nHits=GetISystem()->GetIPhysicalWorld()->RayWorldIntersection(Vec3(vPos1), diff, 
				ent_terrain|ent_static,rwi_ignore_noncolliding |  rwi_stop_at_pierceable, &RayHit, 1,skipPhys,2);
			if (nHits!=0)
				  continue;

			/*
			IRenderAuxGeom *pRC = GetISystem()->GetIRenderer()->GetIRenderAuxGeom();
			SAuxGeomRenderFlags renderFlags( e_Def3DPublicRenderflags );
			pRC->SetRenderFlags( renderFlags );
			pRC->DrawLine(vPos1, ColorF(0, 0.5, 0), vPos2, ColorF(0, 0.5, 0));
			*/

			  pBest=pEnt;
			  fBestDist=fDist;
			  bestPoint3D=Center;
			  //bestPoint3D.z-=0.5f;

			  //int flags = pEnt->GetRndFlags();
			  //flags |= ERF_SELECTED;
			  //pEnt->SetRndFlags(flags);              
		  }					
	  } //i

	  if (!pBest)
    {
			SetTargetDir(vDefaultDir);

      if(0)//m_pLastAiming) // Just lost a target, if it was an extreme angle fix it
				SetSensibleLookDir();
      return;
    }
      

	  if (pBest!=m_pLastAiming)
	  {
		  if (m_fCurrTime>m_pAutoAimingDelay->GetFVal())
		  {
			  m_fCurrTime=0;
  #if 1
        // Send a NewTarget hint to the director.
        {
          CFilmDirector *pDirector=g_pGame04->GetDirector();
          
          if(pDirector)
          {
            CFilmEvent ev;

            ev.type=eNewTarget;
            ev.priority=1;
            ev.vPos=pBest->GetWorldPos();
            ev.aIdActors[0]=pBest->GetId();
            if(m_pLastAiming)
              ev.aIdActors[1]=m_pLastAiming->GetId();

            //pDirector->Event(ev);
          }
        }
  #endif
		  }
		  else
      {
				SetTargetDir(vDefaultDir);
			  return;
      }
    }

		SetTargetParams(vOrigin,bestPoint3D,pBest);
  }
}


void CAutoCombat::BreakObject(IEntity *pEnt)
{
    HSCRIPTFUNCTION scriptOnExplode(NULL);

    IScriptTable *scriptTbl = pEnt->GetScriptTable();

    if (scriptTbl)
    {
      scriptTbl->GetValue("Event_Explode", scriptOnExplode);

      if (scriptOnExplode)
      {
        Script::Call(GetISystem()->GetIScriptSystem(),scriptOnExplode,scriptTbl);
      }
    }
}

//////////////////////////////////////////////////////////////////////////
void CAutoCombat::SetTargetParams(const Vec3 &vOrigin,const Vec3 &_vTarget,IEntity *pTarget)
{
	m_pLastAiming=pTarget;

	Vec3 vTarget=_vTarget;
  
  Vec3 vOrg(vOrigin.x,vOrigin.y,vOrigin.z+0.35);
	//vTarget.z-=0.25;//-=0.5f;
	Vec3 diff(vTarget-vOrg);	
//m_pPlayer->SetDesiredDirection(diff);
	float targDist=diff.len();

	//m_pPlayer->SetWeaponTargetDir(diff.GetNormalized(),1);
	//m_pPlayer->SetWeaponTargetDist(targDist,1);
}

//////////////////////////////////////////////////////////////////////////
void CAutoCombat::GetCinematicFireDirection(Vec3 &vInOutDir,bool bForceMissPlayer)
{
	IAIObject* pObject = m_pPlayer->GetEntity()->GetAI();
	IPipeUser *pPipeUser = 0;

	if (pObject && pObject->CanBeConvertedTo(AIOBJECT_PIPEUSER,(void**) &pPipeUser))
	{
		// get the attention target and see if it's the player

		IAIObject* pTarget = pPipeUser->GetAttentionTarget();
		if (pTarget && pTarget->GetType()==AIOBJECT_PLAYER)
		{
			// the FireDir it is now shooting randomly in a radius around the player.
			// lets improve that with some more cinematics hits.

			IEntity *pPlayerEnt=m_pPlayer->GetEntity();

			// decide if we're going to hit the player or not.
			uint nRandNum=(m_pIRandGen->Generate())&7;

			if ((nRandNum<=1) && (!m_pPlayer->m_bCameraCut) && (!bForceMissPlayer))  // Don't want the player killed in camera cuts
			{
				// hit the player
				vInOutDir=pTarget->GetPos()-pPlayerEnt->GetPos();
			}
			else
			{
				// miss the player - decide what to do				
				nRandNum=(m_pIRandGen->Generate())&3;			

				if (nRandNum!=1)
				{				 
					// see if there is an interesting object close to the player first.
					float radius=4.0f;
					Vec3 vOrigin=pTarget->GetPos();
					Vec3 bmin = vOrigin - Vec3(radius, radius, radius);
					Vec3 bmax = vOrigin + Vec3(radius, radius, radius);

					int physFlags = PHYS_ENTITY_ALL;

					IPhysicalEntity **pList=NULL;
					int n=GetISystem()->GetIPhysicalWorld()->GetEntitiesInBox(bmin, bmax, pList,physFlags);

					IEntity *pBestTarget=NULL;

					for (int i=0; i<n; i++)
					{
						IEntity *pEnt=m_pEntitySystem->GetEntityFromPhysics(pList[i]);  // NB: sometimes returns null pointers.
						if ((!pEnt) || (pEnt==pPlayerEnt))
							continue;

						const char *szName=pEnt->GetName();

						if (strnicmp(szName,"AITarget",8)!=0)
							continue;

						pBestTarget=pEnt;
						if (pBestTarget!=m_pLastAITarget)
							break; // try another one (if there are more) if this one was not already selected last time						
					} //i

					m_pLastAITarget=pBestTarget;

					if (pBestTarget)
					{
						// shoot there
						Vec3 vSource=pPlayerEnt->GetPos();
						// shooting position is higher than entity pos. 
						// apparently from the head.
						// adjust it othrwise it will miss small targets						
						vSource.z+=0.7f;
						vInOutDir=pBestTarget->GetPos()-vSource;
            // Objects don't break when shot at the moment, so try this
            if(( (m_pIRandGen->Generate())&3) == 0)
              BreakObject(pBestTarget);

						/*
						IRenderAuxGeom *pRC = GetISystem()->GetIRenderer()->GetIRenderAuxGeom();
						SAuxGeomRenderFlags renderFlags( e_Def3DPublicRenderflags );
						pRC->SetRenderFlags( renderFlags );
						pRC->DrawLine(pBestTarget->GetPos(), ColorF(0, 0.5, 0), vSource, ColorF(0, 0.5, 0));
						*/

						return;
					}
				}

				// otherwise shoot following the previous player's position					
				if (m_vLastTargetPos.IsZero())
				{
					m_vLastTargetPos=pTarget->GetPos();
				}

				Vec3 vPlayerDir=pTarget->GetPos()-m_vLastTargetPos;

				// set new one for the next time...
				m_vLastTargetPos=pTarget->GetPos();

				// if the player doesn't move we use the normal random shooting.
				float fLen=vPlayerDir.GetLength();
				if (fLen<0.15f)
					return;

				// shoot in the middle
				vPlayerDir=vPlayerDir*(1.0f/fLen);
				Vec3 vTargetPos=pTarget->GetPos()+(vPlayerDir*(fLen/2.0f));
				vInOutDir=vTargetPos-pPlayerEnt->GetPos();
			}
						
		}
	}
}

//////////////////////////////////////////////////////////////////////////
void CAutoCombat::SwitchToDesiredTarget(eTargetDir eDir)
{
	if ((m_eGamePlayMode==eNavigationMode) || m_pPlayer->m_bCameraCut)
		return;

	// find current partition line
	IEntity *pPlayerEnt=m_pPlayer->GetEntity();
	Vec3 v1=pPlayerEnt->GetPos();	
	Vec3 vDir=m_pPlayer->GetWeaponTargetDir(); // returns a normalized vector
	Vec3 v2=v1+(vDir*100.0f);

	for (std::vector<IEntity*>::iterator i=m_lstEntities.begin();i!=m_lstEntities.end();i++)
	{
		IEntity *pEnt=(*i);

		if (pEnt==m_pLastAiming)
			continue; // already selected

		Vec3 vPos=pEnt->GetPos();

		// ignore z and find on which side the enemy is
		if (((v1.x-v2.x)*(vPos.y-v2.y))>=((v1.y-v2.y)*(vPos.x-v2.x)))
		{
			// right side
			if (eDir==eRight)
			{
				SetTargetParams(v1,vPos,pEnt);
				break;
			}
		}
		else
		{
			// left side
			if (eDir==eLeft)
			{
				SetTargetParams(v1,vPos,pEnt);
				break;
			}
		}
	} //i
}

