
/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2004.
-------------------------------------------------------------------------
$Id$
$DateTime$
Description: Implements the auto combat class.

-------------------------------------------------------------------------
History:
- 27:6:2005: Created by Marco Corbetta

*************************************************************************/

#pragma once

//////////////////////////////////////////////////////////////////////////
enum eGamePlayMode
{
	eNavigationMode=0,
	eCombatMode
};

enum eTargetDir
{
	eLeft=0,
	eRight,
};

//////////////////////////////////////////////////////////////////////////
class CPlayer;
class CPlayerG4;
class CMTRand_int32;

//////////////////////////////////////////////////////////////////////////
class CAutoCombat
{
public:
	CAutoCombat(CPlayerG4 *pPlayer);
	virtual ~CAutoCombat(void);

	void	Update(float frameTime);
	void  SetGamePlayMode(eGamePlayMode eMode);	
	eGamePlayMode	GetCurrentMode() { return(m_eGamePlayMode); }

	void	SwitchToDesiredTarget(eTargetDir eDir);

	void	GetCinematicFireDirection(Vec3 &vInOutDir,bool bForceMissPlayer=false);

  IEntity *GetLastAiming() { return m_pLastAiming; }

private:

	void	SetTargetParams(const Vec3 &vOrigin,const Vec3 &vTarget,IEntity *pTarget);
	void	SetTargetDir(const Vec3 &vDefaultDir);
	void	SetSensibleLookDir();

  void BreakObject(IEntity *pEnt);
	
	CMTRand_int32	*m_pIRandGen;
	Vec3					m_vLastTargetPos;
	eGamePlayMode	m_eGamePlayMode;
	float		m_fCurrTime;
	CPlayerG4	*m_pPlayer;	
	IActorSystem		*m_pActorSystem;
	IEntitySystem		*m_pEntitySystem;
	IEntity					*m_pLastAiming;
	IEntity					*m_pLastAITarget;
	ICVar						*m_pAutoAimingRange,*m_pAutoAimingDelay;	
	std::vector<IEntity *> m_lstEntities;
};
