/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2004.
-------------------------------------------------------------------------
$Id$
$DateTime$

-------------------------------------------------------------------------
History:
- 18:12:2005   14:01 : Created by Mrcio Martins

*************************************************************************/
#include "StdAfx.h"
#include "Binocular.h"

#include <IActorSystem.h>
#include <IMovementController.h>


//------------------------------------------------------------------------
void CBinocular::OnAction(EntityId actorId, const char *actionName, int activationMode, float value)
{
	if (!strcmp(actionName, "zoom_in"))
	{
		if (m_zm)
			m_zm->StartZoom();
	}
	else if (!strcmp(actionName, "zoom_out"))
	{
		if (m_zm)
			m_zm->ExitZoom();
	}
  else if (!strcmp(actionName, "attack1"))
  { 
    if (activationMode == eAAM_OnPress)
    {      
      // trigger OnShoot in here.. Binocs don't have any firemode
      Vec3 pos(ZERO);
      Vec3 dir(FORWARD_DIRECTION);

      IActor* pActor = GetISystem()->GetIGame()->GetIGameFramework()->GetIActorSystem()->GetActor(actorId);
      if (pActor)
      {
        IMovementController* pMC = pActor->GetMovementController();
        if (pMC)
        {
          SMovementState state;
          pMC->GetMovementState(state);          
          pos = state.pos;
          dir = state.eyeDirection;
        }
      }
      OnShoot(actorId, 0, "", pos, dir, Vec3(ZERO));
    }
  }
	else
		CWeapon::OnAction(actorId, actionName, activationMode, value);
}

//------------------------------------------------------------------------
void CBinocular::Select(bool select)
{
	CWeapon::Select(select);

	if (select && m_zm)
	{
		SetBusy(false);

		m_zm->StartZoom();
	}
}