/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2004.
-------------------------------------------------------------------------
$Id$
$DateTime$

-------------------------------------------------------------------------
History:
- 18:10:2005   14:14 : Created by Mrcio Martins

*************************************************************************/
#include "StdAfx.h"
#include "Game.h"
#include "Bullet.h"
#include "GameRules.h"
#include <IEntitySystem.h>
#include <IGameTokens.h>



//------------------------------------------------------------------------
CBullet::CBullet()
{
}

//------------------------------------------------------------------------
CBullet::~CBullet()
{
}

//------------------------------------------------------------------------
void CBullet::HandleEvent(const SGameObjectEvent &event)
{
	CProjectile::HandleEvent(event);

	if (!strcmpi(event.event, "OnCollision"))
	{
		if (m_destroying)
			return;

		EventPhysCollision *pCollision = reinterpret_cast<EventPhysCollision *>(event.ptr);
		if (!pCollision)
			return;

		IEntity *pTarget = pCollision->iForeignData[1]==PHYS_FOREIGN_ID_ENTITY ? (IEntity*)pCollision->pForeignData[1]:0;

		Vec3 dir(0, 0, 0);
		if (pCollision->vloc[0].GetLengthSquared() > 1e-6f)
			dir = pCollision->vloc[0].GetNormalized();

		CGameRules *pGameRules = g_pGame->GetGameRules();
	
		CGameRules::HitInfo hitInfo(m_ownerId, pTarget?pTarget->GetId():0, m_weaponId,
			m_damage, 0.0f, pGameRules->GetHitMaterialIdFromSurfaceId(pCollision->idmat[1]), pCollision->partid[1],
			pGameRules->GetHitTypeId("bullet"), pCollision->pt, dir, pCollision->n);

		hitInfo.remote = IsRemote();

		pGameRules->ClientHit(hitInfo);

		if (pCollision->pEntity[0]->GetType() == PE_PARTICLE)
		{
			float bouncy, friction;
			uint	pierceabilityMat;
			GetISystem()->GetIPhysicalWorld()->GetSurfaceParameters(pCollision->idmat[1], bouncy, friction, pierceabilityMat);
			
			pe_params_particle params;
			pCollision->pEntity[0]->GetParams(&params);

			if (pierceabilityMat<params.iPierceability)
				Destroy();
		}
	}
}


