/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2004.
-------------------------------------------------------------------------
$Id$
$DateTime$

-------------------------------------------------------------------------
History:
- 2:3:2005   16:06 : Created by Mrcio Martins

*************************************************************************/
#include "StdAfx.h"
#include "C4.h"

#include "Game.h"
#include "Actor.h"
#include "WeaponSystem.h"



//------------------------------------------------------------------------
void CC4::OnAction(EntityId actorId, const char *actionName, int activationMode, float value)
{
	if (!strcmp(actionName, "zoom"))
	{
		SetCurrentFireMode(1);
		CWeapon::OnAction(actorId, "attack1", activationMode, value);
	}
	else if (!strcmp(actionName, "attack1"))
	{
		SetCurrentFireMode(0);
		CWeapon::OnAction(actorId, actionName, activationMode, value);
	}
}

//------------------------------------------------------------------------
bool CC4::CanSelect() const
{
	CActor *pOwner=GetOwnerActor();
	if (!pOwner)
		return false;

	IFireMode *pFireMode = GetFireMode(0);
	if (pFireMode && g_pGame->GetWeaponSystem()->GetProjectile(pFireMode->GetProjectileId()))
	{
		CActor *pOwner=GetOwnerActor();
		if (!pOwner)
			return false;

		if (pOwner->GetCurrentItem() && !strcmp(pOwner->GetCurrentItem()->GetEntity()->GetClass()->GetName(), "Detonator"))
			return false;

		return true;
	}

	return CWeapon::CanSelect() && !OutOfAmmo(false);
};

//------------------------------------------------------------------------
void CC4::Select(bool select)
{
	if (select)
	{
		IFireMode *pFireMode = GetFireMode(0);
		if (pFireMode && g_pGame->GetWeaponSystem()->GetProjectile(pFireMode->GetProjectileId()))
		{
			CActor *pOwner=GetOwnerActor();
			if (!pOwner)
				return;

			EntityId detonatorId = pOwner->GetInventory()->GetItemByClass("Detonator");

			if (!detonatorId)
				g_pGame->GetIGameFramework()->GetIItemSystem()->GiveItem(pOwner, "Detonator", false, false, false);
			pOwner->SelectItemByName("Detonator", false);

			return;
		}
	}

	CWeapon::Select(select);
}