#include "StdAfx.h"
#include "CompatibilityAlienMovementController.h"
#include "Alien.h"

CCompatibilityAlienMovementController::CCompatibilityAlienMovementController( CAlien * pAlien ) : m_pAlien(pAlien), m_atTarget(false)
{
}

void CCompatibilityAlienMovementController::Reset()
{
}

bool CCompatibilityAlienMovementController::Update( float frameTime, SActorFrameMovementParams& params )
{
	return false;
}

void CCompatibilityAlienMovementController::Release()
{
	delete this;
}

bool CCompatibilityAlienMovementController::RequestMovement( CMovementRequest& request )
{
	SMovementState state;
	GetMovementState(state);

	Vec3 currentEyePos = state.eyePosition;
	Vec3 currentPos = m_pAlien->GetEntity()->GetWorldPos();

	SOBJECTSTATE os;
	// Zero out the directions here, since the constructor of the objectstate sets them to (1,0,0).
	// This prevents the entity to aligning to (1,0,0) when no input is present.
	os.vLookDir.zero();
	os.vMoveDir.zero();
	os.vFireDir.zero();
	os.vTargetPos.zero();

	os.aimLook = false;

	if (request.HasLookTarget())
	{
		os.vLookDir = /*os.vFireDir =*/ (request.GetLookTarget() - currentEyePos).GetNormalizedSafe(FORWARD_DIRECTION);
		os.vTargetPos = request.GetLookTarget();
	}
	if (request.HasAimTarget())
	{
		os.vFireDir = (request.GetAimTarget() - currentEyePos).GetNormalizedSafe(FORWARD_DIRECTION);
		os.vTargetPos = request.GetAimTarget();
		os.aimLook = true;
	}

	os.fDistanceToPathEnd = request.GetDistanceToPathEnd();

	os.fDesiredSpeedMod = 1.0f;
	if (request.HasDesiredSpeed())
		os.fDesiredSpeed = CLAMP( request.GetDesiredSpeed() / state.maxSpeed, 0, 1 );
	if (request.HasMoveTarget())
		os.vMoveDir = (request.GetMoveTarget() - currentPos).GetNormalizedSafe(FORWARD_DIRECTION);
	if (request.HasDesiredSpeedAtTarget() && request.GetDesiredSpeedAtTarget() == 0.0f && request.HasDesiredBodyDirectionAtTarget())
	{
		os.bExactPositioning = true;
		PATHPOINT p;
		p.vPos = request.GetMoveTarget();
		p.vDir = request.GetDesiredBodyDirectionAtTarget();
		os.remainingPath.push_back(p);
	}
	if (request.HasStance())
	{
		switch (request.GetStance())
		{
		case STANCE_CROUCH:
			os.bodystate = 1;
			break;
		case STANCE_PRONE:
			os.bodystate = 2;
			break;
		case STANCE_RELAXED:
			os.bodystate = 3;
			break;
		case STANCE_STEALTH:
			os.bodystate = 4;
			break;
		}
	}
	if (request.ShouldJump())
		os.jump	= true;

	m_pAlien->SetActorMovement(os);

	m_atTarget = os.bGameInPositionReached;

	return true;
}

void CCompatibilityAlienMovementController::GetMovementState( SMovementState& state )
{
	SAIBodyInfo bodyInfo;
	m_pAlien->GetActorInfo( bodyInfo );
	state.eyeHeight = bodyInfo.eyeHeight;
	state.maxSpeed = bodyInfo.maxSpeed;
	state.minSpeed = bodyInfo.minSpeed;
	state.normalSpeed = bodyInfo.normalSpeed;
	state.stance = bodyInfo.stance;
	state.stanceSize = bodyInfo.stanceSize;
	state.eyeDirection = bodyInfo.vEyeDir;
	state.eyePosition = bodyInfo.vEyePos;
	state.movementDirection = bodyInfo.vFwdDir;
	state.upDirection = bodyInfo.vUpDir;
	state.atMoveTarget = m_atTarget;
	state.handPosition = state.eyePosition;
	state.aimDirection = bodyInfo.vFireDir.GetNormalizedSafe();
	state.isAlive = (m_pAlien->GetHealth()>0);
}
