/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2004.
-------------------------------------------------------------------------
$Id$
$DateTime$

-------------------------------------------------------------------------
History:
- 11:9:2005   15:00 : Created by Mrcio Martins

*************************************************************************/
#include "StdAfx.h"
#include "Game.h"
#include "Detonate.h"
#include "WeaponSystem.h"
#include "Item.h"
#include "Weapon.h"
#include "Actor.h"
#include "Projectile.h"



//------------------------------------------------------------------------
CDetonate::CDetonate()
{
}

//------------------------------------------------------------------------
CDetonate::~CDetonate()
{
}

//------------------------------------------------------------------------
void CDetonate::Update(float frameTime, uint frameId)
{
	CSingle::Update(frameTime, frameId);

	if (m_detonationTimer>0.0f)
	{
		m_detonationTimer-=frameTime;
		if (m_detonationTimer<=0.0f)
		{
			m_detonationTimer=0.0f;

			Detonate();
		}
	}
}

//------------------------------------------------------------------------
void CDetonate::ResetParams(const struct IItemParamsNode *params)
{
	CSingle::ResetParams(params);
}

//------------------------------------------------------------------------
void CDetonate::PatchParams(const struct IItemParamsNode *patch)
{
	CSingle::PatchParams(patch);
}

//------------------------------------------------------------------------
void CDetonate::Activate(bool activate)
{
	CSingle::Activate(activate);
	m_detonationTimer=0.0f;
}

//------------------------------------------------------------------------
bool CDetonate::CanReload() const
{
	return false;
}

//------------------------------------------------------------------------
bool CDetonate::CanFire(bool considerAmmo) const
{
	return CSingle::CanFire(considerAmmo) && (m_detonationTimer<=0.0f);
}

//------------------------------------------------------------------------
void CDetonate::StartFire(EntityId shooterId)
{
	if (CanFire(false))
	{
		m_detonationTimer = 1.0f;
		m_pWeapon->PlayAction(m_actions.fire.c_str());
	}
}

//------------------------------------------------------------------------
const char *CDetonate::GetCrosshair() const
{
	return "";
}

//------------------------------------------------------------------------
void CDetonate::Detonate()
{
	IInventory *pInventory = m_pWeapon->GetActorInventory(m_pWeapon->GetOwnerActor());
	if (!pInventory)
		return;

	IItem *pItem = g_pGame->GetIGameFramework()->GetIItemSystem()->GetItem(pInventory->GetItemByClass("C4"));
	if (!pItem)
		return;

	CWeapon *pWeapon = static_cast<CWeapon *>(pItem->GetIWeapon());
	if (!pWeapon)
		return;

	CProjectile *pProjectile = g_pGame->GetWeaponSystem()->
		GetProjectile(pWeapon->GetFireMode(pWeapon->GetCurrentFireMode())->GetProjectileId());

	if (pProjectile && g_pGame->GetIGameFramework()->IsServer())
	{
		pProjectile->Explode(true);

		struct ExplodeAction: public ISchedulerAction
		{
			ExplodeAction(CDetonate *_detonate): pdetonate(_detonate) {};
			CDetonate *pdetonate;

			virtual void execute(CItem *_this)
			{
				pdetonate->SelectExplosive();
			}
		};

		m_pWeapon->GetScheduler()->TimerAction(uint(m_pWeapon->GetCurrentAnimationTime(CItem::eIGS_FirstPerson)*0.35f), new ExplodeAction(this), false);

		return;
	}
}

//------------------------------------------------------------------------
void CDetonate::SelectExplosive()
{
	CActor *pOwner=m_pWeapon->GetOwnerActor();
	if (!pOwner)
		return;

	EntityId c4Id = pOwner->GetInventory()->GetItemByClass("C4");
	CItem *pC4 = pOwner->GetItem(c4Id);

	if (!pC4 || pC4->GetIWeapon()->OutOfAmmo(true))
	{
		if (!pC4 || pOwner->GetInventory()->GetLastItem() != pC4->GetEntityId())
			pOwner->SelectLastItem(false);
		else
			pOwner->SelectNextItem(1, true);
	}
	else
		pOwner->SelectItemByName("C4", false);
}