#include "StdAfx.h"
#include "Tornado.h"
#include "../Game.h"
#include "Environment/FlowTornado.h"
#include <IEffectSystem.h>

//------------------------------------------------------------------------
CTornado::CTornado() :
	m_pGameObject(0),
	m_pEntity(0),
	m_pPhysicalEntity(0),
	m_pFunnelEffect(0),
	m_pCloudConnectEffect(0),
	m_pTopEffect(0),
	m_pGroundEffect(0),
	m_pTargetEntity(0)
{
}

//------------------------------------------------------------------------
CTornado::~CTornado()
{
	delete m_pGroundEffect;
}

//------------------------------------------------------------------------
bool CTornado::Init(IGameObject *pGameObject)
{
	m_pGameObject = pGameObject;
	m_pGameObject->EnablePhysicsEvent(true, eEPE_OnCollisionLogged);

	m_pEntity = pGameObject->GetEntity();
	SmartScriptTable props;
	const char* funnelEffect = 0;  
	GetEntity()->GetScriptTable()->GetValue("Properties", props);

	m_wanderSpeed = 10.0f;
	props->GetValue("fWanderSpeed", m_wanderSpeed);
	m_cloudHeight = 376.0f;
	props->GetValue("fCloudHeight", m_cloudHeight);

	props->GetValue("FunnelEffect", funnelEffect);
	if (!UseFunnelEffect(funnelEffect))
		return false;

	Matrix34 m = m_pEntity->GetWorldTM();
	m_wanderDir = m.GetColumn(1)*0.414214f;

	m_isOnWater = false;
	m_isInAir = false;

	return true;
}

//------------------------------------------------------------------------
void CTornado::PostInit(IGameObject *pGameObject)
{
	m_pGameObject->EnableUpdateSlot(this, 0);
}

//------------------------------------------------------------------------
void CTornado::Release()
{
	delete this;
}

//------------------------------------------------------------------------
void CTornado::Serialize(TSerialize ser, unsigned aspects)
{
}

//------------------------------------------------------------------------
void CTornado::Update(SEntityUpdateContext &ctx, int updateSlot)
{
	if (g_pGame->GetIGameFramework()->IsEditing())
		return;
	// wandering
	Matrix34 m = m_pEntity->GetWorldTM();
	Vec3 dir(m.GetColumn(1));
	Vec3 pos(m_pEntity->GetWorldPos());

	Vec3 wanderPos(dir * 1.414214f);
	float wanderStrength(1.0f);
	float wanderRate(0.6f);
	Vec3 wanderOffset;
	wanderOffset.SetRandomDirection();
	wanderOffset.z = 0.0f;
	wanderOffset.NormalizeSafe(Vec3(1,0,0));
	m_wanderDir += wanderOffset * wanderRate + (m_wanderDir - wanderPos) * wanderStrength;
	m_wanderDir = (m_wanderDir - wanderPos).GetNormalized() + wanderPos;

	Vec3 wanderSteer = (dir + m_wanderDir * GetISystem()->GetITimer()->GetFrameTime());
	wanderSteer.z = 0;
	wanderSteer.NormalizeSafe(Vec3(1,0,0));

	Vec3 targetSteer(0,0,0);
	// go to target
	if (m_pTargetEntity)
	{
		Vec3 target = m_pTargetEntity->GetWorldPos() - pos;
		if (target.GetLength() < 10.0f)
		{
			// emit target reached event
			SEntityEvent event( ENTITY_EVENT_SCRIPT_EVENT );
			event.nParam[0] = (INT_PTR)"TargetReached";
			event.nParam[1] = IEntityClass::EVT_BOOL;
			bool bValue = true;
			event.nParam[2] = (INT_PTR)&bValue;
			m_pEntity->SendEvent( event );
			if (m_pTargetCallback)
				m_pTargetCallback->Done();

			m_pTargetEntity = 0;
			m_pTargetCallback = 0;
		}

		targetSteer = (target - dir);
		targetSteer.z = 0;
		targetSteer.NormalizeSafe(Vec3(1,0,0));
	}

	Vec3 steerDir = (0.4f * wanderSteer + 0.6f * targetSteer).GetNormalized();
	Matrix34 tm = Matrix34(Matrix33::CreateRotationVDir(steerDir));
	pos = pos + steerDir * GetISystem()->GetITimer()->GetFrameTime() * m_wanderSpeed;
	pos.z = GetISystem()->GetI3DEngine()->GetTerrainElevation(pos.x, pos.y);
	float waterLevel = GetISystem()->GetI3DEngine()->GetWaterLevel(&pos);

	bool prevIsOnWater = m_isOnWater;
	m_isOnWater = (pos.z < waterLevel);
	if (m_isOnWater)
	{
		pos.z = waterLevel;
	}

	if (prevIsOnWater != m_isOnWater)
	{
		//state has changed
		if (m_isOnWater)
		{
			m_pGroundEffect->SetParticleEffect("wind.tornado.water");
			//GetEntity()->LoadParticleEmitter(3, m_pWaterEffect, 0, -1, true);
		}
		else
		{
			m_pGroundEffect->SetParticleEffect("wind.tornado.leaves");
			//GetEntity()->LoadParticleEmitter(3, m_pGroundEffect, 0, -1, true);
		}
	}

	tm.SetTranslation(pos);

	m_pEntity->SetWorldTM(tm);
	UpdateParticleEmitters();
}

//------------------------------------------------------------------------
void CTornado::HandleEvent(const SGameObjectEvent &event)
{
}

//------------------------------------------------------------------------
void CTornado::ProcessEvent(SEntityEvent &event)
{
}

//------------------------------------------------------------------------
IEntity *CTornado::GetEntity()
{
	return m_pEntity;
}

//------------------------------------------------------------------------
void CTornado::SetAuthority(bool auth)
{
}

void CTornado::SetTarget(IEntity *pTargetEntity, CFlowTornadoWander *pCallback)
{
	m_pTargetEntity = pTargetEntity;
	m_pTargetCallback = pCallback;
}


bool CTornado::UseFunnelEffect(const char* effectName)
{
	m_pFunnelEffect = GetISystem()->GetI3DEngine()->FindParticleEffect(effectName);

	if (!m_pFunnelEffect)
		return false;

	// move particle slot to the helper position+offset
	GetEntity()->LoadParticleEmitter(0, m_pFunnelEffect, 0, -1, true);
	Matrix34 tm = IParticleEffect::ParticleLoc(Vec3(0,0,0));
	GetEntity()->SetSlotLocalTM(0, tm);
	GetEntity()->SetSlotFlags(0, GetEntity()->GetSlotFlags(0)|ENTITY_SLOT_RENDER);

	// init the first time
	if (!m_pCloudConnectEffect)
	{
		m_pCloudConnectEffect = GetISystem()->GetI3DEngine()->FindParticleEffect("wind.tornado.cloud_connection");
		if (m_pCloudConnectEffect)
		{
			GetEntity()->LoadParticleEmitter(1, m_pCloudConnectEffect, 0, -1, true);
		}
	}
	if (!m_pTopEffect)
	{
		m_pTopEffect = GetISystem()->GetI3DEngine()->FindParticleEffect("wind.tornado.top_part");
		if (m_pTopEffect)
		{
			GetEntity()->LoadParticleEmitter(2, m_pTopEffect, 0, -1, true);
		}
	}

	if (!m_pGroundEffect)
	{
		m_pGroundEffect = g_pGame->GetIGameFramework()->GetIEffectSystem()->CreateGroundEffect(GetEntity());
		m_pGroundEffect->SetParticleEffect("wind.tornado.leaves");
	}
/*
	if (!m_pGroundEffect)
	{
		m_pGroundEffect = GetISystem()->GetI3DEngine()->FindParticleEffect("wind.tornado.leaves");
		if (m_pGroundEffect)
		{
			GetEntity()->LoadParticleEmitter(3, m_pGroundEffect, 0, -1, true);
			GetEntity()->SetSlotFlags(3, GetEntity()->GetSlotFlags(3)|ENTITY_SLOT_RENDER);
		}
	}
	if (!m_pWaterEffect)
	{
		m_pWaterEffect = GetISystem()->GetI3DEngine()->FindParticleEffect("wind.tornado.water");
	}
*/

	UpdateParticleEmitters();
	return true;
}

void CTornado::UpdateParticleEmitters()
{
	Matrix34 tm;
	Vec3 pos(0,0,0);
	pos.z = (m_pEntity->GetWorldPos()).z;
	Vec3 cloudOffset(pos);

	if (m_pCloudConnectEffect)
	{
		cloudOffset.z = m_cloudHeight - pos.z;
		tm = IParticleEffect::ParticleLoc(cloudOffset);
		GetEntity()->SetSlotLocalTM(1, tm);
		GetEntity()->SetSlotFlags(1, GetEntity()->GetSlotFlags(1)|ENTITY_SLOT_RENDER);
	}

	if (m_pTopEffect)
	{
		Vec3 topOffset(cloudOffset);
		topOffset.z -= 140.0f;

		tm = IParticleEffect::ParticleLoc(topOffset);
		GetEntity()->SetSlotLocalTM(2, tm);
		GetEntity()->SetSlotFlags(2, GetEntity()->GetSlotFlags(2)|ENTITY_SLOT_RENDER);
	}

	m_pGroundEffect->Update();
}