/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2006.
-------------------------------------------------------------------------
$Id$
$DateTime$
Description: Tornado entity

-------------------------------------------------------------------------
History:
- 21:02:2006: Created by Marco Koegler

*************************************************************************/
#ifndef __TORNADO_H__
#define __TORNADO_H__
#pragma once

#include <IGameObject.h>

class CFlowTornadoWander;
struct IGroundEffect;

class CTornado : public CGameObjectExtensionHelper<CTornado, IGameObjectExtension>
{
public:
	CTornado();
	virtual ~CTornado();

	// IGameObjectExtension
	virtual bool Init(IGameObject *pGameObject);
	virtual void InitClient(int channelId) {};
	virtual void PostInit(IGameObject *pGameObject);
	virtual void PostInitClient(int channelId) {};
	virtual void Release();
	virtual void Serialize(TSerialize ser, unsigned aspects);
	virtual void Update( SEntityUpdateContext &ctx, int updateSlot);
	virtual void PostUpdate(float frameTime ) {};
	virtual void HandleEvent( const SGameObjectEvent &);
	virtual void ProcessEvent(SEntityEvent &);
	virtual void SetChannelId(uint16 id) {}
	virtual IEntity * GetEntity();
	virtual void SetAuthority(bool auth);
	//~IGameObjectExtension

	void	SetTarget(IEntity *pTargetEntity, CFlowTornadoWander *pCallback);

protected:
	bool	UseFunnelEffect(const char* effectName);
	void	UpdateParticleEmitters();

	IGameObject*			m_pGameObject;
	IEntity*					m_pEntity;
	IPhysicalEntity*	m_pPhysicalEntity;

	// appearance of tornado
	IParticleEffect*	m_pFunnelEffect;
	IParticleEffect*	m_pCloudConnectEffect;
	IParticleEffect*	m_pTopEffect;
	IGroundEffect*		m_pGroundEffect;
	float							m_cloudHeight;
	bool							m_isOnWater;
	bool							m_isInAir;

	// wandering
	Vec3							m_wanderDir;
	float							m_wanderSpeed;

	// target
	IEntity*						m_pTargetEntity;	// the tornado will try to reach this entity
	CFlowTornadoWander*	m_pTargetCallback;
};

#endif //__TORNADO_H__
