/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2004.
-------------------------------------------------------------------------
$Id$
$DateTime$
Description: Monitors the world for the CFilmDirector.
-------------------------------------------------------------------------
History:
- 30:6:2005: Created by Nick Hesketh

*************************************************************************/

#pragma once


class CFilmDirector;
class CGame;

class CFilmBubble;
struct IActor;
struct IActorSystem;
struct IEntitySystem;

#include <IEntitySystem.h>    // For EntityId typedef

//! Monitors the world for the CFilmDirector.
class CFilmWorld
{
public:
  CFilmWorld(CFilmDirector *pDirector,CGame *pGame);
  CFilmWorld::~CFilmWorld();

  void Update(float frameTime);

  IActor *GetActorForEntityId(EntityId idEntity);
  IEntitySystem *GetEntitySystem() { return m_pEntitySystem; }

  int GetBubbleNumber() { return m_iBubble; }
  float GetBubbleProgress();

private:
  CFilmDirector *m_pDirector;
  CGame *m_pGame;
  CFilmBubble *m_pBubble;
  IActorSystem *m_pActorSystem;
  IEntitySystem *m_pEntitySystem;
  int m_iBubble;
};
