/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2004.
-------------------------------------------------------------------------
$Id$
$DateTime$

-------------------------------------------------------------------------
History:
- 19:12:2005   12:10 : Created by Mrcio Martins

*************************************************************************/
#include "StdAfx.h"
#include "FreezingBeam.h"
#include <IGameRulesSystem.h>
#include <IEntitySystem.h>


//------------------------------------------------------------------------
CFreezingBeam::CFreezingBeam()
{
}

//------------------------------------------------------------------------
CFreezingBeam::~CFreezingBeam()
{
}


//------------------------------------------------------------------------
void CFreezingBeam::Hit(ray_hit &hit, const Vec3 &dir)
{
	IEntitySystem *pEntitySystem = GetISystem()->GetIEntitySystem();
	IGameFramework *pGameFramework = GetISystem()->GetIGame()->GetIGameFramework();
	IEntity *pEntity = pEntitySystem->GetEntityFromPhysics(hit.pCollider);

	if (pEntity)
	{
		IEntity *pGameRules = pGameFramework->GetIGameRulesSystem()->GetCurrentGameRulesEntity();
		IScriptTable *pGameRulesScript = pGameRules?pGameRules->GetScriptTable():0;
		if (pGameRulesScript)
		{
			HSCRIPTFUNCTION func = 0;
			if (pGameRules->GetScriptTable()->GetValue("SetFrozenAmount", func))
			{
				Script::Call(pGameRulesScript->GetScriptSystem(), func, pGameRulesScript, pEntity->GetScriptTable(), 1.0f);
				pGameRulesScript->GetScriptSystem()->ReleaseFunc(func);
			}
		}
	}
}

//------------------------------------------------------------------------
void CFreezingBeam::Tick(ray_hit &hit, const Vec3 &dir)
{
}