/*************************************************************************
  Crytek Source File.
  Copyright (C), Crytek Studios, 2001-2005.
  -------------------------------------------------------------------------
  $Id$
  $DateTime$
  Description:  Init input action maps, actor script bindings, factory for
                name to class mapping ( e.g. "player" => CplayerG4 ) etc.

                Inherits from base CGame to provide Game04 specific functionality
  -------------------------------------------------------------------------
  History:
  - 17:8:2005        : Created by NickH from Game.cpp

*************************************************************************/

#include "StdAfx.h"
#include "G4Game.h"
#include "GameActions.h"

#include "Player.h"

#include "Item.h"
#include "Weapon.h"

#include "GameRules.h"

//#include "VehicleMovementStdWheeled.h"
//#include "VehicleMovementVTOL.h"
//#include "VehicleMovementHovercraft.h"
//#include "VehicleMovementHelicopter.h"
//#include "VehicleMovementParachute.h"
//#include "VehicleMovementStdBoat.h"
//#include "VehicleMovementTank.h"

#include "WeaponSystem.h"

#include <IActionMapManager.h>
#include <IViewSystem.h>
#include <ILevelSystem.h>
#include <IItemSystem.h>
#include <IVehicleSystem.h>
#include <IGameTokens.h>
//#include <IScriptSystem.h>
//#include <IConsole.h>

#include "ScriptBind_Actor.h"
#include "G4ScriptBind_Actor.h"
#include "ScriptBind_Item.h"
#include "ScriptBind_Weapon.h"
#include "ScriptBind_GameRules.h"
#include "HUD/ScriptBind_HUD.h"

#include "Game04.h"

#include "GameFactory.h"

#include "G4Player.h"
#include "G4PlayerInput.h"

#include "G4FlowBaseNode.h"


extern CGame *g_pGame;



CGameG4::CGameG4()
{
	g_pGame = (CGame*)this;
	GetISystem()->SetIGame( this );

  m_pGame04=new CGame04(this);
	m_pNoPlayerActionAF=0;
}

CGameG4::~CGameG4()
{
//	m_pFramework->EndGameContext();
	ReleaseScriptBinds();
	ReleaseActionMaps();
}


bool CGameG4::Init(IGameFramework *pFramework)
{
  CGame::Init(pFramework);

  m_pGame04->Init();

	return true;
}


// Called after Init and pFramework->CompleteInit
// This function registers all our game specific flow nodes.
// (Except for any Lua script nodes)
bool CGameG4::CompleteInit()
{
	//--- Initialize G4 flow nodes here
	IFlowSystem *pFlow=m_pFramework->GetIFlowSystem();
	CG4AutoRegFlowNodeBase *pFactory = CG4AutoRegFlowNodeBase::m_pFirst;
	if(pFlow)
	{
		while (pFactory)
		{
			pFlow->RegisterType( pFactory->m_sClassName,pFactory );
			pFactory = pFactory->m_pNext;
		}
	}
	return true;
}

int CGameG4::Update(bool haveFocus, unsigned int updateFlags)
{
	// Clear the input state flags before input is polled
	CPlayerActionMap::GetPlayerActionMap()->ClearActionStates();

	// do any queued input
	IGameFramework *pFramework=GetISystem()->GetIGame()->GetIGameFramework();
	if(pFramework)
	{
		IActor *pActor;
		pActor=pFramework->GetClientActor();
		if(pActor)
		{
			string strAction;
			int mode;
			float value;
			CPlayerG4 *pPlayer=static_cast<CPlayerG4*>(pActor);
			while(pPlayer->PopActionQueue(strAction,mode,value))
				pPlayer->OnAction(strAction.c_str(),mode,value);
		}
	}

	// May systems, incl input are polled/updated here.
	bool bRun = m_pFramework->PreUpdate( true, updateFlags );

	m_pFramework->PostUpdate( true, updateFlags );

	return bRun ? 1 : 0;
}

void CGameG4::Tick(float frameTime)
{
}

void CGameG4::Shutdown()
{
	delete this;
}

const char *CGameG4::GetLongName()
  { return "Game04"; }

const char *CGameG4::GetName()
  { return "G4"; }


// Button codes for Tiger Dongle - xBox controller
//
// 01     A           // 02     B
// 03     X           // 04     Y
// 05     black       // 06     white
// 07     L stick btn // 08     R stick btn
// 09     start       // 10     back
// 31     L Trigger   // 32     R Trigger
//

//---------------------------------------------------------------------------------------------------------
//
// The action names specified below are passed to CPlayerG4::OnAction when the bound input event occurs.
//
// CPlayerG4::OnAction forwards the action to the handler specified, e.g.
//    pMap->AddHandler("movelr",CPlayerG4::OnActionMoveStickLR);
// ** if the handler returns true, or none is mapped to the action, then the action is sent to the script. **
//
// To add a new action, pick a name for it, Call CreateAction and AddHandler as below
// then implement the handler in CPlayerG4, or update an existing handler to check for the new action.
//
//---------------------------------------------------------------------------------------------------------
void CGameG4::InitActionMaps()
{
  CPlayerActionMap *pMap=CPlayerActionMap::GetPlayerActionMap();
	IActionMapManager *pActionMapMan = m_pFramework->GetIActionMapManager();

	m_pDefaultAM = pActionMapMan->CreateActionMap("default");

	// Create an action map for the Tweak system
	IActionMap *m_pTweakMap= pActionMapMan->CreateActionMap("tweak");

	// Enable it
	// It must also have a Listener attached in RegisterActionMaps()
	pActionMapMan->EnableActionMap("tweak",false);

	pMap->Clear();

	// The Tweak system controls
	m_pTweakMap->CreateAction("tweakright",eAAM_OnPress, "right", "xi_dpad_right");
	pMap->AddHandler("tweakright",&CPlayerInputG4::OnActionTweak);
	m_pTweakMap->CreateAction("tweakleft",eAAM_OnPress, "left", "xi_dpad_left");
	pMap->AddHandler("tweakleft",&CPlayerInputG4::OnActionTweak);
	m_pTweakMap->CreateAction("tweakup",eAAM_OnPress, "up", "xi_dpad_up");
	pMap->AddHandler("tweakup",&CPlayerInputG4::OnActionTweak);
	m_pTweakMap->CreateAction("tweakdown",eAAM_OnPress, "down", "xi_dpad_down");
	pMap->AddHandler("tweakdown",&CPlayerInputG4::OnActionTweak);
	m_pTweakMap->CreateAction("tweakincrement",eAAM_OnPress, "pgup", "xi_b");
	pMap->AddHandler("tweakincrement",&CPlayerInputG4::OnActionTweak);
	m_pTweakMap->CreateAction("tweakdecrement",eAAM_OnPress, "pgdn", "xi_a");
	pMap->AddHandler("tweakdecrement",&CPlayerInputG4::OnActionTweak);
	m_pTweakMap->CreateAction("tweakexit",eAAM_OnPress, "tab", "xi_start");
	pMap->AddHandler("tweakexit",&CPlayerInputG4::OnActionTweak);

	// Entering the Tweak system
	m_pDefaultAM->CreateAction("tweakenter",eAAM_OnPress, "tab", "xi_start");
	pMap->AddHandler("tweakenter",&CPlayerInputG4::OnActionTweak);




	//--- Movement Bindings ---------------------------------------------------------
  //const char *psName="TigerGame Xbox to USB Controller";	// name returned by the device driver.
  //if(GetISystem()->GetIInput()->SelectController(psName))
  {
		// Managed to select controller
  }

	// NB: messages from the selected controller are now pushed to the game via the action map's OnAction handler

  // We have 3 distinct types of movement control:
  //  1. GamePad, needs to make use of stick position etc, control varies with game mode (combat or nav)
  //  2. Game mouse+kb, should result in similar game play styles to 1.
  //  3. Dev/FPS mouse+kb, for level designer productivity
  //
  // MoveStick - the gamepad stick controlling movement - normally the left one
  // NavStick - the gamepad stick controlling look around - normally the right one
  //

  // Joystick axis 1 will generate "movelr" actions
  // CPlayerG4's OnAction method will forward these "movelr" actions to CPlayerG4::OnActionMoveStickLR
  m_pDefaultAM->CreateAction("movelr",0,"xi_thumblx");
  pMap->AddHandler("movelr",&CPlayerInputG4::OnActionMoveStickLR);

  m_pDefaultAM->CreateAction("key_moveleft",eAAM_OnPress|eAAM_OnRelease,"a");
  pMap->AddHandler("key_moveleft",&CPlayerInputG4::OnActionMoveLeft);

  m_pDefaultAM->CreateAction("key_moveright",eAAM_OnPress|eAAM_OnRelease,"d");
  pMap->AddHandler("key_moveright",&CPlayerInputG4::OnActionMoveRight);

  m_pDefaultAM->CreateAction("moveud",0,"xi_thumbly");
  pMap->AddHandler("moveud",&CPlayerInputG4::OnActionMoveStickUD);

  m_pDefaultAM->CreateAction("key_moveforward",eAAM_OnPress|eAAM_OnRelease,"w");
  pMap->AddHandler("key_moveforward",&CPlayerInputG4::OnActionMoveUp);

  m_pDefaultAM->CreateAction("key_moveback",eAAM_OnPress|eAAM_OnRelease,"s");
  pMap->AddHandler("key_moveback",&CPlayerInputG4::OnActionMoveDown);

  m_pDefaultAM->CreateAction("nav_lr",0,"xi_thumbrx");
  pMap->AddHandler("nav_lr",&CPlayerInputG4::OnActionNavStickLR);

  m_pDefaultAM->CreateAction("mouse_navlr",0,"maxis_x");
  pMap->AddHandler("mouse_navlr",&CPlayerInputG4::OnActionNavMouseLR);

  m_pDefaultAM->CreateAction("nav_ud",0,"xi_thumbry");
  pMap->AddHandler("nav_ud",&CPlayerInputG4::OnActionNavStickUD);

  m_pDefaultAM->CreateAction("mouse_navud",0,"maxis_y");
  pMap->AddHandler("mouse_navud",&CPlayerInputG4::OnActionNavMouseUD);

	m_pDefaultAM->CreateAction("jump",eAAM_OnPress|eAAM_OnRelease,"space");
	pMap->AddHandler("jump",&CPlayerInputG4::OnActionDev);

	m_pDefaultAM->CreateAction("crouch",eAAM_OnPress|eAAM_OnRelease,"lctrl");
  //m_pDefaultAM->CreateAction("prone",eAAM_OnPress,XKEY_V);
  m_pDefaultAM->CreateAction("sprint",eAAM_OnPress|eAAM_OnRelease,"lshift","xi_b");
  pMap->AddHandler("sprint",&CPlayerInputG4::OnActionDev);
	m_pDefaultAM->CreateAction("snapturn",eAAM_OnPress,"xi_b");
	pMap->AddHandler("snapturn",&CPlayerInputG4::OnActionDev);
  //m_pDefaultAM->CreateAction("leanleft",eAAM_OnHold,XKEY_Q);
  //m_pDefaultAM->CreateAction("leanright",eAAM_OnHold,XKEY_E);

  //--- Action Bindings ---------------------------------------------------------
  //m_pDefaultAM->CreateAction("pad_attack1",eAAM_OnPress|eAAM_OnRelease, "xi_shoulderr");//XKEY_J_BUTTON_01);
	m_pDefaultAM->CreateAction("pad_attack1",eAAM_OnPress|eAAM_OnRelease, "xi_triggerr_btn");//XKEY_J_BUTTON_01);
  pMap->AddHandler("pad_attack1",&CPlayerInputG4::OnActionAttack1);

  m_pDefaultAM->CreateAction("attack1",eAAM_OnPress|eAAM_OnRelease, "mouse1");
  pMap->AddHandler("attack1",&CPlayerInputG4::OnActionAttack1);

	m_pDefaultAM->CreateAction("reload",eAAM_OnPress, "r","xi_x");
	m_pDefaultAM->CreateAction("nextitem",eAAM_OnPress, "mwheel_up", "xi_dpad_right");
	m_pDefaultAM->CreateAction("previtem",eAAM_OnPress, "mwheel_down", "xi_dpad_left");


  m_pDefaultAM->CreateAction("use_on",eAAM_OnPress,"xi_triggerl_btn");
  pMap->AddHandler("use_on",&CPlayerInputG4::OnActionUseOn);

  m_pDefaultAM->CreateAction("use_off",eAAM_OnRelease,"xi_triggerl_btn");
  pMap->AddHandler("use_off",&CPlayerInputG4::OnActionUseOff);

  m_pDefaultAM->CreateAction("use",eAAM_OnPress,"xi_a","f");
  pMap->AddHandler("use",&CPlayerInputG4::OnActionUse);

	m_pDefaultAM->CreateAction("draw",eAAM_OnPress | eAAM_NoModifiers,"delete");
	pMap->AddHandler("draw",&CPlayerInputG4::OnActionDev);

	// "draw_on" and "draw_off"  sent from script
	pMap->AddHandler("draw_on",&CPlayerInputG4::OnActionDev);
	pMap->AddHandler("draw_off",&CPlayerInputG4::OnActionDev);

	// "input_on" and "input_off" sent from script
	pMap->AddHandler("input_on",&CPlayerInputG4::OnActionDev);
	pMap->AddHandler("input_off",&CPlayerInputG4::OnActionDev);

  m_pDefaultAM->CreateAction("nextspawnpoint",eAAM_OnPress | eAAM_NoModifiers,"f2");
  pMap->AddHandler("nextspawnpoint",&CPlayerInputG4::OnActionDev);

  m_pDefaultAM->CreateAction("flymode",eAAM_OnPress | eAAM_NoModifiers,"f3");
  pMap->AddHandler("flymode",&CPlayerInputG4::OnActionDev);

  m_pDefaultAM->CreateAction("godmode",eAAM_OnPress | eAAM_NoModifiers,"f4");
  pMap->AddHandler("godmode",&CPlayerInputG4::OnActionDev);

  m_pDefaultAM->CreateAction("thirdperson",eAAM_OnPress | eAAM_NoModifiers, "f1");
  pMap->AddHandler("thirdperson",&CPlayerInputG4::OnActionDev);

	m_pDefaultAM->CreateAction("thirdpersonEnter",eAAM_OnRelease | eAAM_NoModifiers, "xi_thumbr");
	pMap->AddHandler("thirdpersonEnter",&CPlayerInputG4::OnActionDev);

	m_pDefaultAM->CreateAction("thirdpersonLeave",eAAM_OnPress | eAAM_NoModifiers, "xi_thumbr");
	pMap->AddHandler("thirdpersonLeave",&CPlayerInputG4::OnActionDev);

  m_pDefaultAM->CreateAction("ctrl_connect",eAAM_OnPress | eAAM_NoModifiers, "connect");
  pMap->AddHandler("ctrl_connect",&CPlayerInputG4::OnActionCtrlConnect);

  m_pDefaultAM->CreateAction("ctrl_disconnect",eAAM_OnPress | eAAM_NoModifiers, "disconnect");
  pMap->AddHandler("ctrl_disconnect",&CPlayerInputG4::OnActionCtrlConnect);

  //m_pDefaultAM->CreateAction("ctrl_activedisconnect",eAAM_OnPress | eAAM_NoModifiers, XKEY_J_ACTIVEDISCONNECT);
  //pMap->AddHandler("ctrl_activedisconnect",&CPlayerInputG4::OnActionCtrlConnect);

  //m_pDefaultAM->CreateAction("ctrl_activereconnect",eAAM_OnPress | eAAM_NoModifiers, XKEY_J_ACTIVERECONNECT);
  //pMap->AddHandler("ctrl_activereconnect",&CPlayerInputG4::OnActionCtrlConnect);

	m_pDefaultAM->CreateAction("ai_goto",eAAM_OnPress, "z");
  // no c++ handler, forwarded to script

	m_pDefaultAM->CreateAction("ai_follow",eAAM_OnPress, "c","xi_y");
  // no c++ handler, forwarded to script

	//m_pDefaultAM->CreateAction("modify",eAAM_OnPress, XKEY_M);
  //// no c++ handler, forwarded to script

	//m_pDefaultAM->CreateAction("gyroscope",eAAM_OnPress, XKEY_H);
	//m_pDefaultAM->CreateAction("gboots",eAAM_OnPress, XKEY_G);

	m_pDefaultAM->CreateAction("save", eAAM_OnPress | eAAM_ConsoleCmd | eAAM_NoModifiers, "f5");
  // No C++ handler

	m_pDefaultAM->CreateAction("load", eAAM_OnPress | eAAM_ConsoleCmd | eAAM_NoModifiers, "f6");
  // No C++ handler

		// create action filters
	m_pNoMoveAF = pActionMapMan->CreateActionFilter("no_move", eAFT_ActionFail);
	//m_pNoMoveAF->Filter("leanleft");
	//m_pNoMoveAF->Filter("leanright");
	//m_pNoMoveAF->Filter("crouch");
	m_pNoMoveAF->Filter("jump");
	m_pNoMoveAF->Filter("key_moveleft");
	m_pNoMoveAF->Filter("key_moveright");
	m_pNoMoveAF->Filter("key_moveforward");
	m_pNoMoveAF->Filter("key_moveback");
	m_pNoMoveAF->Filter("sprint");
  m_pNoMoveAF->Filter("movelr");
  m_pNoMoveAF->Filter("moveud");

	//m_pModifyItemAF = pActionMapMan->CreateActionFilter("modify_item", eAFT_ActionPass);
	//m_pModifyItemAF->Filter("modify");

	m_pNoMouseAF = pActionMapMan->CreateActionFilter("no_mouse", eAFT_ActionFail);
	m_pNoMouseAF->Filter("attack1");
	m_pNoMouseAF->Filter("rotateyaw");
	m_pNoMouseAF->Filter("rotatepitch");

	m_pNoPlayerActionAF = pActionMapMan->CreateActionFilter("no_player_action", eAFT_ActionFail);

	m_pNoPlayerActionAF = pActionMapMan->CreateActionFilter("no_follow", eAFT_ActionFail);
		m_pNoPlayerActionAF->Filter("follow");

	m_pNoPlayerActionAF = pActionMapMan->CreateActionFilter("no_attack", eAFT_ActionFail);
		m_pNoPlayerActionAF->Filter("pad_attack1");
		m_pNoPlayerActionAF->Filter("attack1");

		m_pNoPlayerActionAF = pActionMapMan->CreateActionFilter("no_draw", eAFT_ActionFail);
		m_pNoPlayerActionAF->Filter("draw");

	//m_pNoPlayerActionAF->Filter("use");		// Button a: also the skip button
	//m_pNoPlayerActionAF->Filter("jump");	// space key: also the skip button

	
	IActionMap *pEmptyMap= pActionMapMan->CreateActionMap("empty");
	// enable defaults
	pActionMapMan->EnableActionMap("default",true);
}

void CGameG4::RegisterActionMaps()
{
	// Select the correct map
	IActionMapManager *pActionMapMan = m_pFramework->GetIActionMapManager();
	pActionMapMan->EnableActionMap( "tweak", false );
	pActionMapMan->EnableActionMap( "default", true );
	
	// Fetch the maps
	IActionMap *pTweakMap = pActionMapMan->GetActionMap("tweak");
	IActionMap *pDefaultMap = pActionMapMan->GetActionMap("default");
	IActor * pActor = m_pFramework->GetClientActor();
	if (pActor) // Should always be present
	{
		// Set the listeners (may already be set)
		pDefaultMap->SetActionListener(pActor->GetEntityId());
		pTweakMap->SetActionListener(pActor->GetEntityId());
	}
}


void CGameG4::ReleaseActionMaps()
{
	SAFE_RELEASE(m_pDefaultAM);
	SAFE_RELEASE(m_pNoMoveAF);
	//SAFE_RELEASE(m_pModifyItemAF);
	SAFE_RELEASE(m_pNoMouseAF);
	SAFE_DELETE(m_pGameActions);
}

void CGameG4::InitScriptBinds()
{
	m_pScriptBindActor = (CScriptBind_Actor*) new CScriptBind_ActorG4(m_pFramework->GetISystem());
	m_pScriptBindItem = new CScriptBind_Item(m_pFramework->GetISystem(), m_pFramework );
	m_pScriptBindWeapon = new CScriptBind_Weapon(m_pFramework->GetISystem(), m_pFramework);
	m_pScriptBindHUD = new CScriptBind_HUD(m_pFramework->GetISystem(), m_pFramework);
	m_pScriptBindGameRules = new CScriptBind_GameRules(m_pFramework->GetISystem(), m_pFramework);
}

bool CGameG4::SelectController(const char *psName)
{
  bool bRet=false;
//  bRet=GetISystem()->GetIInput()->SetActiveController(psName);
  return bRet;
}
