/*************************************************************************
  Crytek Source File.
  Copyright (C), Crytek Studios, 2001-2005.
  -------------------------------------------------------------------------
  $Id$
  $DateTime$
  Description:  Init input action maps, actor script bindings, factory for
                name to class mapping ( e.g. "player" => CplayerG4 ) etc.

                Inherits from base CGame to provide Game04 specific functionality
  -------------------------------------------------------------------------
  History:
  - 17:8:2005        : Created by NickH from Game.h

*************************************************************************/

#ifndef __G4GAME_H__
#define __G4GAME_H__

#if _MSC_VER > 1000
# pragma once
#endif

#include "game.h"
#include <IGame.h>
#include <IGameFramework.h>


//#define GAME_NAME				"FP"
//#define GAME_LONGNAME		"F.P."


struct ISystem;
struct IConsole;
struct IConsoleCmdArgs;

class	CScriptBind_ActorG4;
class CScriptBind_Item;
class CScriptBind_Weapon;
class CScriptBind_GameRules;
class CWeaponSystem;
class CScriptBind_HUD;

struct IActionMap;
struct IActionFilter;
struct SGameActions;
struct IGameTokenSystem;
class CGameRules;

class CGame04;

class CGameG4 :
	public CGame
{
public:
	CGameG4();
	virtual ~CGameG4();

	// IGame interface
	virtual bool Init(IGameFramework *pFramework);
	virtual bool CompleteInit();
	virtual void Shutdown();
	virtual int Update(bool haveFocus, unsigned int updateFlags);

  virtual const char *GetLongName();
  virtual const char *GetName();
  // ~IGame interface

  // Called once per game tick. Any Game systems that need regular updates that aren't attached to an entity should be called from here.
  // Currently called via CPlayerG4::Update for the client player, will be called from a 
  // more sensible location ASAP.
  void Tick(float frameTime);

  bool SelectController(const char *psName);

	// Ensure action maps have a listener set
	void RegisterActionMaps();

protected:

	virtual void InitActionMaps();
  virtual void ReleaseActionMaps();

	virtual void InitScriptBinds();
  //virtual void ReleaseScriptBinds();

  // These funcs live in G4GameCVars.cpp
	virtual void RegisterConsoleVars();
	virtual void RegisterConsoleCommands();
  static void DumpConsoleVarsWithHelp(IConsoleCmdArgs *pArgs);

  static void ControllerCVarChanged(ICVar *pVar);

  CGame04 *m_pGame04;
	IActionFilter *m_pNoPlayerActionAF;
};


#endif //__G4GAME_H__
