/*************************************************************************
  Crytek Source File.
  Copyright (C), Crytek Studios, 2001-2005.
 -------------------------------------------------------------------------
  $Id$
  $DateTime$
  Description:  Init console vars and commands.
                Game04's customised version.
  
 -------------------------------------------------------------------------
  History:
  - 17:8:2005         : Created by NickH from GameCVars.cpp

*************************************************************************/
#include "StdAfx.h"
#include "G4Game.h"
#include "INetwork.h"

#include <IConsole.h>


void CGameG4::ControllerCVarChanged(ICVar *pVar)
{
  const char *psName=pVar->GetString();

  static_cast<CGameG4*>(g_pGame)->SelectController(psName);
}

// game related cvars must start with an g_
// game server related cvars must start with sv_
// game client related cvars must start with cl_
// no other types of cvars are allowed to be defined here!
void CGameG4::RegisterConsoleVars()
{
	assert(m_pConsole);

  CGame::RegisterConsoleVars();
	
	m_pConsole->RegisterFloat("g_PlayerSpeedActionMoveRate", 0.5f, VF_DUMPTODISK, "Player speed action movement rate.Use values between 0 and 1");


	//FIXME:just for testing
  m_pConsole->RegisterFloat("cl_tpvPitch", 0, VF_DUMPTODISK, "camera angle offset around right vector in 3rd person view");
  m_pConsole->RegisterFloat("cl_tpvRoll", 0, VF_DUMPTODISK, "camera angle offset around dir vector in 3rd person view");

  m_pConsole->RegisterFloat("cl_tpvHOff",0,VF_DUMPTODISK,"Camera horizontal offset in 3rd person view");
  m_pConsole->RegisterFloat("cl_tpvVOff",0,VF_DUMPTODISK,"Camera vertical offset in 3rd person view");

  m_pConsole->RegisterFloat("cl_tpvDeltaDist",3,VF_DUMPTODISK,"Affects how far the cam can lag the player");
  m_pConsole->RegisterFloat("cl_tpvDeltaVel",12,VF_DUMPTODISK,"Affects how far the cam can lag the player");
  //m_pConsole->RegisterFloat("cl_tpvDistCombat", 1.3f, VF_DUMPTODISK, "camera distance in 3rd person view.");
	m_pConsole->RegisterFloat("cl_tpvDistCombat", 1.5f, VF_DUMPTODISK, "camera distance in 3rd person view.");
  m_pConsole->RegisterFloat("cl_tpvPosDamping",15,VF_DUMPTODISK,"Camera position damping: 0..N 0 = camera responds immediately.");
  m_pConsole->RegisterFloat("cl_tpvAngDamping",0.01f,VF_DUMPTODISK,"Camera angle damping: 0..N 0 = camera responds immediately.");

  m_pConsole->RegisterFloat("cl_tpvHOffCombat",0,VF_DUMPTODISK,"Camera horizontal offset in 3rd person view");
  m_pConsole->RegisterFloat("cl_tpvVOffCombat",0,VF_DUMPTODISK,"Camera vertical offset in 3rd person view");
  
  m_pConsole->RegisterFloat("cl_tpvDistNav", 1.2f, VF_DUMPTODISK, "camera distance in 3rd person view.");  
  m_pConsole->RegisterFloat("cl_tpvDeltaDistNav",3,VF_DUMPTODISK,"Nav mode: Affects how far the cam can lag the player");
  m_pConsole->RegisterFloat("cl_tpvDeltaVelNav",12,VF_DUMPTODISK,"Nav mode: Affects how far the cam can lag the player");
  m_pConsole->RegisterFloat("cl_tpvYawNavReturn",0.01f,VF_DUMPTODISK,"return rate of yaw when moving in nav mode.");
  m_pConsole->RegisterFloat("cl_tpvPosDampingNav",15,VF_DUMPTODISK,"Nav mode: Camera position damping: 0..N 0 = camera responds immediately.");
  m_pConsole->RegisterFloat("cl_tpvAngDampingNav",0.01f,VF_DUMPTODISK,"Camera angle damping: 0..N 0 = camera responds immediately.");
  m_pConsole->RegisterFloat("cl_tpvYawNav", 0, 0, "camera angle offset around up vector in 3rd person view");
  m_pConsole->RegisterFloat("cl_tpvPitchNav", 0, 0, "camera angle offset around right vector in 3rd person view");
  m_pConsole->RegisterFloat("cl_tpvPitchNavOffset", 0, 0, "camera angle offset around right vector in 3rd person view");

  m_pConsole->RegisterFloat("cl_tpvHOffNav",-0.2f,VF_DUMPTODISK,"Camera horizontal offset in 3rd person view");
  m_pConsole->RegisterFloat("cl_tpvVOffNav",-0.1f,VF_DUMPTODISK,"Camera vertical offset in 3rd person view");
	m_pConsole->RegisterFloat("cl_tpvFOVNav",60.0f,VF_DUMPTODISK,"Camera FOV in 3rd person Nav mode");
	m_pConsole->RegisterFloat("cl_tpvFOVCombat",45.0f,VF_DUMPTODISK,"Camera FOV in 3rd person Combat mode");
	m_pConsole->RegisterFloat("cl_tpvFOVDamping",0.0f,VF_DUMPTODISK,"Camera FOV damping");

  m_pConsole->RegisterInt("cl_cam_slowmo_on",1,VF_DUMPTODISK,"Camera cut: enable slowmo");
  m_pConsole->RegisterFloat("cl_cam_slowmo_pct",100.0f,VF_DUMPTODISK,"Camera slow_mo precentage chance");
  
  m_pConsole->RegisterInt("cl_cam_dof_on",1,VF_DUMPTODISK,"Camera cut: enable DOF");
  m_pConsole->RegisterFloat("cl_cam_dof_scale",0.25f,VF_DUMPTODISK,"Camera cut: scale the DOF effect");

  m_pConsole->RegisterInt("cl_cam_desat_on",0,VF_DUMPTODISK,"Camera cut: enable desat");

  m_pConsole->RegisterFloat("cl_cam_timescale",1.0f,VF_DUMPTODISK,"Camera cut: scale duration of cam cuts");

  m_pConsole->RegisterFloat("g_time_baseRate",1.0f,VF_DUMPTODISK,"World time is scaled by this, 0.9 => everything runs 10% slower");
  m_pConsole->RegisterFloat("g_time_cinematic_pct",0.0f,VF_DUMPTODISK,"Cinematic system is allowed to adjust game play time by this percentage");

  m_pConsole->RegisterInt("cl_cam_edithold",0,0,"Hold a camera shot for editing purposes");
  m_pConsole->RegisterInt("cl_cam_debug",0,0,"Debug draw cam pos and LineOfAction for current cl_cam_cut");
  m_pConsole->RegisterInt("cl_cam_cut",0,0,"Camera cut type: 0 => use cl_tpv vars, 1..2 specific cuts");

  m_pConsole->RegisterFloat("cl_play_move_nav",1.0f,VF_DUMPTODISK,"Scale the players movement in nav mode");
  m_pConsole->RegisterFloat("cl_play_move_comb",0.65f,VF_DUMPTODISK,"Scale the players movement in combat mode");
  m_pConsole->RegisterFloat("cl_play_move_strafe",0.50f,VF_DUMPTODISK,"Scale the players movement in combat mode");
  m_pConsole->RegisterFloat("cl_play_move_combback",0.30f,VF_DUMPTODISK,"Scale the players movement in combat mode");


  m_pConsole->RegisterInt("cl_cam_mode",10,0,"Camera mode type: -1 => edit pos, 0 => normal mode, 1..N specific camera shot tests");
  m_pConsole->RegisterInt("cl_cam_target",0,0,"Camera edit target: 0: player, -N dead body N, +N live body N");

  m_pConsole->RegisterFloat("cl_cam_soundmusic",0.0f,0,"Scale the music volume by ths");
  m_pConsole->RegisterFloat("cl_cam_soundsfx",0.5f,0,"Scale the music volume by ths");
  m_pConsole->RegisterFloat("cl_cam_soundrate",0.85f,0,"Scale the music volume by ths");

  m_pConsole->RegisterFloat("cl_joy_combat_strafe",0.5f,VF_DUMPTODISK,"scale the strafe movement in combat mode");
  m_pConsole->RegisterFloat("cl_joy_combat_turn",1.4f,VF_DUMPTODISK,"scale the turn movement in combat mode");

	m_pConsole->RegisterFloat("cl_joy_combat_speedH",1.4f,VF_DUMPTODISK,"scale the Horz turn speed combat mode");
	m_pConsole->RegisterFloat("cl_joy_combat_sensitivityH",1.4f,VF_DUMPTODISK,"the stick centre to edge Horz turn sensitivity in combat mode");
	m_pConsole->RegisterFloat("cl_joy_combat_maxH",2.0f,VF_DUMPTODISK,"max Horz turn speed in combat mode");
	m_pConsole->RegisterFloat("cl_joy_combat_speedV",1.4f,VF_DUMPTODISK,"scale the Vert turn speed in combat mode");
	m_pConsole->RegisterFloat("cl_joy_combat_sensitivityV",1.4f,VF_DUMPTODISK,"the stick centre to edge Vert turn sensitivity in combat mode");
	m_pConsole->RegisterFloat("cl_joy_combat_maxV",2.0f,VF_DUMPTODISK,"max Vert turn speed in combat mode");
	m_pConsole->RegisterInt("cl_joy_combat_useHforV",0,VF_DUMPTODISK,"non zero => use the H values for V as well");

	m_pConsole->RegisterFloat("cl_joy_nav_speedH",1.4f,VF_DUMPTODISK,"scale the Horz turn speed in nav mode");
	m_pConsole->RegisterFloat("cl_joy_nav_sensitivityH",1.4f,VF_DUMPTODISK,"the stick centre to edge Horz turn sensitivity in nav mode");
	m_pConsole->RegisterFloat("cl_joy_nav_maxH",2.0f,VF_DUMPTODISK,"max Horz turn speed in nav mode");
	m_pConsole->RegisterFloat("cl_joy_nav_speedV",1.4f,VF_DUMPTODISK,"scale the Vert turn speed in nav mode");
	m_pConsole->RegisterFloat("cl_joy_nav_sensitivityV",1.4f,VF_DUMPTODISK,"the stick centre to edge Vert turn sensitivity in nav mode");
	m_pConsole->RegisterFloat("cl_joy_nav_maxV",2.0f,VF_DUMPTODISK,"max Vert turn speed in nav mode");
	m_pConsole->RegisterInt("cl_joy_nav_useHforV",0,VF_DUMPTODISK,"non zero => use the H values for V as well");

  m_pConsole->RegisterFloat("cl_joy_nav_turn",1.4f,VF_DUMPTODISK,"scale the turn movement in nav mode");


  m_pConsole->RegisterFloat("cl_joy_fwdback",1,VF_DUMPTODISK,"scale the fwdback joy input");

	m_pConsole->RegisterInt("cl_cm",0,0,"cam mode: 0: mouse cam, 1: G4 cam");
	m_pConsole->RegisterInt("cl_footslidemode",0,0,"footsliding: 0: G4 Hack, 1: G02 Hack");

  m_pConsole->RegisterInt("g_sprintOnNav", 0, 0, "Auto sprint in nav mode");

  m_pConsole->RegisterString("cl_controller_name","",VF_DUMPTODISK,"Selected controller",CGameG4::ControllerCVarChanged);

	// XInput: number of ports to poll for connections. override the default of 0.
	ICVar *pXI=m_pConsole->GetCVar("i_xinput");
	if(pXI)	pXI->Set(1);
}

void CGameG4::RegisterConsoleCommands()
{
	assert(m_pConsole);

  CGame::RegisterConsoleCommands();

  m_pConsole->AddCommand("Cam:SetShot", "Cam:SetShot(%1)", 0, "Sets current camera shot.");

  m_pConsole->AddCommand("DumpConsoleVarsWithHelp",DumpConsoleVarsWithHelp,0,"Dump console vars and help to ConsoleVars.txt");
}

class CCVarDumpInfo : public ICVarDumpSink
{
public:

  CCVarDumpInfo(FILE *pFile)
  {
    m_pFile=pFile;
  }

  virtual void ConvertString(string &rStr)
  {
    int pos;

    // replace \ with \\ 
    pos = 1;
    for(;;)
    {
      pos = rStr.find_first_of("\\", pos);

      if (pos == string::npos)
      {
        break;
      }

      rStr.replace(pos, 1, "\\\\", 2);
      pos+=2;
    }

    // replace " with \" 
    pos = 1;
    for(;;)
    {
      pos = rStr.find_first_of("\"", pos);

      if (pos == string::npos)
      {
        break;
      }

      rStr.replace(pos, 1, "\\\"", 2);
      pos+=2;
    }
  }

  virtual void OnElementFound(ICVar *pCVar)
  {
    if (pCVar) // && (pCVar->GetFlags() & VF_DUMPTODISK))
    {
      string szValue = pCVar->GetString();
      string szHelp = pCVar->GetHelp();

      ConvertString(szValue);
      ConvertString(szHelp);

      string szLine = pCVar->GetName();
      szLine += " = \"";
      szLine += szValue;
      szLine += "\"\r\n";
      szLine += "\t";
      szLine += szHelp;
      szLine += "\r\n\r\n";

      if(pCVar->GetFlags()&VF_WARNING_NOTUSED)
        fputs("-- REMARK: the following was not assigned to a console variable\r\n",m_pFile);

      fputs(szLine.c_str(), m_pFile);
    }
  }

protected: // --------------------------------------------------------

  FILE *				m_pFile;					//
};

void CGameG4::DumpConsoleVarsWithHelp(IConsoleCmdArgs *pArgs)
{
  IConsole *pCon=GetISystem()->GetIConsole();
 
  if(pCon)
  {
    FILE *pOutFile=fxopen("ConsoleVars.txt","wb");

    if(pOutFile)
    {
      CCVarDumpInfo dumpInfo(pOutFile);
      pCon->DumpCVars(&dumpInfo);
      fclose(pOutFile);
    }
  }
}
