/*************************************************************************
	Crytek Source File.
	Copyright (C), Crytek Studios, 2001-2004.
	-------------------------------------------------------------------------
	$Id$
	$DateTime$
	Description: Game DLL entry point.

	-------------------------------------------------------------------------
	History:
	- 2:8:2004   10:38 : Created by Mrcio Martins

*************************************************************************/
#include "StdAfx.h"
#include "G4GameStartup.h"
#include "G4EditorGame.h"
#include "CryLibrary.h"

extern "C"
{
	GAME_API IGameStartup *CreateGameStartup()
	{
		// at this point... we have no dynamic memory allocation, and we cannot
		// rely on atexit() doing the right thing; the only recourse is to
		// have a static buffer that we use for this object
		static char gameStartup_buffer[sizeof(CGameStartupG4)];
		return new ((void*)gameStartup_buffer) CGameStartupG4();
	}

	GAME_API IEditorGame *CreateEditorGame()
	{
		return new CEditorGameG4();
	}
}

/*
 * this section makes sure that the framework dll is loaded and cleaned up
 * at the appropriate time
 */

#ifndef _LIB

static HMODULE s_frameworkDLL;

static void CleanupFrameworkDLL()
{
	assert( s_frameworkDLL );
	FreeLibrary( s_frameworkDLL );
	s_frameworkDLL = 0;
}

HMODULE GetFrameworkDLL()
{
	if (!s_frameworkDLL)
	{
		s_frameworkDLL = CryLoadLibrary(GAME_FRAMEWORK_FILENAME);
		atexit( CleanupFrameworkDLL );
	}
	return s_frameworkDLL;
}

#endif //WIN32
