/*************************************************************************
  Crytek Source File.
  Copyright (C), Crytek Studios, 2001-2004.
  -------------------------------------------------------------------------
  $Id$
  $DateTime$
  Description:  Register the factory templates used to create classes from names
                e.g. REGISTER_FACTORY(pFramework, "Player", CPlayer, false);
                or   REGISTER_FACTORY(pFramework, "Player", CPlayerG4, false);

                Since overriding this function creates template based linker errors,
                it's been replaced by a standalone function in its own cpp file.

  -------------------------------------------------------------------------
  History:
  - 17:8:2005   Created by Nick Hesketh - Refactor'd from Game.cpp/h

*************************************************************************/

#include "StdAfx.h"
#include "G4Game.h"
//#include "Spectator.h"
#include "G4Player.h"
//aliens
#include "Alien.h"
#include "Scout.h"
#include "Hunter.h"
#include "Trooper.h"
#include "Observer.h"
//
#include "Item.h"
#include "Weapon.h"
#include "AmmoPickup.h"
#include "Binocular.h"
#include "DebugGun.h"
#include "ReferenceWeapon.h"

#include "VehicleMovementStdWheeled.h"
#include "VehicleMovementVTOL.h"
#include "VehicleMovementHovercraft.h"
#include "VehicleMovementHelicopter.h"
#include "VehicleMovementParachute.h"
#include "VehicleMovementStdBoat.h"
#include "VehicleMovementTank.h"

#include "HUD/HUD.h"

#include "GameRules.h"

#include "Environment/Tornado.h"

#include <IItemSystem.h>
#include <IVehicleSystem.h>
#include <IGameRulesSystem.h>

#define NO_ALIENS		// No aliens please. But keep them in the codebase for now as a debugging tool.

#define HIDE_FROM_EDITOR(className)																																				\
  { IEntityClass *pItemClass = GetISystem()->GetIEntitySystem()->GetClassRegistry()->FindClass(className);\
  pItemClass->SetFlags(pItemClass->GetFlags() | ECLF_INVISIBLE); }																				\

#define REGISTER_GAME_OBJECT_EXTENSION(framework, name, script)\
	{\
		IEntityClassRegistry::SEntityClassDesc clsDesc;\
		clsDesc.sName = #name;\
		clsDesc.sScriptFile = script;\
		struct C##name##Creator : public IGameObjectExtensionCreatorBase\
		{\
			C##name *Create()\
			{\
				return new C##name();\
			}\
			void GetGameObjectExtensionRMIData( void ** ppRMI, size_t * nCount )\
			{\
			C##name::GetGameObjectExtensionRMIData( ppRMI, nCount );\
			}\
		};\
		static C##name##Creator _creator;\
		framework->GetIGameObjectSystem()->RegisterExtension(#name, &_creator, &clsDesc);\
	}

// Register the factory templates used to create classes from names. Called via CGame::Init()
void InitGameFactory(IGameFramework *pFramework)
{
  assert(pFramework);

  REGISTER_FACTORY(pFramework, "Player", CPlayerG4, false);
  REGISTER_FACTORY(pFramework, "Grunt", CPlayerG4, true);
  REGISTER_FACTORY(pFramework, "Civilian", CPlayerG4, true);
	REGISTER_FACTORY(pFramework, "Companion", CPlayerG4, true);
	REGISTER_FACTORY(pFramework, "Goon", CPlayerG4, true);


  // Items
  REGISTER_FACTORY(pFramework, "Item", CItem, false);

  // Weapons
  REGISTER_FACTORY(pFramework, "Weapon", CWeapon, false);
	REGISTER_FACTORY(pFramework, "AmmoPickup", CAmmoPickup, false);
	REGISTER_FACTORY(pFramework, "Binocular", CBinocular, false);
	REGISTER_FACTORY(pFramework, "DebugGun", CDebugGun, false);
	REGISTER_FACTORY(pFramework, "ReferenceWeapon", CReferenceWeapon, false);
	

  IVehicleSystem* pVehicleSystem = pFramework->GetIVehicleSystem();

  // vehicle movements
  REGISTER_FACTORY(pVehicleSystem, "StdWheeled", CVehicleMovementStdWheeled, false);
  REGISTER_FACTORY(pVehicleSystem, "VTOL", CVehicleMovementVTOL, false);
  REGISTER_FACTORY(pVehicleSystem, "Hovercraft", CVehicleMovementHovercraft, false);
  REGISTER_FACTORY(pVehicleSystem, "Helicopter", CVehicleMovementHelicopter, false);
	REGISTER_FACTORY(pVehicleSystem, "Parachute", CVehicleMovementParachute, false);
  REGISTER_FACTORY(pVehicleSystem, "StdBoat", CVehicleMovementStdBoat, false);
  REGISTER_FACTORY(pVehicleSystem, "Tank", CVehicleMovementTank, false);

	// No aliens please. But keep them in the codebase for now as a debugging tool.
	#ifndef NO_ALIENS
		//aliens
		REGISTER_FACTORY(pFramework, "AlienPlayer", CAlien, false);
		REGISTER_FACTORY(pFramework, "Aliens/Alien", CAlien, true);
		REGISTER_FACTORY(pFramework, "Aliens/Observer", CObserver, true);
		REGISTER_FACTORY(pFramework, "Aliens/Trooper", CTrooper, true);
		REGISTER_FACTORY(pFramework, "Aliens/Scout", CScout, true);
		REGISTER_FACTORY(pFramework, "Aliens/Hunter", CHunter, true);
		//	REGISTER_FACTORY(m_pFramework, "Aliens/Warrior", CDrone, true);
		REGISTER_FACTORY(pFramework, "Aliens/Coordinator", CObserver, true);
	#endif

	//HUD
	REGISTER_FACTORY(pFramework, "HUD", CHUD, false);
	//GameRules
	REGISTER_FACTORY(pFramework, "GameRules", CGameRules, false);

	//Tornado
	REGISTER_GAME_OBJECT_EXTENSION(pFramework, Tornado, "Scripts/Entities/Environment/Tornado.lua");

	pFramework->GetIGameRulesSystem()->RegisterGameRules("SinglePlayer", "GameRules");
	pFramework->GetIGameRulesSystem()->RegisterGameRules("DeathMatch", "GameRules");

}
