/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2004.
-------------------------------------------------------------------------
$Id$
$DateTime$

-------------------------------------------------------------------------
History:
- 2:8:2004   15:20 : Created by Mrcio Martins

*************************************************************************/

#include "StdAfx.h"
#include "G4GameStartup.h"
#include "G4Game.h"

#include <CryLibrary.h>
#include <platform_impl.h>
#include <ICryPak.h> // to set aliases

#ifdef _LIB
extern "C" IGameFramework *CreateGameFramework();
#endif

#ifndef XENON
#define DLL_INITFUNC_CREATEGAME "CreateGameFramework"
#else
#define DLL_INITFUNC_CREATEGAME (LPCSTR)1
#endif

CGameStartupG4::CGameStartupG4()
: m_pFramework(0),
	m_pMod(0),
	m_modDll(0),
	m_frameworkDll(0),
	m_initWindow(false)
{
	m_modRef = &m_pMod;
}

CGameStartupG4::~CGameStartupG4()
{
	if (m_pMod)
	{
		m_pMod->Shutdown();
		m_pMod = 0;
	}

	if (m_modDll)
	{
		CryFreeLibrary(m_modDll);
		m_modDll = 0;
	}

	ShutdownFramework();
}

void CGameStartupG4::InitRootDir()
{
#ifdef WIN32
	char exedir[_MAX_PATH];
	char drive[_MAX_DRIVE];
	char dir[_MAX_DIR];
	char fname[_MAX_FNAME];
	char ext[_MAX_EXT];

	char szExeFileName[_MAX_PATH];

	//Get the path of the executable
	/*if (m_pFramework)
	{
		ICmdLine *pCmdLine = m_pFramework->GetISystem()->GetICmdLine();
		
		const ICmdLineArg *exeName = pCmdLine->GetArg(0);
		assert(exeName);

		strcpy(szExeFileName,exeName->GetValue());
	}
	else*/
	{
		GetModuleFileName( GetModuleHandle(NULL), szExeFileName, sizeof(szExeFileName));
	}

	_splitpath( szExeFileName, drive, dir, fname, ext );
	_makepath( exedir, drive,dir,NULL,NULL );

	//FIXME: string or char[]? for now its a char array because before InitFramework() we cant dynamically alloc any memory.
	//m_binDir = string(exedir);
	//m_rootDir = m_binDir + "../";

	char rootDir[256];

	strcpy(rootDir,exedir);
	strcat(rootDir,"../");
	
	SetCurrentDirectory( rootDir/*m_rootDir.c_str()*/ );
#endif
}

IGameRef CGameStartupG4::Init(SSystemInitParams &startupParams)
{
	//FIXME: maybe its not the best place to put the root dir initialization, put it in the launcher?
	InitRootDir();

	// set pak aliases as early as possible during the initialization process...
	//startupParams.pSystem->GetIPak()->SetAlias("Scripts","Scripts04",true);

	if (!InitFramework(startupParams))
	{
		return 0;
	}

	// load the appropriate game
	const ICmdLineArg *game = m_pFramework->GetISystem()->GetICmdLine()->FindArg("game");

	IGameRef pOut;
	if (game && (*game->GetValue() != 0))
	{
		pOut = Reset(game->GetValue());
	}
	else
	{
		pOut = Reset(GAME_NAME);
	}

	if (!m_pFramework->CompleteInit())
	{
		pOut->Shutdown();
		return 0;
	}

	if(m_pMod)
		m_pMod->CompleteInit();

	// should be after init game (should be executed even if there is no game)
	m_pFramework->GetISystem()->ExecuteCommandLine();

/*
	// execute command line arguments e.g. +g_gametype ASSAULT +map "testy"
	{
		ICmdLine *pCmdLine = m_pFramework->GetISystem()->GetICmdLine();			assert(pCmdLine);

		const int iCnt = pCmdLine->GetArgCount();

		for(int i=0;i<iCnt;++i)
		{
			const ICmdLineArg *pCmd=pCmdLine->GetArg(i);

			if(pCmd->GetType()==eCLAT_Post)
			{
				string sLine = pCmd->GetName();

				if(pCmd->GetValue())
					sLine += string(" ") + pCmd->GetValue();

				m_pFramework->GetISystem()->GetILog()->Log("Executing command from command line: %s",sLine.c_str());
				m_pFramework->GetISystem()->GetIConsole()->ExecuteString(sLine.c_str());
			}
		}
	}
*/

	return pOut;
}

IGameRef CGameStartupG4::Reset(const char *modName)
{
	if (m_pMod)
	{
		m_pMod->Shutdown();

		if (m_modDll)
		{
			CryFreeLibrary(m_modDll);
			m_modDll = 0;
		}
	}

	if (!stricmp(modName, GAME_NAME))
	{
		m_pMod = new CGameG4();
	}
	else
	{
		char fileName[1024];
		sprintf(fileName, "%s.dll", modName);

		m_modDll = CryLoadLibrary(fileName);

		if (!m_modDll)
		{
			return 0;
		}

		IGame::TEntryFunction CreateGame = (IGame::TEntryFunction)CryGetProcAddress(m_modDll, "CreateGame");

		if (!CreateGame)
		{
			return 0;
		}

		IGame *mod = CreateGame();

		if (!mod)
		{
			return 0;
		}

		m_pMod = mod;
	}

	assert(m_pMod);

	if (m_pMod && m_pMod->Init(m_pFramework))
	{
		return m_modRef;
	}

	return 0;
}

void CGameStartupG4::Shutdown()
{
	// we are not dynamically allocated (see GameDll.cpp)... therefore
	// we must not call delete here (it will cause big problems)...
	// call the destructor manually instead
	this->~CGameStartupG4();
}

int CGameStartupG4::Update(bool haveFocus, unsigned int updateFlags)
{
	int returnCode = 0;
	
	// update the game
	if (m_pMod)
	{
		returnCode = m_pMod->Update(haveFocus, updateFlags);
	}

	return returnCode;
}

int CGameStartupG4::Run( const char * autoStartLevelName )
{
	if (autoStartLevelName)
	{
		string temp = string("map ") + autoStartLevelName + string(" load");
		m_pFramework->GetISystem()->GetIConsole()->ExecuteString(temp.c_str());
	}

#ifdef WIN32
	for(;;)
	{
		MSG msg;

		if (PeekMessage(&msg, 0, 0, 0, PM_REMOVE))
		{
			if (msg.message != WM_QUIT)
			{
				TranslateMessage(&msg);
				DispatchMessage(&msg);
			}
			else
			{
 				break;
			}
		}
		else
		{
			if (!Update(true, 0))
			{
				// need to clean the message loop (WM_QUIT might cause problems in the case of a restart)
				// another message loop might have WM_QUIT already so we cannot rely only on this 
				while(PeekMessage(&msg, 0, 0, 0, PM_REMOVE))
				{
					TranslateMessage(&msg);
					DispatchMessage(&msg);
				}
				break;
			}
		}
	}
#else
	for(;;)
	{
		if (!Update(true, 0))
		{
			break;
		}
	}
#endif //WIN32

	return 0;
}

bool CGameStartupG4::InitFramework(SSystemInitParams &startupParams)
{
#ifndef _LIB
	m_frameworkDll = GetFrameworkDLL();

	if (!m_frameworkDll)
	{
		// failed to open the framework dll
		CryError("Failed to open the GameFramework DLL!");
		
		return false;
	}

	IGameFramework::TEntryFunction CreateGameFramework = (IGameFramework::TEntryFunction)CryGetProcAddress(m_frameworkDll, DLL_INITFUNC_CREATEGAME );

	if (!CreateGameFramework)
	{
		// the dll is not a framework dll
		CryError("Specified GameFramework DLL is not valid!");

		return false;
	}
#endif //_LIB

	m_pFramework = CreateGameFramework();

	if (!m_pFramework)
	{
		CryError("Failed to create the GameFramework Interface!");
		// failed to create the framework

		return false;
	}

	if (!startupParams.hWnd)
	{
		m_initWindow = true;

		if (!InitWindow(startupParams))
		{
			// failed to register window class
			CryError("Failed to register CryENGINE window class!");

			return false;
		}
	}

	// initialize the engine
	if (!m_pFramework->Init(startupParams))
	{
		CryError("Failed to initialize CryENGINE!");

		return false;
	}
	g_pSystem = m_pFramework->GetISystem();

	return true;
}

void CGameStartupG4::ShutdownFramework()
{
	if (m_pFramework)
	{
		m_pFramework->Shutdown();
		m_pFramework = 0;
	}

	ShutdownWindow();
}

bool CGameStartupG4::InitWindow(SSystemInitParams &startupParams)
{
#ifdef WIN32
	WNDCLASS wc;

	memset(&wc, 0, sizeof(WNDCLASS));

	wc.style         = CS_OWNDC | CS_HREDRAW | CS_VREDRAW;
	wc.lpfnWndProc   = (WNDPROC)CGameStartupG4::WndProc;
	wc.cbClsExtra    = 0;
	wc.cbWndExtra    = 0;
	wc.hInstance     = GetModuleHandle(0);
	// FIXME: Very bad way of getting the Icon from the Launcher project
	wc.hIcon         = LoadIcon((HINSTANCE)startupParams.hInstance, MAKEINTRESOURCE(101));
	wc.hCursor       = 0;
	wc.hbrBackground =(HBRUSH)GetStockObject(BLACK_BRUSH);
	wc.lpszMenuName  = 0;
	wc.lpszClassName = GAME_WINDOW_CLASSNAME;

	if (!RegisterClass(&wc))
	{
		return false;
	}
#endif WIN32
	return true;
}

void CGameStartupG4::ShutdownWindow()
{
#ifdef WIN32
	if (m_initWindow)
	{
		UnregisterClass(GAME_WINDOW_CLASSNAME, GetModuleHandle(0));
	}
#endif
}

//////////////////////////////////////////////////////////////////////////
#ifdef WIN32

//////////////////////////////////////////////////////////////////////////
LRESULT CALLBACK CGameStartupG4::WndProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	switch(msg)
	{
	case WM_CLOSE:
		PostQuitMessage(0);
		return 0;
	case WM_MOUSEACTIVATE:
		return MA_ACTIVATEANDEAT;
	case WM_ENTERSIZEMOVE:
	case WM_ENTERMENULOOP:
		return 0;
	case WM_SIZE:
		if (g_pSystem)
		{
			g_pSystem->GetISystemEventDispatcher()->OnResize(LOWORD(lParam), HIWORD(lParam));
		}
		break;
	case WM_ACTIVATE:
		{
			if (g_pSystem)
			{
				if (wParam != WA_INACTIVE)
				{
					g_pSystem->GetIInput()->SetExclusiveMode( eDI_Mouse, true );
				}
				g_pSystem->GetISystemEventDispatcher()->OnFocusChange(wParam != WA_INACTIVE);
			}
			return 0;
		}
	case WM_HOTKEY:
		return 0;
	}

	return DefWindowProc(hWnd, msg, wParam, lParam);
}
//////////////////////////////////////////////////////////////////////////
#endif //WIN32

