// handles turning actions into CMovementRequests and setting player state
// for the local player

#include "StdAfx.h"
#include "G4PlayerInput.h"
#include "G4Player.h"
#include "G4Game.h"
#include "GameActions.h"
#include "Weapon.h"
#include "WeaponSystem.h"
#include "IVehicleSystem.h"
#include "HUD/HUD.h"
// TODO: make this line go away (only ever access interfaces from CryAction, not concrete implementations)
#include "VehicleSystem/VehicleSeat.h"

#include "AutoCombat.h"

CPlayerInputG4::CPlayerInputG4( CPlayerG4 * pPlayer ) : 
m_actions(0), 
m_pPlayer(pPlayer), 
m_pStats(&pPlayer->m_stats),
m_deltaRotation(0,0,0), 
m_deltaMovement(0,0,0), 
m_xi_deltaRotation(0,0,0), 
m_xi_deltaMovement(0,0,0),
m_filteredDeltaMovement(0,0,0),
m_deltaPitch(0),
m_deltaPitchOnce(0),
m_bEnableTweakMap(false)
{
	m_pPlayer->GetGameObject()->CaptureActions(this);
}

CPlayerInputG4::~CPlayerInputG4()
{
	m_pPlayer->GetGameObject()->ReleaseActions(this);
}

bool CPlayerInputG4::IsClient()
{
	return m_pPlayer->IsClient();
}

void CPlayerInputG4::Reset()
{
	m_actions = 0;

	m_deltaMovement.zero();
	m_filteredDeltaMovement.zero();
	m_deltaRotation.Set(0,0,0);
	m_xi_deltaRotation.Set(0,0,0);

	m_moveKeysPressed = 0;

	m_xi_deltaMovement.zero();
	m_deltaPitch=0;
	m_deltaPitchOnce=0;
}

#if 0		// OnAction
void CPlayerInputG4::OnAction( const ActionId& actionId, int activationMode, float value )
{
	FUNCTION_PROFILER(GetISystem(), PROFILE_GAME);

	m_pPlayer->GetGameObject()->ChangedNetworkState( INPUT_ASPECT );

	//this tell if OnAction have to be forwarded to scripts, now its true by default, only high framerate actions are ignored
	bool filterOut = true;
	bool checkZoom = false;
	const SGameActions& actions = g_pGame->Actions();
	CHUD * pHUD = m_pPlayer->GetHUD();

	IVehicle *pVehicle = m_pPlayer->GetLinkedVehicle();

	//FIXME:on vehicles use cannot be used
	if ((actions.use == actionId) && pVehicle)
	{
		filterOut = false;
	}
	else if (actions.rotateyaw == actionId)
	{
		m_deltaRotation.z -= value;
		filterOut = false;
	}
	else if (actions.rotatepitch == actionId)
	{
		m_deltaRotation.x -= value;
		filterOut = false;
	}
	else if (actions.xi_rotateyaw == actionId)
	{
		m_xi_deltaRotation.z -= value;
		filterOut = false;
	}
	else if (actions.xi_rotatepitch == actionId)
	{
		m_xi_deltaRotation.x += value;
		filterOut = false;
	}
	else if (actions.moveright == actionId)
	{
		m_deltaMovement.x += value*2.0f - 1.0f;
		filterOut = false;
		checkZoom = true;
		AdjustMoveKeysPressed(activationMode);
	}
	else if (actions.moveleft == actionId)
	{
		m_deltaMovement.x -= value*2.0f - 1.0f;
		filterOut = false;
		checkZoom = true;
		AdjustMoveKeysPressed(activationMode);
	}
	else if (actions.moveforward == actionId)
	{
		m_deltaMovement.y += value*2.0f - 1.0f;
		filterOut = false;
		checkZoom = true;
		AdjustMoveKeysPressed(activationMode);
	}
	else if (actions.moveback == actionId)
	{
		m_deltaMovement.y -= value*2.0f - 1.0f;
		filterOut = false;
		checkZoom = true;
		AdjustMoveKeysPressed(activationMode);
	}
	else if (actions.xi_movex == actionId)
	{
		m_deltaMovement.y += value;
		filterOut = false;
	}
	else if (actions.xi_movey == actionId)
	{
		m_deltaMovement.x += value;
		filterOut = false;
	}
	else if (actions.jump == actionId)
	{
		if (value > 0.0f)
		{
			if (m_pPlayer->m_params.speedMultiplier > 0.99f)
				m_actions |= ACTION_JUMP;
		}
		else
		{
			m_actions &= ~ACTION_JUMP;
		}
	}
	else if (actions.crouch == actionId)
	{
		if (value > 0.0f)
		{
			if (m_pPlayer->m_params.speedMultiplier > 0.99f)
				m_actions |= ACTION_CROUCH;
		}
		else
		{
			m_actions &= ~ACTION_CROUCH;
		}
	}
	else if (actions.prone == actionId)
	{
		if (!(m_actions & ACTION_PRONE))
			m_actions |= ACTION_PRONE;
		else
			m_actions &= ~ACTION_PRONE;
	}
	else if (actions.gyroscope == actionId)
	{
		//FIXME:makes more sense a ExosuitActive()
		if (m_pPlayer->IsZeroG())
		{
			if (m_actions & ACTION_GYROSCOPE)
				m_actions &= ~ACTION_GYROSCOPE;
			else
				m_actions |= ACTION_GYROSCOPE;

			m_pPlayer->CreateScriptEvent("gyroscope",(m_actions & ACTION_GYROSCOPE)?1.0f:0.0f);
		}
	}
	else if (actions.gboots == actionId)
	{
		//FIXME:makes more sense a ExosuitActive()
		if (m_pPlayer->IsZeroG())
		{
			if (m_actions & ACTION_GRAVITYBOOTS)
				m_actions &= ~ACTION_GRAVITYBOOTS;
			else
				m_actions |= ACTION_GRAVITYBOOTS;

			m_pPlayer->CreateScriptEvent("gravityboots",(m_actions & ACTION_GRAVITYBOOTS)?1.0f:0.0f);

			if(m_actions & ACTION_GRAVITYBOOTS)
			{
				SGameObjectEvent evt("HUD_TextMessage",eGOEF_ToAll, IGameObjectSystem::InvalidExtensionID, (void*)("gravity_boots_on"));
				GetISystem()->GetIGame()->GetIGameFramework()->GetIGameObjectSystem()->BroadcastEvent(evt);
			}
			else
			{
				SGameObjectEvent evt("HUD_TextMessage",eGOEF_ToAll, IGameObjectSystem::InvalidExtensionID, (void*)("gravity_boots_off"));
				GetISystem()->GetIGame()->GetIGameFramework()->GetIGameObjectSystem()->BroadcastEvent(evt);
			}

		}
	}
	else if (actions.sprint == actionId)
	{
		if (value > 0.0f)
		{
			if (m_pPlayer->m_params.speedMultiplier > 0.99f)
				m_actions |= ACTION_SPRINT;
		}
		else
		{
			m_actions &= ~ACTION_SPRINT;
		}
	}
	else if (actions.leanleft==actionId)
	{
		m_actions |= ACTION_LEANLEFT;
	}
	else if (actions.leanright==actionId)
	{
		m_actions |= ACTION_LEANRIGHT;
	}
	else if (actions.thirdperson==actionId)
	{ 
		if (!pVehicle)
			m_pPlayer->ToggleThirdPerson();
	}
	else if (actions.flymode==actionId)
	{
		++m_pStats->flyMode;

		if (m_pStats->flyMode>2)
			m_pStats->flyMode = 0;

		IPhysicalEntity *pPhys = m_pPlayer->GetEntity()->GetPhysics();
		if (pPhys)
		{
			pe_player_dynamics pD;
			pD.bActive = (m_pStats->flyMode==2)?false:true;
			pPhys->SetParams(&pD);
		}

		switch(m_pStats->flyMode)
		{
		case 0:m_pPlayer->CreateScriptEvent("printhud",0,"FlyMode/NoClip OFF");break;
		case 1:m_pPlayer->CreateScriptEvent("printhud",0,"FlyMode ON");break;
		case 2:m_pPlayer->CreateScriptEvent("printhud",0,"NoClip ON");break;
		}
	}
	else if (actions.godmode==actionId)
	{
		++m_pStats->godMode;

		if (m_pStats->godMode>2)
			m_pStats->godMode = 0;

		if (pHUD)
		{
			pHUD->SetGODMode(m_pStats->godMode);
		}
	}
	else if (actions.debuggun == actionId)
	{
		if (g_pGame)
			g_pGame->GetWeaponSystem()->DebugGun(0);
	}
	else if (actions.refgun == actionId)
	{
		if (g_pGame)
			g_pGame->GetWeaponSystem()->RefGun(0);
	}
	else if (actions.suitsave == actionId)
	{
		m_pPlayer->GetNanoSuit().SaveConfig();
		SGameObjectEvent evt("HUD_TextMessage",eGOEF_ToAll, IGameObjectSystem::InvalidExtensionID, (void*)("suit_config_saved"));
		GetISystem()->GetIGame()->GetIGameFramework()->GetIGameObjectSystem()->BroadcastEvent(evt);
	}
	else if (actions.suitload == actionId)
	{
		m_pPlayer->GetNanoSuit().LoadConfig();
		SGameObjectEvent evt("HUD_TextMessage",eGOEF_ToAll, IGameObjectSystem::InvalidExtensionID, (void*)("suit_config_loaded"));
		GetISystem()->GetIGame()->GetIGameFramework()->GetIGameObjectSystem()->BroadcastEvent(evt);
	}
	//FIXME:temporary debug code
	/*	else if (actions.suitslot==actionId)
	{
	m_nanoSuit.debugSetNextSlot();
	}
	else if (actions.suitmore==actionId)
	{
	int slot(m_nanoSuit.debugGetCurrentSlot());
	if (slot>=NANOSLOT_LAST)
	m_nanoSuit.SetMedicalMode(true);
	else
	m_nanoSuit.SetSlotValue(slot,m_nanoSuit.GetSlotValue(slot,true)+1);
	}
	else if (actions.suitless==actionId)
	{
	int slot(m_nanoSuit.debugGetCurrentSlot());
	if (slot>=NANOSLOT_LAST)
	m_nanoSuit.SetMedicalMode(false);
	else
	m_nanoSuit.SetSlotValue(slot,m_nanoSuit.GetSlotValue(slot,true)-1);
	}*/

	if (pVehicle)
	{
		pVehicle->OnAction(actionId.c_str(),activationMode,value,m_pPlayer->GetEntityId());

		// if thirdperson, check if view has changed
		if (actions.thirdperson==actionId)
		{
			CVehicleSeat* pSeat = pVehicle->GetSeatForPassenger(m_pPlayer->GetEntity()->GetId());

			if (pSeat && pSeat->GetCurrentView() && pSeat->GetCurrentView()->IsThirdPerson() != m_pStats->isThirdPerson)      
				m_pPlayer->ToggleThirdPerson();
			else
				filterOut = false;
		}

		//FIXME:not really good
		m_actions = 0;
		m_deltaRotation.Set(0,0,0);
		m_deltaMovement.Set(0,0,0);
	}
	else if (!m_pPlayer->m_isFrozen)
	{
		m_pPlayer->CActor::OnAction(actionId, activationMode, value);

		IInventory *pInventory = static_cast<IInventory *>(m_pPlayer->GetGameObject()->QueryExtension("Inventory"));
		if (!pInventory)
			return;

		bool binoculars = false;
		EntityId itemId = pInventory->GetCurrentItem();
		if (itemId)
		{
			CWeapon *pWeapon = m_pPlayer->GetWeapon(itemId);
			if (pWeapon && !strcmp(pWeapon->GetEntity()->GetClass()->GetName(), "Binoculars"))
				binoculars = true;
		}
		if ((actions.nextitem == actionId) && !binoculars)
			m_pPlayer->SelectNextItem(1, true);
		else if ((actions.previtem == actionId) && !binoculars)
			m_pPlayer->SelectNextItem(-1, true);
		else if ((actions.drop == actionId) && !binoculars && itemId)
			m_pPlayer->DropItem(itemId);
		else if (actions.binoculars == actionId)
		{
			if (binoculars)
				m_pPlayer->SelectLastItem(false);
			else
				m_pPlayer->SelectItemByName("Binoculars", true);
		}
	}

	if (m_moveKeysPressed > 0 && checkZoom)
	{
		IWeapon *wep = NULL;
		if(m_pPlayer->GetCurrentItem())
			wep = m_pPlayer->GetCurrentItem()->GetIWeapon();
		if (wep)
		{
			IZoomMode *zm = wep->GetZoomMode(wep->GetCurrentZoomMode());
			if (zm && !zm->IsZooming() && !zm->IsZoomed())
			{
				m_pPlayer->m_intensityMonitor->Enable(true);
				m_pPlayer->m_intensityMonitor->ChangeFOV(1.0f, m_pPlayer->m_pMoveZoomTime->GetFVal(), true, 1.0f - m_pPlayer->m_pZoomAmount->GetFVal());
				m_pPlayer->m_intensityMonitor->Enable(false);
			}
		}

		checkZoom = false;
	}
	if (checkZoom)
	{
		IWeapon *wep = NULL;
		if(m_pPlayer->GetCurrentItem())
			wep = m_pPlayer->GetCurrentItem()->GetIWeapon();
		if (wep)
		{
			IZoomMode *zm = wep->GetZoomMode(wep->GetCurrentZoomMode());
			if (zm && !zm->IsZooming() && !zm->IsZoomed())
			{
				m_pPlayer->m_intensityMonitor->Enable(true);
			}
		}
		checkZoom = false;
	}

	//send the onAction to scripts, after filter the range of actions. for now just use and hold
	if (filterOut)
	{
		HSCRIPTFUNCTION scriptOnAction(NULL);

		IScriptTable *scriptTbl = m_pPlayer->GetEntity()->GetScriptTable();

		if (scriptTbl)
		{
			scriptTbl->GetValue("OnAction", scriptOnAction);

			if (scriptOnAction)
			{
				char *activation = 0;

				switch(activationMode)
				{
				case eAAM_OnHold:
					activation = "hold";
					break;
				case eAAM_OnPress:
					activation = "press";
					break;
				case eAAM_OnRelease:
					activation = "release";
					break;
				default:
					activation = "";
					break;
				}

				Script::Call(GetISystem()->GetIScriptSystem(),scriptOnAction,scriptTbl,actionId.c_str(),activation, value);
			}
		}
	}

	// FIXME: temporary method to dispatch Actions to HUD (it's not yet possible to register)
	if(pHUD)
	{
		pHUD->OnAction(actionId,activationMode,value);
	}
}
#endif //if 0		// OnAction

void CPlayerInputG4::PreUpdate()
{
	CMovementRequest request;


	// get rotation into a manageable form
	float mouseSensitivity;
	if (m_pPlayer->IsZeroG())
		mouseSensitivity = 0.01f*MAX(1.0f, GetISystem()->GetIConsole()->GetCVar("cl_sensitivityZeroG")->GetFVal());
	else
		mouseSensitivity = 0.01f*MAX(1.0f, GetISystem()->GetIConsole()->GetCVar("cl_sensitivity")->GetFVal());

	m_deltaRotation += m_xi_deltaRotation;

	Ang3 deltaRotation = m_deltaRotation;
	deltaRotation *= mouseSensitivity * m_pPlayer->m_params.viewSensitivity * gf_PI / 180.0f;
	deltaRotation *= m_pPlayer->GetMassFactor();

	if (GetISystem()->GetIConsole()->GetCVar("cl_invertMouse")->GetIVal())
		deltaRotation.x *= -1.0f;

	request.AddDeltaRotation( deltaRotation );


	// add some movement...
	if (!m_pStats->isFrozen)
		request.AddDeltaMovement( FilterMovement(m_deltaMovement) );


	// handle actions
	if (m_actions & ACTION_JUMP)
		request.SetJump();
	if (m_pStats->isOnLadder)
	{
		m_actions &= ~ACTION_PRONE;
		m_actions &= ~ACTION_CROUCH;
	}
	else if (m_actions & ACTION_JUMP && m_pPlayer->GetStance() == STANCE_PRONE)
	{
		m_actions &= ~ACTION_PRONE;
		//		m_actionsPressed &= ~ACTION_JUMP;
	}

	request.SetStance(FigureOutStance());

	// handle leaning
	if (m_actions & ACTION_LEANLEFT)
		request.SetLean(-1.0f);
	else if (m_actions & ACTION_LEANRIGHT)
		request.SetLean(1.0f);
	else
		request.ClearLean();


	// send the movement request to the appropriate spot!
	m_pPlayer->m_pMovementController->RequestMovement( request );
	m_pPlayer->m_actions = m_actions;

	// reset things for next frame that need to be
	m_deltaRotation = Ang3(0,0,0);

	//static float color[] = {1,1,1,1};    
  //GetISystem()->GetIRenderer()->Draw2dLabel(100,50,1.5,color,false,"deltaMovement:%f,%f", m_deltaMovement.x,m_deltaMovement.y);
}

EStance CPlayerInputG4::FigureOutStance()
{
	if (m_actions & ACTION_CROUCH)
		return STANCE_CROUCH;
	else if (m_actions & ACTION_PRONE)
		return STANCE_PRONE;
	else if (m_actions & ACTION_RELAXED)
		return STANCE_RELAXED;
	else if (m_actions & ACTION_STEALTH)
		return STANCE_STEALTH;
	else if (m_pPlayer->GetStance() == STANCE_NULL)
		return STANCE_STAND;
	return STANCE_STAND;
}

void CPlayerInputG4::Update()
{
}

void CPlayerInputG4::PostUpdate()
{
	// Select action maps
	IActionMapManager *pActionMapMan = GetISystem()->GetIGame()->GetIGameFramework()->GetIActionMapManager();
	pActionMapMan->EnableActionMap("default",!m_bEnableTweakMap);
	pActionMapMan->EnableActionMap("tweak",m_bEnableTweakMap);
	
	m_actions &= ~(ACTION_LEANLEFT | ACTION_LEANRIGHT);

	const float pitchScale=2.5f;
	float frameTime(GetISystem()->GetITimer()->GetFrameTime());
	bool bFlipPitch=true;
	float deltaPitch=m_deltaPitch;
	deltaPitch+=m_deltaPitchOnce;
	m_deltaPitchOnce=0;

	if(bFlipPitch) deltaPitch=-deltaPitch;

	float pitch=GetISystem()->GetIConsole()->GetCVar("cl_tpvPitchNav")->GetFVal();
	pitch+=deltaPitch*(frameTime/0.1f)*pitchScale;
	pitch=(pitch>50) ? 50 : (pitch<-20) ? -20 : pitch;
	GetISystem()->GetIConsole()->GetCVar("cl_tpvPitchNav")->Set(pitch);

	m_pPlayer->m_timeLastYawPitch+=frameTime;
	m_pPlayer->m_nTickLastPitch++;
}

void CPlayerInputG4::GetState( SSerializedPlayerInput& input )
{
	SMovementState movementState;
	m_pPlayer->GetMovementController()->GetMovementState( movementState );

	input.stance = FigureOutStance();
	input.desiredDirection = movementState.movementDirection.GetNormalizedSafe(FORWARD_DIRECTION);
	input.desiredSpeed = movementState.desiredSpeed;
	Vec3 playerPos = m_pPlayer->GetEntity()->GetWorldPos();
	input.lookDirection = (movementState.eyePosition + movementState.eyeDirection - playerPos).GetNormalized();
	input.bodyDirection = movementState.bodyDirection;
}

void CPlayerInputG4::SetState( const SSerializedPlayerInput& input )
{
	assert(false);
	GameWarning("CPlayerInputG4::SetState called: should never happen");
}

void CPlayerInputG4::AdjustMoveKeysPressed( int activationMode )
{
	if (activationMode == eAAM_OnPress)
		m_moveKeysPressed ++;
	else if (activationMode == eAAM_OnRelease)
		m_moveKeysPressed --;
}

//---------------------------------------------------------------------------------------------
//---------------------------------------------------------------------------------------------
//---------------------------------------------------------------------------------------------
#define G4_MOVECODE		0			// 0 disables G4 movement code for integration testing.

//
// Input handling for controllers.
//
// Navigational input behaves differently depending on which of two game modes we're in:
//
//  Navigation mode:
//    Left stick L/R turns the character
//    Left stick F/B moves F/B
//    Left stick backwards followed by sprint button 'snap' turns 180
//
//    Right stick pans camera L/R/U/D - no effect on movement dir, auto centres
//
//  Combat mode:
//    Left stick L/R steps/strafes L/R
//    Left stick F/B moves F/B
//
//    Right stick aims within a dead zone, when outside the dead zone the character turns or looks up/down
//
//  Terminology:
//    MoveStick is the stick used for forward/back movement. Normally the left stick.
//    NavStick is the stick used for looking up/down etc. Normally the right stick.
//


// Post Game02's VS2 milestone, stick normalisation needs to go into the joystick device.
// Normalise the input, correcting for the dead zone
static inline float NormaliseStick(float value)
{
	// Assuming a 0.24 dead zone in the driver, but will still function if this is false.
	if(value>0)
	{
		value=(value-0.24)/(1-0.24);
		if (value<0) value=0;
	}
	else if (value<0)
	{
		value=(value+0.24)/(1-0.24);
		if (value>0) value=0;
	}

	return (value<-1) ? -1 : (value>1) ? 1 : value;
}

// Normalise the input, correcting for the dead zone, then apply a gain/power sensitivity curve
// the higher gamma is, the more sensitive the stick is at the centre, and the less sensitive it is at the edge.
// the gain speeds up the stick over its entire centre to edge range.
static inline float AdjustStickInput(float value,float gain,float gamma,float clamp)
{
	value=NormaliseStick(value);

	if(value<0)
		gain=-gain;
	value=gain*pow(abs(value),gamma);

	if(clamp>0.01f)
		value = value<-clamp ? -clamp : value>clamp ? clamp : value;
	return value;
}

// Normalise the input, correcting for the dead zone, then apply a gain/power curve
// the higher gamma is, the more sensitive the stick is at the centre, and the less sensitive it is at the edge.
// the gain speeds up the stick over its entire centre to edge range.
float CPlayerInputG4::AdjustStickInputHorz(float value)
{
	eGamePlayMode eMode=m_pPlayer->m_pAutoCombat->GetCurrentMode();
	float gain=1,gamma=1,clamp=1;

	if(eMode== eCombatMode)
	{
		gain=GetISystem()->GetIConsole()->GetCVar("cl_joy_combat_speedH")->GetFVal();
		gamma=GetISystem()->GetIConsole()->GetCVar("cl_joy_combat_sensitivityH")->GetFVal();
		clamp=GetISystem()->GetIConsole()->GetCVar("cl_joy_combat_maxH")->GetFVal();
	}
	else	// nav mode
	{
		gain=GetISystem()->GetIConsole()->GetCVar("cl_joy_nav_speedH")->GetFVal();
		gamma=GetISystem()->GetIConsole()->GetCVar("cl_joy_nav_sensitivityH")->GetFVal();
		clamp=GetISystem()->GetIConsole()->GetCVar("cl_joy_nav_maxH")->GetFVal();
	}

	return AdjustStickInput(value,gain,gamma,clamp);
}

float CPlayerInputG4::AdjustStickInputVert(float value)
{
	eGamePlayMode eMode=m_pPlayer->m_pAutoCombat->GetCurrentMode();
	int iUseHForV=0;
	
	if(eMode == eCombatMode)
	{
		iUseHForV=GetISystem()->GetIConsole()->GetCVar("cl_joy_combat_useHforV")->GetIVal();
	}
	else
	{
		iUseHForV=GetISystem()->GetIConsole()->GetCVar("cl_joy_nav_useHforV")->GetIVal();
	}

	if(0!=iUseHForV)
	{
		value=AdjustStickInputHorz(value);
	}
	else
	{
		float gain=1,gamma=1,clamp=1;

		if(eMode== eCombatMode)
		{
			gain=GetISystem()->GetIConsole()->GetCVar("cl_joy_combat_speedV")->GetFVal();
			gamma=GetISystem()->GetIConsole()->GetCVar("cl_joy_combat_sensitivityV")->GetFVal();
			clamp=GetISystem()->GetIConsole()->GetCVar("cl_joy_combat_maxV")->GetFVal();
		}
		else	// nav mode
		{
			gain=GetISystem()->GetIConsole()->GetCVar("cl_joy_nav_speedV")->GetFVal();
			gamma=GetISystem()->GetIConsole()->GetCVar("cl_joy_nav_sensitivityV")->GetFVal();
			clamp=GetISystem()->GetIConsole()->GetCVar("cl_joy_nav_maxV")->GetFVal();
		}

		value=AdjustStickInput(value,gain,gamma,clamp);
	}
	return value;
}

bool CPlayerInputG4::OnActionMoveStickLR(const char *actionName, int activationMode, float value)
{
	//--- Nick temp hack whilst we've no sidestep assets.
	//return OnActionNavStickLR(actionName,activationMode,value);

	value=NormaliseStick(value);
	//value*=GetISystem()->GetIConsole()->GetCVar("cl_joy_combat_turn")->GetFVal();

#if G4_MOVECODE
	if(!m_modes.bFirstPersonStaticMode)
	{
		if(IsCombatMode())
		{
			// Cover?
			if(m_modes.bCoverMode)
			{
				float val=value*0.01f*0.5f;
				m_deltaMovement.x += val;  // Strafe only
			}
			else
			{
				//float val=value*0.01f*GetISystem()->GetIConsole()->GetCVar("cl_joy_combat_strafe")->GetFVal();
				//m_deltaMovement.x += val;  // Strafe
				//m_deltaRotation.z -= val*20*GetISystem()->GetIConsole()->GetCVar("cl_joy_combat_turn")->GetFVal();      // And turn
				float val=value*0.01f*0.5f;
				m_deltaMovement.x += val;  // Strafe only
			}
		}
		else	// ! CombatMode => is Nav mode
		{
			if(m_modes.bCoverMode)
			{
				float val=value*0.01f*0.5f;
				m_deltaMovement.x += val;  // Strafe only in cover
				// should actually turn to track the cover object as needed / sensible
			}
			else
			{
				float val=value*0.2f*GetISystem()->GetIConsole()->GetCVar("cl_joy_nav_turn")->GetFVal();
				//CryLogAlways(" Nav:%f\n",val);
				m_deltaRotation.z -= val;
			}
		}
	}
#else
	m_deltaMovement.x = value;
	//m_deltaMovement.y += value;
#endif
	return false;
}


bool CPlayerInputG4::OnActionMoveLeft(const char *actionName, int activationMode, float value)
{
#if G4_MOVECODE
	if(!m_modes.bFirstPersonStaticMode)
	{
		m_deltaMovement.x -= value;
	}
#else
	//m_deltaMovement.x -= value*2.0f - 1.0f;
		ApplyMovement(Vec3(-(value*2.0f - 1.0f),0,0));

		//checkZoom = true;
		AdjustMoveKeysPressed(activationMode);
#endif
	return false;
	//return OnActionMoveStickLR(actionName,activationMode,-value);
}
bool CPlayerInputG4::OnActionMoveRight(const char *actionName, int activationMode, float value)
{
#if G4_MOVECODE
	if(!m_modes.bFirstPersonStaticMode)
	{
		m_deltaMovement.x += value;
	}
#else
	//m_deltaMovement.x += value*2.0f - 1.0f;
		ApplyMovement(Vec3(value*2.0f - 1.0f,0,0));

		//checkZoom = true;
		AdjustMoveKeysPressed(activationMode);
#endif
	return false;
	//return OnActionMoveStickLR(actionName,activationMode,value);
}

bool CPlayerInputG4::OnActionMoveUDShared(const char *actionName, int activationMode, float value)
{
	if(!m_pPlayer->m_modes.bFirstPersonStaticMode)
	{
		m_deltaMovement.y += value;

		//--- Nav look return with movement
		m_pPlayer->YawAutoReturn(1.0f,abs(value)); // frameTime=1.0f since value is already scaled by frameTime

		if(!m_pPlayer->IsCombatMode() )
		{
			if(1==GetISystem()->GetIConsole()->GetCVar("g_sprintOnNav")->GetIVal())
				m_actions |= ACTION_SPRINT; // sprint lock on navigate mode?

			m_pPlayer->PitchAutoReturn(1.0f,abs(value));
		}
		else  // combat mode
		{
		}
	}

	return false;
}

bool CPlayerInputG4::OnActionMoveStickUD(const char *actionName, int activationMode, float value)
{
	value=NormaliseStick(value);
#if G4_MOVECODE
	return OnActionMoveUDShared(actionName,activationMode,-value*0.03f);
#else
	m_deltaMovement.y = value;
	return false;
#endif
}

bool CPlayerInputG4::OnActionMoveUp(const char *actionName, int activationMode, float value)
{
#if G4_MOVECODE
	return OnActionMoveUDShared(actionName,activationMode,value*3);
#else
	//m_deltaMovement.y += value*2.0f - 1.0f;
		ApplyMovement(Vec3(0,value*2.0f - 1.0f,0));

		//checkZoom = true;
		AdjustMoveKeysPressed(activationMode);
	return false;
#endif
}
bool CPlayerInputG4::OnActionMoveDown(const char *actionName, int activationMode, float value)
{
#if G4_MOVECODE
	return OnActionMoveUDShared(actionName,activationMode,-value*3);
#else
	//m_deltaMovement.y -= value*2.0f - 1.0f;
		ApplyMovement(Vec3(0,-(value*2.0f - 1.0f),0));

		//checkZoom = true;
		AdjustMoveKeysPressed(activationMode);
	return false;
#endif
}

float CPlayerInputG4::WrapAngle180(float yaw)
{
	if(yaw>180)
		yaw=yaw-360;
	if(yaw<-180)
		yaw=yaw+360;

	return yaw;
}


bool CPlayerInputG4::OnActionNavStickLR(const char *actionName, int activationMode, float value)
{
	//value=NormaliseStick(value);
	//value*=GetISystem()->GetIConsole()->GetCVar("cl_joy_combat_turn")->GetFVal();
	value=AdjustStickInputHorz(value);
#if G4_MOVECODE
	// Need seperate move LR for dev mode kb/mouse control
	//m_deltaMovement.x += value*0.005f;

	m_pPlayer->m_timeLastYawPitch=0;
	m_pPlayer->m_nTickLastPitch=0;
	const float scale=0.001f;

	if(1) //if(!IsCombatMode())	// Nav mode
	{
		float yaw=GetISystem()->GetIConsole()->GetCVar("cl_tpvYawNav")->GetFVal();
		float yawIn=yaw;
		yaw+=value*scale;

		yaw=WrapAngle180(yaw);

		GetISystem()->GetIConsole()->GetCVar("cl_tpvYawNav")->Set(yaw);

		if(yawIn!=yaw)
		{
			char acBuf[1024];
			sprintf(acBuf,"Yaw change: %f to %f (step:%f)\n",yawIn,yaw,value*0.05f);
			//CryLogAlways(acBuf);
			//			CreateScriptEvent("printhud",0,acBuf);
		}
	}
	else  // combat mode
	{
		GetISystem()->GetIConsole()->GetCVar("cl_tpvYawNav")->Set(0);

		float yaw=m_pPlayer->m_aiming.aimYaw;
		float yawIn=yaw;
		yaw+=value*0.05f*scale;

		yaw=WrapAngle180(yaw);

		m_pPlayer->m_aiming.aimYaw=yaw;

		if(0)	// if m_aiming.aimYaw too far from look yaw
		{
			float val=value*0.2f*GetISystem()->GetIConsole()->GetCVar("cl_joy_nav_turn")->GetFVal();
			//CryLogAlways(" Nav:%f\n",val);
			m_deltaRotation.z -= val;
			// change this to desired dir
		}

		if(yawIn!=yaw)
		{
			char acBuf[1024];
			sprintf(acBuf,"Yaw change: %f to %f (step:%f)\n",yawIn,yaw,value*0.05f);
			//CryLogAlways(acBuf);
			//			CreateScriptEvent("printhud",0,acBuf);
		}
	}
#else
	m_pPlayer->m_timeLastYawPitch=0;
	m_pPlayer->m_nTickLastPitch=0;

	m_xi_deltaRotation.z = -20.0f*value;
#endif
	return false;
}

bool CPlayerInputG4::OnActionNavStickUD(const char *actionName, int activationMode, float value)
{
	//value=NormaliseStick(value);
	value=AdjustStickInputHorz(value);
#if G4_MOVECODE
	// "rotatepitch"

	m_pPlayer->m_timeLastYawPitch=0;
	m_pPlayer->m_nTickLastPitch=0;

	eGamePlayMode eMode=m_pPlayer->m_pAutoCombat->GetCurrentMode();
	if(eNavigationMode == eMode)
	{

		float pitch=GetISystem()->GetIConsole()->GetCVar("cl_tpvPitchNav")->GetFVal();
		float pitchIn=pitch;
		pitch+=value*0.05f;


		pitch=(pitch>65) ? 65 : (pitch<-15) ? -15 : pitch;
		//pitch=WrapAngle180(pitch);

		GetISystem()->GetIConsole()->GetCVar("cl_tpvPitchNav")->Set(pitch);
	}

	int iCamMode=GetISystem()->GetIConsole()->GetCVar("cl_cm")->GetIVal();
	if(0==iCamMode)
		m_deltaRotation.x -= value;
#else
	m_pPlayer->m_timeLastYawPitch=0;
	m_pPlayer->m_nTickLastPitch=0;

	eGamePlayMode eMode=m_pPlayer->m_pAutoCombat->GetCurrentMode();
	//	if(eNavigationMode == eMode)
	{

		float pitch=0;
		float pitchIn=pitch;
		pitch=value*0.05f*20;

		m_deltaPitch=pitch;
		//pitch=WrapAngle180(pitch);

		//GetISystem()->GetIConsole()->GetCVar("cl_tpvPitchNav")->Set(pitch);
	}
	m_xi_deltaRotation.x = 20.0f*value;
#endif
	return false;
}

bool CPlayerInputG4::OnActionNavMouseUD(const char *actionName, int activationMode, float value)
{
#if G4_MOVECODE
	// "rotatepitch"
	eGamePlayMode eMode=m_pPlayer->m_pAutoCombat->GetCurrentMode();
	//if(eNavigationMode == eMode)
	m_deltaRotation.x -= value;
#else
	m_deltaRotation.x -= value;

	{

		float pitch=0;
		float pitchIn=pitch;
		pitch=-value*0.05f*2.5f;

		m_deltaPitchOnce=pitch;
		//pitch=WrapAngle180(pitch);

		//GetISystem()->GetIConsole()->GetCVar("cl_tpvPitchNav")->Set(pitch);
	}
#endif
	return false;
}

bool CPlayerInputG4::OnActionNavMouseLR(const char *actionName, int activationMode, float value)
{
#if G4_MOVECODE
	if(IsClient() && m_pPlayer->m_pAutoCombat)
	{
		if(eCombatMode==m_pPlayer->m_pAutoCombat->GetCurrentMode()) // Combat mode
		{
			float val=value;//*0.01f*GetISystem()->GetIConsole()->GetCVar("cl_joy_combat_strafe")->GetFVal();
			//CryLogAlways(" Combat:%f\n",val);
			m_deltaMovement.x += val;  // Strafe
			m_deltaRotation.z -= val;      // And turn
		}
		else  // Navigation mode
		{
			float val=value;//*0.2f*GetISystem()->GetIConsole()->GetCVar("cl_joy_nav_turn")->GetFVal();
			//CryLogAlways(" Nav:%f\n",val);
			m_deltaRotation.z -= val;
		}
	}
#else
	m_deltaRotation.z -= value;
#endif
	return false;
}

bool CPlayerInputG4::OnActionAttack1(const char *actionName, int activationMode, float value)
{
	// Force the action name nomatter which action invoked us.
	//value=value>0.3f ? 1.0f : 0.0f;
	SetNewActionName("attack1");
	OnActionCallScript(GetNewActionName(actionName),activationMode,value);
	return false;
}
bool CPlayerInputG4::OnActionUseOn(const char *actionName, int activationMode, float value)
{
	if (IsClient() && m_pPlayer->m_pAutoCombat)
	{
		m_pPlayer->m_pAutoCombat->SetGamePlayMode(eCombatMode);		
		//SetLocalPitch(0);
	}
	return true;
}

bool CPlayerInputG4::OnActionUseOff(const char *actionName, int activationMode, float value)
{
	if (IsClient() && m_pPlayer->m_pAutoCombat)
	{
		m_pPlayer->m_pAutoCombat->SetGamePlayMode(eNavigationMode);
		//SetLocalPitch(0);
	}
	return true;
}


bool CPlayerInputG4::OnActionUse(const char *actionName, int activationMode, float value)
{
	if (IsClient())
	{
		if(m_pPlayer->m_modes.bCoverMode)
		{
			//--			LeaveCover();
		}
		else
		{
			Vec3 vCoverDir;
			SCover cover;

			if(m_pPlayer->GetCover(vCoverDir,cover))
			{
				//--					EnterCover(vCoverDir,cover);
			}
			else
			{
				//--				CryLogAlways("--- Use ---------------");
				//--				CreateScriptEvent("printhud",0,"Use");
			}
		}
	}
	return true;
}

void CPlayerInputG4::HolsterItem(bool bHolster)
{
	m_pPlayer->m_bHolster=bHolster;
	m_pPlayer->HolsterItem(m_pPlayer->m_bHolster);
}

bool CPlayerInputG4::OnActionDev(const char *actionName, int activationMode, float value)
{
	IVehicle *pVehicle = m_pPlayer->GetLinkedVehicle();

	if (!strcmp("temp_trig_left", actionName))
	{
		if (IsClient() && m_pPlayer->m_pAutoCombat)
		{
			m_pPlayer->m_pAutoCombat->SwitchToDesiredTarget(eLeft);
		}
	}
	else if (!strcmp("temp_trig_right", actionName))
	{
		if (IsClient() && m_pPlayer->m_pAutoCombat)
		{
			m_pPlayer->m_pAutoCombat->SwitchToDesiredTarget(eRight);
		}
	}
	else if (!strcmp("draw",actionName))
	{
		HolsterItem(!m_pPlayer->m_bHolster);
	}
	else if (!strcmp("draw_on",actionName))
	{
		HolsterItem(false);
	}
	else if (!strcmp("draw_off",actionName))
	{
		HolsterItem(true);
	}
	else if (!strcmp("jump",actionName))
	{
		//m_actions |= ACTION_JUMP;
		if (value > 0.0f)
		{
			//if (m_pPlayer->m_params.speedMultiplier > 0.99f)	// Hmm!!!!!!
				m_actions |= ACTION_JUMP;
		}
		else
		{
			m_actions &= ~ACTION_JUMP;
		}
	}
	else if (!strcmp("crouch",actionName))
	{
		if (value > 0.0f)
		{
			//if (m_pPlayer->m_params.speedMultiplier > 0.99f)
				m_actions |= ACTION_CROUCH;
		}
		else
		{
			m_actions &= ~ACTION_CROUCH;
		}
	}
	else if (!strcmp("prone",actionName))
	{
		//if (!(m_actions & ACTION_PRONE))
		//	m_actions |= ACTION_PRONE;
		//else
		//	m_actions &= ~ACTION_PRONE;
	}
	else if (!strcmp("sprint",actionName))
	{
		if (value > 0.0f)
		{
			if (m_pPlayer->m_params.speedMultiplier > 0.99f)
				m_actions |= ACTION_SPRINT;
		}
		else
		{
			m_actions &= ~ACTION_SPRINT;
		}
	}
	else if (!strcmp("leanleft",actionName))
	{
		m_actions |= ACTION_LEANLEFT;
	}
	else if (!strcmp("leanright",actionName))
	{
		m_actions |= ACTION_LEANRIGHT;
	}
	else if (!strcmp("thirdperson",actionName))
	{
		if (!pVehicle) 
			m_pPlayer->ToggleThirdPerson();
	}
	else if (!strcmp("thirdpersonEnter",actionName))
	{ 
		if(!pVehicle && !m_pPlayer->IsThirdPerson())
		{
			m_pPlayer->ToggleThirdPerson();
			SetNewActionName("thirdperson");
		}
		else
		{
			// For editor
			//ToggleThirdPerson();
			//ToggleThirdPerson();
		}
		m_pPlayer->m_modes.bFirstPersonStaticMode=false;
	}
	else if (!strcmp("thirdpersonLeave",actionName))
	{
		if(!pVehicle && m_pPlayer->IsThirdPerson())
		{
			m_pPlayer->ToggleThirdPerson();
			SetNewActionName("thirdperson");
		}
		else
		{
			// For editor
			//ToggleThirdPerson();
			//ToggleThirdPerson();
		}
		m_pPlayer->m_modes.bFirstPersonStaticMode=true;
	}
	else if (!strcmp("flymode",actionName))
	{
		//m_pStats->flyMode = !m_pStats->flyMode;
		++m_pPlayer->m_stats.flyMode;

		if (m_pPlayer->m_stats.flyMode>2)
			m_pPlayer->m_stats.flyMode = 0;

		IPhysicalEntity *pPhys = m_pPlayer->GetEntity()->GetPhysics();
		if (pPhys)
		{
			pe_player_dynamics pD;
			pD.bActive = (m_pPlayer->m_stats.flyMode==2)?false:true;
			pPhys->SetParams(&pD);
		}

		switch(m_pPlayer->m_stats.flyMode)
		{
		case 0:m_pPlayer->CreateScriptEvent("printhud",0,"FlyMode/NoClip OFF");break;
		case 1:m_pPlayer->CreateScriptEvent("printhud",0,"FlyMode ON");break;
		case 2:m_pPlayer->CreateScriptEvent("printhud",0,"NoClip ON");break;
		}
	}
	else if (!strcmp("godmode",actionName))
	{
		++m_pStats->godMode;

		if (m_pStats->godMode>2)
			m_pStats->godMode = 0;

		switch(m_pStats->godMode)
		{
		case 0:	m_pPlayer->CreateScriptEvent("printhud",0,"GodMode OFF");break;
		case 1:	m_pPlayer->CreateScriptEvent("printhud",0,"GodMode ON");break;
		case 2:	m_pPlayer->CreateScriptEvent("printhud",0,"Team GodMode ON");break;
		}
	}
	else if (!strcmp("debuggun",actionName))
	{
		if (g_pGame)
			g_pGame->GetWeaponSystem()->DebugGun(0);
	}
	else if (!strcmp("refgun",actionName))
	{
		if (g_pGame)
			g_pGame->GetWeaponSystem()->RefGun(0);
	}
	else if (!strcmp("debug_ag_step",actionName))
	{
		GetISystem()->GetIConsole()->ExecuteString("ag_step");
	}
	else if (!strcmp("snapturn",actionName))
	{
		//--- TODO: This now needs implementing in the post action callback since we can no longer query the stick.
#if 0
		float snapTurnThreshold=-0.3f;
		IJoystick *pStick=GetISystem()->GetIInput()->GetSelectedController();
		if(pStick && (pStick->GetAnalog1Dir().y < snapTurnThreshold))
		{
			// should eval the best turn dir here and set .z to appropriate side of -180
			// snap turn by almost 180 degrees. (Needs to be slightly less than 180 for consistent turn direction)
			m_deltaRotation.z -= 179.9f*g_PI/180.0f;
		}
#endif
	}

	return true;
}

bool CPlayerInputG4::OnActionCallScript(const char *actionName, int activationMode, float value)
{
	HSCRIPTFUNCTION scriptOnAction(NULL);

	IScriptTable *scriptTbl = m_pPlayer->GetEntity()->GetScriptTable();

	if (scriptTbl)
	{
		scriptTbl->GetValue("OnAction", scriptOnAction);

		if (scriptOnAction)
		{
			char *activation = 0;

			switch(activationMode)
			{
			case eAAM_OnHold:
				activation = "hold";
				break;
			case eAAM_OnPress:
				activation = "press";
				break;
			case eAAM_OnRelease:
				activation = "release";
				break;
			default:
				activation = "";
				break;
			}

			Script::Call(GetISystem()->GetIScriptSystem(),scriptOnAction,scriptTbl,actionName,activation, value);
		}
	}
	return false;
}

// Controller connection/disconnection.
bool CPlayerInputG4::OnActionCtrlConnect(const char *actionName, int activationMode, float value)
{
	if(IsClient())
	{
		CryLogAlways("CtrlConnect: '%s'\n",actionName);

		if(0==strcmp(actionName,"ctrl_connect"))
		{
			// A new controller's been connected.
		}
		else if(0==strcmp(actionName,"ctrl_disconnect"))
		{
			// A controller's been disconnected.
		}
		else if(0==strcmp(actionName,"ctrl_activedisconnect"))
		{
			// the currently selected controller's been disconnected
		}
		else if(0==strcmp(actionName,"ctrl_activereconnect"))
		{
			// the currently selected controller's been reconnected
		}
	}
	return false;
}

bool CPlayerInputG4::OnActionTweak(const char *actionName, int activationMode, float value)
{
	CPlayerActionMap *pMap=CPlayerActionMap::GetPlayerActionMap();
	IActionMapManager *pActionMapMan = GetISystem()->GetIGame()->GetIGameFramework()->GetIActionMapManager();

	if(0==strcmp(actionName,"tweakexit"))
	{
		m_bEnableTweakMap = false;
	} 
	else if(0==strcmp(actionName,"tweakenter"))
	{
		m_bEnableTweakMap = true;
	}

	// In all cases, forward the event to the TweakHUD
	CHUD* pHUD = (CHUD*)m_pPlayer->GetGameObject()->QueryExtension("HUD");
	if (pHUD)
	{
		pHUD->OnActionTweak(actionName, activationMode, value);
	}
	return false;
}

//this will convert the input into a structure the player will use to process movement & input
//void CPlayerInputG4::OnAction(const char *actionName, int activationMode, float value)
void CPlayerInputG4::OnAction(const ActionId& initialActionId, int activationMode, float value)
{	
	FUNCTION_PROFILER(GetISystem(), PROFILE_GAME);
	const char *actionName=initialActionId.c_str();
	//this tell if OnAction have to be forwarded to scripts, now its true by default, only high framerate actions are ignored
	bool filterOut(true);
	CHUD * pHUD = m_pPlayer->GetHUD();

	IVehicle *pVehicle = m_pPlayer->GetLinkedVehicle();

	SetNewActionName(0);

	// Check for special case actions that enable/disable the action system
	if(0==strcmp("input_on",actionName))
	{
		m_pPlayer->m_bActionsEnabled=true;
	}
	else if (0==strcmp("input_off",actionName))
	{
		m_pPlayer->m_bActionsEnabled=false;
	}


	if(m_pPlayer->m_bActionsEnabled)
	{
		// Call the registered handler for this action. See GameG4::InitActionMaps for the action and handler registration.
		filterOut=CPlayerActionMap::GetPlayerActionMap()->OnAction(this,actionName,activationMode,value);

		actionName=GetNewActionName(actionName);

		//send the onAction to scripts, after filter the range of actions. for now just use and hold

		if (filterOut)
			OnActionCallScript(actionName,activationMode,value);

		if (pVehicle)
		{
			pVehicle->OnAction(actionName,activationMode,value,m_pPlayer->GetEntity()->GetId());

			//FIXME:not really good
			m_actions = 0;
			m_deltaRotation.Set(0,0,0);
			m_deltaMovement.Set(0,0,0);
		}
		else
		{
			m_pPlayer->CActor::OnAction(actionName, activationMode, value);

			IInventory *pInventory = static_cast<IInventory *>(m_pPlayer->GetGameObject()->QueryExtension("Inventory"));
			if (!pInventory)
				return;

			bool binoculars = false;
			EntityId itemId = pInventory->GetCurrentItem();
			if (itemId)
			{
				CWeapon *pWeapon = m_pPlayer->GetWeapon(itemId);
				if (pWeapon && !strcmp(pWeapon->GetEntity()->GetClass()->GetName(), "Binoculars"))
					binoculars = true;
			}
			//if ((actions.nextitem == actionId) && !binoculars)
			//	SelectNextItem(1, true);
			//else if ((actions.previtem == actionId) && !binoculars)
			//	SelectNextItem(-1, true);
			//else if (actions.binoculars == actionId)
			//{
			//	if (binoculars)
			//		SelectLastItem(false);
			//	else
			//		SelectItemByName("Binoculars", true);
			//}
		}

		// relay input to the weapon system
		// Now done via CActor::OnAction
		//if (m_pItemSystem)
		//{
		//	m_pItemSystem->OnAction(GetEntityId(), actionName, activationMode, value);
		//}

		// FIXME: temporary method to dispatch Actions to HUD (it's not yet possible to register)
		if(pHUD)
		{
			pHUD->OnAction(actionName,activationMode,value);
		}
	}
	SetNewActionName(0);
}

//this function basically returns a smoothed movement vector, for better movement responsivness in small spaces
const Vec3 &CPlayerInputG4::FilterMovement(const Vec3 &desired)
{
	float frameTimeCap(min(GetISystem()->GetITimer()->GetFrameTime(),0.033f));
	float inputAccel(g_pGame->GetCVars()->pl_inputAccel->GetFVal());

	if (desired.len2()<0.01f)
	{
		m_filteredDeltaMovement.zero();
	}
	else if (inputAccel<=0.0f)
	{
		m_filteredDeltaMovement = desired;
	}
	else
	{
		Vec3 delta(desired - m_filteredDeltaMovement);

		float len(delta.len());
		if (len<=1.0f)
			delta = delta * (1.0f - len*0.55f);

		m_filteredDeltaMovement += delta * min(frameTimeCap * inputAccel,1.0f);
	}

	return m_filteredDeltaMovement;
}

void CPlayerInputG4::ApplyMovement(Vec3 delta)
{
	//m_deltaMovement += delta;
	m_deltaMovement.x = clamp_tpl(m_deltaMovement.x+delta.x,-1.0f,1.0f);
	m_deltaMovement.y = clamp_tpl(m_deltaMovement.y+delta.y,-1.0f,1.0f);
	m_deltaMovement.z = 0;
}
