/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2004.
-------------------------------------------------------------------------
$Id$
$DateTime$

Description:
The view specific code (First person, Third person, followCharacterHead etc).


-------------------------------------------------------------------------
History:
- 21:02:2006: Re-factored from Filippo's CPlayer code by Nick Hesketh

*************************************************************************/

#ifndef __G4PLAYERVIEW_H__
#define __G4PLAYERVIEW_H__

#if _MSC_VER > 1000
# pragma once
#endif

#include "PlayerView.h"
#include "G4Player.h"
#include "AutoCombat.h"

#define G4_VIEW	1

struct SCamPos
{
	Vec3 vPos;
	float dist;		// spherical coords of camera relative to player/reference object
	float yaw;		// spherical coords of camera relative to player/reference object
	float pitch;	// spherical coords of camera relative to player/reference object

	float horzFraming;		// horizontal framing offset. Normally -1/3, 0, or +1/3 (left third, middle, right third)
	float vertFraming;		// vertical framing offset. Normally -1/3, 0, or +1/3 (top third, middle, bottom third)

	float angDamping;
	float posDamping;
};

struct SCamLook
{
	Quat rotation;
	float yaw;		// where the camera is looking
	float pitch;	// where the camera is looking
	float roll;		// where the camera is looking

	float focalDist;		// These are used by the DOF effect
	float focalWidth;		// These are used by the DOF effect
	float focalAmount;	// These are used by the DOF effect

	float angDamping;
	float focalDistDamping;
	float focalWidthDamping;
	float focalAmountDamping;

};

struct SCamEffect
{
	float dofAmount;	// depth of field. calc'd from focal amount
	float dofNear;		// depth of field. calc'd from focal dist, width
	float dofFar;			// depth of field. calc'd from focal dist, width
	float fov;				// field of view
	float fovDamping;
};

struct SCamState
{
	SCamPos pos;
	SCamLook look;
	SCamEffect effect;
};

inline Vec3 SphericalToCartesian(float yaw,float pitch,float dist)
{
	Vec3 vPos;
	vPos.x=dist*cos(yaw)*sin(pitch);
	vPos.y=dist*sin(yaw)*sin(pitch);
	vPos.z=dist*cos(pitch);

	return vPos;
}

inline void CartesianToSpherical(Vec3 vPos,float &yaw,float &pitch,float &dist)
{
	yaw=atan2(vPos.y,vPos.x);
	dist=vPos.len();
	float distPitch= abs(dist)> 0.0001f ? dist : dist >=0 ? 0.0001f : -0.0001f;
	pitch=acos(vPos.z/distPitch);
}

class CPlayerViewG4 : public CPlayerView
{
public:
	CPlayerViewG4(const CPlayerG4 &rPlayer,SViewParams &viewParams);

	void Process(SViewParams &viewParams);

	void Commit(CPlayerG4 &rPlayer,SViewParams &viewParams);

protected:
struct SCamPos
{
	Vec3 vPos;
	float dist;		// spherical coords of camera relative to player/reference object
	float yaw;		// spherical coords of camera relative to player/reference object
	float pitch;	// spherical coords of camera relative to player/reference object

	float horzFraming;		// horizontal framing offset. Normally -1/3, 0, or +1/3 (left third, middle, right third)
	float vertFraming;		// vertical framing offset. Normally -1/3, 0, or +1/3 (top third, middle, bottom third)

	float angDamping;
	float posDamping;
};

struct SCamLook
{
	Quat rotation;
	float yaw;		// where the camera is looking
	float pitch;	// where the camera is looking
	float roll;		// where the camera is looking

	float focalDist;		// These are used by the DOF effect
	float focalWidth;		// These are used by the DOF effect
	float focalAmount;	// These are used by the DOF effect

	float angDamping;
	float focalDistDamping;
	float focalWidthDamping;
	float focalAmountDamping;

};

struct SCamEffect
{
	float dofAmount;	// depth of field. calc'd from focal amount
	float dofNear;		// depth of field. calc'd from focal dist, width
	float dofFar;			// depth of field. calc'd from focal dist, width
	float fov;				// field of view
	float fovDamping;
};

struct SCamState
{
	SCamPos pos;
	SCamLook look;
	SCamEffect effect;
};
	struct SViewStateIn	// to become SViewStateInG4 : public CPlayerView::SViewStateIn
	{
		Vec3 lastPos;				// previous view position
		Quat lastQuat;			// previous view rotation
		float defaultFov;

		float frameTime;

		ICharacterInstance *pCharacter;
		IVehicle *pVehicle;

		bool bIsGrabbing;
		bool stats_isRagDoll;							// ViewFollowCharacterFirstPerson (Primarily: Dead or TrackView) uses to add a small z offset to the view
		bool stats_followCharacterHead;		// Part of selection criteria for ViewFollowCharacterFirstPerson. Also forces an update to baseMtx, viewMtx,viewMtxFinal (update the player rotation if view control is taken from somewhere else)
		float stats_flatSpeed;
		float stats_leanAmount;
		float stats_inAir;
		int stats_firstPersonBody;
		float stats_onGround;
		Vec3 stats_velocity;
		uint8 stats_flyMode;

		float params_viewFoVScale;
		Vec3 params_viewPivot;
		float params_headBobbingMultiplier;
		float params_viewDistance;
		float params_weaponInertiaMultiplier;
		Ang3 params_hudAngleOffset;
		Vec3 params_hudOffset;
		float params_viewHeightOffset;
		float params_weaponBobbingMultiplier;

		float cl_bob;

		bool bIsThirdPerson;
		Vec3 vEntityWorldPos;
		EntityId entityId;
		Matrix34 entityWorldMatrix;
		Matrix34 entityWorldMatrix2;
		Vec3 localEyePos;
		Vec3 worldEyePos;
		Matrix33 headMtxLocal;
		float thirdPersonDistance;
		float thirdPersonYaw;
		float stand_MaxSpeed;

		int32 health;

		EStance stance;
		float shake;
		float standSpeed;
		//-----------------------------
		Vec3 posRef;
		Vec3 vCoverDir;
		SModes modes;
		eGamePlayMode eMode;
		int iCamMode;
		bool bThirdPersonDamped;
	};

	struct SViewStateInOut // to become SViewStateInOutG4 : public CPlayerView::SViewStateInOut
	{
		//--- temporaries - FirstThird shared
		bool bUsePivot;
		float bobMul;
		Matrix33 viewMtxForWeapon;	// First Person view matrix before bobbing has been applied
		Vec3 eyeOffsetGoal;
		//--- temporaries - view shared
		Ang3 wAngles;
		//--- I/O
		//--- Used by Pre-process only (in from game?)
		//Vec3 m_lastPos;	// Tested in pre-process stage, and used to calc m_blendViewOffset. cleared at this point

//Vec3 blendViewOffset;
//uint8 stats_viewID;		// Used to trigger view blending in the output stage based on changes in the view method (FP, ThirdP, Vehicle)
		// Only used by the player view system.
//uint8 stats_viewIDLast;
		Vec3 stats_HUDPos;		// Ouput only in Post-Process
		Matrix33 viewMtxFinal;	// ProcessRotation: m_viewMtxFinal = m_viewMtx * Matrix33::CreateRotationXYZ(m_viewAnglesOffset);
		Matrix33 viewMtx;
		Matrix33 baseMtx;				// Output IF: in vehicle or following the character head (ViewFollowCharacterFirstPerson)
//Quat blendViewRotOffset;
		Ang3 stats_FPWeaponAngles;
		Vec3 stats_FPWeaponPos;
		Ang3 stats_FPSecWeaponAngles;
		Vec3 stats_FPSecWeaponPos;
		//SViewShake viewShake;
		Vec3 eyeOffset;
		float stats_bobCycle;
		float stats_smoothViewZ;
		uint8 stats_smoothZType;

		Ang3 vFPWeaponAngleOffset;
		Vec3 vFPWeaponLastDirVec;
		Vec3 vFPWeaponOffset;
		Vec3 bobOffset;
		Ang3 angleOffset;
		Ang3 viewAngleOffset;
		bool stats_landed;
		bool stats_jumped;

		//---------------------------
		Matrix33 camViewMtxFinal;	// output
		Quat rotRef;							// temp
		Quat rotDesired;					// temp
		Vec3 posDesired;					// temp
		SCamState state;					// temp
	};

	SViewStateIn m_viewStateIn_private;	// only write-able from pre-process (Should move into a base class to enforce this)

	const SViewStateIn &m_in;
	SViewStateInOut m_io;

	void ViewFirstThirdSharedPre(SViewParams &viewParams);
	void ViewFirstThirdSharedPost(SViewParams &viewParams);
	void ViewThirdPerson(SViewParams &viewParams);
	void ViewFirstPerson(SViewParams &viewParams);
	void FirstPersonJump(SViewParams &viewParams,Vec3 &weaponOffset);
	void ViewVehicle(SViewParams &viewParams);
	void ViewFollowCharacterFirstPerson(SViewParams &viewParams);

//void ViewBlendPostProcess(CPlayerG4 &rPlayer,SViewParams &viewParams);
	void ViewExternalControlPostProcess(CPlayerG4 &rPlayer,SViewParams &viewParams);
	void FirstPersonWeaponPostProcess(CPlayerG4 &rPlayer,SViewParams &viewParams);
	void ViewShakePostProcess(CPlayerG4 &rPlayer,SViewParams &viewParams);
	void HudPostProcess(CPlayerG4 &rPlayer,SViewParams &viewParams);
	void HandsPostProcess(CPlayerG4 &rPlayer,SViewParams &viewParams);

	void ViewProcess(SViewParams &viewParams);
	void ViewPreProcess(const CPlayerG4 &rPlayer,SViewParams &viewParams,SViewStateIn & m_viewStateIn);
	void ViewPostProcess(CPlayerG4 &rPlayer,SViewParams &viewParams);

#if G4_VIEW
	void ViewThirdPersonDampedPre(const CPlayerG4 &rPlayer,SViewParams &viewParams,SViewStateIn & m_viewStateIn);
	void ViewThirdPersonDamped(SViewParams &viewParams);
#endif
};

#endif	// ifndef __G4PLAYERVIEW_H__
