/*************************************************************************
  Crytek Source File.
  Copyright (C), Crytek Studios, 2001-2004.
 -------------------------------------------------------------------------
  $Id$
  $DateTime$
  
 -------------------------------------------------------------------------
  History:
  - 7:10:2004   14:19 : Created by Mrcio Martins

*************************************************************************/
#include "StdAfx.h"
#include "ScriptBind_Actor.h"
#include "G4ScriptBind_Actor.h"
#include "Actor.h"
#include "FilmDirector.h"
#include "Game04.h"
#include "IMovementController.h"
#include "Item.h"


#include "Player.h"
#include "G4Player.h"
#include <IGameFramework.h>
#include <IVehicleSystem.h>
#include <IGameObject.h>
#include <IRenderAuxGeom.h>
#include <Cry_Geo.h>
#include <Cry_GeoDistance.h>
#include "VehicleSystem/VehicleSeat.h"

//------------------------------------------------------------------------
CScriptBind_ActorG4::CScriptBind_ActorG4(ISystem *pSystem) : CScriptBind_Actor(pSystem)
{
#undef SCRIPT_REG_CLASSNAME
#define SCRIPT_REG_CLASSNAME &CScriptBind_ActorG4::


  SCRIPT_REG_TEMPLFUNC(PlayerCameraCut,"pos");
	SCRIPT_REG_FUNC(EndPlayerCameraCut);
  SCRIPT_REG_TEMPLFUNC(DrawLine,"pos1,pos2");
  SCRIPT_REG_TEMPLFUNC(SetWeaponTargetDirLeft,"dir");  //SetWeaponTargetDir("pos,iHand"); would be too error prone for script.
  SCRIPT_REG_TEMPLFUNC(SetWeaponTargetDirRight,"dir");
  SCRIPT_REG_TEMPLFUNC(SetWeaponTargetDistLeft,"dist");  //SetWeaponTargetDir("pos,iHand"); would be too error prone for script.
  SCRIPT_REG_TEMPLFUNC(SetWeaponTargetDistRight,"dist");
  SCRIPT_REG_FUNC(GetWeaponTargetDirLeft);  //SetWeaponTargetDir("pos,iHand"); would be too error prone for script.
  SCRIPT_REG_FUNC(GetWeaponTargetDirRight);
  SCRIPT_REG_FUNC(GetWeaponTargetDistLeft);  //SetWeaponTargetDir("pos,iHand"); would be too error prone for script.
  SCRIPT_REG_FUNC(GetWeaponTargetDistRight);

  SCRIPT_REG_FUNC(GetCinematicDeathImpulse);
  SCRIPT_REG_TEMPLFUNC(CameraSetShot,"psShot");
  SCRIPT_REG_FUNC(CameraToggleMode);
  SCRIPT_REG_FUNC(CameraDumpShots);
  SCRIPT_REG_FUNC(Breakpoint);
	SCRIPT_REG_TEMPLFUNC(ProjectToScreen,"x,y,z");

	SCRIPT_REG_TEMPLFUNC(AttachToActor,"parentId,vOrigin,psBone");
	SCRIPT_REG_TEMPLFUNC(DetachFromEntity,"parentId");

	SCRIPT_REG_FUNC(GetHandWorldPosition);	
	SCRIPT_REG_FUNC(SetIKArmPosition);
}

//------------------------------------------------------------------------
CScriptBind_ActorG4::~CScriptBind_ActorG4()
{
}

//////////////////////////////////////////////////////////////////////////
int CScriptBind_ActorG4::GetHandWorldPosition(IFunctionHandler *pH)
{
	int nHand;
	if (!pH->GetParam(1,nHand)) 
		return pH->EndFunction();

	CActor *pActor = GetActor(pH);
	IEntity * pEntity = pActor->GetEntity();
	ICharacterInstance * pCharacter = pEntity->GetCharacter(0);
	if (!pCharacter)
		return pH->EndFunction();
	ISkeleton * pSkeleton = pCharacter->GetISkeleton();

	int bone = -1;
	if (nHand==1)
		bone=pActor->GetBoneID(BONE_LEFT_HAND);
	else
		bone=pActor->GetBoneID(BONE_RIGHT_HAND);

	if (bone<0)
	{
		GetISystem()->GetILog()->Log("BONE %d NOT FOUND",bone);
		return pH->EndFunction();
	}

	Vec3 posBone = pSkeleton->GetAbsJPositionByID(bone);
	Vec3 posBoneWorld = pEntity->GetSlotWorldTM(0) * posBone;
	return pH->EndFunction(Script::SetCachedVector( posBoneWorld , pH, 1 ));
}

//////////////////////////////////////////////////////////////////////////
int CScriptBind_ActorG4::SetIKArmPosition(IFunctionHandler *pH)
{
	Vec3 vGoal;
	if (!pH->GetParam(1, vGoal))
		return pH->EndFunction();

	int nArm;
	if (!pH->GetParam(2,nArm)) 
		return pH->EndFunction();

	CActor *pActor = GetActor(pH);
	pActor->SetIKArm(vGoal,nArm);

	return pH->EndFunction();
}


int CScriptBind_ActorG4::PlayerCinematicEvent(IFunctionHandler *pH)
{
  CActor *pActor = GetActor(pH);
  CFilmDirector *pDirector=g_pGame04->GetDirector();
  CFilmEvent ev;
  bool bValid=true;
  const char *psName;
  Vec3 vPos(0,0,0);
  ScriptHandle sh;

  int nParam=pH->GetParamCount();

  // Required:
  //  arg 1: string name of event
  // Optional:
  //  arg 2: pos
  //  arg 3: target 1
  //  arg 4: target 2
  //  arg 5: target 3
  //  arg 6: target 4

  switch(nParam)
  {
  default:  // quietly drop args after the first 6. (May later expand to allow more entity id's)
  case 6:
    if(pH->GetParam(6,sh)) ev.aIdActors[3]=sh.n;
  case 5:
    if(pH->GetParam(5,sh)) ev.aIdActors[2]=sh.n;
  case 4:
    if(pH->GetParam(4,sh)) ev.aIdActors[1]=sh.n;
  case 3:
    if(pH->GetParam(3,sh)) ev.aIdActors[0]=sh.n;
  case 2:
    if(pH->GetParam(2,vPos)) ev.vPos=vPos;
  case 1:
    if(svtString == pH->GetParamType(1))
    {
      pH->GetParam(1,psName);
      ev.type = CFilmEvent::NameToType(psName);
    }
    else
      bValid=false;
    break;
  case 0:
    bValid=false;
  }

  if(bValid)
  {
    pDirector->Event(ev);
  }

  return pH->EndFunction();
}

int CScriptBind_ActorG4::PlayerCameraCut(IFunctionHandler *pH,Vec3 vPos1)
{
  CActor *pActor = GetActor(pH);

  CFilmDirector *pDirector=g_pGame04->GetDirector();

  CFilmEvent ev;

  ev.type=eDeathCut;
  ev.priority=1000;
  ev.vPos=vPos1;
  ev.aIdActors[0]=pActor->GetEntityId();

  pDirector->Event(ev);

  return pH->EndFunction();

}

static float GetFallHeight(Vec3 vPos,Vec3 vBase,IEntity *pIgnore1=0,IEntity *pIgnore2=0)
{
  ray_hit rayHit;
  float hgt=0.0f;

  IPhysicalEntity *pI1=0,*pI2=0;

  if(pIgnore1) pI1=pIgnore1->GetPhysics();
  if(pIgnore2) pI2=pIgnore2->GetPhysics();

  // is there a clear line to the fall point?
  if(!GetISystem()->GetIPhysicalWorld()->RayWorldIntersection(vBase, vPos-vBase, 
    ent_terrain|ent_static,0, &rayHit, 1,pI1, pI2))
  {
    // How far down?
    if (GetISystem()->GetIPhysicalWorld()->RayWorldIntersection(vPos, Vec3(0,0,-40), 
      ent_terrain|ent_static,0, &rayHit, 1,pI1, pI2))
    {
      hgt=rayHit.dist;
    }
    else
      float hgt=40.0f;
  }
  else
  {
    hgt=0.0f;
  }

  return hgt;
}

int CScriptBind_ActorG4::GetCinematicDeathImpulse(IFunctionHandler *pH)
{
  CActor *pActor = GetActor(pH);
  Vec3 vTgt(0,0,0);

  if(pActor)
  {
    const float testDist=1.5f;
    float h,hMax=0.0f;
    IEntity *pEnt=pActor->GetEntity();
    Vec3 vPos=pEnt->GetPos();
    vPos.z+=0.4f;
    vTgt=vPos;
    Vec3 vTest;
    bool bHgt=false;
    bool bPlayer=false;
    CPlayerG4 *pActorPlayer=0;

    //if( pActor->IsPlayer())
    {
      pActorPlayer=static_cast<CPlayerG4*>(pActor);
    }

    //---- Cliff edge test. if they're near an edge, give them a shove!
    vTest=vPos-Vec3(testDist,0,0);
    h=GetFallHeight(vTest,vPos,pEnt);
    vTgt=vTest; hMax=h;

    vTest=vPos+Vec3(testDist,0,0);
    h=GetFallHeight(vTest,vPos,pEnt);
    if(h > hMax) { vTgt=vTest; hMax=h; }

    vTest=vPos-Vec3(0,testDist,0);
    h=GetFallHeight(vTest,vPos,pEnt);
    if(h > hMax) { vTgt=vTest; hMax=h; }

    vTest=vPos+Vec3(0,testDist,0);
    h=GetFallHeight(vTest,vPos,pEnt);
    if(h > hMax) { vTgt=vTest; hMax=h; }

    if(hMax>1.6f)
    {
      float scale=120.0f;
      vTgt.z+=1.2f*testDist; // lift up a little
      vTgt=(vTgt-vPos).GetNormalized()*scale;
      //IRenderAuxGeom* pRenderAuxGeom( GetISystem()->GetIRenderer()->GetIRenderAuxGeom() ); 
      //pRenderAuxGeom->SetRenderFlags( e_Def3DPublicRenderflags );
      //pRenderAuxGeom->DrawLine( vPos, ColorB(0,128,0,128), vPos+vTgt, ColorB(0,128,0,128) );
      bHgt=true;
      CryLogAlways("CinematicDeathImpulse: Detected potential fall of %0.3f metres",hMax);
    }
    else
    {
      vTgt=Vec3(0,0,0);
    }
    //---- Blast em out of players way - if close
    Vec3 vDirPlayer=pEnt->GetPos()-g_pGame04->GetClientPlayer()->GetEntity()->GetPos();
    float distPlayer=vDirPlayer.len();
    if(distPlayer<=4.0f)
    {
      vDirPlayer/=distPlayer;
      Vec3 vPlayImpulse=((rand()%10)+91)/100.0f*(4-distPlayer)*vDirPlayer*20;
      float theta=((rand()%11)-5)*1.0f*gf_PI/180; // +/- 5 degrees
      Quat qRot=Quat::CreateRotationZ(theta);
      if(bHgt)
      {
        vTgt+=qRot*vPlayImpulse*0.125f;
        CryLogAlways("CinematicDeathImpulse: also blasting a little out of players way");
      }
      else
      {
        vTgt=qRot*vPlayImpulse;
        CryLogAlways("CinematicDeathImpulse: Close to player, blasting out of way");
      }
    }

    if(!bHgt && pActorPlayer) // && !bPlayImpulse
    {
      float pct=(rand()%101);
      if(pct>=0)
      {
        CryLogAlways("CinematicDeath: Shoot object");
        pActorPlayer->CinematicDeathAct("ShootObject");
      }
    }

  }
  return pH->EndFunction(Script::SetCachedVector( vTgt, pH, 1 ));
}

int CScriptBind_ActorG4::EndPlayerCameraCut(IFunctionHandler *pH)
{
//  m_pPlayer->EndPlayerCameraCut();
#if 0
  CFilmDirector *pDirector=g_pGame04->GetDirector();

  CFilmEvent ev;

  ev.type=eEndDeathCut;
  ev.priority=1000;

  pDirector->Event(ev);
#endif
  return pH->EndFunction();

}

extern bool bCamDebugDraw;
int CScriptBind_ActorG4::DrawLine(IFunctionHandler *pH, Vec3 pos1, Vec3 pos2)
{
  if(bCamDebugDraw || GetISystem()->GetIConsole()->GetCVar("cl_cam_debug")->GetIVal())
  {
    CActor *pActor = GetActor(pH);
    const static ColorB color( 255, 0, 0, 128 );  
    //static primitives::box box;
    IRenderAuxGeom* pRenderAuxGeom( m_pSystem->GetIRenderer()->GetIRenderAuxGeom() ); 
    pRenderAuxGeom->SetRenderFlags( e_Def3DPublicRenderflags );
    pRenderAuxGeom->DrawLine( pos1, color, pos2, color );

    //m_pSystem->GetIRenderer()->TextToScreen(0,0,"0..Testing..0");
    //m_pSystem->GetIRenderer()->TextToScreen(128,128,"1..Testing..1");
  }
  return pH->EndFunction();
}

int CScriptBind_ActorG4::SetWeaponTargetDirLeft(IFunctionHandler *pH, Vec3 dir)  //SetWeaponTargetDir("pos,iHand"); would be too error prone for script.
{
  CActor *pActor = GetActor(pH);

  if( pActor ) //&& pActor->IsPlayer())
  {
    static_cast<CPlayerG4*>(pActor)->SetWeaponTargetDir(dir,0);
  }

  return pH->EndFunction();
}

int CScriptBind_ActorG4::SetWeaponTargetDirRight(IFunctionHandler *pH, Vec3 dir)  //SetWeaponTargetDir("pos,iHand"); would be too error prone for script.
{
  CActor *pActor = GetActor(pH);

  if( pActor ) //&& pActor->IsPlayer())
  {
    static_cast<CPlayerG4*>(pActor)->SetWeaponTargetDir(dir,1);
  }

  return pH->EndFunction();
}
int CScriptBind_ActorG4::SetWeaponTargetDistLeft(IFunctionHandler *pH, float dist)  //SetWeaponTargetDir("pos,iHand"); would be too error prone for script.
{
  CActor *pActor = GetActor(pH);

  if( pActor ) //&& pActor->IsPlayer())
  {
    static_cast<CPlayerG4*>(pActor)->SetWeaponTargetDist(dist,0);
  }

  return pH->EndFunction();
}

int CScriptBind_ActorG4::SetWeaponTargetDistRight(IFunctionHandler *pH, float dist)  //SetWeaponTargetDir("pos,iHand"); would be too error prone for script.
{
  CActor *pActor = GetActor(pH);

  if( pActor ) //&& pActor->IsPlayer())
  {
    static_cast<CPlayerG4*>(pActor)->SetWeaponTargetDist(dist,1);
  }

  return pH->EndFunction();
}

int CScriptBind_ActorG4::GetWeaponTargetDirLeft(IFunctionHandler *pH)  //SetWeaponTargetDir("pos,iHand"); would be too error prone for script.
{
  CActor *pActor = GetActor(pH);

  //FIXME:dir is not used
  //	Vec3 dir(0,0,0);
  //	Vec3 pos(0,0,0);
  //	pActor->GetActorInfo(pos,dir);
  Vec3 v(0,1,0);

  if(pActor ) //&& pActor->IsPlayer())
    v=static_cast<CPlayerG4*>(pActor)->GetWeaponTargetDir(0);

  return pH->EndFunction(Script::SetCachedVector( v, pH, 1 ));
}

int CScriptBind_ActorG4::GetWeaponTargetDirRight(IFunctionHandler *pH)  //SetWeaponTargetDir("pos,iHand"); would be too error prone for script.
{
  CActor *pActor = GetActor(pH);

  //FIXME:dir is not used
  //	Vec3 dir(0,0,0);
  //	Vec3 pos(0,0,0);
  //	pActor->GetActorInfo(pos,dir);
  Vec3 v(0,1,0);

  if(pActor) // && pActor->IsPlayer())
    v=static_cast<CPlayerG4*>(pActor)->GetWeaponTargetDir(1);

  {
//    const char *psFunc,*psFile;
//    int iLine;
    //SmartScriptTable stack(GetIScriptSystem()->GetCallsStack());
    //SmartScriptTable frame0;(GetIScriptSystem()->GetCallsStack());
    //stack.GetPtr()->GetValue("description",psFunc);
    //stack.GetPtr()->GetValue("sourcefile",psFile);
    //CryLogAlways("File:%s
    //pH->GetIScriptSystem()->EnableDebugger(true);
    //pH->GetIScriptSystem()->DebugStepInto();
  }
  return pH->EndFunction(Script::SetCachedVector( v, pH, 1 ));
}

int CScriptBind_ActorG4::GetWeaponTargetDistLeft(IFunctionHandler *pH)
{
  CActor *pActor = GetActor(pH);

  if(pActor) // && pActor->IsPlayer())
    pH->EndFunction(static_cast<CPlayerG4*>(pActor)->GetWeaponTargetDist(0));

  return pH->EndFunction();
}

int CScriptBind_ActorG4::GetWeaponTargetDistRight(IFunctionHandler *pH)
{
  CActor *pActor = GetActor(pH);

  if(pActor) // && pActor->IsPlayer())
    pH->EndFunction(static_cast<CPlayerG4*>(pActor)->GetWeaponTargetDist(1));

  return pH->EndFunction();
}

int CScriptBind_ActorG4::CameraSetShot(IFunctionHandler *pH,const char *psShot)
{
  CActor *pActor = GetActor(pH);

  g_pGame04->GetDirector()->SetShot(psShot);

  return pH->EndFunction();
}

int CScriptBind_ActorG4::CameraDumpShots(IFunctionHandler *pH)
{
  g_pGame04->GetDirector()->DumpShots();

  return pH->EndFunction();
}

int CScriptBind_ActorG4::CameraToggleMode(IFunctionHandler *pH)
{
  g_pGame04->GetClientPlayer()->OnAction("editcam_hold",eAAM_OnPress,1.0f);

  return pH->EndFunction();
}

static bool bEnableBreakpoint=true;
int CScriptBind_ActorG4::Breakpoint(IFunctionHandler *pH)
{
	CActor *pActor = GetActor(pH);

	// See the c++ callstack for a lua func.
	if(bEnableBreakpoint)
		DEBUG_BREAK;

	return pH->EndFunction();
}

int CScriptBind_ActorG4::ProjectToScreen(IFunctionHandler *pH,float x,float y,float z)
{
	Vec3 v;
	IRenderer *pRenderer = GetISystem()->GetIRenderer();

	v.x=v.y=v.z=0;
	pRenderer->ProjectToScreen(x,y,z,&v.x,&v.y,&v.z);

	// Scale for our virtual 800x600 display
	v.x*=8;
	v.y*=6;

	return pH->EndFunction(Script::SetCachedVector( v, pH, 1 ));
}

int CScriptBind_ActorG4::AttachToActor(IFunctionHandler *pH,ScriptHandle parentId,Vec3 vOrigin,const char *psBone)
{
#if 0
		CActor *pActor = GetActor(pH);
		CPlayerG4 *pActorPlayer=static_cast<CPlayerG4*>(pActor);

		IPhysicalEntity *pPhysEnt = pActorPlayer->GetEntity()->GetPhysics();
		pe_player_dynamics pD;
		pD.bActive = false;

		pActorPlayer->m_modelOffset.Set(vOrigin.x,vOrigin.y,vOrigin.z);
		pActorPlayer->m_charLocalMtx.SetTranslation(pActorPlayer->m_modelOffset);
		pActorPlayer->GetEntity()->SetSlotLocalTM(0,pActorPlayer->m_charLocalMtx);

		//ResetAnimations();

		pe_action_move actionMove;
		actionMove.dir = Vec3(0,0,0);
		pPhysEnt->Action(&actionMove);
#endif
		return pH->EndFunction();
}

int CScriptBind_ActorG4::DetachFromEntity(IFunctionHandler *pH,ScriptHandle parentId)
{
		CActor *pActor = GetActor(pH);
		CPlayerG4 *pActorPlayer=static_cast<CPlayerG4*>(pActor);

		return pH->EndFunction();
}
