/*************************************************************************
  Crytek Source File.
  Copyright (C), Crytek Studios, 2001-2004.
 -------------------------------------------------------------------------
  $Id$
  $DateTime$
  Description: Exposes actor functionality to LUA
  
 -------------------------------------------------------------------------
  History:
  - 7:10:2004   14:19 : Created by Mrcio Martins

*************************************************************************/
#ifndef __SCRIPTBIND_ACTORG4_H__
#define __SCRIPTBIND_ACTORG4_H__

#if _MSC_VER > 1000
# pragma once
#endif


#include <IScriptSystem.h>
#include <ScriptHelpers.h>
#include "Actor.h"

class CActor;

// <title Actor>
// Syntax: Actor
class CScriptBind_ActorG4 :
	public CScriptBind_Actor
{
public:
	CScriptBind_ActorG4(ISystem *pSystem);
	virtual ~CScriptBind_ActorG4();

  // PlayerCinematicEvent(event_name,pos,idTarg1,idTarg2,idTarg3,idTarg4)
  //    event_name: string name of the event eg: "eDeathCut","eExplosion" (see FilmDirector for event names)
  // Optional Args:
  //    pos: a position vector
  //    idTarg1,2,3,4: entity id's
  virtual int PlayerCinematicEvent(IFunctionHandler *pH);
  virtual int GetCinematicDeathImpulse(IFunctionHandler *pH);

  virtual int PlayerCameraCut(IFunctionHandler *pH, Vec3 pos);
  virtual int EndPlayerCameraCut(IFunctionHandler *pH);
  virtual int DrawLine(IFunctionHandler *pH, Vec3 pos1, Vec3 pos2);

  virtual int SetWeaponTargetDirLeft(IFunctionHandler *pH, Vec3 dir);
  virtual int SetWeaponTargetDirRight(IFunctionHandler *pH, Vec3 dir);
  virtual int SetWeaponTargetDistLeft(IFunctionHandler *pH, float dist);
  virtual int SetWeaponTargetDistRight(IFunctionHandler *pH, float dist);

  virtual int GetWeaponTargetDirLeft(IFunctionHandler *pH);
  virtual int GetWeaponTargetDirRight(IFunctionHandler *pH);
  virtual int GetWeaponTargetDistLeft(IFunctionHandler *pH);
  virtual int GetWeaponTargetDistRight(IFunctionHandler *pH);

  virtual int CameraSetShot(IFunctionHandler *pH,const char *psShot);
  virtual int CameraDumpShots(IFunctionHandler *pH);
  virtual int CameraToggleMode(IFunctionHandler *pH);

  virtual int GetHandWorldPosition(IFunctionHandler *pH);  
  virtual int SetIKArmPosition(IFunctionHandler *pH);  

  virtual int Breakpoint(IFunctionHandler *pH);

	virtual int ProjectToScreen(IFunctionHandler *pH,float x,float y,float z);

	virtual int AttachToActor(IFunctionHandler *pH,ScriptHandle parentId,Vec3 vOrigin,const char *psBone);
	virtual int DetachFromEntity(IFunctionHandler *pH,ScriptHandle parentId);



protected:

};

#endif //__SCRIPTBIND_ACTORG4_H__
