/*************************************************************************
  Crytek Source File.
  Copyright (C), Crytek Studios, 2001-2004.
 -------------------------------------------------------------------------
  $Id$
  $DateTime$
  
 -------------------------------------------------------------------------
  History:
  - 3:8:2004   11:26 : Created by Mrcio Martins
  - 17:8:2005        : Modified - NickH: Factory registration moved to GameFactory.cpp

*************************************************************************/
#include "StdAfx.h"
#include "Game.h"
#include "GameActions.h"
//#include "Spectator.h"
#include "Player.h"
//aliens
#include "Alien.h"
#include "Scout.h"
#include "Hunter.h"
#include "Trooper.h"
#include "Observer.h"
//
#include "Item.h"
#include "Weapon.h"

#include "GameRules.h"

#include "VehicleMovementStdWheeled.h"
#include "VehicleMovementVTOL.h"
#include "VehicleMovementHovercraft.h"
#include "VehicleMovementHelicopter.h"
#include "VehicleMovementParachute.h"
#include "VehicleMovementStdBoat.h"
#include "VehicleMovementTank.h"

#include "WeaponSystem.h"

#include <IActionMapManager.h>
#include <IViewSystem.h>
#include <ILevelSystem.h>
#include <IItemSystem.h>
#include <IVehicleSystem.h>
#include <IGameTokens.h>

#include "ScriptBind_Actor.h"
#include "ScriptBind_Item.h"
#include "ScriptBind_Weapon.h"
#include "ScriptBind_GameRules.h"
#include "HUD/ScriptBind_HUD.h"

#include "GameFactory.h"

#include "Nodes/G2FlowBaseNode.h"

//FIXME: really horrible. Remove ASAP
int OnImpulse( const EventPhys *pEvent ) 
{ 
	//return 1;
	return 0;
}
//

// Needed for the Game02 specific flow node
CG2AutoRegFlowNodeBase *CG2AutoRegFlowNodeBase::m_pFirst=0;
CG2AutoRegFlowNodeBase *CG2AutoRegFlowNodeBase::m_pLast=0;

CGame *g_pGame = 0;


CGame::CGame()
: m_pFramework(0),
	m_pConsole(0),
	m_pWeaponSystem(0),
	m_pScriptBindActor(),
	m_pGameActions(new SGameActions())
{
	g_pGame = this;
	GetISystem()->SetIGame( this );
}

CGame::~CGame()
{
	m_pFramework->EndGameContext();
	ReleaseScriptBinds();
	ReleaseActionMaps();
	m_pWeaponSystem->Release();
	g_pGame = 0;
}

bool CGame::Init(IGameFramework *pFramework)
{
	m_pFramework = pFramework;
	assert(m_pFramework);

	m_pConsole = GetISystem()->GetIConsole();

	RegisterConsoleVars();
	RegisterConsoleCommands();

	InitActionMaps();
	InitScriptBinds();
	InitGameTokens();

  // Register all the games factory classes e.g. maps "Player" to CPlayer
  InitGameFactory(m_pFramework);

	//FIXME: horrible, remove this ASAP
	m_pFramework->GetISystem()->GetIPhysicalWorld()->AddEventClient( EventPhysImpulse::id,OnImpulse,0 );  

	m_pWeaponSystem = new CWeaponSystem(this, GetISystem());
	m_pWeaponSystem->Init();

	string itemFolder = "scripts/entities/items/xml";
	pFramework->GetIItemSystem()->Scan(itemFolder.c_str());
	m_pWeaponSystem->Scan(itemFolder.c_str());

  // submit water material to physics
  //IMaterialManager* pMatMan = GetISystem()->GetI3DEngine()->GetMaterialManager();    
  //GetISystem()->GetIPhysicalWorld()->SetWaterMat( pMatMan->GetSurfaceTypeByName("mat_water")->GetId() );
  
	m_pFramework->GetISystem()->GetIConsole()->CreateKeyBind("f12", "\\r_getscreenshot 1");
	m_pFramework->GetISystem()->GetIConsole()->CreateKeyBind("xi_start", "\\map player_zoo");

	return true;
}

bool CGame::CompleteInit()
{
	// Initialize Game02 flow nodes

	if (IFlowSystem *pFlow = m_pFramework->GetIFlowSystem())
	{
		CG2AutoRegFlowNodeBase *pFactory = CG2AutoRegFlowNodeBase::m_pFirst;

		while (pFactory)
		{
			pFlow->RegisterType( pFactory->m_sClassName,pFactory );
			pFactory = pFactory->m_pNext;
		}
	}

	return true;
}

int CGame::Update(bool haveFocus, unsigned int updateFlags)
{
	bool bRun = m_pFramework->PreUpdate( true, updateFlags );

	m_pWeaponSystem->Update(GetISystem()->GetITimer()->GetFrameTime());

	m_pFramework->PostUpdate( true, updateFlags );

	return bRun ? 1 : 0;
}

void CGame::Shutdown()
{
	delete this;
}

const char *CGame::GetLongName()
{
	return "FP";
}

const char *CGame::GetName()
{
	return "fp";
}

CGameRules *CGame::GetGameRules() const
{
	return static_cast<CGameRules *>(m_pFramework->GetIGameRulesSystem()->GetCurrentGameRules());;
}

void CGame::InitActionMaps()
{
	IActionMapManager *pActionMapMan = m_pFramework->GetIActionMapManager();

	// make sure that they are also added to the GameActions.actions file!
	XmlNodeRef rootNode = m_pFramework->GetISystem()->LoadXmlFile("libs/config/defaultProfile.xml");
	pActionMapMan->LoadFromXML(rootNode);
	m_pDefaultAM = pActionMapMan->GetActionMap("default");
	m_pNoMoveAF = pActionMapMan->GetActionFilter("no_move");
	m_pNoMouseAF = pActionMapMan->GetActionFilter("no_mouse");

	// enable defaults
	pActionMapMan->EnableActionMap("default",true);
}

void CGame::ReleaseActionMaps()
{
	SAFE_RELEASE(m_pDefaultAM);
	SAFE_RELEASE(m_pNoMoveAF);
	SAFE_RELEASE(m_pNoMouseAF);
	SAFE_DELETE(m_pGameActions);
}

void CGame::InitScriptBinds()
{
	m_pScriptBindActor = new CScriptBind_Actor(m_pFramework->GetISystem());
	m_pScriptBindItem = new CScriptBind_Item(m_pFramework->GetISystem(), m_pFramework);
	m_pScriptBindWeapon = new CScriptBind_Weapon(m_pFramework->GetISystem(), m_pFramework);
	m_pScriptBindHUD = new CScriptBind_HUD(m_pFramework->GetISystem(), m_pFramework);
	m_pScriptBindGameRules = new CScriptBind_GameRules(m_pFramework->GetISystem(), m_pFramework);
}

void CGame::ReleaseScriptBinds()
{
	SAFE_DELETE(m_pScriptBindActor);
	SAFE_DELETE(m_pScriptBindItem);
	SAFE_DELETE(m_pScriptBindWeapon);
	SAFE_DELETE(m_pScriptBindHUD);
	SAFE_DELETE(m_pScriptBindGameRules);
}

void CGame::InitGameTokens()
{
	// save pointer to GameTokenSystem
	m_pGameTokenSystem = m_pFramework->GetIGameTokenSystem();
	// TFlowInputData (value, locked)
	// value must be of correct type (bool, int, float, string) and locked==true means it will always
	// holds values of the assigned type (it's a LOCKED variant)
	IGameToken* token = 0;
	// 'HUD' is the library name, 'Nanosuit' is the group, 'Strength' is the token
	token = m_pGameTokenSystem->SetOrCreateToken("HUD.Nanosuit.Strength", TFlowInputData((float)100.0f, true));
	// or
	// 'Game' is the library name, 'HUD' is the group, 'Nanosuit.Strength' is the token
	// token = m_pGameTokenSystem->SetOrCreateToken("HUD.Nanosuit.Strength", TFlowInputData((float)100.0f, true));

	// string val;
	// bool ok =m_pGameTokenSystem->GetTokenValueAs("HUD.Nanosuit.Strength", val);
}
