/*************************************************************************
  Crytek Source File.
  Copyright (C), Crytek Studios, 2001-2004.
 -------------------------------------------------------------------------
  $Id$
  $DateTime$
  Description: 
  
 -------------------------------------------------------------------------
  History:
  - 3:8:2004   11:23 : Created by Mrcio Martins

*************************************************************************/
#ifndef __GAME_H__
#define __GAME_H__

#if _MSC_VER > 1000
# pragma once
#endif

#include <IGame.h>
#include <IGameFramework.h>


#define GAME_NAME				"FP"
#define GAME_LONGNAME		"F.P."


struct ISystem;
struct IConsole;

class	CScriptBind_Actor;
class CScriptBind_Item;
class CScriptBind_Weapon;
class CScriptBind_GameRules;
class CWeaponSystem;
class CScriptBind_HUD;

struct IActionMap;
struct IActionFilter;
struct SGameActions;
struct IGameTokenSystem;
class CGameRules;

struct SCVars
{
	//ICVar *g_aimdebug;
	ICVar *cl_fov;
	ICVar *cl_bob;
	ICVar *cl_tpvDist;
	ICVar *cl_tpvYaw;
	ICVar *cl_nearPlane;
	ICVar *cl_sprintShake;
	ICVar *cl_sensitivityZeroG;
	ICVar *cl_sensitivity;
	ICVar *cl_invertMouse;
	ICVar *cl_lookTargetName;
	ICVar *pl_inputAccel;

	//
	SCVars()
	{
		memset(this,0,sizeof(SCVars));
	}

	void InitCVars(IConsole *pConsole);
};

class CGame :
	public IGame
{
public:
	CGame();
	virtual ~CGame();

	// IGame
	virtual bool Init(IGameFramework *pFramework);
	virtual bool CompleteInit();
	virtual void Shutdown();
	virtual int Update(bool haveFocus, unsigned int updateFlags);

	virtual IGameFramework *GetIGameFramework() { return m_pFramework; }

	virtual const char *GetLongName();
	virtual const char *GetName();
	// ~IGame

	virtual CScriptBind_Actor *GetActorScriptBind() { return m_pScriptBindActor; }
	virtual CScriptBind_Item *GetItemScriptBind() { return m_pScriptBindItem; }
	virtual CScriptBind_Weapon *GetWeaponScriptBind() { return m_pScriptBindWeapon; }
	virtual CScriptBind_GameRules *GetGameRulesScriptBind()
	{ 
		return m_pScriptBindGameRules;
	}
	virtual CScriptBind_HUD *GetHUDScriptBind() { return m_pScriptBindHUD; }
	virtual CWeaponSystem *GetWeaponSystem() { return m_pWeaponSystem; };
	SGameActions&	Actions() const {	return *m_pGameActions;	};

	CGameRules *GetGameRules() const;

	ILINE SCVars *GetCVars() {return &m_CVars;}

protected:
	virtual void InitActionMaps();
	virtual void ReleaseActionMaps();

	virtual void InitScriptBinds();
	virtual void ReleaseScriptBinds();

  // These funcs live in GameCVars.cpp
	virtual void RegisterConsoleVars();
	virtual void RegisterConsoleCommands();

	virtual void InitGameTokens();

	static void CmdName(IConsoleCmdArgs *pArgs);

	IGameFramework			*m_pFramework;
	IConsole						*m_pConsole;

	CWeaponSystem				*m_pWeaponSystem;

	// script binds
	CScriptBind_Actor		*m_pScriptBindActor;
	CScriptBind_Item		*m_pScriptBindItem;
	CScriptBind_Weapon	*m_pScriptBindWeapon;
	CScriptBind_GameRules*m_pScriptBindGameRules;
	CScriptBind_HUD     *m_pScriptBindHUD;

	IActionMap					*m_pDefaultAM;
	IActionFilter				*m_pNoMoveAF;
	IActionFilter				*m_pNoMouseAF;
	SGameActions				*m_pGameActions;	
	IGameTokenSystem		*m_pGameTokenSystem;

	SCVars m_CVars;
};

extern CGame *g_pGame;

#endif //__GAME_H__
