/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2005.
-------------------------------------------------------------------------
$Id$
$DateTime$
Description: Organisational class for Game04.

-------------------------------------------------------------------------
History:
- 6:7:2005   : Created by Nick Hesketh

*************************************************************************/

/*
  CGame04:
    Separates most game specific code out from the CGame class for ease of integration.
    Any Game04 systems should be able to locate each other through here.
    Any Game04 non-entity systems needing a regular update tick should be called from here.
    Game wide data can be stored/accessed via CGame04.
*/

#include "StdAfx.h"

#include "Game04.h"

#include "FilmDirector.h"
#include "Game.h"
#include "Player.h"
#include "G4Player.h"

CGame04 *g_pGame04=0;

void CGame04::OnEditorSetGameMode(bool bGameMode)
{
  if(m_pDirector)
    m_pDirector->OnEditorSetGameMode(bGameMode);

  if(bGameMode)
  {
    CPlayerG4 *pPlayer=FindClientPlayer();

    if(pPlayer)
    {
			pPlayer->EditorToGameMode();
      //if(!pPlayer->IsThirdPerson())
      //  pPlayer->ToggleThirdPerson();
    }
  }
}
// Any Game04 non-entity systems needing a regular update tick should be called from here.
void CGame04::UpdateTick(float frameTime)
{
  if(m_bInit)
  {
    if(m_pDirector)
    {
      m_pDirector->Update(frameTime);
    }
  }
}

CGame04::CGame04(CGame *pGame)
{
  g_pGame04=this;
  m_bInit=false;

  m_pGame=pGame;
  m_pFramework=0;
  m_pPlayer=0;

  m_pDirector=new CFilmDirector(pGame);
}

CGame04::~CGame04()
{
  if(m_bInit)
    DeInit();
  delete m_pDirector;

  g_pGame04=0;
}

void CGame04::Init()
{
  if(!m_bInit)
  {
    m_bInit=true;
  }
  else
  {
    // Log double init error here.
  }
  m_pFramework=m_pGame->GetIGameFramework();
}

void CGame04::DeInit()
{
  if(m_bInit)
  {
    m_bInit=false;
    m_pPlayer=0;
  }
  else
  {
    // Log not init'd error here.
  }
}

CPlayerG4 *CGame04::FindClientPlayer()
{
  //IActorProxy *pActorProxy;
  IActor *pActor=0;
  CPlayerG4 *pPlayer=0;

  m_pFramework=m_pGame->GetIGameFramework();
  if(m_pFramework)
  {
      pActor=m_pFramework->GetClientActor();
  }
  
  if(pActor)
    pPlayer=(CPlayerG4*)pActor;

  return pPlayer;
}
