/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2005.
-------------------------------------------------------------------------
$Id$
$DateTime$
Description: Organisational class for Game04.

-------------------------------------------------------------------------
History:
- 6:7:2005   : Created by Nick Hesketh

*************************************************************************/

/*
  CGame04:
    Separates most game specific code out from the CGame class for ease of integration.
    Any Game04 systems should be able to locate each other through here.
    Any Game04 non-entity systems needing a regular update tick should be called from here.
    Game wide data can be stored/accessed via CGame04.
*/

#pragma once

class CFilmDirector;
class CGame;
class CPlayer;
class CPlayerG4;
struct IGameFramework;

class CGame04
{
public:
  CGame04(CGame *pGame);
  ~CGame04();

  void Init();
  void DeInit();

  void UpdateTick(float frameTime);

  CPlayerG4 *GetClientPlayer()
  {
    //if(!m_pPlayer)  // Need to hook into level loading / player destruction/construction before this can be cached..
      m_pPlayer=FindClientPlayer();
    return m_pPlayer;
  }

  CFilmDirector *GetDirector() { return m_pDirector; }

  void OnEditorSetGameMode(bool bGameMode);

private:
  bool m_bInit;
  CGame *m_pGame;
  IGameFramework *m_pFramework;
  CFilmDirector *m_pDirector;
  CPlayerG4 *m_pPlayer;

  CPlayerG4 *FindClientPlayer();
};

extern CGame04 *g_pGame04;
