/*************************************************************************
  Crytek Source File.
  Copyright (C), Crytek Studios, 2001-2004.
 -------------------------------------------------------------------------
  $Id$
  $DateTime$
  
 -------------------------------------------------------------------------
  History:
  - 11:8:2004   10:50 : Created by Mrcio Martins

*************************************************************************/
#include "StdAfx.h"
#include "Game.h"
#include "INetwork.h"
#include "IGameObject.h"
#include "IActorSystem.h"
#include "GameRules.h"


static void BroadcastChangeSafeMode( ICVar * )
{
	SGameObjectEvent event("ResetMovementController", eGOEF_ToExtensions);
	IEntitySystem * pES = GetISystem()->GetIEntitySystem();
	IEntityItPtr pIt = pES->GetEntityIterator();
	while (!pIt->IsEnd())
	{
		if (IEntity * pEnt = pIt->Next())
			if (IActor * pActor = g_pGame->GetIGameFramework()->GetIActorSystem()->GetActor(pEnt->GetId()))
				pActor->HandleEvent( event );
	}
}

// game related cvars must start with an g_
// game server related cvars must start with sv_
// game client related cvars must start with cl_
// no other types of cvars are allowed to be defined here!
void SCVars::InitCVars(IConsole *pConsole)
{
	pConsole->RegisterString("cl_serveraddr", 
		"localhost", 
		VF_DUMPTODISK, "Server address");
	pConsole->RegisterInt("cl_serverport", 
		SERVER_DEFAULT_PORT, 
		VF_DUMPTODISK, "Server address");
	pConsole->RegisterString("sv_map", 
		"levels\\testy", 
		VF_DUMPTODISK, "The map the server should load", NULL);
	pConsole->RegisterString("sv_gamerules",
		"SinglePlayer",
		VF_DUMPTODISK, "The game rules that the server should use", NULL);
	pConsole->RegisterInt("sv_port", 
		SERVER_DEFAULT_PORT, 
		VF_DUMPTODISK, "Server address");
	pConsole->RegisterInt("i_staticfiresounds",
		1,
		VF_DUMPTODISK, "Enable/Disable static fire sounds. Static sounds are not unloaded when idle.");
	pConsole->RegisterInt("i_lighteffects",
		1,
		VF_DUMPTODISK, "Enable/Disable lights spawned during item effects.");
	pConsole->RegisterInt("i_particleeffects",
		1,
		VF_DUMPTODISK, "Enable/Disable particles spawned during item effects.");

	//client cvars
	cl_sensitivity = pConsole->RegisterFloat("cl_sensitivity", 10.0f, VF_DUMPTODISK, "Set mouse sensitivity!");
	cl_sensitivityZeroG = pConsole->RegisterFloat("cl_sensitivityZeroG", 22.5f, VF_DUMPTODISK, "Set mouse sensitivity in ZeroG!");
	cl_invertMouse = pConsole->RegisterInt("cl_invertMouse", 0, VF_DUMPTODISK, "mouse invert?");

	cl_lookTargetName = pConsole->RegisterString("cl_lookTargetName", "",VF_CHEAT,"A debug CVar. name of an entity we want the player to look at");

	//FIXME:just for testing
	pConsole->RegisterFloat("cl_strengthscale", 1.0f, 0, "nanosuit strength scale");

	cl_tpvDist = pConsole->RegisterFloat("cl_tpvDist", 3.5f, 0, "camera distance in 3rd person view");
	cl_tpvYaw = pConsole->RegisterFloat("cl_tpvYaw", 0, 0, "camera angle offset in 3rd person view");
	cl_bob = pConsole->RegisterFloat("cl_bob", 0.0f, 0, "view bobbing");
	cl_sprintShake = pConsole->RegisterFloat("cl_sprintShake", 0.0f, 0, "sprint shake");


	pConsole->RegisterFloat("cl_motionBlur", 2, 0, "motion blur type (0=off, 1=accumulation-based, 2=velocity-based)");
	pConsole->RegisterFloat("cl_sprintBlur", 0.6f, 0, "sprint blur");
	pConsole->RegisterFloat("cl_hitShake", 1.25f, 0, "hit shake");
	pConsole->RegisterFloat("cl_hitBlur", 0.25f, 0, "blur on hit");

	cl_fov = pConsole->RegisterFloat("cl_fov", 60, 0, "field of view.");
	cl_nearPlane = pConsole->RegisterFloat("cl_nearPlane", 0, 0, "overrides the near clipping plane if != 0, just for testing.");

	pConsole->RegisterInt("cl_righthand", 1, 0, "Select right-handed weapon!");
	pConsole->RegisterInt("cl_screeneffects", 1, 0, "Enable player screen effects (depth-of-field, motion blur, ...).");
	pConsole->RegisterInt("cl_fpBody", 2, 0, "first person body");
	pConsole->RegisterInt("cl_actordebug", 0, 0, "enable actor debugging");
	pConsole->RegisterInt("g_grabMode", 0, 0, "how to grab objects");
  pConsole->RegisterInt("g_grabLog", 0, 0, "verbosity for grab logging (0-2)");

	pl_inputAccel = pConsole->RegisterFloat("pl_inputAccel", 30.0f, 0, "Movement input acceleration");

	pConsole->RegisterFloat("cl_nanoSuitInfo", 1, VF_DUMPTODISK, "Show NanoSuit informations");
	pConsole->RegisterInt("cl_actorsafemode", 0, VF_CHEAT, "Enable/disable actor safe mode", BroadcastChangeSafeMode);
	pConsole->RegisterInt("g_hunterIK", 1, 0, "Hunter uses always IK");
	pConsole->RegisterFloat("i_offset_front", 0.0f, 0, "Item position front offset");
	pConsole->RegisterFloat("i_offset_up", -0.075f, 0, "Item position up offset");
	pConsole->RegisterFloat("i_offset_right", 0.0f, 0, "Item position right offset");
	pConsole->RegisterFloat("i_unlimitedammo", 0, VF_CHEAT, "unlimited ammo");
  pConsole->RegisterInt("g_useMatDecals", 1, VF_DUMPTODISK, "Enable usage of MatDecals");
  pConsole->RegisterInt("g_logDecals", 0, 0, "Output log message on decal creation call");
	pConsole->RegisterFloat("g_tentacle_joint_limit", -1.0f, 0, "forces specific tentacle limits; used for tweaking");
	//
	pConsole->RegisterFloat("int_ZoomAmount", 0.75f, VF_CHEAT, "Maximum zoom, between 0.0 and 1.0. Default = .75");
	pConsole->RegisterFloat("int_ZoomInTime", 5.0f, VF_CHEAT, "Number of seconds it takes to zoom in. Default = 5.0");
	pConsole->RegisterFloat("int_MoveZoomTime", 0.1f, VF_CHEAT, "Number of seconds it takes to zoom out when moving. Default = 0.2");
	pConsole->RegisterFloat("int_ZoomOutTime", 0.1f, VF_CHEAT, "Number of seconds it takes to zoom out when you stop firing. Default = 0.5");

	pConsole->RegisterFloat("h_rX", 0.005f, VF_CHEAT, "rot x");
	pConsole->RegisterFloat("h_rY", 0.0f, VF_CHEAT, "rot y");
	pConsole->RegisterFloat("h_rZ", 0.0f, VF_CHEAT, "rot z");

	pConsole->RegisterFloat("h_sX", 0.0f, VF_CHEAT, "shift x");
	pConsole->RegisterFloat("h_sY", 0.0f, VF_CHEAT, "shift x");
	pConsole->RegisterFloat("h_sZ", 0.0f, VF_CHEAT, "shift x");

	pConsole->RegisterFloat("h_rand", 0.0f, VF_CHEAT, "randomness");

	pConsole->RegisterFloat("aa_maxDist", 10.0f, VF_CHEAT, "max lock distance");

  // frozen shake vars (for tweaking only)
  pConsole->RegisterInt("cl_debugFreezeShake", 0, VF_CHEAT|VF_DUMPTODISK, "Toggle freeze shake debug draw");  
  pConsole->RegisterInt("cl_frozenSteps", 3, VF_CHEAT, "Number of steps for unfreeze shaking");  
  pConsole->RegisterFloat("cl_frozenSensMin", 1.0f, VF_CHEAT, "Frozen sensitivity min"); // was 0.2
  pConsole->RegisterFloat("cl_frozenSensMax", 1.0f, VF_CHEAT, "Frozen sensitivity max"); // was 0.4
  pConsole->RegisterFloat("cl_frozenAngleMin", 1.f, VF_CHEAT, "Frozen clamp angle min");
  pConsole->RegisterFloat("cl_frozenAngleMax", 10.f, VF_CHEAT, "Frozen clamp angle max");
  pConsole->RegisterFloat("cl_frozenMult", 0.05f, VF_CHEAT, "Frozen shake multiplier");
  pConsole->RegisterFloat("cl_frozenSoundDelta", 0.004f, VF_CHEAT, "Threshold for unfreeze shake to trigger a crack sound");
  pConsole->RegisterFloat("cl_frozenShakeScreenMult", 1.7f, VF_CHEAT, "Frozen shake screenfrost multiplier");

	pConsole->RegisterFloat("g_walkMultiplier", 1, VF_CHEAT, "Modify walk speed");
}

void CGame::RegisterConsoleVars()
{
	assert(m_pConsole);

	//
	m_CVars.InitCVars(m_pConsole);    
}

void CGame::RegisterConsoleCommands()
{
	assert(m_pConsole);
	
	m_pConsole->AddCommand("quit", "System.Quit()", 0, "Quits the game");
	m_pConsole->AddCommand("kill", "g_gameRules:ProcessDeath(g_localActor, NULL_ENTITY, NULL_ENTITY, \"\", 0);", 0, "kills the player");
	m_pConsole->AddCommand("goto", "g_localActor:SetWorldPos({x=%1, y=%2, z=%3})", 0, "Sets current player position.");
  m_pConsole->AddCommand("freeze", "g_gameRules:SetFrozenAmount(g_localActor,1)", 0, "Freezes player");

	m_pConsole->AddCommand("name", CmdName, 0, "Sets player name.");
}


//------------------------------------------------------------------------
void CGame::CmdName(IConsoleCmdArgs *pArgs)
{
	if (!g_pGame->GetIGameFramework()->IsClient())
		return;

	IActor *pClientActor=g_pGame->GetIGameFramework()->GetClientActor();
	if (!pClientActor)
		return;

	CGameRules *pGameRules = g_pGame->GetGameRules();
	if (pGameRules)
		pGameRules->RenamePlayer(pGameRules->GetActorByEntityId(pClientActor->GetEntityId()), pArgs->GetArg(1));
}
