/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2004.
-------------------------------------------------------------------------
$Id$
$DateTime$
Description: 

-------------------------------------------------------------------------
History:
- 2:8:2004   11:04 : Created by Mrcio Martins

*************************************************************************/
#ifndef __GAMESTARTUP_H__
#define __GAMESTARTUP_H__

#if _MSC_VER > 1000
# pragma once
#endif


#include <IGameFramework.h>
#ifdef WIN32
#include <windows.h>
// get rid of (really) annoying MS defines
#undef min
#undef max
#endif

#define GAME_FRAMEWORK_FILENAME	"cryaction.dll"
#define GAME_WINDOW_CLASSNAME		"CryENGINE"

// implemented in GameDll.cpp
extern HMODULE GetFrameworkDLL();

class CGameStartup :
	public IGameStartup
{
public:
	CGameStartup();
	virtual ~CGameStartup();

	virtual IGameRef Init(SSystemInitParams &startupParams);
	virtual IGameRef Reset(const char *modName);
	virtual void Shutdown();
	virtual int Update(bool haveFocus, unsigned int updateFlags);
	virtual int Run( const char * autoStartLevelName );

private:

	bool InitWindow(SSystemInitParams &startupParams);
	void ShutdownWindow();

	bool InitFramework(SSystemInitParams &startupParams);
	void ShutdownFramework();

	void InitRootDir();

	static LRESULT CALLBACK WndProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);

	IGame						*m_pMod;
	IGameRef				m_modRef;
	IGameFramework	*m_pFramework;
	bool						m_initWindow;

	HMODULE					m_modDll;
	HMODULE					m_frameworkDll;

	string					m_rootDir;
	string					m_binDir;
};


#endif //__GAMESTARTUP_H__
