/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2005.
-------------------------------------------------------------------------
$Id$
$DateTime$
Description:
	Defines an operation on Flash animations that takes them to a frame and stops the animation.
	The frame to use is derived from a GameToken. Simple use: a health bar.
	Shared by G02 and G04

-------------------------------------------------------------------------
History:
- 07:11:2005: Created by Julien Darre
- 22:02:2006: Refactored for G04 by Matthew Jack

*************************************************************************/
#include "StdAfx.h"
#include "GFGotoAndStop.h"
#include "IFlashPlayer.h"
#include "IGameTokens.h"

//-----------------------------------------------------------------------------------------------------

CGFGotoAndStop::CGFGotoAndStop(IGameFlashAnimation *pGameFlashAnimation) : CGameFlashLogicBase(pGameFlashAnimation), m_fPreviousValue(-666.0f)
{
}

//-----------------------------------------------------------------------------------------------------

CGFGotoAndStop::~CGFGotoAndStop()
{
}

//-----------------------------------------------------------------------------------------------------

void CGFGotoAndStop::Init(const char *strName,const char *strASControl,const char *strToken,float fScale,float fOffset)
{
	SetName(strName);
	strcpy(m_strASControl,strASControl);
	strcpy(m_strToken,strToken);
	sprintf(m_strInvoke,"%s.gotoAndStop",strASControl);
	m_fScale = fScale;
	m_fOffset = fOffset;
}

//-----------------------------------------------------------------------------------------------------

void CGFGotoAndStop::Update(float fDeltaTime)
{
	float fValue = 0.0f;
	if(GetIGameTokenSystem()->GetTokenValueAs(m_strToken,fValue))
	{
			if(m_pGameFlashAnimation->GetFlashPlayer()->IsAvailable(m_strASControl))
			{
//				if(m_fPreviousValue != fValue)
				{
					m_pGameFlashAnimation->GetFlashPlayer()->Invoke(m_strInvoke,"%f",fValue*m_fScale+m_fOffset);
					m_fPreviousValue = fValue;
				}
		}
	}
}

//-----------------------------------------------------------------------------------------------------