/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2005.
-------------------------------------------------------------------------
$Id$
$DateTime$
Description:
	Defines an operation on Flash animations that sets a Flash variable.
	The value to use is derived from a GameToken.
	Shared by G02 and G04

-------------------------------------------------------------------------
History:
- 07:11:2005: Created by Julien Darre
- 22:02:2006: Refactored for G04 by Matthew Jack

*************************************************************************/
#include "StdAfx.h"
#include "GFVariable.h"
#include "IFlashPlayer.h"
#include "IGameTokens.h"

//-----------------------------------------------------------------------------------------------------

CGFVariable::CGFVariable(IGameFlashAnimation *pGameFlashAnimation) : CGameFlashLogicBase(pGameFlashAnimation)
{
}

//-----------------------------------------------------------------------------------------------------

CGFVariable::~CGFVariable()
{
}

//-----------------------------------------------------------------------------------------------------

void CGFVariable::Init(const char *strName,const char *strASControl,const char *strVariable,const char *strToken,float fScale,float fOffset)
{
	SetName(strName);
	strcpy(m_strASControl,strASControl);
	strcpy(m_strToken,strToken);
	sprintf(m_strInvoke,"%s.%s",strASControl,strVariable);
	m_fScale = fScale;
	m_fOffset = fOffset;
}

//-----------------------------------------------------------------------------------------------------

void CGFVariable::Update(float fDeltaTime)
{
	float fValue = 0.0f;
	if(GetIGameTokenSystem()->GetTokenValueAs(m_strToken,fValue))
	{
		if(m_pGameFlashAnimation->GetFlashPlayer()->IsAvailable(m_strASControl))
		{
			char strValue[HUD_MAX_STRING_SIZE];
			sprintf(strValue,"%f",fValue*m_fScale+m_fOffset);
			m_pGameFlashAnimation->GetFlashPlayer()->SetVariable(m_strInvoke,strValue);
		}
	}
}

//-----------------------------------------------------------------------------------------------------