/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2005.
-------------------------------------------------------------------------
$Id$
$DateTime$
Description:

-------------------------------------------------------------------------
History:
- 07:11:2005: Created by Julien Darre

*************************************************************************/
#include "StdAfx.h"
#include "GameFlashAnimation.h"
#include "GameFlashLogicBase.h"
#include "IFlashPlayer.h"

//-----------------------------------------------------------------------------------------------------

CGameFlashAnimation::CGameFlashAnimation()
{
	m_pFlashPlayer = NULL;
	m_eGFDock = eGFD_Top;
	m_fDeltaTime = 0.0f;
}

//-----------------------------------------------------------------------------------------------------

CGameFlashAnimation::~CGameFlashAnimation()
{
	for(TGameFlashLogicsList::iterator iter=m_gameFlashLogicsList.begin(); iter!=m_gameFlashLogicsList.end(); iter++)
	{
		SAFE_DELETE(*iter);
	}

	SAFE_RELEASE(m_pFlashPlayer);
}

//-----------------------------------------------------------------------------------------------------

IFlashPlayer *CGameFlashAnimation::GetFlashPlayer()
{
	return m_pFlashPlayer;
}

//-----------------------------------------------------------------------------------------------------

void CGameFlashAnimation::SetDock(int eGFDock)
{
	m_eGFDock = eGFDock;
}

//-----------------------------------------------------------------------------------------------------

int CGameFlashAnimation::GetDock()
{
	return m_eGFDock;
}

//-----------------------------------------------------------------------------------------------------

bool CGameFlashAnimation::Load(const char *strName,const char *strFileName)
{
	m_strName = strName;

	m_pFlashPlayer = GetISystem()->CreateFlashPlayerInstance();
	if (!m_pFlashPlayer)
	{
		GetISystem()->Warning(
				VALIDATOR_MODULE_GAME,
				VALIDATOR_ERROR,
				0,
				NULL,
				"Can't create flash player for '%s'",
				strName);
		return false;
	}

	if(m_pFlashPlayer->LoadSWF(strFileName))
	{
		IRenderer *pRenderer = GetISystem()->GetIRenderer();
		SetViewport(0,0,pRenderer->GetWidth(),pRenderer->GetHeight());
		m_pFlashPlayer->SetBackgroundAlpha(0.0f);

		return true;
	}

	return false;
}

//-----------------------------------------------------------------------------------------------------

void CGameFlashAnimation::AddGameFlashLogic(IGameFlashLogic *pGameFlashLogic)
{
	m_gameFlashLogicsList.push_back(static_cast<CGameFlashLogicBase *>(pGameFlashLogic));
}

//-----------------------------------------------------------------------------------------------------

void CGameFlashAnimation::Update(float fDeltaTime)
{
	m_fDeltaTime = fDeltaTime;

	for(TGameFlashLogicsList::iterator iter=m_gameFlashLogicsList.begin(); iter!=m_gameFlashLogicsList.end(); iter++)
	{
		(*iter)->Update(fDeltaTime);
	}
}

//-----------------------------------------------------------------------------------------------------

void CGameFlashAnimation::Render()
{
	m_pFlashPlayer->RenderFrame(m_fDeltaTime);
}

//-----------------------------------------------------------------------------------------------------

void CGameFlashAnimation::SetViewport(int x,int y,int width,int height)
{
	m_pFlashPlayer->SetViewport(x,y,width,height);
}

//-----------------------------------------------------------------------------------------------------
