/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2005.
-------------------------------------------------------------------------
$Id$
$DateTime$
Description:
	Base class for defining operations on a Flash animation
	Shared by G02 and G04

-------------------------------------------------------------------------
History:
- 07:11:2005: Created by Julien Darre
- 22:02:2006: Refactored for G04 by Matthew Jack

*************************************************************************/
#include "StdAfx.h"
#include "GameFlashLogicBase.h"
#include "IGameTokens.h"
#include "IGame.h"
#include "IGameFramework.h"

//-----------------------------------------------------------------------------------------------------

CGameFlashLogicBase::CGameFlashLogicBase(IGameFlashAnimation *pGameFlashAnimation)
{
	m_pGameFlashAnimation = pGameFlashAnimation;
}

//-----------------------------------------------------------------------------------------------------

CGameFlashLogicBase::~CGameFlashLogicBase()
{
}

//-----------------------------------------------------------------------------------------------------

void CGameFlashLogicBase::SetName(const char *strName)
{
	strcpy(m_strName,strName);
}

//-----------------------------------------------------------------------------------------------------

const char *CGameFlashLogicBase::GetName()
{
	return m_strName;
}

//-----------------------------------------------------------------------------------------------------

// Convenience method for accessing the GameToken system
IGameTokenSystem *CGameFlashLogicBase::GetIGameTokenSystem() const
{
	return GetISystem()->GetIGame()->GetIGameFramework()->GetIGameTokenSystem();
}