/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2005.
-------------------------------------------------------------------------
$Id$
$DateTime$
Description: 
	Base class for defining operations on a Flash animation
	Shared by G02 and G04

-------------------------------------------------------------------------
History:
- 07:11:2005: Created by Julien Darre
- 22:02:2006: Refactored for G04 by Matthew Jack

*************************************************************************/
#ifndef __GAMEFLASHLOGICBASE_H__
#define __GAMEFLASHLOGICBASE_H__

//-----------------------------------------------------------------------------------------------------

#include "IGameFlash.h"

//-----------------------------------------------------------------------------------------------------

#define HUD_MAX_STRING_SIZE 256

//-----------------------------------------------------------------------------------------------------

// Forward declaration

struct IGameTokenSystem;

//-----------------------------------------------------------------------------------------------------

class CGameFlashLogicBase : public IGameFlashLogic
{
public:

	void SetName(const char *strName);
	const char *GetName();

						CGameFlashLogicBase(IGameFlashAnimation *pGameFlashAnimation);
	virtual ~	CGameFlashLogicBase();

protected:

	// Convenience method for accessing the GameToken system
	IGameTokenSystem *GetIGameTokenSystem() const;

	char m_strName[HUD_MAX_STRING_SIZE];

	IGameFlashAnimation *m_pGameFlashAnimation;
};

//-----------------------------------------------------------------------------------------------------

#endif

//-----------------------------------------------------------------------------------------------------