/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2005.
-------------------------------------------------------------------------
$Id$
$DateTime$
Description: 
	G02 HUD using Flash player
	Code specific to G02 should go here
	For code needed by all games, see CHUDCommon


-------------------------------------------------------------------------
History:
- 07:11:2005: Created by Julien Darre
- 01:02:2006: Modified by Jan Mller
- 22:02:2006: Refactored for G04 by Matthew Jack

*************************************************************************/
#include "StdAfx.h"
#include <StlUtils.h>

#include "Game.h"
#include "GameActions.h"
#include "Player.h"

#include "HUD.h"
#include "HUDDraw.h"
#include "HUDAmmo.h"
#include "HUDCrosshair.h"
#include "HUDRadar.h"
#include "HUDTextChat.h"
#include "HUDScore.h"
#include "ScriptBind_HUD.h"

#include "GameFlashAnimation.h"
#include "GFGotoAndStop.h"
#include "GFVariable.h"

#include "IGameTokens.h"
#include "IItemSystem.h"
#include "ISound.h"
#include "ILevelSystem.h"
#include "IPlayerInput.h"

#include "Weapon.h"

#include "Tweaks\HUDTweakMenu.h"

//-----------------------------------------------------------------------------------------------------

#define ATTACHMENT_BOTTOM		"attachment_bottom"
#define ATTACHMENT_SILENCER	"silencer_attach"
#define ATTACHMENT_TOP			"attachment_top"
#define ATTACHMENT_MAGAZINE	"magazine"
#define ATTACHMENT_SIDE			"attachment_side"

//-----------------------------------------------------------------------------------------------------

#define INTERFACE_NOTHING					0
#define INTERFACE_QUICKMENU				1
#define INTERFACE_WEAPON_SELECTOR	2

//-----------------------------------------------------------------------------------------------------

CHUD::CHUD() 
{
	// CHUDCommon constructor runs first

	m_pHUDAmmo			= NULL;
	m_pHUDCrosshair = NULL;
	m_pHUDRadar			= NULL;
	m_pHUDTweakMenu = NULL;
	m_pHUDScore			= NULL;
	m_pRenderer			= NULL;

	m_iFade = -1;

	m_bLaunchWS = false;
	m_bIgnoreMiddleClick = true;
	m_iInterface = INTERFACE_NOTHING;

	m_bChangedSomething = false;

	m_eNanoSlotMax = NANOSLOT_ARMOR;
	m_bDemoMode = false;
	m_bAutosnap = false;
	m_bHideCrosshair = false;

	m_fPrevProjectionOffsetX = m_fPrevProjectionOffsetY = -666.0f;
	m_fPrevAlpha = 1.0f;

	m_fSuitEnergy = 200.0f;

	m_pGameFlashAnimationAmmo									= NULL;
	m_pGameFlashAnimationCornersLeft					= NULL;
	m_pGameFlashAnimationCornersRight					= NULL;
	m_pGameFlashAnimationDamage								= NULL;
	m_pGameFlashAnimationHealthArmor					= NULL;
	m_pGameFlashAnimationMultiplayerScoreboard	= NULL;
	m_pGameFlashAnimationPDA									= NULL;
	m_pGameFlashAnimationQuickMenu						= NULL;
	m_pGameFlashAnimationRadarCompassStealth	= NULL;
	m_pGameFlashAnimationTargetAutoaim				= NULL;
	m_pGameFlashAnimationTargetLock						= NULL;
	m_pGameFlashAnimationWeaponSelector				= NULL;
	m_pGameFlashAnimationTextField						= NULL;

	m_fDefenseTimer = m_fStrengthTimer = m_fSpeedTimer = 0;
	m_bPlayingSpeedSound = false;
	m_fLastSoundPlayedMedical = 0;

	m_pNanoSuit = NULL;

	m_demoMessages = GetISystem()->LoadXmlFile("Libs/UI/DemoMessages.xml");
	m_statusMessages = GetISystem()->LoadXmlFile("Libs/UI/StatusMessages.xml");
	m_missionObjectiveSystem.SetHUD(this);

	if (GetISystem()->GetISoundSystem())
	{
		GetISystem()->GetISoundSystem()->Precache("Sounds/interface:suit:generic_beep", FLAG_SOUND_2D, true);
	}

	m_entityTargetAutoaimId = 0;
	m_entityTargetLockId = 0;

	m_fAutosnapCursorRelativeX = 0.0f;
	m_fAutosnapCursorRelativeY = 0.0f;
	m_bOnCircle = false;
}

//-----------------------------------------------------------------------------------------------------

CHUD::~CHUD()
{
	std::for_each(m_hudObjectsList.begin(), m_hudObjectsList.end(), stl::container_object_deleter());
	m_hudObjectsList.clear();

	SAFE_DELETE(m_pGameFlashAnimationAmmo);
	SAFE_DELETE(m_pGameFlashAnimationCornersLeft);
	SAFE_DELETE(m_pGameFlashAnimationCornersRight);
	SAFE_DELETE(m_pGameFlashAnimationDamage);
	SAFE_DELETE(m_pGameFlashAnimationHealthArmor);
	SAFE_DELETE(m_pGameFlashAnimationMultiplayerScoreboard);
	SAFE_DELETE(m_pGameFlashAnimationPDA);
	SAFE_DELETE(m_pGameFlashAnimationQuickMenu);
	SAFE_DELETE(m_pGameFlashAnimationRadarCompassStealth);
	SAFE_DELETE(m_pGameFlashAnimationTargetAutoaim);
	SAFE_DELETE(m_pGameFlashAnimationTargetLock);
	SAFE_DELETE(m_pGameFlashAnimationTextField);
	
	SAFE_DELETE(m_pHUDRadar);

	// CHUDCommon destructor runs last
}

//-----------------------------------------------------------------------------------------------------

void CHUD::PlaySound(ESound eSound, bool play)
{
	if(!GetISystem()->GetISoundSystem())
		return;

	string strSound;

	switch(eSound)
	{
	case ESound_GenericBeep:
		strSound = "Sounds/interface:suit:generic_beep";
		break;
	case ESound_PresetNavigationBeep:
		strSound = "Sounds/interface:suit:preset_navigation_beep";
		break;
	case ESound_TemperatureBeep:
		strSound = "Sounds/interface:suit:temperature_beep";
		break;
	case ESound_SuitStrengthActivate:
		strSound = "Sounds/interface:suit:suit_strength_activate";
		break;
	case ESound_SuitSpeedActivate:
		strSound = "Sounds/interface:suit:suit_speed_activate";
		break;
	case ESound_SuitArmorActivate:
		strSound = "Sounds/interface:suit:suit_armor_activate";
		break;
	case ESound_SuitMenuAppear:
		strSound = "sounds/interface:suit:modification_menu_appear";
		break;
	case ESound_SuitMenuDisappear:
		strSound = "Sounds/interface:suit:modification_menu_disappear";
		break;
	case ESound_WeaponModification:
		strSound = "Sounds/interface:suit:weapon_modification_beep";
		break;
	default:
		assert(0);
		return;
	}

	_smart_ptr<ISound> pSound = GetISystem()->GetISoundSystem()->LoadSound(strSound,FLAG_SOUND_2D);

	if ( pSound )
	{
		if(play)
			pSound->Play();
		else
			pSound->Stop();
	}
}

//-----------------------------------------------------------------------------------------------------

void CHUD::PlayStatusSound(const char* name)
{
	if(!GetISystem()->GetISoundSystem())
		return;

	string strSound("sounds/interface:suit:");

	//VS2 hack ...
	if(!strcmp(name, "temperature_cloak_on"))
		strSound.append("full_cloak_on");
	else if(!strcmp(name, "temperature_cloak_off"))
		strSound.append("full_cloak_off");
	else
		strSound.append(name);

	_smart_ptr<ISound> pSound = GetISystem()->GetISoundSystem()->LoadSound(strSound,FLAG_SOUND_2D);
	if ( pSound )
		pSound->Play();
}

//-----------------------------------------------------------------------------------------------------

bool CHUD::Init(IGameObject *pGameObject)
{
	// Initialize CHUDCommon
	if (!CHUDCommon::Init(pGameObject)) return false;

	g_pGame->GetHUDScriptBind()->AttachTo(this);

	m_pRenderer = GetISystem()->GetIRenderer();

	m_iTextureIDCursor = m_pHUDDraw->CreateTexture("UI\\HUD\\NanoCursor.dds");

	m_pHUDAmmo			= new CHUDAmmo			(m_pHUDDraw);
	m_pHUDCrosshair = new CHUDCrosshair	(m_pHUDDraw);
	m_pHUDRadar			= new CHUDRadar			(m_pHUDDraw);
	m_pHUDTextChat	= new CHUDTextChat  (m_pHUDDraw);
	m_pHUDScore			= new CHUDScore			(m_pHUDDraw);

	IScriptSystem* pScriptSystem = GetISystem()->GetIScriptSystem();
	m_pHUDTweakMenu =  new CHUDTweakMenu( m_pHUDDraw, pScriptSystem );

	m_hudObjectsList.push_back(m_pHUDAmmo);
	m_hudObjectsList.push_back(m_pHUDCrosshair);
	//m_hudObjectsList.push_back(m_pHUDRadar);  Don't add it, do delete it
	m_hudObjectsList.push_back(m_pHUDTextChat);
	m_hudObjectsList.push_back(m_pHUDScore);
	m_hudObjectsList.push_back(m_pHUDTweakMenu);

	m_pGameFlashAnimationAmmo = AddNewFlashAnimation("HUD_Ammo", "Libs/UI/HUD_Ammo.swf", eGFD_Right, true);
	m_pGameFlashAnimationCornersLeft = AddNewFlashAnimation("HUD_CornersLeft", "Libs/UI/HUD_CornersLeft.swf", eGFD_Left, false);
	m_pGameFlashAnimationCornersRight = AddNewFlashAnimation("HUD_CornersRight", "Libs/UI/HUD_CornersRight.swf", eGFD_Right, false);

	// This one isn't added to the list
	m_pGameFlashAnimationDamage = new CGameFlashAnimation;
	if(m_pGameFlashAnimationDamage->Load("HUD_Corners","Libs/UI/HUD_Damage.swf"))
	{
		m_pGameFlashAnimationDamage->SetDock(eGFD_Top);
		//m_gameFlashAnimationsList.push_back(m_pGameFlashAnimationDamage);
	}
	else
	{
		SAFE_DELETE(m_pGameFlashAnimationDamage);
	}

	if (m_pGameFlashAnimationHealthArmor = AddNewFlashAnimation("HUD_HealthArmor", "Libs/UI/HUD_HealthArmor.swf", eGFD_Right, false))
	{
		AddGotoAndStop(m_pGameFlashAnimationHealthArmor,"Health",						"Root.HealthArmorArea.HealthArmor.HealthBar",											"hud.health",					99.0f/100.0f,1.0f);
		AddGotoAndStop(m_pGameFlashAnimationHealthArmor,"Armor",						"Root.HealthArmorArea.HealthArmor.ArmorBar",											"hud.nanosuit.armor",	99.0f/100.0f,1.0f);
		AddGotoAndStop(m_pGameFlashAnimationHealthArmor,"HealthProjection",	"Root.HealthArmorArea.HealthArmorProjection.HealthBarProjection",	"hud.health",					99.0f/100.0f,1.0f);
		AddGotoAndStop(m_pGameFlashAnimationHealthArmor,"ArmorProjection",	"Root.HealthArmorArea.HealthArmorProjection.ArmorBarProjection",	"hud.nanosuit.armor",	99.0f/100.0f,1.0f);
	}

	m_pGameFlashAnimationMultiplayerScoreboard = AddNewFlashAnimation("HUD_MultiplayerScoreboard", "Libs/UI/HUD_MultiplayerScoreboard.swf", eGFD_Middle, false);

	m_pGameFlashAnimationPDA = AddNewFlashAnimation("HUD_PDA", "Libs/UI/HUD_PDA.swf", eGFD_Right, true);

	m_pGameFlashAnimationQuickMenu = AddNewFlashAnimation("HUD_QuickMenu", "Libs/UI/HUD_QuickMenu.swf", eGFD_Middle, true);

	/*
	if (m_pGameFlashAnimationRadarCompassStealth = AddNewFlashAnimation("HUD_RadarCompassStealth", "Libs/UI/HUD_RadarCompassStealth.swf", eGFD_Left, false))
	{
		AddGotoAndStop(m_pGameFlashAnimationRadarCompassStealth,"Stealth",					"Root.RadarCompassArea.RadarCompass.StealthBar",										"hud.stealth",9.9f,1.0f);
		AddGotoAndStop(m_pGameFlashAnimationRadarCompassStealth,"StealthProjection","Root.RadarCompassArea.RadarCompassProjection.StealthBarProjection","hud.stealth",9.9f,1.0f);

		AddVariable(m_pGameFlashAnimationRadarCompassStealth,"Compass","Root.RadarCompassArea.RadarCompass.Compass","_rotation","hud.compass",180.0f/gf_PI,-90.0f);
	}
	*/

	// This one isn't added to the list
	m_pGameFlashAnimationTargetAutoaim = new CGameFlashAnimation;
	if(m_pGameFlashAnimationTargetAutoaim->Load("HUD_TargetAutoaim","Libs/UI/HUD_TargetAutoaim.swf"))
	{
		m_pGameFlashAnimationTargetAutoaim->SetDock(eGFD_Top);
		//m_gameFlashAnimationsList.push_back(m_pGameFlashAnimationTargetAutoaim);
	}
	else
	{
		SAFE_DELETE(m_pGameFlashAnimationTargetAutoaim);
	}

	// This one isn't added to the list
	m_pGameFlashAnimationTargetLock = new CGameFlashAnimation;
	if(m_pGameFlashAnimationTargetLock->Load("HUD_TargetLock","Libs/UI/HUD_TargetLock.swf"))
	{
		m_pGameFlashAnimationTargetLock->SetDock(eGFD_Top);
		//m_gameFlashAnimationsList.push_back(m_pGameFlashAnimationTargetLock);
	}
	else
	{
		SAFE_DELETE(m_pGameFlashAnimationTargetLock);
	}

	m_pGameFlashAnimationTextField = AddNewFlashAnimation("HUD_TextField", "Libs/UI/HUD_TextField.swf", eGFD_Left, false);

	if (m_pGameFlashAnimationWeaponSelector = AddNewFlashAnimation("HUD_WeaponSelector", "Libs/UI/HUD_WeaponSelector.swf", eGFD_Middle, true))
	{
		AddVariable(m_pGameFlashAnimationWeaponSelector,"WeaponSelectorGrenade","Root.WSArea.Grenade","_x","hud.WSGrenadeX",1.0f,0.0f);
		AddVariable(m_pGameFlashAnimationWeaponSelector,"WeaponSelectorGrenade","Root.WSArea.Grenade","_y","hud.WSGrenadeY",1.0f,0.0f);

		AddVariable(m_pGameFlashAnimationWeaponSelector,"WeaponSelectorBarrel","Root.WSArea.Barrel","_x","hud.WSBarrelX",1.0f,0.0f);
		AddVariable(m_pGameFlashAnimationWeaponSelector,"WeaponSelectorBarrel","Root.WSArea.Barrel","_y","hud.WSBarrelY",1.0f,0.0f);

		AddVariable(m_pGameFlashAnimationWeaponSelector,"WeaponSelectorScopes","Root.WSArea.Scopes","_x","hud.WSScopesX",1.0f,0.0f);
		AddVariable(m_pGameFlashAnimationWeaponSelector,"WeaponSelectorScopes","Root.WSArea.Scopes","_y","hud.WSScopesY",1.0f,0.0f);

		AddVariable(m_pGameFlashAnimationWeaponSelector,"WeaponSelectorClips","Root.WSArea.Clips","_x","hud.WSClipsX",1.0f,0.0f);
		AddVariable(m_pGameFlashAnimationWeaponSelector,"WeaponSelectorClips","Root.WSArea.Clips","_y","hud.WSClipsY",1.0f,0.0f);

		AddVariable(m_pGameFlashAnimationWeaponSelector,"WeaponSelectorFrontSideRail","Root.WSArea.FrontSideRail","_x","hud.WSFrontSideRailX",1.0f,0.0f);
		AddVariable(m_pGameFlashAnimationWeaponSelector,"WeaponSelectorFrontSideRail","Root.WSArea.FrontSideRail","_y","hud.WSFrontSideRailY",1.0f,0.0f);
	}

	GetISystem()->GetIGame()->GetIGameFramework()->GetIGameTokenSystem()->GetTokenValueAs("hud.health",m_fHealth);


	//Jan - hack
	std::list<CHUDObject *>::iterator it;
	for(it = m_hudObjectsList.begin(); it != m_hudObjectsList.end(); it++)
		(*it)->SetParent(this);

	return true;
}

//-----------------------------------------------------------------------------------------------------

bool CHUD::UpdateNanoSlotMax()
{
	ENanoSlot eNanoSlotOld = m_eNanoSlotMax;

	if(m_pNanoSuit->GetSlotValue(NANOSLOT_ARMOR,false) > m_pNanoSuit->GetSlotValue(m_eNanoSlotMax,false))
	{
		m_eNanoSlotMax = NANOSLOT_ARMOR;
	}
	if(m_pNanoSuit->GetSlotValue(NANOSLOT_SPEED,false) > m_pNanoSuit->GetSlotValue(m_eNanoSlotMax,false))
	{
		m_eNanoSlotMax = NANOSLOT_SPEED;
	}
	if(m_pNanoSuit->GetSlotValue(NANOSLOT_STRENGTH,false) > m_pNanoSuit->GetSlotValue(m_eNanoSlotMax,false))
	{
		m_eNanoSlotMax = NANOSLOT_STRENGTH;
	}
	if(m_pNanoSuit->GetSlotValue(NANOSLOT_MEDICAL,false) > m_pNanoSuit->GetSlotValue(m_eNanoSlotMax,false))
	{
		m_eNanoSlotMax = NANOSLOT_MEDICAL;
	}

	if(m_eNanoSlotMax != eNanoSlotOld)
	{
		return true;
	}

	return false;
}

//-----------------------------------------------------------------------------------------------------

void CHUD::Serialize(TSerialize ser,unsigned aspects)
{
	FUNCTION_PROFILER(GetISystem(), PROFILE_GAME);

	m_missionObjectiveSystem.Serialize(ser, aspects);
	// TODO: re-show in the PDA

	if (ser.GetSerializationTarget() != eST_Network)
	{
		ser.Value("hudDemoMode",m_bDemoMode);
		ser.Value("hudShow", m_bShow);
		ser.Value("hudGodMode",m_godMode);
		if(ser.IsReading())
		{
			SetGODMode(m_godMode, true);	//reset god mode - only necessary when reading
			m_levelName = string(g_pGame->GetIGameFramework()->GetLevelName());		//get level name
		}
		ser.Value("hudGodDeaths",m_iDeaths);
		ser.Value("hudInterface",m_iInterface);

		//serialize first time encounters
		//...

		//**********************************Radar serialization
		ser.Value("hudRadarTag",this->m_pHUDRadar->m_aiEntitiesId[0], NSerPolicy::AC_EntityId());
		ser.Value("hudRadarTag",this->m_pHUDRadar->m_aiEntitiesId[1], NSerPolicy::AC_EntityId());
		ser.Value("hudRadarTag",this->m_pHUDRadar->m_aiEntitiesId[2], NSerPolicy::AC_EntityId());
		int amount = 0;
		if(ser.IsReading())
		{
			ser.Value("AmountOfRadarEntities", amount);
			m_pHUDRadar->m_entitiesOnRadar.clear();
			m_pHUDRadar->m_entitiesOnRadar.resize(amount);
		}
		else
		{
			amount = m_pHUDRadar->m_entitiesOnRadar.size();
			ser.Value("AmountOfRadarEntities", amount);
		}
		for(int h = 0; h < amount; h++)
			ser.Value("RadarEntity", m_pHUDRadar->m_entitiesOnRadar[h].m_id);

		//weapon setup should be serialized too?!

	}
	else 
	{

	}
}

//-----------------------------------------------------------------------------------------------------

//handles all kinds of mouse clicks and flash callbacks
void CHUD::HandleFSCommand(const char *strCommand,const char *strArgs)
{
	if(!strcmp(strCommand,"AmmoAlpha"))
	{
		float fAlpha;
		sscanf(strArgs,"%f",&fAlpha);
		m_pHUDAmmo->SetAlpha(fAlpha/100.0f);
		return;
	}

	if(!strcmp(strCommand,"WeaponSelector"))
	{
		CWeapon *pWeapon = GetWeapon();
		if(pWeapon)
		{
			PlaySound(ESound_WeaponModification);
			pWeapon->SwitchAccessory(strArgs);

			IAISignalExtraData* pData = GetISystem()->GetAISystem()->CreateSignalExtraData();//AI System will be the owner of this data
			pData->SetObjectName(strArgs);
			CPlayer *pPlayer = static_cast<CPlayer *>(GetISystem()->GetIGame()->GetIGameFramework()->GetClientActor());
			if(pPlayer && pPlayer->GetEntity() && pPlayer->GetEntity()->GetAI())
				GetISystem()->GetAISystem()->SendSignal(SIGNALFILTER_GROUPONLY,1,"OnSwitchWeaponAccessory",pPlayer->GetEntity()->GetAI(),pData);
		}
		return;
	}

	if(0 == strcmp(strCommand,"QuickMenuSpeedPreset"))
	{
		m_pNanoSuit->SetAllSlots(25, 50, 100);
		PlaySound(ESound_SuitSpeedActivate);
		m_fSpeedTimer = GetISystem()->GetITimer()->GetAsyncTime().GetMilliSeconds();
		m_pGameFlashAnimationHealthArmor->GetFlashPlayer()->Invoke("Root.NanoState.gotoAndStop","%d",2);
		return;
	}
	else if(0 == strcmp(strCommand,"QuickMenuStrengthPreset"))
	{
		m_pNanoSuit->SetAllSlots(50, 100, 25);
		PlaySound(ESound_SuitStrengthActivate);
		m_fStrengthTimer = GetISystem()->GetITimer()->GetAsyncTime().GetMilliSeconds();
		m_pGameFlashAnimationHealthArmor->GetFlashPlayer()->Invoke("Root.NanoState.gotoAndStop","%d",3);
		return;
	}
	else if(0 == strcmp(strCommand,"QuickMenuDefensePreset"))
	{
		m_pNanoSuit->SetAllSlots(75, 25, 25);
		PlaySound(ESound_SuitArmorActivate);
		m_fDefenseTimer = GetISystem()->GetITimer()->GetAsyncTime().GetMilliSeconds();
		m_pGameFlashAnimationHealthArmor->GetFlashPlayer()->Invoke("Root.NanoState.gotoAndStop","%d",4);
		return;
	}
	else if(0 == strcmp(strCommand,"QuickMenuDefault"))
	{
		PlaySound(ESound_PresetNavigationBeep);
		if(m_pNanoSuit->GetSlotValue(NANOSLOT_ARMOR, true) != 50 || m_pNanoSuit->GetSlotValue(NANOSLOT_SPEED, true) != 50 ||
			m_pNanoSuit->GetSlotValue(NANOSLOT_STRENGTH, true) != 50 || m_pNanoSuit->GetSlotValue(NANOSLOT_MEDICAL, true) != 50)
		{
			m_bChangedSomething = false;
			SGameObjectEvent evt ("HUD_TextMessage", 0, IGameObjectSystem::InvalidExtensionID, (void*)("suit_modification_engaged"));
			//SGameObjectEvent evt ("HUD_TextMessage", 0, IGameObjectSystem::InvalidExtensionID, (void*)("Nanosuit balanced mode engaged!"));
			HandleEvent(evt);
		}
		m_pNanoSuit->SetAllSlots(50, 50, 50);

		//disable cloak if active
		if(m_pNanoSuit->GetCloaked())
		{
			CPlayer *pPlayer = static_cast<CPlayer *>(GetISystem()->GetIGame()->GetIGameFramework()->GetClientActor());
			(*(pPlayer->GetPlayerInput()))->OnAction("suitsilence", eAAM_OnPress, 1.0f);
			(*(pPlayer->GetPlayerInput()))->OnAction("suitcamoflage", eAAM_OnPress, 1.0f);
			m_pNanoSuit->SwitchCloaked();
		}
		m_pGameFlashAnimationHealthArmor->GetFlashPlayer()->Invoke("Root.NanoState.gotoAndStop","%d",1);
		return;
	}
	else if(!strcmp(strCommand,"QuickMenuSwitchWeaponSelector"))
	{
		CPlayer *pPlayer = static_cast<CPlayer *>(GetISystem()->GetIGame()->GetIGameFramework()->GetClientActor());
		CWeapon *pWeapon = GetWeapon();
		if(pPlayer && pWeapon && !strcmp(pWeapon->GetEntity()->GetClass()->GetName(),"SCAR"))
		{
			if(!((SPlayerStats *) pPlayer->GetActorStats())->isFrozen)
			{
				CursorIncrementCounter();
				m_iInterface = INTERFACE_WEAPON_SELECTOR;
				pWeapon->OnAction(pPlayer->GetEntityId(),"modify",0,1);
				m_bLaunchWS = true;
			}
		}
		return;
	}
	else if(!strcmp(strCommand,"Cloak"))
	{
		CPlayer *pPlayer = static_cast<CPlayer *>(GetISystem()->GetIGame()->GetIGameFramework()->GetClientActor());
		(*(pPlayer->GetPlayerInput()))->OnAction("suitsilence", eAAM_OnPress, 1.0f);
		(*(pPlayer->GetPlayerInput()))->OnAction("suitcamoflage", eAAM_OnPress, 1.0f);
		m_pNanoSuit->SwitchCloaked();
		return;
	}
	/*else if(!strcmp(strCommand,"QuickMenuMute"))
	{
		CPlayer *pPlayer = static_cast<CPlayer *>(GetISystem()->GetIGame()->GetIGameFramework()->GetClientActor());
		pPlayer->OnAction("suitsilence", eAAM_OnPress, 1.0f);
		return;
	}*/
	else if(!strcmp(strCommand,"QuickMenuSuitOverload"))
	{
		CPlayer *pPlayer = static_cast<CPlayer *>(GetISystem()->GetIGame()->GetIGameFramework()->GetClientActor());
		(*(pPlayer->GetPlayerInput()))->OnAction("suitoverload", eAAM_OnPress, 1.0f);

		return;
	}
}

//-----------------------------------------------------------------------------------------------------

#ifdef WIN32
#include <windows.h>
#undef PlaySound
#undef DrawText
#undef GetMessage
void HUD_TRACE(const char *_strText,...)
{
	va_list args;
	va_start(args,_strText);

	char strBuffer[256];
	_vsnprintf_s(strBuffer,256,_TRUNCATE,_strText,args);

	va_end(args);

	OutputDebugString(strBuffer);
}
#else
void HUD_TRACE(const char *_strText,...)
{
}
#endif

void CHUD::OnAction(const ActionId& action, int activationMode, float value)
{
	const SGameActions &rGameActions = g_pGame->Actions();

	bool bCursorEvent = false;
	if(action == rGameActions.hud_mousex)
	{
		if(m_iCursorVisibilityCounter)
		{
			m_fCursorX = clamp_tpl(m_fCursorX+value,0.0f,799.0f);
			bCursorEvent = true;
		}
		else if(m_bAutosnap)
		{
			m_fAutosnapCursorRelativeX += value;
		}
	}
	else if(action == rGameActions.hud_mousey)
	{
		if(m_iCursorVisibilityCounter)
		{
			m_fCursorY = clamp_tpl(m_fCursorY+value,0.0f,599.0f);
			bCursorEvent = true;
		}
		else if(m_bAutosnap)
		{
			m_fAutosnapCursorRelativeY += value;
		}
	}
	if(bCursorEvent)
	{
		int iCursorX = (int)(m_pRenderer->ScaleCoordX(m_fCursorX));
		int iCursorY = (int)(m_pRenderer->ScaleCoordY(m_fCursorY));

		if(INTERFACE_WEAPON_SELECTOR == m_iInterface)
		{
			if(m_pGameFlashAnimationWeaponSelector)
			{
				iCursorX = RepositionCursorXPos(m_pGameFlashAnimationWeaponSelector, iCursorX);
				m_pGameFlashAnimationWeaponSelector->GetFlashPlayer()->SendCursorEvent(SFlashCursorEvent(SFlashCursorEvent::eCursorMoved,iCursorX,iCursorY));
			}
		}
/*		else if(INTERFACE_QUICKMENU == m_iInterface)
		{
			if(m_pGameFlashAnimationQuickMenu)
			{
				iCursorX = RepositionCursorXPos(m_pGameFlashAnimationQuickMenu, iCursorX);
				m_pGameFlashAnimationQuickMenu->GetFlashPlayer()->SendCursorEvent(SFlashCursorEvent(SFlashCursorEvent::eCursorMoved,iCursorX,iCursorY));
			}
		}*/

		return;
	}

	if(action == rGameActions.hud_mouseclick)
	{
		if(m_iCursorVisibilityCounter)
		{
			if(INTERFACE_WEAPON_SELECTOR == m_iInterface)
			{
				SFlashCursorEvent::ECursorState eCursorState = (value > 0.0f) ? SFlashCursorEvent::eCursorPressed : SFlashCursorEvent::eCursorReleased;

				int iCursorX = (int)(m_pRenderer->ScaleCoordX(m_fCursorX));
				int iCursorY = (int)(m_pRenderer->ScaleCoordY(m_fCursorY));

				if(m_pGameFlashAnimationWeaponSelector)
					m_pGameFlashAnimationWeaponSelector->GetFlashPlayer()->SendCursorEvent(SFlashCursorEvent(eCursorState,iCursorX,iCursorY));
			}
		}
	}
	else if(action == rGameActions.hud_mousemiddleclickpress)
	{
		if(INTERFACE_NOTHING == m_iInterface)
		{
			bool bModifying = false;
			bool bIsBusy = false;
			bool bZooming = false;
			CWeapon *pWeapon = GetWeapon();
			if(pWeapon)
			{
				bModifying = pWeapon->IsModifying();
				bIsBusy = pWeapon->IsBusy();
				IZoomMode *pZoomMode = pWeapon->GetZoomMode(pWeapon->GetCurrentZoomMode());
				if(pZoomMode)
				{
					bZooming = (pZoomMode->IsZoomed() || pZoomMode->IsZooming());
				}
			}
			if((pWeapon && !bZooming && !bModifying && !bIsBusy) || !pWeapon)
			{
				if(m_pGameFlashAnimationQuickMenu)
					m_pGameFlashAnimationQuickMenu->GetFlashPlayer()->Invoke("Root.QuickMenu.showQuickMenu","");
				if(m_pGameFlashAnimationAmmo)
				{
					m_pGameFlashAnimationAmmo->GetFlashPlayer()->Invoke("Root.AmmoArea.showAmmo","");
					PlaySound(ESound_SuitMenuAppear);
				}
				GetISystem()->GetIGame()->GetIGameFramework()->GetIActionMapManager()->EnableFilter("no_mouse",true);
				m_bAutosnap = true;
				m_iInterface = INTERFACE_QUICKMENU;
			}
		}
		else if(INTERFACE_WEAPON_SELECTOR == m_iInterface)
		{
			if(!m_bIgnoreMiddleClick)
			{
				CursorDecrementCounter();
				m_iInterface = INTERFACE_NOTHING;
				CPlayer *pPlayer = static_cast<CPlayer *>(GetISystem()->GetIGame()->GetIGameFramework()->GetClientActor());
				CWeapon *pWeapon = GetWeapon();
				if(pPlayer && pWeapon && !strcmp(pWeapon->GetEntity()->GetClass()->GetName(),"SCAR"))
				{
					pWeapon->OnAction(pPlayer->GetEntityId(),"modify",0,1);
				}
				if(m_bChangedSomething)
				{
					SGameObjectEvent evt ("HUD_TextMessage", 0, IGameObjectSystem::InvalidExtensionID, (void*)("suit_modification_engaged"));
					HandleEvent(evt);
					m_bChangedSomething = false;
				}
			}
		}
	}
	else if(action == rGameActions.hud_mousemiddleclickrelease)
	{
		if(INTERFACE_QUICKMENU == m_iInterface)
		{
			GetISystem()->GetIGame()->GetIGameFramework()->GetIActionMapManager()->EnableFilter("no_mouse",false);
			m_bAutosnap = false;
			m_iInterface = INTERFACE_NOTHING;
			if(m_pGameFlashAnimationQuickMenu)
			{
				m_pGameFlashAnimationQuickMenu->GetFlashPlayer()->Invoke("Root.QuickMenu.setAutosnapFunction","");
				m_fAutosnapCursorRelativeX = 0;
				m_fAutosnapCursorRelativeY = 0;
				m_bOnCircle = false;
			}
			if(m_pGameFlashAnimationAmmo && !m_bLaunchWS)
			{
				m_pGameFlashAnimationAmmo->GetFlashPlayer()->Invoke("Root.AmmoArea.hideAmmo","");
				PlaySound(ESound_SuitMenuDisappear);
			}
			if(m_pGameFlashAnimationQuickMenu)
				m_pGameFlashAnimationQuickMenu->GetFlashPlayer()->Invoke("Root.QuickMenu.hideQuickMenu","");
			m_bLaunchWS = false;
		}
	}
	else if(action == rGameActions.hud_pda_switch)
	{
		if(!GetISystem()->GetIGame()->GetIGameFramework()->IsMultiplayer())
		{
		if(m_pGameFlashAnimationPDA)
			m_pGameFlashAnimationPDA->GetFlashPlayer()->Invoke("Root.PDAMC.switchPDA","");
	}
	}
	else if(action == rGameActions.hud_show_multiplayer_scoreboard)
	{
//		if(GetISystem()->GetIGame()->GetIGameFramework()->IsMultiplayer())
		{
			if(m_pGameFlashAnimationMultiplayerScoreboard)
			{
				m_pGameFlashAnimationMultiplayerScoreboard->GetFlashPlayer()->Invoke("Root.setVisible","%d",1);
				m_pHUDScore->SetVisible(true);
			}
		}
	}
	else if(action == rGameActions.hud_hide_multiplayer_scoreboard)
	{
//		if(GetISystem()->GetIGame()->GetIGameFramework()->IsMultiplayer())
		{
			if(m_pGameFlashAnimationMultiplayerScoreboard)
			{
				m_pGameFlashAnimationMultiplayerScoreboard->GetFlashPlayer()->Invoke("Root.setVisible","%d",0);
				m_pHUDScore->SetVisible(false);
			}
		}
	}
	else if(action == rGameActions.hud_demo_mode)
	{
		m_bDemoMode = !m_bDemoMode;
		if(m_bDemoMode)
			m_onScreenText = string("Demo mode activated!");
		else
			m_onScreenText = string("Demo mode deactivated!");

		m_onScrTextStart = GetISystem()->GetITimer()->GetCurrTime();
	}
}

//-----------------------------------------------------------------------------------------------------

void CHUD::PostUpdate(float frameTime)
{
	FUNCTION_PROFILER(GetISystem(),PROFILE_GAME);

	if(m_pNanoSuit == NULL)
	{
		//get nanosuit  -   perhaps this will cause trouble on player death / level change or similar
		CPlayer * pPlayer = static_cast<CPlayer *>(GetISystem()->GetIGame()->GetIGameFramework()->GetClientActor());
		if (pPlayer)
		{
			CNanoSuit &rNanoSuit = pPlayer->GetNanoSuit();
			m_pNanoSuit = &rNanoSuit;
		}
		else
		{
			return; // early out... nothing to do here
		}
	}

	//handle button vocals
	if(m_fSpeedTimer != 0)
	{
		float now = GetISystem()->GetITimer()->GetAsyncTime().GetMilliSeconds();
		if(now - m_fSpeedTimer > 2000)
		{
			m_fSpeedTimer = 0;
			SGameObjectEvent evt ("HUD_TextMessage", 0, IGameObjectSystem::InvalidExtensionID, (void*)("maximum_speed"));
			HandleEvent(evt);
		}
	}
	if(m_fStrengthTimer != 0)
	{
		float now = GetISystem()->GetITimer()->GetAsyncTime().GetMilliSeconds();
		if(now - m_fStrengthTimer > 2000)
		{
			m_fStrengthTimer = 0;
			SGameObjectEvent evt ("HUD_TextMessage", 0, IGameObjectSystem::InvalidExtensionID, (void*)("maximum_strength"));
			HandleEvent(evt);
		}
	}
	if(m_fDefenseTimer != 0)
	{
		float now = GetISystem()->GetITimer()->GetAsyncTime().GetMilliSeconds();
		if(now - m_fDefenseTimer > 1000)
		{
			m_fDefenseTimer = 0;
			SGameObjectEvent evt ("HUD_TextMessage", 0, IGameObjectSystem::InvalidExtensionID, (void*)("maximum_defense"));
			HandleEvent(evt);
		}
	}

	// FIXME: Unless we find a better way to avoid this no-resize bug !
	if (m_width != m_pRenderer->GetWidth() || m_height != m_pRenderer->GetHeight())
	{
		OnResize(m_pRenderer->GetWidth(), m_pRenderer->GetHeight());
	}

	if(m_iFade)
	{
		m_iFade -= 1;
		if(0 == m_iFade)
		{
			m_bShow = true;
		}
	}

	CActor *pPlayerActor = static_cast<CActor *>(GetISystem()->GetIGame()->GetIGameFramework()->GetClientActor());
	if(m_bShow && pPlayerActor)
	{

		if(pPlayerActor && pPlayerActor->GetCurrentItem() && pPlayerActor->GetCurrentItem()->GetEntity())
			InvokeIntroduction(pPlayerActor->GetCurrentItem()->GetEntity()->GetName());

		IGameTokenSystem *pGameTokenSystem = GetISystem()->GetIGame()->GetIGameFramework()->GetIGameTokenSystem();

		float fStealthValue = clamp_tpl(GetISystem()->GetAISystem()->GetPerceptionValue(NULL),0.0f,10.0f);
		pGameTokenSystem->SetOrCreateToken("hud.stealth",TFlowInputData(fStealthValue,true));
		pGameTokenSystem->SetOrCreateToken("hud.compass",TFlowInputData((pPlayerActor ? pPlayerActor->GetAngles().z : 0.0f),true));

		CWeapon *pWeapon = GetWeapon();
		if(pWeapon)
		{
			float fScaleX = GetScaleX();
			float fScaleY = GetScaleY();

			Vec3 vWorldPos;
			Vec3 vScreenSpace;

			vWorldPos = pWeapon->GetSlotHelperPos(CItem::eIGS_FirstPerson,ATTACHMENT_BOTTOM,true);
			m_pRenderer->ProjectToScreen(vWorldPos.x,vWorldPos.y,vWorldPos.z,&vScreenSpace.x,&vScreenSpace.y,&vScreenSpace.z);

			pGameTokenSystem->SetOrCreateToken("hud.WSGrenadeX",TFlowInputData(vScreenSpace.x*fScaleX,true));
			pGameTokenSystem->SetOrCreateToken("hud.WSGrenadeY",TFlowInputData(vScreenSpace.y*fScaleY,true));

			vWorldPos = pWeapon->GetSlotHelperPos(CItem::eIGS_FirstPerson,ATTACHMENT_SILENCER,true);
			m_pRenderer->ProjectToScreen(vWorldPos.x,vWorldPos.y,vWorldPos.z,&vScreenSpace.x,&vScreenSpace.y,&vScreenSpace.z);

			pGameTokenSystem->SetOrCreateToken("hud.WSBarrelX",TFlowInputData(vScreenSpace.x*fScaleX,true));
			pGameTokenSystem->SetOrCreateToken("hud.WSBarrelY",TFlowInputData(vScreenSpace.y*fScaleY,true));

			vWorldPos = pWeapon->GetSlotHelperPos(CItem::eIGS_FirstPerson,ATTACHMENT_TOP,true);
			m_pRenderer->ProjectToScreen(vWorldPos.x,vWorldPos.y,vWorldPos.z,&vScreenSpace.x,&vScreenSpace.y,&vScreenSpace.z);

			pGameTokenSystem->SetOrCreateToken("hud.WSScopesX",TFlowInputData(vScreenSpace.x*fScaleX,true));
			pGameTokenSystem->SetOrCreateToken("hud.WSScopesY",TFlowInputData(vScreenSpace.y*fScaleY,true));

			vWorldPos = pWeapon->GetSlotHelperPos(CItem::eIGS_FirstPerson,ATTACHMENT_MAGAZINE,true);
			m_pRenderer->ProjectToScreen(vWorldPos.x,vWorldPos.y,vWorldPos.z,&vScreenSpace.x,&vScreenSpace.y,&vScreenSpace.z);

			pGameTokenSystem->SetOrCreateToken("hud.WSClipsX",TFlowInputData(vScreenSpace.x*fScaleX,true));
			pGameTokenSystem->SetOrCreateToken("hud.WSClipsY",TFlowInputData(vScreenSpace.y*fScaleY,true));

			vWorldPos = pWeapon->GetSlotHelperPos(CItem::eIGS_FirstPerson,ATTACHMENT_SIDE,true);
			m_pRenderer->ProjectToScreen(vWorldPos.x,vWorldPos.y,vWorldPos.z,&vScreenSpace.x,&vScreenSpace.y,&vScreenSpace.z);

			pGameTokenSystem->SetOrCreateToken("hud.WSFrontSideRailX",TFlowInputData(vScreenSpace.x*fScaleX,true));
			pGameTokenSystem->SetOrCreateToken("hud.WSFrontSideRailY",TFlowInputData(vScreenSpace.y*fScaleY,true));
		}

		const float fOffset = 0.0001f;

		// Damages

		float fValue;
		GetISystem()->GetIGame()->GetIGameFramework()->GetIGameTokenSystem()->GetTokenValueAs("hud.health",fValue);

		int iCamoDamageBeingApplied = 0;
		if (pPlayerActor)
			pPlayerActor->GetEntity()->GetScriptTable()->GetValue("camoDamageBeingApplied",iCamoDamageBeingApplied);

		if(pPlayerActor && m_fHealth > fValue && (fValue < 5 || (m_fHealth - fValue) > 1.9f) && !iCamoDamageBeingApplied)
		{
			Vec3 vHitDir;
			pPlayerActor->GetEntity()->GetScriptTable()->GetValue("hit_dir",vHitDir);

			Vec3 vHeadDir = FORWARD_DIRECTION;
			IMovementController *pMovementController = pPlayerActor->GetMovementController();
      if(pMovementController)
			{
				SMovementState sMovementState;
				pMovementController->GetMovementState(sMovementState);
				vHeadDir = sMovementState.eyeDirection;
			}

			bool bAll = false;

			if(	vHitDir.x < fOffset &&
					vHitDir.y < fOffset &&
					vHitDir.z < fOffset)
			{
				bAll = true;
			}

			Vec3 vRightDir = vHeadDir.Cross(Vec3(0,0,1));
			float fFront = -vHeadDir.Dot(vHitDir);
			float fRight = -vRightDir.Dot(vHitDir);
			if(m_pGameFlashAnimationDamage)
			{
				IFlashPlayer *pFlashPlayer = m_pGameFlashAnimationDamage->GetFlashPlayer();

				if(	pFlashPlayer->IsAvailable("Damage.DamageNorth") &&
						pFlashPlayer->IsAvailable("Damage.DamageSouth") &&		
						pFlashPlayer->IsAvailable("Damage.DamageWest")	&&
						pFlashPlayer->IsAvailable("Damage.DamageEast"))
				{
					if(fFront < 0 || bAll)
					{
						pFlashPlayer->Invoke("Damage.DamageNorth.gotoAndPlay","%d",2);
					}
					if(fFront > 0 || bAll)
					{
						pFlashPlayer->Invoke("Damage.DamageSouth.gotoAndPlay","%d",2);
					}
					if(fRight < 0 || bAll)
					{
						pFlashPlayer->Invoke("Damage.DamageWest.gotoAndPlay","%d",2);
					}
					if(fRight > 0 || bAll)
					{
						pFlashPlayer->Invoke("Damage.DamageEast.gotoAndPlay","%d",2);
					}
				}
			}
		}

		if(m_pGameFlashAnimationDamage)
		{
			m_pGameFlashAnimationDamage->Update(frameTime);
			m_pGameFlashAnimationDamage->Render();
		}

		m_fHealth = fValue;

		// Target autoaim

		IEntity* pEntityTargetAutoaim = GetISystem()->GetIEntitySystem()->GetEntity(m_entityTargetAutoaimId);
		if (pEntityTargetAutoaim == 0)
		{
			m_entityTargetAutoaimId = 0;
		}
		else
		{	
      AABB box;
      pEntityTargetAutoaim->GetWorldBounds(box);

			// We should be outside the screen with these values

			float fMinX = +100000.0f;
			float fMinY = +100000.0f;
			float fMinZ = +100000.0f;

			float fMaxX = -100000.0f;
			float fMaxY = -100000.0f;
			float fMaxZ = -100000.0f;

#define GETMINMAX(fX,fY,fZ)\
{\
	Vec3 vEntityScreenSpace;\
	m_pRenderer->ProjectToScreen(fX,fY,fZ,&vEntityScreenSpace.x,&vEntityScreenSpace.y,&vEntityScreenSpace.z);\
	fMinX = MIN(fMinX,vEntityScreenSpace.x);\
	fMinY = MIN(fMinY,vEntityScreenSpace.y);\
	fMinZ = MIN(fMinZ,vEntityScreenSpace.z);\
	fMaxX = MAX(fMaxX,vEntityScreenSpace.x);\
	fMaxY = MAX(fMaxY,vEntityScreenSpace.y);\
	fMaxZ = MAX(fMaxZ,vEntityScreenSpace.z);\
}

			GETMINMAX(box.min.x,box.min.y,box.min.z);
			GETMINMAX(box.min.x,box.min.y,box.max.z);
			GETMINMAX(box.min.x,box.max.y,box.min.z);
			GETMINMAX(box.min.x,box.max.y,box.max.z);
			GETMINMAX(box.max.x,box.min.y,box.min.z);
			GETMINMAX(box.max.x,box.min.y,box.max.z);
			GETMINMAX(box.max.x,box.max.y,box.min.z);
			GETMINMAX(box.max.x,box.max.y,box.max.z);

			float fScaleX = GetScaleX();
			float fScaleY = GetScaleY();

			char strX[16];
			char strY[16];
			if(m_pGameFlashAnimationTargetAutoaim)
			{
				Vec3 vEntityScreenSpace;
				m_pRenderer->ProjectToScreen(box.GetCenter().x,box.GetCenter().y,box.GetCenter().z,&vEntityScreenSpace.x,&vEntityScreenSpace.y,&vEntityScreenSpace.z);
				sprintf(strX,"%f",vEntityScreenSpace.x*fScaleX-450.0f-64.0f);
				sprintf(strY,"%f",vEntityScreenSpace.y*fScaleY-475.0f-8.0f);
				m_pGameFlashAnimationTargetAutoaim->GetFlashPlayer()->SetVariable("Root.TargetLockText._x",strX);
				m_pGameFlashAnimationTargetAutoaim->GetFlashPlayer()->SetVariable("Root.TargetLockText._y",strY);

				sprintf(strX,"%f",fMinX*fScaleX);
				sprintf(strY,"%f",fMinY*fScaleY);
				m_pGameFlashAnimationTargetAutoaim->GetFlashPlayer()->SetVariable("Root.CornerTopLeft._x",strX);
				m_pGameFlashAnimationTargetAutoaim->GetFlashPlayer()->SetVariable("Root.CornerTopLeft._y",strY);

				sprintf(strX,"%f",fMaxX*fScaleX);
				sprintf(strY,"%f",fMinY*fScaleY);
				m_pGameFlashAnimationTargetAutoaim->GetFlashPlayer()->SetVariable("Root.CornerTopRight._x",strX);
				m_pGameFlashAnimationTargetAutoaim->GetFlashPlayer()->SetVariable("Root.CornerTopRight._y",strY);

				sprintf(strX,"%f",fMinX*fScaleX);
				sprintf(strY,"%f",fMaxY*fScaleY);
				m_pGameFlashAnimationTargetAutoaim->GetFlashPlayer()->SetVariable("Root.CornerBottomLeft._x",strX);
				m_pGameFlashAnimationTargetAutoaim->GetFlashPlayer()->SetVariable("Root.CornerBottomLeft._y",strY);

				sprintf(strX,"%f",fMaxX*fScaleX);
				sprintf(strY,"%f",fMaxY*fScaleY);
				m_pGameFlashAnimationTargetAutoaim->GetFlashPlayer()->SetVariable("Root.CornerBottomRight._x",strX);
				m_pGameFlashAnimationTargetAutoaim->GetFlashPlayer()->SetVariable("Root.CornerBottomRight._y",strY);
			}
		}

		if(m_pGameFlashAnimationTargetAutoaim)
		{
			m_pGameFlashAnimationTargetAutoaim->Update(frameTime);
			m_pGameFlashAnimationTargetAutoaim->Render();
		}

		// Target lock
		IEntity* pEntityTargetLock = GetISystem()->GetIEntitySystem()->GetEntity(m_entityTargetLockId);
		if (pEntityTargetLock == 0)
		{
			m_entityTargetLockId = 0;
		}
		else
		{	
      AABB box;
      pEntityTargetLock->GetWorldBounds(box);

      Vec3 vWorldPos = box.GetCenter();
			Vec3 vEntityScreenSpace;
			m_pRenderer->ProjectToScreen(	vWorldPos.x,
																		vWorldPos.y,
																		vWorldPos.z,
																		&vEntityScreenSpace.x,
																		&vEntityScreenSpace.y,
																		&vEntityScreenSpace.z);
			float fScaleX = GetScaleX();
			float fScaleY = GetScaleY();

			char strX[16];
			char strY[16];
			sprintf(strX,"%f",vEntityScreenSpace.x*fScaleX-512.0f); // FIXME: From where does this 512x384 offset is coming???
			sprintf(strY,"%f",vEntityScreenSpace.y*fScaleY-384.0f);
			if(m_pGameFlashAnimationTargetLock)
			{
				m_pGameFlashAnimationTargetLock->GetFlashPlayer()->SetVariable("Root.Cursor._x",strX);
				m_pGameFlashAnimationTargetLock->GetFlashPlayer()->SetVariable("Root.Cursor._y",strY);
			}
		}

		if(m_pGameFlashAnimationTargetLock)
		{
			m_pGameFlashAnimationTargetLock->Update(frameTime);
			m_pGameFlashAnimationTargetLock->Render();
		}

		// Projections offsets

		float fProjectionsOffsetX=0;
		float fProjectionsOffsetY=0;
		if(	pGameTokenSystem->GetTokenValueAs("hud.offsetx",fProjectionsOffsetX) &&
				pGameTokenSystem->GetTokenValueAs("hud.offsety",fProjectionsOffsetY))
		{
			float fScale = 60.0f;

			fProjectionsOffsetX *= fScale;
			fProjectionsOffsetY *= fScale;
		}

		{
			float fAlpha;
			if(pGameTokenSystem->GetTokenValueAs("hud.alpha",fAlpha))
			{
				if(fabsf(fAlpha-m_fPrevAlpha) > fOffset)
				{
					m_fPrevAlpha = fAlpha;
					for(TGameFlashAnimationsList::iterator iter=m_gameFlashAnimationsList.begin(); iter!=m_gameFlashAnimationsList.end(); iter++)
					{
						CGameFlashAnimation *pGameFlashAnimation = (*iter);
						if(pGameFlashAnimation->GetFlashPlayer()->IsAvailable("setAlpha"))
						{
							pGameFlashAnimation->GetFlashPlayer()->Invoke("setAlpha","%f",fAlpha);
						}
					}
					m_pHUDAmmo	->SetFadeValue(fAlpha);
					m_pHUDRadar	->SetFadeValue(fAlpha);
				}
			}
		}

		{
			bool bUpdateProjections = false;
			if(	fabsf(fProjectionsOffsetX-m_fPrevProjectionOffsetX) > fOffset &&
					fabsf(fProjectionsOffsetY-m_fPrevProjectionOffsetY) > fOffset)
			{
				m_fPrevProjectionOffsetX = fProjectionsOffsetX;
				m_fPrevProjectionOffsetY = fProjectionsOffsetY;
				bUpdateProjections = true;
			}
			for(TGameFlashAnimationsList::iterator iter=m_gameFlashAnimationsList.begin(); iter!=m_gameFlashAnimationsList.end(); iter++)
			{
				CGameFlashAnimation *pGameFlashAnimation = (*iter);

				{
					FRAME_PROFILER("HUD_0a", GetISystem(), PROFILE_GAME);
					if(bUpdateProjections)
					{
						if(pGameFlashAnimation->GetFlashPlayer()->IsAvailable("setProjectionsOffset"))
						{
							pGameFlashAnimation->GetFlashPlayer()->Invoke("setProjectionsOffset","%f %f",fProjectionsOffsetX,fProjectionsOffsetY);
						}
					}
				}
				{
					FRAME_PROFILER("HUD_0b", GetISystem(), PROFILE_GAME);
					pGameFlashAnimation->Update(frameTime);
				}
				{
					FRAME_PROFILER("HUD_0c", GetISystem(), PROFILE_GAME);
					pGameFlashAnimation->Render();
				}
			}
		}

		// Autosnap

		if(m_bAutosnap)
		{
			const float fRadius = 50.0f;
			static Vec2 s_vCursor = Vec2(0,0);
			s_vCursor.x = m_fAutosnapCursorRelativeX;
			s_vCursor.y = m_fAutosnapCursorRelativeY;
			if(m_bOnCircle && s_vCursor.len() < fRadius*0.5f)
			{
				m_fAutosnapCursorRelativeX = 0;
				m_fAutosnapCursorRelativeY = 0;
				m_bOnCircle = false;
			}
			if(s_vCursor.len() > fRadius)
			{
				s_vCursor.normalize();
				m_fAutosnapCursorRelativeX = s_vCursor.x*fRadius;
				m_fAutosnapCursorRelativeY = s_vCursor.y*fRadius;
				m_bOnCircle = true;
			}
			if(m_bOnCircle)
			{
				Vec2 vCursor = s_vCursor;
				vCursor.normalize();

/*				ColorB col(255,255,255,255);
				int iW=m_pRenderer->GetWidth();
				int iH=m_pRenderer->GetHeight();
				m_pRenderer->Set2DMode(true,iW,iH);
				m_pRenderer->GetIRenderAuxGeom()->DrawLine(Vec3(iW/2,iH/2,0),col,Vec3(iW/2+vCursor.x*100,iH/2+vCursor.y*100,0),col,5);
				m_pRenderer->Set2DMode(false,0,0);*/

				float fAngle;
				if(vCursor.y < 0)
				{
					fAngle = RAD2DEG(acosf(vCursor.x));
				}
				else
				{
					fAngle = RAD2DEG(gf_PI2-acosf(vCursor.x));
				}

//				HUD_TRACE("Angle=%f\n",fAngle);

				if(fAngle >= 315 || fAngle < 45)
				{
					if(m_pGameFlashAnimationQuickMenu)
					{
						m_pGameFlashAnimationQuickMenu->GetFlashPlayer()->Invoke("Root.QuickMenu.setAutosnapItem","%s","Cloak");
					}
				}
				else if(fAngle >= 45 && fAngle < 135)
				{
					if(m_pGameFlashAnimationQuickMenu)
					{
						m_pGameFlashAnimationQuickMenu->GetFlashPlayer()->Invoke("Root.QuickMenu.setAutosnapItem","%s","Weapon");
					}
				}
				else if(fAngle >= 135 && fAngle < 165)
				{
					if(m_pGameFlashAnimationQuickMenu)
					{
						m_pGameFlashAnimationQuickMenu->GetFlashPlayer()->Invoke("Root.QuickMenu.setAutosnapItem","%s","Speed");
					}
				}
				else if(fAngle >= 165 && fAngle < 190)
				{
					if(m_pGameFlashAnimationQuickMenu)
					{
						m_pGameFlashAnimationQuickMenu->GetFlashPlayer()->Invoke("Root.QuickMenu.setAutosnapItem","%s","Strength");
					}
				}
				else if(fAngle >= 190 && fAngle < 225)
				{
					if(m_pGameFlashAnimationQuickMenu)
					{
						m_pGameFlashAnimationQuickMenu->GetFlashPlayer()->Invoke("Root.QuickMenu.setAutosnapItem","%s","Defense");
					}
				}
				else if(fAngle >= 225 && fAngle < 315)
				{
					if(m_pGameFlashAnimationQuickMenu)
					{
						m_pGameFlashAnimationQuickMenu->GetFlashPlayer()->Invoke("Root.QuickMenu.setAutosnapItem","%s","Default");
					}
				}
			}
			else
			{
				if(m_pGameFlashAnimationQuickMenu)
				{
					m_pGameFlashAnimationQuickMenu->GetFlashPlayer()->Invoke("Root.QuickMenu.setAutosnapItem","%s","Center");
				}
			}
		}

		// Non flash stuff

		m_pHUDDraw->PreRender();

		{
			FRAME_PROFILER("HUD_1", GetISystem(), PROFILE_GAME);
			for(THUDObjectsList::iterator iter=m_hudObjectsList.begin(); iter!=m_hudObjectsList.end(); iter++)
			{
				if(((*iter) == m_pHUDCrosshair && !m_iCursorVisibilityCounter && !m_bAutosnap && !m_bHideCrosshair) || (*iter) != m_pHUDCrosshair)
				{
					(*iter)->Update(frameTime);
				}
			}
		}

		/*if(m_bDemoMode)
		{
			m_pHUDDraw->DrawText(400,30,"Demo mode activated",0.8f,0.76f,0.97f,0.74f,HUDDRAWHORIZONTAL_CENTER);
		}*/

		if(!m_onScreenMessage.empty())
		{
			float time = GetISystem()->GetITimer()->GetCurrTime();
			if(time - m_onScrMsgStart < 4) //display 4 seconds
			{
				float alpha = 0.75f;
				if(time - m_onScrMsgStart < 0.75f)		//fade in
					alpha = (time - m_onScrMsgStart);
				else if(time - m_onScrMsgStart > 3.25f)		//fade out
					alpha -= ((time - m_onScrMsgStart) - 3.25f);
				m_pHUDDraw->DrawText(400,15,m_onScreenMessage.c_str(),alpha,0.76f,0.97f,0.74f,HUDDRAWHORIZONTAL_CENTER);
			}
			else
				m_onScreenMessage.clear();
		}

		if(!m_onScreenText.empty())
		{
			if(GetISystem()->GetITimer()->GetCurrTime() - m_onScrTextStart < 2) //display 2 seconds
				m_pHUDDraw->DrawText(400,550,m_onScreenText.c_str(),0.8f,0.76f,0.97f,0.74f,HUDDRAWHORIZONTAL_CENTER);
			else
				m_onScreenText.clear();
		}

		if(!m_onScrMission.empty())
		{
			float time = GetISystem()->GetITimer()->GetCurrTime();
			if(time - m_onScrMisStart < 4) //display 4 seconds (1.5s fading)
			{
				float alpha = 0.75f;
				if(time - m_onScrMisStart < 0.75f)		//fade in
					alpha = (time - m_onScrMisStart);
				else if(time - m_onScrMisStart > 3.25f)		//fade out
					alpha -= ((time - m_onScrMisStart) - 3.25f);
				m_pHUDDraw->DrawText(400,40,m_onScrMission.c_str(),alpha,0.76f,0.97f,0.74f,HUDDRAWHORIZONTAL_CENTER);
			}
			else
				m_onScrMission.clear();
		}

		m_pHUDDraw->DrawText(10,60,m_strGODMode,0.75f,1,1,1,HUDDRAWHORIZONTAL_LEFT);
		//debugging : render number of deaths in God mode ...
		if(!strcmp(m_strGODMode,"GOD") || !strcmp(m_strGODMode,"Team GOD"))
		{
			string died("You died ");
			char aNumber[4];
			itoa(m_iDeaths, aNumber, 10);
			died.append(aNumber);
			died.append(" times.");
			m_pHUDDraw->DrawText(10,80,died.c_str(),0.75f,1,1,1,HUDDRAWHORIZONTAL_LEFT);
		}

		if(m_iCursorVisibilityCounter)
		{
			FRAME_PROFILER("HUD_2", GetISystem(), PROFILE_GAME);
			m_pHUDDraw->DrawImage(m_iTextureIDCursor,m_fCursorX,m_fCursorY,32,32,0,1,1,1,1);
		}

		FRAME_PROFILER("HUD_3", GetISystem(), PROFILE_GAME);
		m_pHUDDraw->PostRender();
	}

	//check for NanoSuit energy drop
	if(m_pNanoSuit->GetSuitEnergy() < 20 && m_pNanoSuit->GetCloaked())
	{
		CPlayer *pPlayer = static_cast<CPlayer *>(GetISystem()->GetIGame()->GetIGameFramework()->GetClientActor());
		(*(pPlayer->GetPlayerInput()))->OnAction("suitsilence", eAAM_OnPress, 1.0f);
		(*(pPlayer->GetPlayerInput()))->OnAction("suitcamoflage", eAAM_OnPress, 1.0f);
		m_pNanoSuit->SwitchCloaked();
	}
	if(m_fSuitEnergy > 50.0f && m_pNanoSuit->GetSuitEnergy() < 50)
	{
		SGameObjectEvent evt ("HUD_TextMessage", 0, IGameObjectSystem::InvalidExtensionID, (void*)("energy_critical"));
		HandleEvent(evt);
	}
	m_fSuitEnergy = m_pNanoSuit->GetSuitEnergy();
}

//-----------------------------------------------------------------------------------------------------

//handles global and local message events
void CHUD::HandleEvent(const SGameObjectEvent &rGameObjectEvent)
{

	// We show the HUD during the game, we hide it during the menu

	if(0 == strcmp(rGameObjectEvent.event,"StartGame"))
	{
		m_iFade = 8;
	}
	else if(0 == strcmp(rGameObjectEvent.event,"PauseGame"))
	{
		m_bShow = false;
	}
	else if(0 == strcmp(rGameObjectEvent.event,"ResumeGame"))
	{
		if(0 == m_iFade)
		{
			m_bShow = true;
		}
	}
	else if(0 == strcmp(rGameObjectEvent.event,"MultiplayerChatMessage"))
	{
		m_pHUDTextChat->AddChatMessage((const char*)rGameObjectEvent.param);
	}
	else if(0 == strcmp(rGameObjectEvent.event,"OnUsableMessageOn"))
	{
		m_pHUDCrosshair->SetUsable(true);
	}
	else if(0 == strcmp(rGameObjectEvent.event,"OnUsableMessageOff"))
	{
		m_pHUDCrosshair->SetUsable(false);
	}
	else if(0 == strcmp(rGameObjectEvent.event,"HUD_SwitchWeaponSelectorInterfaceOn"))
	{
		m_bIgnoreMiddleClick = false;

		CWeapon *pWeapon = GetWeapon();
		assert(pWeapon);

		if(pWeapon && m_pGameFlashAnimationWeaponSelector)
		{
			bool bGrenadeLauncher = false;
			CPlayer *pPlayer = static_cast<CPlayer *>(GetISystem()->GetIGame()->GetIGameFramework()->GetClientActor());
			if(pPlayer)
			{
				IGameObject *pGameObject = pPlayer->GetGameObject();
				if(pGameObject)
				{
					IInventory *pInventory = static_cast<IInventory *>(pGameObject->QueryExtension("Inventory"));
					if(pInventory)
					{
						bGrenadeLauncher = !(pInventory->GetItemByClass("GrenadeLauncher") == 0);
					}
				}
			}

			m_pGameFlashAnimationWeaponSelector->GetFlashPlayer()->Invoke("Root.WSArea.setWeapon",				"%s %d",pWeapon->GetEntity()->GetClass()->GetName(),bGrenadeLauncher);
			m_pGameFlashAnimationWeaponSelector->GetFlashPlayer()->Invoke("Root.WSArea.setGrenade",				"%s",pWeapon->CurrentAttachment(ATTACHMENT_BOTTOM).c_str());
			m_pGameFlashAnimationWeaponSelector->GetFlashPlayer()->Invoke("Root.WSArea.setBarrel",				"%s",pWeapon->CurrentAttachment(ATTACHMENT_SILENCER).c_str());
			m_pGameFlashAnimationWeaponSelector->GetFlashPlayer()->Invoke("Root.WSArea.setScopes",				"%s",pWeapon->CurrentAttachment(ATTACHMENT_TOP).c_str());
			m_pGameFlashAnimationWeaponSelector->GetFlashPlayer()->Invoke("Root.WSArea.setClips",					"%s",pWeapon->CurrentAttachment(ATTACHMENT_MAGAZINE).c_str());
			m_pGameFlashAnimationWeaponSelector->GetFlashPlayer()->Invoke("Root.WSArea.setFrontSideRail",	"%s",pWeapon->CurrentAttachment(ATTACHMENT_SIDE).c_str());
			m_pGameFlashAnimationWeaponSelector->GetFlashPlayer()->Invoke("Root.WSArea.showWeaponSelector","");
		}
	}
	else if(0 == strcmp(rGameObjectEvent.event,"HUD_SwitchWeaponSelectorInterfaceOff"))
	{
		m_bIgnoreMiddleClick = true;

		if(m_pGameFlashAnimationAmmo)
		{
			m_pGameFlashAnimationAmmo->GetFlashPlayer()->Invoke("Root.AmmoArea.hideAmmo","");
			PlaySound(ESound_SuitMenuDisappear);
		}
		if(m_pGameFlashAnimationWeaponSelector)
		{
			m_pGameFlashAnimationWeaponSelector->GetFlashPlayer()->Invoke("Root.WSArea.hideWeaponSelector","");
		}
	}
	else if (m_bDemoMode && (0 == strcmp(rGameObjectEvent.event,"HUD_DemoMessage")))
	{
		const char* param = (const char*) rGameObjectEvent.param;
		assert (0 != param);

		//triggered flash animation available?
		//InvokeIntroduction(param, true);

		if(m_demoMessages->haveAttr(param))
		{
			//show text message if existing
			const char* message = 0;
			message = m_demoMessages->getAttr(param);
			if(message)
			{
				m_onScreenMessage = string("Demo Mode: ");
				m_onScreenMessage.append(message);
				m_onScrMsgStart = GetISystem()->GetITimer()->GetCurrTime();
			}
		}
	}
	else if (0 == strcmp(rGameObjectEvent.event,"HUD_TextMessage"))  //textMessages are also used as statusMessages
	{
		const char* message = (const char*) rGameObjectEvent.param;

		if(message)
		{
			//DEBUG : used for balancing
			if(!strcmp(message, "GodMode:died!"))
			{
				m_iDeaths++;
				m_pNanoSuit->ResetEnergy();
				return;
			}
			//VS2 hack
			if(!strcmp(message, "temperature_cloak_disabled"))
			{
				if(m_pNanoSuit->GetCloaked())
					m_pNanoSuit->SwitchCloaked();
			}
			//find a vocal/sound to a text string ...
			const char* textMessage = 0;
			textMessage = m_statusMessages->getAttr(message);
			if(textMessage && strcmp(textMessage, ""))	//if known status message
			{
				PlayStatusSound(message);  //trigger vocals
				message = textMessage; //change to localized message for text rendering
			}
			//display message
			string newText(message);
			if(m_onScreenText != newText) //the text is deleted when finished displaying - don't restart it
			{
				m_onScreenText = newText;
				m_onScrTextStart = GetISystem()->GetITimer()->GetCurrTime();
			}
		}
	}
	else if (0 == strcmp(rGameObjectEvent.event,"HUD_LongTextMessage"))
	{
		const char* message = (const char*) rGameObjectEvent.param;

		if(message)
		{
			//display message
			string newText(message);
			if(m_onScreenText != newText) //the text is deleted when finished displaying - don't restart it
			{
				m_onScreenText = newText;
				m_onScrTextStart = GetISystem()->GetITimer()->GetCurrTime() + 2;//make it last longer!
			}
		}
	}
	else if (0 == stricmp(rGameObjectEvent.event, "hud_targetlock"))
	{
		const char* param = (const char*) rGameObjectEvent.param;
		assert (0 != param);
		EntityId id = 0;
		sscanf(param, "%u", &id);
		if (id != 0)
		{
			m_entityTargetLockId = id;
			if(m_pGameFlashAnimationTargetLock)
				m_pGameFlashAnimationTargetLock->GetFlashPlayer()->Invoke("Root.setTargetLockVisible","%d",1);
		}
		else
		{
			m_entityTargetLockId = id;
		}
	}
	else if (0 == stricmp(rGameObjectEvent.event, "hud_targetunlock"))
	{
		m_entityTargetLockId = 0;
		if(m_pGameFlashAnimationTargetLock)
			m_pGameFlashAnimationTargetLock->GetFlashPlayer()->Invoke("Root.setTargetLockVisible","%d",0);
	}
	else if (0 == stricmp(rGameObjectEvent.event,"hud_tagbullet"))
	{
		if(m_pGameFlashAnimationWeaponSelector)
			m_pGameFlashAnimationWeaponSelector->GetFlashPlayer()->Invoke("Root.WSArea.addTagBullet","");
		m_pHUDRadar->AddTagBullet((EntityId)(UINT_PTR)rGameObjectEvent.param);
	}
	else if (0 == stricmp(rGameObjectEvent.event,"HUD_AutoaimLocking"))
	{
		m_entityTargetAutoaimId = (EntityId)(UINT_PTR)(rGameObjectEvent.param);
		if(m_pGameFlashAnimationTargetAutoaim)
			m_pGameFlashAnimationTargetAutoaim->GetFlashPlayer()->Invoke("Root.setTargetAutoaimLocking","");
	}
	else if (0 == stricmp(rGameObjectEvent.event,"HUD_AutoaimLocked"))
	{
		m_bHideCrosshair = true;
    m_entityTargetAutoaimId = (EntityId)(UINT_PTR)(rGameObjectEvent.param);
		if(m_pGameFlashAnimationTargetAutoaim)
			m_pGameFlashAnimationTargetAutoaim->GetFlashPlayer()->Invoke("Root.setTargetAutoaimLocked","");
	}
	else if (0 == stricmp(rGameObjectEvent.event,"HUD_AutoaimUnlock"))
	{
		m_bHideCrosshair = false;
		m_entityTargetLockId = 0;
		if(m_pGameFlashAnimationTargetAutoaim)
			m_pGameFlashAnimationTargetAutoaim->GetFlashPlayer()->Invoke("Root.setTargetAutoaimUnlock","");
	}
	else if(!strcmp(rGameObjectEvent.event, "HUD_PDAMessage"))
	{
		const char* message = m_missionObjectiveSystem.GetMissionObjectiveDescription((const char*)rGameObjectEvent.param);
		if(message)
		{
				m_onScrMission = string("New Objective: ");
				m_onScrMission.append(message);
				m_onScrMisStart = GetISystem()->GetITimer()->GetCurrTime();

				// FIXME: because of crappy Scaleform, just after loading time, this does not work
				if(m_pGameFlashAnimationPDA)
					m_pGameFlashAnimationPDA->GetFlashPlayer()->Invoke("Root.PDAMC.setObjective","%s",(const char*) rGameObjectEvent.param);
				SGameObjectEvent evt ("HUD_TextMessage", 0, IGameObjectSystem::InvalidExtensionID, (void*)("pda_updated"));
				HandleEvent(evt);
		}
		//also look for a triggered first time introduction
		InvokeIntroduction((const char*) rGameObjectEvent.param);
	}
	else if(!strcmp(rGameObjectEvent.event, "NANOSUIT_UsingStrength"))
		m_pNanoSuit->SetStrengthUsed();
}
//-----------------------------------------------------------------------------------------------------
void CHUD::UpdateObjective(CHUDMissionObjective *pObjective)
{
	const char *status;

	switch (pObjective->GetStatus())
	{
	case CHUDMissionObjective::ACTIVATED:
		status = "ACTIVATED";
		break;
	case CHUDMissionObjective::DEACTIVATED:
		status = "DEACTIVATED";
		break;
	case CHUDMissionObjective::COMPLETED:
		status = "COMPLETED";
		break;
	case CHUDMissionObjective::FAILED:
		status = "FAILED";
		break;
	}
	string message;
	message = pObjective->GetMessage();

	//message+=" ";
	//message+=status;

	// FIXME: because of crappy Scaleform, just after loading time, this does not work
	if(m_pGameFlashAnimationPDA)
		m_pGameFlashAnimationPDA->GetFlashPlayer()->Invoke("Root.PDAMC.setObjective","%s", message.c_str());
}

//-----------------------------------------------------------------------------------------------------

void CHUD::InvokeIntroduction(const char* entityName)
{
	string encounterName(entityName);
	if(m_pGameFlashAnimationPDA &&  m_FTE.FirstTimer(encounterName))
	{
		const char *test = m_pGameFlashAnimationPDA->GetFlashPlayer()->Invoke("Root.PDAMC.setScanData","%s", encounterName.c_str());
		if(strcmp(test, "undefined"))
		{
			SGameObjectEvent evt ("HUD_TextMessage", 0, IGameObjectSystem::InvalidExtensionID, (void*)("pda_updated"));
			HandleEvent(evt);
		}
	}
}

//-----------------------------------------------------------------------------------------------------

void CHUD::AddToScoreBoard(const char* player, int kills, int deaths)
{
	m_pHUDScore->AddEntry(player, kills, deaths);
}

//-----------------------------------------------------------------------------------------------------

void CHUD::CheckForLevelChange()
{
	const char* levelName = g_pGame->GetIGameFramework()->GetLevelName();
	if(strcmp(levelName, m_levelName.c_str()) != 0)
	{
		m_iDeaths = 0;

		//get hudLevelData (currently a list of firstTimeEncounters ...)
		m_FTE.LoadLevelEncounters(levelName);
		
		//update current mission objectives
		m_missionObjectiveSystem.LoadLevelObjectives(levelName);

		m_levelName = string(levelName);
	}
}

//-----------------------------------------------------------------------------------------------------

void CHUD::ProcessEvent( SEntityEvent &rEntityEvent )
{
	switch (rEntityEvent.event)
	{
	case ENTITY_EVENT_START_LEVEL:
		CheckForLevelChange();		//check whether a new level was loaded ...
		SGameObjectEvent evt ("StartGame", 0);
		HandleEvent(evt);
		break;
	}
}

//-----------------------------------------------------------------------------------------------------

CHUD *CHUD::GetHUD(void)
{
	return static_cast<CHUD*> (s_pHUD);
}

//-----------------------------------------------------------------------------------------------------



//-----------------------------------------------------------------------------------------------------
//-- ISystemEventListener
//-----------------------------------------------------------------------------------------------------

void CHUD::OnResize(int width, int height)
{
	// Specific functionality
	if(m_pGameFlashAnimationDamage)
		RepositionFlashAnimation(m_pGameFlashAnimationDamage, width, height);

	// Shared resize functionality
	CHUDCommon::OnResize(width, height);
}

//-----------------------------------------------------------------------------------------------------
//-- ~ ISystemEventListener
//-----------------------------------------------------------------------------------------------------

void CHUD::ShowTextField(bool show)
{
	char strValue[64];
	sprintf(strValue,"%f",((float)show)*100.0f);
	if(m_pGameFlashAnimationTextField)
		m_pGameFlashAnimationTextField->GetFlashPlayer()->SetVariable("_root.TextField._alpha", strValue);
}

void CHUD::OnActionTweak(const char *actionName, int activationMode, float value) {
	// Just forward to the HUD Tweak menu
	m_pHUDTweakMenu->OnActionTweak(actionName, activationMode, value);
}


//-----------------------------------------------------------------------------------------------------

