/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2005.
-------------------------------------------------------------------------
$Id$
$DateTime$
Description: 
	Header for G02 CHUD class

-------------------------------------------------------------------------
History:
- 07:11:2005: Created by Julien Darre
- 01:02:2006: Modified by Jan Mller
- 22:02:2006: Refactored for G04 by Matthew Jack

*************************************************************************/
#ifndef __HUD_H__
#define __HUD_H__

//-----------------------------------------------------------------------------------------------------

#include "HUDCommon.h"
#include "IFlashPlayer.h"
#include "IActionMapManager.h"
#include "NanoSuit.h"

#include "HUDFirstTimeEncounters.h"
#include "HUDMissionObjectiveSystem.h"

//-----------------------------------------------------------------------------------------------------

// Forward declarations
struct IRenderer;

class CHUDObject;
class CHUDAmmo;
class CHUDCrosshair;
class CHUDRadar;
class CHUDTextChat;
class CHUDScore;
class CHUDTweakMenu;

class CGameFlashAnimation;

class CWeapon;

//-----------------------------------------------------------------------------------------------------

class CHUD :	public CHUDCommon,
				public IActionListener
{
public:

	// IGameObjectExtension
	virtual bool Init(IGameObject *pGameObject);
	virtual void Serialize(TSerialize ser,unsigned aspects);
	virtual void PostUpdate(float frameTime);
	virtual void HandleEvent(const SGameObjectEvent &rGameObjectEvent);
	virtual void ProcessEvent(SEntityEvent &rEntityEvent);
	// ~IGameObjectExtension

	// IFSCommandHandler
	void HandleFSCommand(const char *strCommand,const char *strArgs);
	// ~IFSCommandHandler

	// ISystemEventListener
	// Overridden for specific functionality
	void OnResize(int width, int height);
	// ~ISystemEventListener

	// IActionListener
	virtual void OnAction(const ActionId& action, int activationMode, float value);
	// ~IActionListener

						CHUD();
	virtual	~	CHUD();

	//Jan : this function is used to check whether an item or enemy has been encountered before or has to be introduced
	void InvokeIntroduction(const char* entityName);
	CHUDMissionObjectiveSystem& GetMissionObjectiveSystem()
	{
		return m_missionObjectiveSystem;
	}

	void ShowTextField(bool show);

	void UpdateObjective(CHUDMissionObjective* pObjective);

	void OnActionTweak(const char *actionName, int activationMode, float value);



	enum ESound
	{
		ESound_GenericBeep,
		ESound_PresetNavigationBeep,
		ESound_TemperatureBeep,
		ESound_SuitStrengthActivate,
		ESound_SuitSpeedActivate,
		ESound_SuitArmorActivate,
		ESound_SuitMenuAppear,
		ESound_SuitMenuDisappear,
		ESound_WeaponModification,
		ESound_SuitMedicalInUse,
		ESound_SuitStrengthInUse,
		ESound_SuitSpeedInUse,
		//		ESound_SuitDeepFreeze,
		//		ESound_BreathingInMaskColdOneShot
	};

	void PlaySound(ESound eSound, bool play = true);

	void PlayStatusSound(const char* identifier);

	void AddToScoreBoard(const char* player, int kills, int deaths);

private:
	
	static CHUD *GetHUD(void);

	void CheckForLevelChange();

	bool UpdateNanoSlotMax();

	CHUDAmmo			*m_pHUDAmmo;
	CHUDCrosshair *m_pHUDCrosshair;
	CHUDRadar			*m_pHUDRadar;
	CHUDTextChat	*m_pHUDTextChat;
	CHUDTweakMenu	*m_pHUDTweakMenu;
	CHUDScore			*m_pHUDScore;

	//cached pointer to renderer
	IRenderer			*m_pRenderer;

	//different HUD text messages
	string				m_onScreenMessage;
	float					m_onScrMsgStart;
	string				m_onScreenText;
	float					m_onScrTextStart;
	string				m_onScrMission;
	float					m_onScrMisStart;

	//sound related
	float m_fLastSoundPlayedMedical;
	bool  m_bPlayingSpeedSound;
	float m_fSpeedTimer, m_fStrengthTimer, m_fDefenseTimer;

	//this manages the mission objectives
	CHUDMissionObjectiveSystem		m_missionObjectiveSystem;

	//messages that are going to be displayed when a demo is triggered
	XmlNodeRef		m_demoMessages;
	//status messages that are displayed on screen and trigger vocals
	XmlNodeRef    m_statusMessages;
	//Jan : list of first counter objects that invoke an animation
	CFirstTimeEncounters			m_FTE;
	//this is the current level name
	string										m_levelName;
	//used to fetch nanosuit-modifications
	bool					m_bChangedSomething;

	//NanoSuit-pointer for suit interaction
	CNanoSuit    *m_pNanoSuit;
	//NanoSuit
	ENanoSlot m_eNanoSlotMax;
	float m_fHealth;
	bool m_bDemoMode;
	float m_fSuitEnergy;
	
	//interface logic
	bool m_bHideCrosshair;
	bool m_bAutosnap;
	bool m_bIgnoreMiddleClick;
	bool m_bLaunchWS;
	int m_iInterface;
	int m_iTextureIDCursor;
	float m_fPrevProjectionOffsetX, m_fPrevProjectionOffsetY;
	float m_fPrevAlpha;
	int m_iFade;

	//flash anims
	CGameFlashAnimation *m_pGameFlashAnimationAmmo;
	CGameFlashAnimation *m_pGameFlashAnimationCornersLeft;
	CGameFlashAnimation *m_pGameFlashAnimationCornersRight;
	CGameFlashAnimation *m_pGameFlashAnimationDamage;
	CGameFlashAnimation *m_pGameFlashAnimationHealthArmor;
	CGameFlashAnimation *m_pGameFlashAnimationMultiplayerScoreboard;
	CGameFlashAnimation *m_pGameFlashAnimationPDA;
	CGameFlashAnimation *m_pGameFlashAnimationQuickMenu;
	CGameFlashAnimation *m_pGameFlashAnimationRadarCompassStealth;
	CGameFlashAnimation *m_pGameFlashAnimationTargetAutoaim;
	CGameFlashAnimation *m_pGameFlashAnimationTargetLock;
	CGameFlashAnimation *m_pGameFlashAnimationWeaponSelector;
	CGameFlashAnimation *m_pGameFlashAnimationTextField;

	typedef std::list<CHUDObject *> THUDObjectsList;
	THUDObjectsList m_hudObjectsList;

	EntityId m_entityTargetAutoaimId;
	EntityId m_entityTargetLockId;

	float m_fAutosnapCursorRelativeX;
	float m_fAutosnapCursorRelativeY;
	bool m_bOnCircle;
};

//-----------------------------------------------------------------------------------------------------

#endif

//-----------------------------------------------------------------------------------------------------
