/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2005.
-------------------------------------------------------------------------
$Id$
$DateTime$
Description: HUD ammo

-------------------------------------------------------------------------
History:
- 07:11:2005: Created by Julien Darre

*************************************************************************/
#include "StdAfx.h"
#include "HUDAmmo.h"
#include "IGameTokens.h"

//-----------------------------------------------------------------------------------------------------

CHUDAmmo::CHUDAmmo(CHUDDraw *pHUDDraw) : CHUDObject(pHUDDraw)
{
	m_fX = 685.0f;
	m_fY = 461.0f;

	m_iTextureIDNumbers = m_pHUDDraw->CreateTexture("UI\\HUD\\numbers.dds");

	m_fAlpha = 0.0f;
}

//-----------------------------------------------------------------------------------------------------

CHUDAmmo::~CHUDAmmo()
{
}

//-----------------------------------------------------------------------------------------------------

void CHUDAmmo::SetAlpha(float fAlpha)
{
	m_fAlpha = fAlpha;
}

//-----------------------------------------------------------------------------------------------------

void CHUDAmmo::DrawText(float fX,float fY,const char *strText,float fFadeValue)
{
	float fTextX = fX;
	float fTextY = fY;

	float fOffsetX = 16.0f / 256.0f;
	float fOffsetY = 1.0f;

	float fAngle = 15.0f;

	for(int iChar=0; iChar<strlen(strText); iChar++)
	{
		float fU = ((float) (strText[iChar] - 47)) * 16.0f / 256.0f;
		float fV = 0.0f;

		float fSizeX = 8.0f;
		float fSizeY = 16.0f;

		m_pHUDDraw->DrawImage(m_iTextureIDNumbers,fTextX,fTextY,fSizeX,fSizeY,fAngle,1,1,1,fFadeValue,fU,fV,fU+fOffsetX,fV+fOffsetY);

		fTextX += fSizeX;
		fTextY += 1.8f;
	}
}

//-----------------------------------------------------------------------------------------------------

void CHUDAmmo::OnUpdate(float fDeltaTime,float fFadeValue)
{
	int iWeaponAmmo = 0;
	int iWeaponClips = 0;
	int iWeaponClipSize = 0;
	if(	GetIGameTokenSystem()->GetTokenValueAs("hud.weapon.ammo",iWeaponAmmo)		&&
			GetIGameTokenSystem()->GetTokenValueAs("hud.weapon.clips",iWeaponClips)	&&
			GetIGameTokenSystem()->GetTokenValueAs("hud.weapon.clip_size",iWeaponClipSize))
	{
		char strText[32];
		sprintf(strText,"%d/%d",iWeaponAmmo,iWeaponClips*iWeaponClipSize);
		GetISystem()->GetIRenderer()->SetState(GS_BLSRC_SRCALPHA|GS_BLDST_ONE|GS_NODEPTHTEST);
		DrawText(m_fX,m_fY,strText,fFadeValue*m_fAlpha);
		GetISystem()->GetIRenderer()->SetState(GS_BLSRC_SRCALPHA|GS_BLDST_ONEMINUSSRCALPHA|GS_NODEPTHTEST);
	}
}

//-----------------------------------------------------------------------------------------------------