/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2005.
-------------------------------------------------------------------------
$Id$
$DateTime$
Description: 
	Header for CHUDCommon base class
	Shared by G02 and G04


-------------------------------------------------------------------------
History:
- 22:02:2006: Created by Matthew Jack from original HUD class

*************************************************************************/
#ifndef __HUDCOMMON_H__
#define __HUDCOMMON_H__

//-----------------------------------------------------------------------------------------------------

#include <list>
#include "IGameObject.h"
#include "IFlashPlayer.h"
#include "IGameFlash.h"

//-----------------------------------------------------------------------------------------------------

// Forward declarations
struct IGameTokenSystem;
class CGameFlashAnimation;
class CWeapon;
class CHUDDraw;

//-----------------------------------------------------------------------------------------------------

class CHUDCommon : public CGameObjectExtensionHelper<CHUDCommon,IGameObjectExtension>,
						public ISystemEventListener,
						public IFSCommandHandler
{
public:

	// IGameObjectExtension
	virtual bool Init(IGameObject *pGameObject);
	virtual void InitClient(int channelId) {}
	virtual void PostInit(IGameObject *pGameObject);
	virtual void PostInitClient(int channelId) {}
	virtual void Release();
	virtual void Serialize(TSerialize ser,unsigned aspects) = 0;
	virtual void Update(SEntityUpdateContext &ctx, int updateSlot) {}
	virtual void PostUpdate(float frameTime) = 0;
	virtual void HandleEvent(const SGameObjectEvent &rGameObjectEvent) = 0;
	virtual void ProcessEvent(SEntityEvent &rEntityEvent) = 0;
	virtual void SetChannelId(uint16 id) {};
	virtual void SetAuthority(bool auth) {}
	virtual void SetHud(int version);
	// ~IGameObjectExtension

	// IFSCommandHandler
	virtual void HandleFSCommand(const char *strCommand,const char *strArgs) = 0;
	// ~IFSCommandHandler

	// ISystemEventListener
	virtual void OnFocusChange(bool bFocus) {}
	virtual void OnResize(int width, int height);
	// ~ISystemEventListener

	// IConsole callback
	static void ConsoleCommandFunc(IConsoleCmdArgs *pConsoleCmdArgs);
	// ~IConsole callback

						CHUDCommon();
	virtual	~	CHUDCommon();

	// Set the GOD mode
	void SetGODMode(uint8 ucGodMode, bool forceUpdate = false);

	// Show or hide the Flash HUD
	void Show(bool bShow);

	// Cursor handling
	void CursorReset();
	void CursorIncrementCounter();
	void CursorDecrementCounter();
	int		RepositionCursorXPos(CGameFlashAnimation *pAnimation, int x);

	// Positioning and scaling animations
	void	RepositionFlashAnimation(CGameFlashAnimation *pAnimation, int width, int height) const;

	// Get scaling data
	virtual float GetScaleX() const;
	virtual float GetScaleY() const;

protected:
	// Static reference to the instance
	static CHUDCommon *s_pHUD;

	// Reference to the HUD Drawing instance
	CHUDDraw *m_pHUDDraw;

	//DEBUG : used for balancing (player deaths in god mode)
	int						m_iDeaths;

	// Current GOD mode
	uint8					m_godMode;
	char					m_strGODMode[32];

	// Cursor state
	float m_fCursorX;
	float m_fCursorY;
	int m_iCursorVisibilityCounter;

	// Cached sizes
	int						m_width;
	int						m_height;

	// Flash HUD visibility
	bool m_bShow;

	// Convenience method for accessing the GameToken system
	IGameTokenSystem *GetIGameTokenSystem() const;

	// Add a new Flash animation
	CGameFlashAnimation * AddNewFlashAnimation(const char *strName, const char *filename, EGameFlashDock docking, bool setHandler);

	// Add operations to Flash animations
	void AddGotoAndStop	(CGameFlashAnimation *pGameFlashAnimation,const char *strName,const char *strControl,													const char *strToken,float fScale,float fOffset);
	void AddVariable		(CGameFlashAnimation *pGameFlashAnimation,const char *strName,const char *strControl,const char *strVariable,	const char *strToken,float fScale,float fOffset);

	// Get the current weapon object
	CWeapon *GetWeapon();

	// List of Flash animations loaded
	typedef std::list<CGameFlashAnimation *> TGameFlashAnimationsList;
	TGameFlashAnimationsList m_gameFlashAnimationsList;
};

//-----------------------------------------------------------------------------------------------------

#endif

//-----------------------------------------------------------------------------------------------------
