/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2005.
-------------------------------------------------------------------------
$Id$
$DateTime$
Description: HUD compass

-------------------------------------------------------------------------
History:
- 07:11:2005: Created by Julien Darre

*************************************************************************/
#include "StdAfx.h"
#include "HUDCompass.h"
#include "Actor.h"

//-----------------------------------------------------------------------------------------------------

CHUDCompass::CHUDCompass(CHUDDraw *pHUDDraw) : CHUDObject(pHUDDraw)
{
	m_fX = 400.0f;
	m_fY = 40.0f;

	m_iTextureIDBackground = m_pHUDDraw->CreateTexture("Textures\\Gui\\HUD\\Compass.dds");
}

//-----------------------------------------------------------------------------------------------------

CHUDCompass::~CHUDCompass()
{
}

//-----------------------------------------------------------------------------------------------------

void CHUDCompass::OnUpdate(float fDeltaTime,float fFadeValue)
{
	// TODO: found a place to call this only once
	// TODO: found a place to call this only once
	// TODO: found a place to call this only once
	// TODO: found a place to call this only once

	CActor *pActor = static_cast<CActor *>(GetISystem()->GetIGame()->GetIGameFramework()->GetClientActor());

	if(pActor)
	{
		float fAngleZ = gf_PI - pActor->GetAngles().z;

		float fLU = fAngleZ * 0.5f / gf_PI2 + 0.45f;
		float fRU = fLU + 0.28f;

		float fUV = 0.0f;
		float fDV = 1.0f;

		float fSizeX = 180.0f;
		float fSizeY = 32.0f;

		m_pHUDDraw->DrawQuad(m_fX-fSizeX*0.5f,m_fY-fSizeY*0.5f,fSizeX,fSizeY,m_pHUDDraw->GetColorARGB((uint8)(64*fFadeValue),0,0,0));
		m_pHUDDraw->DrawQuad(m_fX-fSizeX*0.5f,m_fY-fSizeY*0.5f,fSizeX,fSizeY,m_pHUDDraw->GetColorARGB((uint8)(255*fFadeValue),255,255,255),0,0,0,0,m_iTextureIDBackground,fLU,fUV,fRU,fUV,fLU,fDV,fRU,fDV);

		float fNeedleLU = 504.0f / 512.0f;
		float fNeedleRU = 511.0f / 512.0f;
		float fNeedleUV = 48.0f / 64.0f;
		float fNeedleDV = 40.0f / 64.0f;

		m_pHUDDraw->DrawQuad(m_fX-3.5f,m_fY-fSizeY*0.5f,7,8,m_pHUDDraw->GetColorARGB((uint8)(192*fFadeValue),255,255,255),0,0,0,0,m_iTextureIDBackground,fNeedleLU,fNeedleUV,fNeedleRU,fNeedleUV,fNeedleLU,fNeedleDV,fNeedleRU,fNeedleDV);
	}
}

//-----------------------------------------------------------------------------------------------------