/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2005.
-------------------------------------------------------------------------
$Id$
$DateTime$
Description: HUD crosshair

-------------------------------------------------------------------------
History:
- 07:11:2005: Created by Julien Darre
- 22:02:2006: Minor refactoring by Matthew Jack

*************************************************************************/
#include "StdAfx.h"
#include "HUDCrosshair.h"
#include "IGameTokens.h"
#include "Actor.h"
#include "IActorSystem.h"

//-----------------------------------------------------------------------------------------------------

CHUDCrosshair::CHUDCrosshair(CHUDDraw *pHUDDraw) : CHUDObject(pHUDDraw)
{
	// TODO: shouldn't be 399.5f and 299.5f ?

	m_fX = 400.0f;
	m_fY = 300.0f;

	m_iTextureIDBracket = m_pHUDDraw->CreateTexture("UI\\HUD\\crosshair_bracket.dds");
	m_iTextureIDReticle = m_pHUDDraw->CreateTexture("UI\\HUD\\crosshair_reticle.dds");
	m_iTextureIDLaser		= m_pHUDDraw->CreateTexture("UI\\HUD\\crosshair_laser_pointer.dds");

	m_bUsable = false;
	m_hitTimer=0.0f;
}

//-----------------------------------------------------------------------------------------------------

CHUDCrosshair::~CHUDCrosshair()
{
}

//-----------------------------------------------------------------------------------------------------

void CHUDCrosshair::SetUsable(bool bUsable)
{
	m_bUsable = bUsable;
}

//-----------------------------------------------------------------------------------------------------

void CHUDCrosshair::OnUpdate(float fDeltaTime,float fFadeValue)
{
	float fCrosshairVisibility;
	float fCrosshairOpacity;
	float fSpread;

	CActor *pActor = static_cast<CActor *>(GetISystem()->GetIGame()->GetIGameFramework()->GetClientActor());

	if(	(GetIGameTokenSystem()->GetTokenValueAs("hud.weapon.crosshair_visibility",fCrosshairVisibility)	&&
			GetIGameTokenSystem()->GetTokenValueAs("hud.weapon.crosshair_opacity",fCrosshairOpacity)				&&
			GetIGameTokenSystem()->GetTokenValueAs("hud.weapon.spread",fSpread)) ||
			!pActor->GetCurrentItem())
	{
		if(!pActor->GetCurrentItem())
		{
			fCrosshairOpacity = 0.7f;
			fCrosshairVisibility = 1.0f;
		}
		if(fCrosshairVisibility > 0.0f)
		{
			float fSize = 16.0f;

			if(m_bUsable)
			{
				m_pHUDDraw->DrawImageCentered(m_iTextureIDReticle,m_fX,m_fY,fSize,fSize,0,1,1,1,fCrosshairOpacity*fFadeValue);
			}
			else
			{
				uint uiColor = m_pHUDDraw->GetColorARGB((uint8)(128*fCrosshairOpacity*fFadeValue),255,255,255);

				m_pHUDDraw->DrawQuad(m_fX-fSize*0.5f,m_fY-fSize*0.5f,fSize,fSize,uiColor,0,0,0,0,m_iTextureIDLaser);
			}

			IRenderer *pRenderer = GetISystem()->GetIRenderer();
			float fWidth43 = pRenderer->GetHeight()*4.0f/3.0f;
			float widthScale = fWidth43/(float)pRenderer->GetWidth();
			float fSpreadFactor = 1.5f;
			float fScale = fSpread * fSpreadFactor;
			float fOffset = -2.0f;

			uint uiColor = m_pHUDDraw->GetColorARGB((uint8)(255*fCrosshairOpacity*fFadeValue),255,255,255);

			float fLX = m_fX - fSize - fScale - fOffset + (1.0f - widthScale)*(fSize/2);
			float fRX = m_fX				 + fScale + fOffset - (1.0f - widthScale)*(fSize/2);
			float fTY = m_fY - fScale - fSize - fOffset;
			float fBY = m_fY + fScale + fOffset;

			int crosshairHit=0;
			GetIGameTokenSystem()->GetTokenValueAs("hud.weapon.crosshair_hit", crosshairHit);
			
			if (crosshairHit || m_hitTimer>0.0f)
			{
				const float F=5.0f;
				const float T=1/F;
				const float BlinkCount=2.0f;

				if (m_hitTimer>0.0f)
					m_hitTimer-=fDeltaTime;

				if (crosshairHit)
				{
					if (m_hitTimer<=0.0f)
						m_hitTimer=BlinkCount*T;
					else
					{
						m_hitTimer+=BlinkCount*T;
						while(m_hitTimer>2.0f*BlinkCount*T)
							m_hitTimer-=T;
					}

					crosshairHit=0;
					GetIGameTokenSystem()->SetOrCreateToken("hud.weapon.crosshair_hit", crosshairHit);
				}

				float t=fabsf(cosf((m_hitTimer/T)*3.14159f));

				// blend between red and white
				byte r=255;
				byte g=(byte)(255.f*(1.f-t));
				byte b=(byte)(255.f*(1.f-t));

				uiColor = m_pHUDDraw->GetColorARGB((uint8)(128*fCrosshairOpacity*fFadeValue),r,g,b);
			}

			m_pHUDDraw->DrawQuad(fLX,fTY,fSize,fSize,uiColor,0,0,0,0,m_iTextureIDBracket,+0,+0,+1,+0,+0,+1,+1,+1);
			m_pHUDDraw->DrawQuad(fRX,fTY,fSize,fSize,uiColor,0,0,0,0,m_iTextureIDBracket,+1,+0,+0,+0,+1,+1,+0,+1);
			m_pHUDDraw->DrawQuad(fLX,fBY,fSize,fSize,uiColor,0,0,0,0,m_iTextureIDBracket,+0,+1,+1,+1,+0,+0,+1,+0);
			m_pHUDDraw->DrawQuad(fRX,fBY,fSize,fSize,uiColor,0,0,0,0,m_iTextureIDBracket,+1,+1,+0,+1,+1,+0,+0,+0);
		}
	}
}

//-----------------------------------------------------------------------------------------------------
