/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2005.
-------------------------------------------------------------------------
$Id$
$DateTime$
Description: HUD draw functions

-------------------------------------------------------------------------
History:
- 07:11:2005: Created by Julien Darre

*************************************************************************/
#ifndef __HUDDRAW_H__
#define __HUDDRAW_H__

//-----------------------------------------------------------------------------------------------------

#include <map>

//-----------------------------------------------------------------------------------------------------

enum EHUDDRAWHORIZONTAL
{
	HUDDRAWHORIZONTAL_LEFT,
	HUDDRAWHORIZONTAL_CENTER,
	HUDDRAWHORIZONTAL_RIGHT
};

/*enum EHUDDRAWVERTICAL
{
	HUDDRAWVERTICAL_TOP,
	HUDDRAWVERTICAL_CENTER,
	HUDDRAWVERTICAL_BOTTOM
};*/

//-----------------------------------------------------------------------------------------------------

class CHUDDraw
{
public:

		CHUDDraw();
	~	CHUDDraw();

	void PreRender();
	void PostRender();

	// TODO: uintARGB or float,float,float,float ?
	// TODO: uintARGB or float,float,float,float ?
	// TODO: uintARGB or float,float,float,float ?
	// TODO: uintARGB or float,float,float,float ?

	uint GetColorARGB(uint8 ucAlpha,uint8 ucRed,uint8 ucGreen,uint8 ucBlue);

	int CreateTexture(const char *strName);

	IFFont* GetFont()
	{
		return m_pFont;
	}

	void DrawTriangle(float fX0,float fY0,float fX1,float fY1,float fX2,float fY2,uint uiColor);

	void DrawQuad(	float fX,
									float fY,
									float fSizeX,
									float fSizeY,
									uint uiDiffuse=0,
									uint uiDiffuseTL=0,uint uiDiffuseTR=0,uint uiDiffuseDL=0,uint uiDiffuseDR=0,
									uint uiTextureID=0,
									float fUTexCoordsTL=0.0f,float fVTexCoordsTL=0.0f,
									float fUTexCoordsTR=1.0f,float fVTexCoordsTR=0.0f,
									float fUTexCoordsDL=0.0f,float fVTexCoordsDL=1.0f,
									float fUTexCoordsDR=1.0f,float fVTexCoordsDR=1.0f);


	void DrawImage(int iTextureID,	float fX,
																	float fY,
																	float fSizeX,
																	float fSizeY,
																	float fAngleInDegrees,
																	float fRed,
																	float fGreen,
																	float fBlue,
																	float fAlpha,
																	float fS0 = 0.0f,
																	float fT0 = 0.0f,
																	float fS1 = 1.0f,
																	float fT1 = 1.0f);

	void DrawImageCentered(int iTextureID,	float fX,
																					float fY,
																					float fSizeX,
																					float fSizeY,
																					float fAngleInDegrees,
																					float fRed,
																					float fGreen,
																					float fBlue,
																					float fAlpha);

	void DrawText(float fX,float fY,const char *strText,float fAlpha,float fRed,float fGreen,float fBlue,EHUDDRAWHORIZONTAL eHUDDrawHorizontal);

private:

	typedef std::map<int,ITexture *> TTexturesMap;
	TTexturesMap m_texturesMap;

	IFFont		*m_pFont;

	IRenderer *m_pRenderer;
};

//-----------------------------------------------------------------------------------------------------

#endif

//-----------------------------------------------------------------------------------------------------