/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2005.
-------------------------------------------------------------------------
$Id$
$DateTime$
Description: A little list of events that invoke an HUD-animation as a introduction.
(basically a string comparison that looks for a substring: for example Hunter03 -> Hunter / true)
It is used to introduce new weapons and aliens/objects on the radar.

-------------------------------------------------------------------------
History:
- 01:19:2006: Created by Jan Mller

*************************************************************************/

#include "StdAfx.h"
#include <deque>
#include "HUDFirstTimeEncounters.h"

bool CFirstTimeEncounters::FirstTimer(string &name)
{
	if(m_names.size() == 0)
		return false;

	std::deque<string>::iterator it;
	string temp;
	for(it = m_names.begin(); it != m_names.end(); it++)
	{
		temp = *it;
		if(name.find(temp) != string::npos)
		{
			name = temp;
			m_names.erase(it);
			return true;
		}
	}
	return false;
}

void CFirstTimeEncounters::LoadLevelEncounters(const char* levelName)
{
	string m_levelName = string(levelName);
	string tmpLevel;
	tmpLevel = string("Libs/UI/");
	tmpLevel.append(levelName);
	tmpLevel.append(".xml");
	m_names.clear();
	XmlNodeRef levelData = GetISystem()->LoadXmlFile(tmpLevel.c_str());
	if(levelData)
	{
		const char *item ;
		char key[3];
		for(int l = 0; l < levelData->getNumAttributes(); l++)
		{
			tmpLevel = m_levelName;
			itoa(l, key, 10);
			tmpLevel.append(key);
			item = levelData->getAttr(tmpLevel.c_str());
			m_names.push_back(string(item));
		}
	}
}
