/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2005.
-------------------------------------------------------------------------
$Id$
$DateTime$
Description: A little list of events that invoke an HUD-animation as a introduction.
(basically a string comparison that looks for a substring: for example Hunter03 -> Hunter / true)
It is used to introduce new weapons and aliens/objects on the radar.

-------------------------------------------------------------------------
History:
- 01:19:2006: Created by Jan Mller

*************************************************************************/
#ifndef __HUD_FIRST_TIME_ENCOUNTERS__
#define __HUD_FIRST_TIME_ENCOUNTERS__

#pragma once

#include <platform.h>

class CFirstTimeEncounters
{
private:
	std::deque<string> m_names;

public:
	CFirstTimeEncounters() : m_names(2)
	{
		m_names[0] = "Hurricane";
		m_names[1] = "Hunter";
	}

	//returns true, if param name has a substring that is listed - and overwrites name with this substring
	bool FirstTimer(string &name);

	//loads all FTEs for the level
	void LoadLevelEncounters(const char* levelName);
};

#endif
