/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2005.
-------------------------------------------------------------------------
$Id$
$DateTime$
Description: HUD health

-------------------------------------------------------------------------
History:
- 07:11:2005: Created by Julien Darre

*************************************************************************/
#include "StdAfx.h"
#include "HUDHealth.h"
#include "Actor.h"
#include "IGameTokens.h"

//-----------------------------------------------------------------------------------------------------

CHUDHealth::CHUDHealth(CHUDDraw *pHUDDraw) : CHUDObject(pHUDDraw)
{
	m_fX = 650.0f;
	m_fY = 560.0f;
}

//-----------------------------------------------------------------------------------------------------

CHUDHealth::~CHUDHealth()
{
}

//-----------------------------------------------------------------------------------------------------

void CHUDHealth::OnUpdate(float fDeltaTime,float fFadeValue)
{
	float fPlayerHealth = 0.0f;
	if(GetIGameTokenSystem()->GetTokenValueAs("hud.health",fPlayerHealth))
	{
		uint uiColorBack	= m_pHUDDraw->GetColorARGB((uint8) (128*fFadeValue),0,0,64);
		uint uiColorTL		= m_pHUDDraw->GetColorARGB((uint8) (96*fFadeValue),255,0,0);
		uint uiColorTR		= m_pHUDDraw->GetColorARGB((uint8) (96*fFadeValue),255,255,0);
		uint uiColorDL		= m_pHUDDraw->GetColorARGB((uint8) (192*fFadeValue),255,0,0);
		uint uiColorDR		= m_pHUDDraw->GetColorARGB((uint8) (192*fFadeValue),255,255,0);

		m_pHUDDraw->DrawQuad(m_fX-1,m_fY-1,102,12,0,uiColorBack,uiColorBack,uiColorBack,uiColorBack,0);
		m_pHUDDraw->DrawQuad(m_fX,m_fY,fPlayerHealth,10,0,uiColorTL,uiColorTR,uiColorDL,uiColorDR,0);
	}
}

//-----------------------------------------------------------------------------------------------------