/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2005.
-------------------------------------------------------------------------
$Id$
$DateTime$
Description: HUD interpolate util

-------------------------------------------------------------------------
History:
- 07:11:2005: Created by Julien Darre

*************************************************************************/
#include "StdAfx.h"
#include "HUDInterpolate.h"

//-----------------------------------------------------------------------------------------------------

CHUDInterpolate::CHUDInterpolate(float fSrc)
{
	m_fSrc = fSrc;
	m_fCur = fSrc;
	m_bInterpolate = false;
}

//-----------------------------------------------------------------------------------------------------

CHUDInterpolate::~CHUDInterpolate()
{
}

//-----------------------------------------------------------------------------------------------------

void CHUDInterpolate::Start(float fDuration,float fDst)
{
	m_fTime = 0.0f;
	m_fDuration = fDuration;
	m_fSrc = m_fCur;
	m_fDst = fDst;
	m_bInterpolate = true;
}

//-----------------------------------------------------------------------------------------------------

float CHUDInterpolate::Update(float fDeltaTime)
{
	if(m_bInterpolate)
	{
		float fFactor = m_fTime / m_fDuration;
		m_fCur = m_fDst * fFactor + m_fSrc * (1.0f - fFactor);
		m_fTime += fDeltaTime;
		if(m_fTime > m_fDuration)
		{
			m_fCur = m_fDst;
			m_bInterpolate = false;
		}
	}
	return m_fCur;
}

//-----------------------------------------------------------------------------------------------------