#include "StdAfx.h"
#include "SerPolicy.h"
#include "ISerialize.h"
#include "HUDMissionObjectiveSystem.h"
#include "HUD.h"

void CHUDMissionObjective::SetStatus(HUDMissionStatus status)
{
	if (status == m_eStatus)
		return;

	m_eStatus = status;

	switch(status)
	{
	case ACTIVATED:
	case DEACTIVATED:			
	case COMPLETED:
	case FAILED:
	default:
		assert (m_pMOS != 0);
		m_pMOS->GetHUD()->UpdateObjective(this);
		break;
	}
}


const char* CHUDMissionObjectiveSystem::GetMissionObjectiveDescription(const char* objectiveName)
{
	const char* message = 0;
	CHUDMissionObjective* pObj = GetMissionObjective(objectiveName);
	if (pObj)
		message = pObj->GetMessage();
	return message;
}

void CHUDMissionObjectiveSystem::LoadLevelObjectives(const char* levelName)
{
	m_currentMissionObjectives.clear();

	// AlexL: there is no longer an objective file.
	//        every text from an MissionObjective entity can be an objective
#if 1
	XmlNodeRef missionObjectives = GetISystem()->LoadXmlFile("Libs/UI/Objectives.xml");
	string tmpLevel = string(levelName);
	char firstChar = toupper(*(tmpLevel.begin()));
	tmpLevel.replace(0, 1, string(firstChar));			//first char of level-name currently has to be upper case

	//another hack for VS2-2*********

	int pos = tmpLevel.find(string("_vs2"), 0);
	if(string::npos != pos)
		tmpLevel = tmpLevel.substr(0, pos);
	pos = tmpLevel.find(string("_VS2"), 0);
	if(string::npos != pos)
		tmpLevel = tmpLevel.substr(0, pos);
	//*******************************

	string tempObjective;
	for(int o = 0; o < missionObjectives->getNumAttributes(); ++o)
	{
		const char* objective;
		const char* text;
		if(missionObjectives->getAttributeByIndex(o, &objective, &text))
		{
			tempObjective = string(objective);
			if(tempObjective.find(tmpLevel) != string::npos)
				m_currentMissionObjectives.push_back(CHUDMissionObjective(this, objective, text));
		}
	}
#endif
}

CHUDMissionObjective* CHUDMissionObjectiveSystem::GetMissionObjective(const char* objectiveName)
{
	std::vector<CHUDMissionObjective>::iterator it;
	for(it = m_currentMissionObjectives.begin(); it != m_currentMissionObjectives.end(); ++it)
	{
		if(!strcmp( (*it).GetName(), objectiveName))
			return &(*it);
	}
	const char* message = 0; // TODO: look up localized message
	message = objectiveName;
	m_currentMissionObjectives.push_back(CHUDMissionObjective(this, objectiveName, message));
	return &m_currentMissionObjectives.back();
}

void CHUDMissionObjectiveSystem::Serialize(TSerialize ser, unsigned aspects)	//not tested!!
{
	if(ser.GetSerializationTarget() != eST_Network)		
	{
		if (ser.IsReading())
			m_currentMissionObjectives.clear();

		ser.Value("Objectives", m_currentMissionObjectives);

		// fix pointers after reading
		if (ser.IsReading())
		{
			for(std::vector<CHUDMissionObjective>::iterator it = m_currentMissionObjectives.begin(); it != m_currentMissionObjectives.end(); ++it)
			{
				(*it).SetMOS(this);
			}
		}
	}
}