/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2005.
-------------------------------------------------------------------------
$Id$
$DateTime$
Description: CHUDMissionObjectives manages the status of a mission objective.
Also the description of the objective is saved here.
CHUDMissionObjectiveSystem encapsulates all objectives of a level.

-------------------------------------------------------------------------
History:
- 01/02:2006: Created by Jan Mller

*************************************************************************/
#ifndef __HUD_MISSION_OBJECTIVE_SYSTEM_H__
#define __HUD_MISSION_OBJECTIVE_SYSTEM_H__

#pragma once

class CHUD;

class CHUDMissionObjective
{
	friend class CHUDMissionObjectiveSystem;

public:
	enum HUDMissionStatus
	{
		FIRST = 0,
		DEACTIVATED = FIRST,
		COMPLETED,
		FAILED,
		ACTIVATED,
		LAST = ACTIVATED
	};

	CHUDMissionObjective() : m_pMOS(0), m_trackedEntity(0), m_eStatus(DEACTIVATED)
	{
	}

	CHUDMissionObjective(CHUDMissionObjectiveSystem* pMOS, const char* name, const char* msg = 0) : m_pMOS(pMOS), m_name(name), m_screenMessage(msg)
	{
		m_eStatus = DEACTIVATED;
		m_trackedEntity = 0;
	}

	HUDMissionStatus GetStatus() const
	{
		return m_eStatus;
	}

	void SetStatus(HUDMissionStatus);

	ILINE EntityId GetTrackedEntity() const
	{
		return m_trackedEntity;
	}

	ILINE void SetTrackedEntity(EntityId entityID)
	{
		m_trackedEntity = entityID;
	}
	
	ILINE bool GetRadar() const
	{
		return m_trackedEntity != 0;
	}

	ILINE bool IsActivated() const
	{
		return (m_eStatus == ACTIVATED);
	}

	ILINE const char* GetName() const
	{
		return m_name.c_str();
	}

	ILINE const char* GetMessage() const
	{
		return m_screenMessage.c_str();
	}

	void Serialize(TSerialize ser)
	{
		ser.Value("m_name", m_name);
		ser.Value("m_screenMessage", m_screenMessage);
		ser.Value("m_trackedEntity", m_trackedEntity, NSerPolicy::AC_EntityId());
		ser.EnumValue("m_eStatus", m_eStatus, FIRST, LAST);
	}

protected:

	ILINE void SetMOS(CHUDMissionObjectiveSystem* pMOS)
	{
		m_pMOS = pMOS;
	}

private:
	CHUDMissionObjectiveSystem* m_pMOS;
	string						m_name;
	string						m_screenMessage;
	EntityId          m_trackedEntity;
	HUDMissionStatus	m_eStatus;
};

class CHUDMissionObjectiveSystem
{
	//this is a list of the current level's mission objectives ...
	std::vector<CHUDMissionObjective> m_currentMissionObjectives;
	CHUD* m_pHUD;

public:

	CHUDMissionObjectiveSystem() : m_pHUD(0)
	{
	}

	const std::vector<CHUDMissionObjective>& GetObjectives() const
	{
		return m_currentMissionObjectives;
	}

	//get the description of the objective
	const char* GetMissionObjectiveDescription(const char* objectiveName);

	//loads the level's mission objectives from a XML file
	void LoadLevelObjectives(const char* levelName);

	//get a pointer to the objective (NULL if not available)
	//TODO: don't return ptr into a vector! If vector changes, ptr is trash!
	CHUDMissionObjective* GetMissionObjective(const char* objectiveName);

	void Serialize(TSerialize ser,unsigned aspects);	//not tested!!

	void SetHUD(CHUD* pHUD)
	{
		m_pHUD = pHUD;
	}

	CHUD* GetHUD() const
	{
		return m_pHUD;
	}
};

#endif