/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2005.
-------------------------------------------------------------------------
$Id$
$DateTime$
Description: 	
	Header for HUD object base class
	Shared by G02 and G04

-------------------------------------------------------------------------
History:
- 07:11:2005: Created by Julien Darre
- 22:02:2006: Refactored for G04 by Matthew Jack

*************************************************************************/
#ifndef __HUDOBJECT_H__
#define __HUDOBJECT_H__

//-----------------------------------------------------------------------------------------------------

#include "HUDDraw.h"

//-----------------------------------------------------------------------------------------------------

// Forward declaration

struct IGameTokenSystem;

//-----------------------------------------------------------------------------------------------------

class CHUDObject
{
public:

						CHUDObject(CHUDDraw *pDraw,bool bVisible=true);
	virtual ~	CHUDObject();

	void SetFadeValue(float fFadeValue);

	void Update(float fDeltaTime);

	virtual void SetParent(void* parent);

protected:

	virtual void OnUpdate(float fDeltaTime,float fFadeValue) = 0;

	// Convenience method for accessing the GameToken system.
	IGameTokenSystem *GetIGameTokenSystem() const;

	CHUDDraw *m_pHUDDraw;

	float m_fX;
	float m_fY;

	void		*m_parent;

private:

	float m_fFadeValue;
};

//-----------------------------------------------------------------------------------------------------

#endif

//-----------------------------------------------------------------------------------------------------