/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2005.
-------------------------------------------------------------------------
$Id$
$DateTime$
Description: HUD radar

-------------------------------------------------------------------------
History:
- 07:11:2005: Created by Julien DarreRadarEntity(id)

*************************************************************************/
#include "StdAfx.h"
#include "HUDRadar.h"
#include "HUDInterpolate.h"
#include "IGameTokens.h"
#include "Actor.h"

#include "HUD.h"

//-----------------------------------------------------------------------------------------------------

CHUDRadar::CHUDRadar(CHUDDraw *pHUDDraw) : CHUDObject(pHUDDraw)
{
	m_fX = 94.0f;
	m_fY = 533.5f;

	m_aiEntitiesId[0] = 0;
	m_aiEntitiesId[1] = 0;
	m_aiEntitiesId[2] = 0;

	m_radarDotSizes[0] = 0.7f;
	m_radarDotSizes[1] = 1.5f;
	m_radarDotSizes[2] = 2.3f;
	m_radarDotSizes[3] = 2.5f;	//this is currently used as a multiplier for the hunter

	m_fTime = 0.0f;

	m_iTextureIDEnemy			= m_pHUDDraw->CreateTexture("UI\\HUD\\enemy_triangle.dds");
	m_iTextureIDFov				= m_pHUDDraw->CreateTexture("UI\\HUD\\fov.dds");
	m_iTextureIDPlayer		= m_pHUDDraw->CreateTexture("UI\\HUD\\player.dds");
	m_iTextureIDWaypoint	= m_pHUDDraw->CreateTexture("UI\\HUD\\enemy_circle.dds"); // TODO: change name to waypoint
}

//-----------------------------------------------------------------------------------------------------

CHUDRadar::~CHUDRadar()
{
}

//-----------------------------------------------------------------------------------------------------

void CHUDRadar::AddTagBullet(EntityId iEntityId)
{
	m_aiEntitiesId[2] = m_aiEntitiesId[1];
	m_aiEntitiesId[1] = m_aiEntitiesId[0];
	m_aiEntitiesId[0] = iEntityId;
}

//-----------------------------------------------------------------------------------------------------

void CHUDRadar::OnUpdate(float fDeltaTime,float fFadeValue)
{
	FUNCTION_PROFILER(GetISystem(),PROFILE_GAME);

	m_fTime += fDeltaTime * 3.0f;
	IRenderer *pRenderer = GetISystem()->GetIRenderer();
	float fWidth43 = pRenderer->GetHeight()*4.0f/3.0f;
	float widthScale = fWidth43/(float)pRenderer->GetWidth();
	const float newX = m_fX*widthScale;

	CActor *pActor = static_cast<CActor *>(GetISystem()->GetIGame()->GetIGameFramework()->GetClientActor());
	if (!pActor)
		return;

	EntityId lookAtObject = pActor->GetViewIntersectionEntity();	//the object the player is looking at ...

	const float fRadarSizeOverTwo = 47.0f;
	const float fEntitySize = 5.0f;
	const float fEntityMaxDistance = fRadarSizeOverTwo - fEntitySize;

	m_pHUDDraw->DrawImageCentered(m_iTextureIDPlayer,newX,m_fY,8,8,0,1,1,1,fFadeValue);

	float fFov = 0.0f;
	if(GetIGameTokenSystem()->GetTokenValueAs("hud.fov",fFov))
	{
		float fFovTextureSize = 128.0f;
		float fFovSizeX = fFovTextureSize * fFov / 90.0f;
		float fFovSizeY = fFovTextureSize;
		float fFovX = newX - 0.5f * (fFovSizeX) + 0.5f;
		float fFovY = m_fY - 94.0f;

		m_pHUDDraw->DrawQuad(fFovX,fFovY,fFovSizeX,fFovSizeY,m_pHUDDraw->GetColorARGB((uint8)(fFadeValue*255),255,255,255),0,0,0,0,m_iTextureIDFov);
	}

	Vec3 vOrigin = GetISystem()->GetViewCamera().GetPosition();
	float fRadius = 60.0f;
	//IPhysicalEntity **pPhysicalEntitiesList;

	SEntityProximityQuery query;
	query.box = AABB( Vec3(vOrigin.x-fRadius,vOrigin.y-fRadius,vOrigin.z-fRadius),Vec3(vOrigin.x+fRadius,vOrigin.y+fRadius,vOrigin.z+fRadius) );
	query.nEntityFlags = ENTITY_FLAG_ON_RADAR; // Filter by entity flag.
	int iNumEntities = GetISystem()->GetIEntitySystem()->QueryProximity( query );
	for(int iEntity=0; iEntity<query.nCount; iEntity++)
	{
		IEntity *pEntity = query.pEntities[iEntity];
		if(pEntity && !pEntity->IsHidden())
		{
			//reasons not to go on ... *********************************************************************
			EntityId id = pEntity->GetId();
			if(m_aiEntitiesId[0] == id || m_aiEntitiesId[1] == id || m_aiEntitiesId[2] == id)
				continue;

			IActor* tempActor = GetISystem()->GetIGame()->GetIGameFramework()->GetIActorSystem()->GetActor(pEntity->GetId());
			if(tempActor && !(tempActor->GetHealth() > 0))
				continue;

			if(pActor->GetEntityId() == id)
				continue;
			//**********************************************************************************************

			if(m_parent)
			{
				CHUD* parent = (CHUD*)m_parent;
				parent->InvokeIntroduction(pEntity->GetName());
			}

			Vec3 vTransformed = pEntity->GetWorldPos();
			pActor->VectorToLocal(vTransformed);
			vTransformed.z = 0;

			//has the object been scanned already?
			if(!IsOnRadar(id, 0, m_entitiesOnRadar.size()-1))
			{
				if(lookAtObject == id)
					AddToRadar(id);
				continue;
			}

			//**********************************************************************************************

			float sizeScale = GetRadarSize(pEntity, pActor);

			if(vTransformed.len() > fEntityMaxDistance - sizeScale/*fEntitySize*/)
			{
				continue;
				//vTransformed.SetLength(fEntityMaxDistance);
			}

			//**********************************************************************************************

			float fX = newX + vTransformed.x*widthScale;
			float fY = m_fY - vTransformed.y;

			float fAngle = pActor->GetAngles().z - pEntity->GetWorldAngles().z;

			float fRed		= 0;
			float fGreen	= 0;
			float fBlue		= 0;
			float fAlpha	= 0.75f * fFadeValue;

			IAIObject *pAIObject = pEntity->GetAI();
			if(pAIObject)
			{
				if(AIOBJECT_VEHICLE == pAIObject->GetType())
				{
					fBlue = 1;
				}
				else if(pAIObject->IsHostile(pActor->GetEntity()->GetAI()))
				{
					int iAlertnessState = pAIObject->GetProxy()->GetAlertnessState();

					if(0 == iAlertnessState)
					{
						fRed		= 1;
						fGreen	= 0.75f;
						fBlue		= 0.25f;
					}
					else if(1 == iAlertnessState)
					{
						fRed		= 1;
						fGreen	= 0.5f;
					}
					else if(2 == iAlertnessState)
					{
						fRed = 1;
					}
				}
				else
				{
					fGreen = 1;
				}
			}

			m_pHUDDraw->DrawImageCentered(m_iTextureIDEnemy,fX,fY,fEntitySize*sizeScale,fEntitySize*sizeScale,RAD2DEG(fAngle),fRed,fGreen,fBlue,fAlpha);
		}
	}

	// Draw MissionObjectives or their target entities
	// we draw after normal targets, so AI guys which are targets show up as Objective
	// TODO: we overdraw currently, not so nice...
	CHUD* pHUD = (CHUD*)m_parent;
	assert (pHUD != 0);
	const std::vector<CHUDMissionObjective>& objectives = pHUD->GetMissionObjectiveSystem().GetObjectives();
	std::vector<CHUDMissionObjective>::const_iterator iter = objectives.begin();
	while (iter != objectives.end())
	{
		const CHUDMissionObjective& obj (*iter);
		if (obj.GetStatus() == CHUDMissionObjective::ACTIVATED)
		{
			EntityId id = obj.GetTrackedEntity();
			IEntity* pEntity = GetISystem()->GetIEntitySystem()->GetEntity(id);
			if (pEntity && !pEntity->IsHidden())
			{
				Vec3 vTransformed = pEntity->GetWorldPos();
				pActor->VectorToLocal(vTransformed);
				vTransformed.z = 0;

				const float len = vTransformed.len();

				if(len > fEntityMaxDistance)
					vTransformed.SetLength(fEntityMaxDistance);

				float fX = newX + vTransformed.x*widthScale;
				float fY = m_fY - vTransformed.y;
				float fAlpha	= 0.75f * fFadeValue;

				float fCos	= cosf(m_fTime);
				float fR		= (0.35f + fCos * 0.2f) * 1.1f;
				float fG    = 0.75f + (1.0f + fCos) * 0.125f;
				float fB		= (0.45f + fCos * 0.35f) * 1.1f;

				//m_pHUDDraw->DrawImageCentered(m_iTextureIDWaypoint,fX,fY,fEntitySize*0.5f,fEntitySize*0.5f,0,1,1,0,fAlpha);
				m_pHUDDraw->DrawImageCentered(m_iTextureIDWaypoint,fX,fY,6,6,0,fR,fG,fB,fFadeValue);
				m_pHUDDraw->DrawImageCentered(m_iTextureIDWaypoint,fX,fY,3,3,0,0.17f, 0.88f, 0.0f,fFadeValue);
			}
		}
		++iter;
	}


	for(int iIndex=0; iIndex<3; iIndex++)
	{
		if(m_aiEntitiesId[iIndex])
		{
			IEntity *pEntity = GetISystem()->GetIEntitySystem()->GetEntity(m_aiEntitiesId[iIndex]);

			if(pEntity)
			{
				Vec3 vTransformed = pEntity->GetWorldPos();
				pActor->VectorToLocal(vTransformed);
				vTransformed.z = 0;

				float fEntityMaxDistance = 42.0f;
				if(vTransformed.len() > fEntityMaxDistance)
				{
					vTransformed.SetLength(fEntityMaxDistance);
				}

				Vec3 vScreenSpace;
				GetISystem()->GetIRenderer()->ProjectToScreen(vTransformed.x,vTransformed.y,vTransformed.z,&vScreenSpace.x,&vScreenSpace.y,&vScreenSpace.z);

				float fX = newX + vTransformed.x;
				float fY = m_fY - vTransformed.y;

				float fCos	= cosf(m_fTime);
				float fR		= (0.45f + fCos * 0.35f) * 1.1f;
				float fG		= (0.35f + fCos * 0.2f) * 1.1f;
				float fBlue = 0.75f + (1.0f + fCos) * 0.125f;

				float sizeScale = GetRadarSize(pEntity, pActor);
				m_pHUDDraw->DrawImageCentered(m_iTextureIDWaypoint,fX,fY,4*sizeScale,4*sizeScale,0,fR,fG,fBlue,fFadeValue);
				m_pHUDDraw->DrawImageCentered(m_iTextureIDWaypoint,fX,fY,2*sizeScale,2*sizeScale,0,0.88f, 0.17f, 0.0f,fFadeValue);
			}
		}
		else
			m_aiEntitiesId[iIndex] = 0;
	}
}

//-----------------------------------------------------------------------------------------------------

float CHUDRadar::GetRadarSize(IEntity* entity, CActor* actor)
{
	float posEnt = entity->GetWorldPos().z;
	float posPlayer = actor->GetEntity()->GetWorldPos().z;
	float returnValue = 1.0f;

	if((posEnt + 15) < posPlayer)
		returnValue = m_radarDotSizes[0];
	else if((posEnt - 15) > posPlayer)
		returnValue = m_radarDotSizes[2];
	else
		returnValue = m_radarDotSizes[0] + ((posEnt - (posPlayer-15)) / 30.0f) * (m_radarDotSizes[2] - m_radarDotSizes[0]);

	string name(entity->GetName());
	if(name.find("Hunter") != string::npos)
		returnValue *= m_radarDotSizes[3];

	return returnValue;
}

bool CHUDRadar::IsOnRadar(EntityId id, int first, int last)
{
	int size = last - first;
	if(size > 1)
	{
		int mid = first + (size / 2);
		EntityId midId = m_entitiesOnRadar[mid].m_id;
		if(midId == id)
			return true;
		else if(midId > id)
			return IsOnRadar(id, first, mid-1);
		else
			return IsOnRadar(id, mid+1, last);
	}
	else if(size == 1)
		return (m_entitiesOnRadar[first].m_id == id  || m_entitiesOnRadar[last].m_id == id);
	else if(m_entitiesOnRadar.size() > 0)
		return (m_entitiesOnRadar[first].m_id == id);
	return false;
}

void CHUDRadar::AddToRadar(EntityId id)
{
	if(m_entitiesOnRadar.size()>0)
	{
		if(m_entitiesOnRadar[0].m_id > id)
			m_entitiesOnRadar.push_front(RadarEntity(id));
		else if(m_entitiesOnRadar[m_entitiesOnRadar.size()-1].m_id < id)
			m_entitiesOnRadar.push_back(RadarEntity(id));
		else
		{
			std::deque<RadarEntity>::iterator it, itTemp;
			for(it = m_entitiesOnRadar.begin(); it != m_entitiesOnRadar.end(); it++)
			{
				itTemp = it;
				itTemp++;
				if(itTemp != m_entitiesOnRadar.end())
				{
					if(it->m_id < id && itTemp->m_id > id)
					{
						m_entitiesOnRadar.insert(itTemp, 1, RadarEntity(id));
						break;
					}
				}
				else { assert(false); }
			}
		}
	}
	else
		m_entitiesOnRadar.push_back(RadarEntity(id));
}